/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (C) 2006 Dan Everton
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/

#ifndef __UISDL_H__
#define __UISDL_H__

#include <stdbool.h>
#include "SDL.h"
#include "config.h"

/* colour definitions are R, G, B */

#if defined(ARCHOS_RECORDER)
#define UI_TITLE                    "Jukebox Recorder"
#define UI_WIDTH                    270 /* width of GUI window */
#define UI_HEIGHT                   406 /* height of GUI window */
#define UI_LCD_POSX                 80 /* x position of lcd */
#define UI_LCD_POSY                 104 /* y position of lcd */

#elif defined(ARCHOS_PLAYER)
#define UI_TITLE                    "Jukebox Player"
#define UI_WIDTH                    284 /* width of GUI window */
#define UI_HEIGHT                   420 /* height of GUI window */
#define UI_LCD_POSX                 75 /* x position of lcd */
#define UI_LCD_POSY                 116 /* y position of lcd */

#elif defined(ARCHOS_FMRECORDER) || defined(ARCHOS_RECORDERV2)
#define UI_TITLE                    "Jukebox FM Recorder"
#define UI_WIDTH                    285 /* width of GUI window */
#define UI_HEIGHT                   414 /* height of GUI window */
#define UI_LCD_POSX                 87 /* x position of lcd */
#define UI_LCD_POSY                 77 /* y position of lcd */

#elif defined(ARCHOS_ONDIOSP) || defined(ARCHOS_ONDIOFM)
#define UI_TITLE                    "Ondio"
#define UI_WIDTH                    155 /* width of GUI window */
#define UI_HEIGHT                   334 /* height of GUI window */
#define UI_LCD_POSX                 21 /* x position of lcd */
#define UI_LCD_POSY                 82 /* y position of lcd */

#elif defined(IRIVER_H120) || defined(IRIVER_H100)
#define UI_TITLE                    "iriver H1x0"
#define UI_WIDTH                    379 /* width of GUI window */
#define UI_HEIGHT                   508 /* height of GUI window */
#define UI_LCD_POSX                 109 /* x position of lcd */
#define UI_LCD_POSY                 23 /* y position of lcd */
#define UI_REMOTE_POSX              50  /* x position of remote lcd */
#define UI_REMOTE_POSY              403 /* y position of remote lcd */

#elif defined(IRIVER_H300)
#define UI_TITLE                    "iriver H300"
#define UI_WIDTH                    288 /* width of GUI window */
#define UI_HEIGHT                   581 /* height of GUI window */
#define UI_LCD_POSX                 26 /* x position of lcd */
#define UI_LCD_POSY                 36 /* y position of lcd */
#define UI_REMOTE_POSX              12  /* x position of remote lcd */
#define UI_REMOTE_POSY              478 /* y position of remote lcd */

#elif defined(IPOD_1G2G)
#define UI_TITLE                    "iPod 1G/2G"
#define UI_WIDTH                    224 /* width of GUI window */
#define UI_HEIGHT                   382 /* height of GUI window */
#define UI_LCD_POSX                 32 /* x position of lcd */
#define UI_LCD_POSY                 12 /* y position of lcd */

#elif defined(IPOD_3G)
#define UI_TITLE                    "iPod 3G"
#define UI_WIDTH                    218 /* width of GUI window */
#define UI_HEIGHT                   389 /* height of GUI window */
#define UI_LCD_POSX                 29 /* x position of lcd */
#define UI_LCD_POSY                 16 /* y position of lcd */

#elif defined(IPOD_4G)
#define UI_TITLE                    "iPod 4G"
#define UI_WIDTH                    196 /* width of GUI window */
#define UI_HEIGHT                   370 /* height of GUI window */
#define UI_LCD_POSX                 19 /* x position of lcd */
#define UI_LCD_POSY                 14 /* y position of lcd */

#elif defined(IPOD_MINI) || defined(IPOD_MINI2G)
#define UI_TITLE                    "iPod mini"
#define UI_WIDTH                    191 /* width of GUI window */
#define UI_HEIGHT                   365 /* height of GUI window */
#define UI_LCD_POSX                 24 /* x position of lcd */
#define UI_LCD_POSY                 17 /* y position of lcd */

#elif defined(IPOD_COLOR)
#define UI_TITLE                    "iPod Color"
#define UI_WIDTH                    261 /* width of GUI window */
#define UI_HEIGHT                   493 /* height of GUI window */
#define UI_LCD_POSX                 21 /* x position of lcd */
#define UI_LCD_POSY                 16 /* y position of lcd */

#elif defined(IPOD_NANO)
#define UI_TITLE                    "iPod Nano"
#define UI_WIDTH                    199 /* width of GUI window */
#define UI_HEIGHT                   421 /* height of GUI window */
#define UI_LCD_POSX                 13 /* x position of lcd */
#define UI_LCD_POSY                 14 /* y position of lcd */

#elif defined(IPOD_NANO2G)
#define UI_TITLE                    "iPod Nano 2G"
#define UI_WIDTH                    235 /* width of GUI window */
#define UI_HEIGHT                   537 /* height of GUI window */
#define UI_LCD_POSX                 29 /* x position of lcd */
#define UI_LCD_POSY                 33 /* y position of lcd */

#elif defined(IPOD_VIDEO)
#define UI_TITLE                    "iPod Video"
#define UI_WIDTH                    350 /* width of GUI window */
#define UI_HEIGHT                   591 /* height of GUI window */
#define UI_LCD_POSX                 14 /* x position of lcd */
#define UI_LCD_POSY                 12 /* y position of lcd */

#elif defined(IAUDIO_X5)
#define UI_TITLE                    "iAudio X5"
#define UI_WIDTH                    300 /* width of GUI window */
#define UI_HEIGHT                   558 /* height of GUI window */
#define UI_LCD_POSX                 55 /* x position of lcd */
#define UI_LCD_POSY                 61 /* y position of lcd */
#define UI_REMOTE_POSX              12  /* x position of remote lcd */
#define UI_REMOTE_POSY              462 /* y position of remote lcd */

#elif defined(IAUDIO_M5)
#define UI_TITLE                    "iAudio M5"
#define UI_WIDTH                    374 /* width of GUI window */
#define UI_HEIGHT                   650 /* height of GUI window */
#define UI_LCD_POSX                 82 /* x position of lcd */
#define UI_LCD_POSY                 74 /* y position of lcd */
#define UI_REMOTE_POSX              59  /* x position of remote lcd */
#define UI_REMOTE_POSY              509 /* y position of remote lcd */

#elif defined(IAUDIO_M3)
#define UI_TITLE                    "iAudio M3"
#define UI_WIDTH                    397 /* width of GUI window */
#define UI_HEIGHT                   501 /* height of GUI window */
#define UI_LCD_POSX                 92  /* x position of lcd */
#define UI_LCD_POSY                 348 /* y position of lcd */

#elif defined(GIGABEAT_F)
#define UI_TITLE                    "Toshiba Gigabeat"
#define UI_WIDTH                    401 /* width of GUI window */
#define UI_HEIGHT                   655 /* height of GUI window */
#define UI_LCD_POSX                 48 /* x position of lcd */
#define UI_LCD_POSY                 60 /* y position of lcd */

#elif defined(GIGABEAT_S)
#define UI_TITLE                    "Toshiba Gigabeat"
#define UI_WIDTH                    450 /* width of GUI window */
#define UI_HEIGHT                   688 /* height of GUI window */
#define UI_LCD_POSX                 96 /* x position of lcd */
#define UI_LCD_POSY                 90 /* y position of lcd */

#elif defined(MROBE_500)
#if LCD_WIDTH==320
#define UI_TITLE                    "Olympus M:Robe 500"
#define UI_WIDTH                    450 /* width of GUI window */
#define UI_HEIGHT                   350 /* height of GUI window */
#define UI_LCD_POSX                 65 /* x position of lcd */
#define UI_LCD_POSY                 30 /* y position of lcd */
#define UI_REMOTE_POSX              36  /* x position of remote lcd */
#define UI_REMOTE_POSY              318 /* y position of remote lcd */
#else
#define UI_TITLE                    "Olympus M:Robe 500"
#define UI_WIDTH                    895 /* width of GUI window */
#define UI_HEIGHT                   646 /* height of GUI window */
#define UI_LCD_POSX                 129 /* x position of lcd */
#define UI_LCD_POSY                 60  /* y position of lcd */
#define UI_REMOTE_POSX              37 /* x position of remote lcd */
#define UI_REMOTE_POSY              615 /* y position of remote lcd */
#endif

#elif defined(IRIVER_H10)
#define UI_TITLE                    "iriver H10 20Gb"
#define UI_WIDTH                    392 /* width of GUI window */
#define UI_HEIGHT                   391 /* height of GUI window */
#define UI_LCD_POSX                 111 /* x position of lcd */
#define UI_LCD_POSY                 30 /* y position of lcd */

#elif defined(IRIVER_H10_5GB)
#define UI_TITLE                    "iriver H10 5/6Gb"
#define UI_WIDTH                    353 /* width of GUI window */
#define UI_HEIGHT                   460 /* height of GUI window */
#define UI_LCD_POSX                 112 /* x position of lcd */
#define UI_LCD_POSY                 45  /* y position of lcd */

#elif defined(SANSA_E200) || defined(SANSA_E200V2)
#ifdef SANSA_E200
#define UI_TITLE                    "Sansa e200"
#else
#define UI_TITLE                    "Sansa e200v2"
#endif
#define UI_WIDTH                    260 /* width of GUI window */
#define UI_HEIGHT                   502 /* height of GUI window */
#define UI_LCD_POSX                 42 /* x position of lcd */
#define UI_LCD_POSY                 37  /* y position of lcd */

#elif defined(SANSA_C200) || defined(SANSA_C200V2)
#ifdef SANSA_C200
#define UI_TITLE                    "Sansa c200"
#else
#define UI_TITLE                    "Sansa c200v2"
#endif
#define UI_WIDTH                    350 /* width of GUI window */
#define UI_HEIGHT                   152 /* height of GUI window */
#define UI_LCD_POSX                 42 /* x position of lcd */
#define UI_LCD_POSY                 35  /* y position of lcd */

#elif defined(IRIVER_IFP7XX)
#define UI_TITLE                    "iriver iFP7xx"
#define UI_WIDTH                    425 /* width of GUI window */
#define UI_HEIGHT                   183 /* height of GUI window */
#define UI_LCD_POSX                 115 /* x position of lcd */
#define UI_LCD_POSY                 54 /* y position of lcd */

#elif defined(ARCHOS_AV300)
#define UI_TITLE                    "Archos AV300"
/* We are temporarily using a 2bpp LCD driver and dummy bitmap */
#define UI_WIDTH                    420 /* width of GUI window */
#define UI_HEIGHT                   340 /* height of GUI window */
#define UI_LCD_POSX                 50 /* x position of lcd */
#define UI_LCD_POSY                 50 /* y position of lcd */

#elif defined(MROBE_100)
#define UI_TITLE                    "Olympus M:Robe 100"
#define UI_WIDTH                    247 /* width of GUI window */
#define UI_HEIGHT                   462 /* height of GUI window */
#define UI_LCD_POSX                 43 /* x position of lcd */
#define UI_LCD_POSY                 25 /* y position of lcd */
#define UI_REMOTE_POSX              34 /* x position of remote lcd */
#define UI_REMOTE_POSY              432 /* y position of remote lcd */

#elif defined(COWON_D2)
#define UI_TITLE                    "Cowon D2"
#define UI_WIDTH                    472 /* width of GUI window */
#define UI_HEIGHT                   368 /* height of GUI window */
#define UI_LCD_POSX                 58 /* x position of lcd */
#define UI_LCD_POSY                 67 /* y position of lcd */

#elif defined(IAUDIO_7)
#define UI_TITLE                    "iAudio7"
#define UI_WIDTH                    494 /* width of GUI window */
#define UI_HEIGHT                   214 /* height of GUI window */
#define UI_LCD_POSX                 131 /* x position of lcd */
#define UI_LCD_POSY                 38 /* y position of lcd */

#elif defined(CREATIVE_ZVM) || defined(CREATIVE_ZVM60GB)
#ifdef CREATIVE_ZVM
 #define UI_TITLE                    "Creative Zen Vision:M 30GB"
#else
 #define UI_TITLE                    "Creative Zen Vision:M 60GB"
#endif
#define UI_WIDTH                    383 /* width of GUI window */
#define UI_HEIGHT                   643 /* height of GUI window */
#define UI_LCD_POSX                 31 /* x position of lcd */
#define UI_LCD_POSY                 62 /* y position of lcd */

#elif defined(CREATIVE_ZV)
#define UI_TITLE                    "Creative Zen Vision"
#define UI_WIDTH                    1054 /* width of GUI window */
#define UI_HEIGHT                   643 /* height of GUI window */
#define UI_LCD_POSX                 129 /* x position of lcd */
#define UI_LCD_POSY                 85 /* y position of lcd */

#elif defined(MEIZU_M6SL)
#define UI_TITLE                    "Meizu M6"
#define UI_WIDTH                    512 /* width of GUI window */
#define UI_HEIGHT                   322 /* height of GUI window */
#define UI_LCD_POSX                 39 /* x position of lcd */
#define UI_LCD_POSY                 38 /* y position of lcd */

#elif defined(SANSA_FUZEPLUS)
#define UI_TITLE                    "Sansa Fuze+"
#define UI_WIDTH                    322 /* width of GUI window */
#define UI_HEIGHT                   609 /* height of GUI window */
#define UI_LCD_POSX                 43 /* x position of lcd */
#define UI_LCD_POSY                 62 /* y position of lcd */


#elif defined(SANSA_FUZE) || defined(SANSA_FUZEV2)
#ifdef SANSA_FUZE
#define UI_TITLE                    "Sansa Fuze"
#else
#define UI_TITLE                    "Sansa Fuzev2"
#endif
#define UI_WIDTH                    279 /* width of GUI window */
#define UI_HEIGHT                   449 /* height of GUI window */
#define UI_LCD_POSX                 30 /* x position of lcd */
#define UI_LCD_POSY                 31 /* y position of lcd */

#elif defined(SANSA_CLIP) || defined(SANSA_CLIPV2)
#if defined(SANSA_CLIP)
#define CLIP_VERSION                ""
#elif defined(SANSA_CLIPV2)
#define CLIP_VERSION                "v2"
#endif
#define UI_TITLE                    "Sansa Clip"CLIP_VERSION
#define UI_WIDTH                    205 /* width of GUI window */
#define UI_HEIGHT                   325 /* height of GUI window */
#define UI_LCD_POSX                 38 /* x position of lcd */
#define UI_LCD_POSY                 38 /* y position of lcd */

#elif defined(SANSA_CLIPPLUS)
#define UI_TITLE                    "Sansa Clip+"
#define UI_WIDTH                    205 /* width of GUI window */
#define UI_HEIGHT                   325 /* height of GUI window */
#define UI_LCD_POSX                 42 /* x position of lcd */
#define UI_LCD_POSY                 42 /* y position of lcd */

#elif defined(SANSA_CLIPZIP)
#define UI_TITLE                    "Sansa Clip Zip"
#define UI_WIDTH                    160 /* width of GUI window */
#define UI_HEIGHT                   254 /* height of GUI window */
#define UI_LCD_POSX                 33 /* x position of lcd */
#define UI_LCD_POSY                 26 /* y position of lcd */

#elif defined(PHILIPS_SA9200)
#define UI_TITLE                    "Philips GoGear SA9200"
#define UI_WIDTH                    233 /* width of GUI window */
#define UI_HEIGHT                   435 /* height of GUI window */
#define UI_LCD_POSX                 50  /* x position of lcd */
#define UI_LCD_POSY                 50  /* y position of lcd */

#elif defined(PHILIPS_HDD1630)
#define UI_TITLE                    "Philips GoGear HDD1630"
#define UI_WIDTH                    407 /* width of GUI window */
#define UI_HEIGHT                   391 /* height of GUI window */
#define UI_LCD_POSX                 143 /* x position of lcd */
#define UI_LCD_POSY                 27   /* y position of lcd */

#elif defined(PHILIPS_HDD6330)
#define UI_TITLE                    "Philips GoGear HDD63X0"
#define UI_WIDTH                    400 /* width of GUI window */
#define UI_HEIGHT                   614 /* height of GUI window */
#define UI_LCD_POSX                 89  /* x position of lcd */
#define UI_LCD_POSY                 113 /* y position of lcd */

#elif defined(SANSA_M200V4)
#define UI_TITLE                    "sansa m200v4"
#define UI_WIDTH                    350 /* width of GUI window */
#define UI_HEIGHT                   168 /* height of GUI window */
#define UI_LCD_POSX                 42 /* x position of lcd */
#define UI_LCD_POSY                 55 /* y position of lcd */

#elif defined(ONDA_VX747) || defined(ONDA_VX747P)
#ifdef ONDA_VX747
#define UI_TITLE                    "Onda VX747"
#else
#define UI_TITLE                    "Onda VX747+"
#endif
#define UI_WIDTH                    340 /* width of GUI window */
#define UI_HEIGHT                   601 /* height of GUI window */
#define UI_LCD_POSX                 45  /* x position of lcd */
#define UI_LCD_POSY                 90  /* y position of lcd */

#elif defined(ONDA_VX777)
#define UI_TITLE                    "Onda VX777"
#define UI_WIDTH                    306 /* width of GUI window */
#define UI_HEIGHT                   558 /* height of GUI window */
#define UI_LCD_POSX                 32  /* x position of lcd */
#define UI_LCD_POSY                 81  /* y position of lcd */

#elif defined(SAMSUNG_YH820)
#define UI_TITLE                    "Samsung YH-820"
#define UI_WIDTH                    368 /* width of GUI window */
#define UI_HEIGHT                   428 /* height of GUI window */
#define UI_LCD_POSX                 120 /* x position of lcd */
#define UI_LCD_POSY                 75  /* y position of lcd */

#elif defined(SAMSUNG_YH920) || defined(SAMSUNG_YH925)
#ifdef SAMSUNG_YH920
#define UI_TITLE                    "Samsung YH-920"
#else
#define UI_TITLE                    "Samsung YH-925"
#endif
#define UI_WIDTH                    408 /* width of GUI window */
#define UI_HEIGHT                   454 /* height of GUI window */
#define UI_LCD_POSX                 124 /* x position of lcd */
#define UI_LCD_POSY                 42  /* y position of lcd */

#elif defined(MINI2440)
#define UI_TITLE                    "Mini2440"
#define UI_WIDTH                    441 /* width of GUI window */
#define UI_HEIGHT                   436 /* height of GUI window */
#define UI_LCD_POSX                 148 /* x position of lcd */
#define UI_LCD_POSY                 50 /* y position of lcd */

#elif defined(PBELL_VIBE500)
#define UI_TITLE                    "Packard Bell Vibe 500"
#define UI_WIDTH                    287 /* width of GUI window */
#define UI_HEIGHT                   488 /* height of GUI window */
#define UI_LCD_POSX                 64 /* x position of lcd */
#define UI_LCD_POSY                 61 /* y position of lcd */

#elif defined(MPIO_HD200)
#define UI_TITLE                    "MPIO HD200"
#define UI_WIDTH                    430 /* width of GUI window */
#define UI_HEIGHT                   479 /* height of GUI window */
#define UI_LCD_POSX                 101
#define UI_LCD_POSY                 195

#elif defined(MPIO_HD300)
#define UI_TITLE                    "MPIO HD300"
#define UI_WIDTH                    286 /* width of GUI window */
#define UI_HEIGHT                   524 /* height of GUI window */
#define UI_LCD_POSX                 64
#define UI_LCD_POSY                 127

#elif defined(SANSA_CONNECT)
#define UI_TITLE                    "Sansa Connect"
#define UI_WIDTH                    371 /* width of GUI window */
#define UI_HEIGHT                   687 /* height of GUI window */
#define UI_LCD_POSX                 68
#define UI_LCD_POSY                 77

#elif defined(CREATIVE_ZENXFI3)
#define UI_TITLE                    "Creative ZEN X-Fi3"
#define UI_WIDTH                    262 /* width of GUI window */
#define UI_HEIGHT                   350 /* height of GUI window */
#define UI_LCD_POSX                 43
#define UI_LCD_POSY                 65

#elif defined(APPLICATION)
#define UI_TITLE                    "Rockbox"
#define UI_LCD_POSX                 0
#define UI_LCD_POSY                 0
#define UI_WIDTH                    LCD_WIDTH
#define UI_HEIGHT                   LCD_HEIGHT

#elif defined(SIMULATOR)
#error no UI defines
#endif

#endif /* #ifndef __UISDL_H__ */

