/* ARM part only for now */
#define AHB_SRAM 0x00000000

#define ARM_BUS0_BASE 0x18000000
#define ARM_BUS1_BASE 0x18400000

#define FLASH_BANK0 0x10000000
#define FLASH_BANK1 0x11000000

#define USB_NUM_ENDPOINTS 16
#define USB_DEVBSS_ATTR

/* Timers */
#define APB0_TIMER             (ARM_BUS0_BASE + 0x00000000)
#define TMR0LR                 (*(volatile unsigned long *)(APB0_TIMER + 0x00))
#define TMR0CVR                (*(volatile unsigned long *)(APB0_TIMER + 0x04))
#define TMR0CON                (*(volatile unsigned long *)(APB0_TIMER + 0x08))

#define TMR1LR                 (*(volatile unsigned long *)(APB0_TIMER + 0x10))
#define TMR1CVR                (*(volatile unsigned long *)(APB0_TIMER + 0x14))
#define TMR1CON                (*(volatile unsigned long *)(APB0_TIMER + 0x18))

#define TMR2LR                 (*(volatile unsigned long *)(APB0_TIMER + 0x20))
#define TMR2CVR                (*(volatile unsigned long *)(APB0_TIMER + 0x24))
#define TMR2CON                (*(volatile unsigned long *)(APB0_TIMER + 0x28))

/* UART0  */
#define APB0_UART0             (ARM_BUS0_BASE + 0x00004000)
#define UART0_RBR              (*(volatile unsigned long *)(APB0_UART0 + 0x00))
#define UART0_THR              (*(volatile unsigned long *)(APB0_UART0 + 0x00))
#define UART0_DLL              (*(volatile unsigned long *)(APB0_UART0 + 0x00))
#define UART0_DLH              (*(volatile unsigned long *)(APB0_UART0 + 0x04))
#define UART0_IER              (*(volatile unsigned long *)(APB0_UART0 + 0x04))
#define UART0_IIR              (*(volatile unsigned long *)(APB0_UART0 + 0x08))
#define UART0_FCR              (*(volatile unsigned long *)(APB0_UART0 + 0x08))
#define UART0_LCR              (*(volatile unsigned long *)(APB0_UART0 + 0x0C))
#define UART0_MCR              (*(volatile unsigned long *)(APB0_UART0 + 0x10))
#define UART0_LSR              (*(volatile unsigned long *)(APB0_UART0 + 0x14))
#define UART0_MSR              (*(volatile unsigned long *)(APB0_UART0 + 0x18))

/* UART1 */
#define APB0_UART1             (ARM_BUS0_BASE + 0x00008000)
#define UART1_RBR              (*(volatile unsigned long *)(APB0_UART1 + 0x00))
#define UART1_THR              (*(volatile unsigned long *)(APB0_UART1 + 0x00))
#define UART1_DLL              (*(volatile unsigned long *)(APB0_UART1 + 0x00))
#define UART1_DLH              (*(volatile unsigned long *)(APB0_UART1 + 0x04))
#define UART1_IER              (*(volatile unsigned long *)(APB0_UART1 + 0x04))
#define UART1_IIR              (*(volatile unsigned long *)(APB0_UART1 + 0x08))
#define UART1_FCR              (*(volatile unsigned long *)(APB0_UART1 + 0x08))
#define UART1_LCR              (*(volatile unsigned long *)(APB0_UART1 + 0x0C))
#define UART1_MCR              (*(volatile unsigned long *)(APB0_UART1 + 0x10))
#define UART1_LSR              (*(volatile unsigned long *)(APB0_UART1 + 0x14))
#define UART1_MSR              (*(volatile unsigned long *)(APB0_UART1 + 0x18))

/* GPIO ports A,B,C,D */
#define APB0_GPIO0             (ARM_BUS0_BASE + 0x0000C000)
#define GPIO_PADR              (*(volatile unsigned long *)(APB0_GPIO0 + 0x00))
#define GPIO_PACON             (*(volatile unsigned long *)(APB0_GPIO0 + 0x04))
#define GPIO_PBDR              (*(volatile unsigned long *)(APB0_GPIO0 + 0x08))
#define GPIO_PBCON             (*(volatile unsigned long *)(APB0_GPIO0 + 0x0C))
#define GPIO_PCDR              (*(volatile unsigned long *)(APB0_GPIO0 + 0x10))
#define GPIO_PCCON             (*(volatile unsigned long *)(APB0_GPIO0 + 0x14))
#define GPIO_PDDR              (*(volatile unsigned long *)(APB0_GPIO0 + 0x18))
#define GPIO_PDCON             (*(volatile unsigned long *)(APB0_GPIO0 + 0x1C))
#define GPIO_TEST              (*(volatile unsigned long *)(APB0_GPIO0 + 0x20))
#define GPIO_IEA               (*(volatile unsigned long *)(APB0_GPIO0 + 0x24))
#define GPIO_IEB               (*(volatile unsigned long *)(APB0_GPIO0 + 0x28))
#define GPIO_IEC               (*(volatile unsigned long *)(APB0_GPIO0 + 0x2C))
#define GPIO_IED               (*(volatile unsigned long *)(APB0_GPIO0 + 0x30))
#define GPIO_ISA               (*(volatile unsigned long *)(APB0_GPIO0 + 0x34))
#define GPIO_ISB               (*(volatile unsigned long *)(APB0_GPIO0 + 0x38))
#define GPIO_ISC               (*(volatile unsigned long *)(APB0_GPIO0 + 0x3C))
#define GPIO_ISD               (*(volatile unsigned long *)(APB0_GPIO0 + 0x40))
#define GPIO_IBEA              (*(volatile unsigned long *)(APB0_GPIO0 + 0x44))
#define GPIO_IBEB              (*(volatile unsigned long *)(APB0_GPIO0 + 0x48))
#define GPIO_IBEC              (*(volatile unsigned long *)(APB0_GPIO0 + 0x4C))
#define GPIO_IBED              (*(volatile unsigned long *)(APB0_GPIO0 + 0x50))
#define GPIO_IEVA              (*(volatile unsigned long *)(APB0_GPIO0 + 0x54))
#define GPIO_IEVB              (*(volatile unsigned long *)(APB0_GPIO0 + 0x58))
#define GPIO_IEVC              (*(volatile unsigned long *)(APB0_GPIO0 + 0x5C))
#define GPIO_IEVD              (*(volatile unsigned long *)(APB0_GPIO0 + 0x60))
#define GPIO_ICA               (*(volatile unsigned long *)(APB0_GPIO0 + 0x64))
#define GPIO_ICB               (*(volatile unsigned long *)(APB0_GPIO0 + 0x68))
#define GPIO_ICC               (*(volatile unsigned long *)(APB0_GPIO0 + 0x6C))
#define GPIO_ICD               (*(volatile unsigned long *)(APB0_GPIO0 + 0x70))
#define GPIO_ISR               (*(volatile unsigned long *)(APB0_GPIO0 + 0x74))

/* Watchdog */
#define APB0_WDT               (ARM_BUS0_BASE + 0x00010000)
#define WDTLR                  (*(volatile unsigned long *)(APB0_WDT + 0x00))
#define WDTCVR                 (*(volatile unsigned long *)(APB0_WDT + 0x04))
#define WDTCON                 (*(volatile unsigned long *)(APB0_WDT + 0x08))

/* RTC module documentation missing */
#define APB0_RTC               (ARM_BUS0_BASE + 0x00014000)
#define RTC_TIME               (*(volatile unsigned long *)(APB0_RTC + 0x00))
#define RTC_DATE               (*(volatile unsigned long *)(APB0_RTC + 0x04))
#define RTC_TALARM             (*(volatile unsigned long *)(APB0_RTC + 0x08))
#define RTC_DALARM             (*(volatile unsigned long *)(APB0_RTC + 0x0C))
#define RTC_CTRL               (*(volatile unsigned long *)(APB0_RTC + 0x10))
#define RTC_RESET              (*(volatile unsigned long *)(APB0_RTC + 0x14))
#define RTC_PWOFF              (*(volatile unsigned long *)(APB0_RTC + 0x18))
#define RTC_PWFAIL             (*(volatile unsigned long *)(APB0_RTC + 0x1C))

/* SPI */
#define APB0_SPI               (ARM_BUS0_BASE + 0x00018000)
#define SPI_TXR                (*(volatile unsigned long *)(APB0_SPI + 0x00))
#define SPI_RXR                (*(volatile unsigned long *)(APB0_SPI + 0x00))
#define SPI_IER                (*(volatile unsigned long *)(APB0_SPI + 0x04))
#define SPI_FCR                (*(volatile unsigned long *)(APB0_SPI + 0x08))
#define SPI_FWCR               (*(volatile unsigned long *)(APB0_SPI + 0x0C))
#define SPI_DLYCR              (*(volatile unsigned long *)(APB0_SPI + 0x10))
#define SPI_TXCR               (*(volatile unsigned long *)(APB0_SPI + 0x14))
#define SPI_RXCR               (*(volatile unsigned long *)(APB0_SPI + 0x18))
#define SPI_SSCR               (*(volatile unsigned long *)(APB0_SPI + 0x1C))
#define SPI_ISR                (*(volatile unsigned long *)(APB0_SPI + 0x20))

/* SCU module */
#define APB0_SCU               (ARM_BUS0_BASE + 0x0001C000)
#define SCU_ID                 (*(volatile unsigned long *)(APB0_SCU + 0x00))
#define SCU_REMAP              (*(volatile unsigned long *)(APB0_SCU + 0x04))
#define SCU_PLLCON1            (*(volatile unsigned long *)(APB0_SCU + 0x08))
#define SCU_PLLCON2            (*(volatile unsigned long *)(APB0_SCU + 0x0C))
#define SCU_PLLCON3            (*(volatile unsigned long *)(APB0_SCU + 0x10))
#define SCU_DIVCON1            (*(volatile unsigned long *)(APB0_SCU + 0x14))
#define SCU_CLKCFG             (*(volatile unsigned long *)(APB0_SCU + 0x18))
#define SCU_RSTCFG             (*(volatile unsigned long *)(APB0_SCU + 0x1C))
#define SCU_PWM                (*(volatile unsigned long *)(APB0_SCU + 0x20))
#define SCU_CPUPD              (*(volatile unsigned long *)(APB0_SCU + 0x24))
#define SCU_CHIPCFG            (*(volatile unsigned long *)(APB0_SCU + 0x28))
#define SCU_STATUS             (*(volatile unsigned long *)(APB0_SCU + 0x2C))
#define SCU_IOMUXA_CON         (*(volatile unsigned long *)(APB0_SCU + 0x30))
/* 20 - 31 reserved */
#define IOMUX_I2S_PAD          (1<<19)
#define IOMUX_I2S_CODEC        (0<<19)
#define IOMUX_I2C_PAD          (1<<18)
#define IOMUX_I2C_CODEC        (0<<18)
#define IOMUX_GPIO_B7          (2<<16)
#define IOMUX_NAND_CS3         (1<<16)
#define IOMUX_I2C_SDA          (0<<16)
#define IOMUX_GPIO_B6          (2<<14)
#define IOMUX_NAND_CS2         (1<<14)
#define IOMUX_I2C_SCL          (0<<14)
#define IOMUX_SPI              (2<<12)
#define IOMUX_SD               (1<<12)
#define IOMUX_GPIO_B05         (0<<12)
#define IOMUX_LCD_VSYNC        (1<<11)
#define IOMUX_GPIO_A7          (0<<11)
#define IOMUX_LCD_DEN          (1<<10)
#define IOMUX_GPIO_A6          (0<<10)
#define IOMUX_NAND_CS1         (1<<9)
#define IOMUX_GPIO_A5          (0<<9)
#define IOMUX_LCD_D22          (1<<8)
#define IOMUX_GPIO_A4          (0<<8)
#define IOMUX_UART0_NRTS       (2<<6)
#define IOMUX_LCD_D20          (1<<6)
#define IOMUX_GPIO_A3          (0<<6)
#define IOMUX_UART0_NCTS       (2<<4)
#define IOMUX_LCD_D18          (1<<4)
#define IOMUX_GPIO_A2          (0<<4)
#define IOMUX_UART0_TXD        (2<<2)
#define IOMUX_LCD_D17          (1<<2)
#define IOMUX_GPIO_A1          (0<<2)
#define IOMUX_UART0_RXD        (2<<0)
#define IOMUX_LCD_D16          (1<<0)
#define IOMUX_GPIO_A0          (0<<0)                 

#define SCU_IOMUXB_CON         (*(volatile unsigned long *)(APB0_SCU + 0x34))
/* bits 31 - 23 reserved */
#define IOMUX_HADC             (1<<22)
#define IOMUX_VIP              (0<<22)
#define IOMUX_SDRAM_CKE        (1<<21)
#define IOMUX_GPIO_D3          (0<<21)
#define IOMUX_UHC_VBUS         (1<<20)
#define IOMUX_GPIO_F4          (0<<20)
#define IOMUX_UHC_OCUR         (1<<19)
#define IOMUX_GPIO_F3          (0<<19)
#define IOMUX_GPIO_F2          (1<<18)
#define IOMUX_SDRAM_A12        (0<<18)
#define IOMUX_GPIO_F1          (1<<17)
#define IOMUX_SDRAM_A11        (0<<17)
#define IOMUX_VIP_CLK          (1<<16)
#define IOMUX_GPIO_F0          (0<<16)
#define IOMUX_LCD_D815         (1<<15)
#define IOMUX_GPIO_E07         (0<<15)
#define IOMUX_PWM3             (1<<14)
#define IOMUX_GPIO_D7          (0<<14)
#define IOMUX_PWM2             (1<<13)
#define IOMUX_GPIO_D6          (0<<13)
#define IOMUX_PWM1             (1<<12)
#define IOMUX_GPIO_D5          (0<<12)
#define IOMUX_PWM0             (1<<11)
#define IOMUX_GPIO_D4          (0<<11)
#define IOMUX_SD_WPA           (1<<10)
#define IOMUX_GPIO_D2          (0<<10)
#define IOMUX_UART1_RXD        (2<<8)
#define IOMUX_SD_CDA           (1<<8)
#define IOMUX_GPIO_D1          (0<<8)
#define IOMUX_UART1_TXD        (2<<6)
#define IOMUX_SD_PCA           (1<<6)
#define IOMUX_GPIO_D0          (0<<6)
#define IOMUX_STMEM_CS1        (1<<5)
#define IOMUX_GPIO_C7          (0<<5)
#define IOMUX_I2S_CLK          (1<<4)
#define IOMUX_GPIO_C6          (0<<4)
#define IOMUX_I2S_SDO          (1<<3)
#define IOMUX_GPIO_C5          (0<<3)
#define IOMUX_I2S_SDI          (1<<2)
#define IOMUX_GPIO_C4          (0<<2)
#define IOMUX_I2S_LRCK         (1<<1)
#define IOMUX_GPIO_C3          (0<<1)
#define IOMUX_I2S_SCLK         (1<<0)
#define IOMUX_GPIO_C2          (0<<0)

#define SCU_GPIOUPCON          (*(volatile unsigned long *)(APB0_SCU + 0x38))
#define SCU_DIVCON2            (*(volatile unsigned long *)(APB0_SCU + 0x3C))

/* I2C controller */
#define APB0_I2C               (ARM_BUS0_BASE + 0x00020000)
#define I2C_MTXR               (*(volatile unsigned long *)(APB0_I2C + 0x00))
#define I2C_MRXR               (*(volatile unsigned long *)(APB0_I2C + 0x04))
#define I2C_STXR               (*(volatile unsigned long *)(APB0_I2C + 0x08))
#define I2C_SRXR               (*(volatile unsigned long *)(APB0_I2C + 0x0C))
#define I2C_SADDR              (*(volatile unsigned long *)(APB0_I2C + 0x10))
#define I2C_IER                (*(volatile unsigned long *)(APB0_I2C + 0x14))
#define I2C_ISR                (*(volatile unsigned long *)(APB0_I2C + 0x18))
#define I2C_LCMR               (*(volatile unsigned long *)(APB0_I2C + 0x1C))
#define I2C_LSR                (*(volatile unsigned long *)(APB0_I2C + 0x20))
#define I2C_CONR               (*(volatile unsigned long *)(APB0_I2C + 0x24))
#define I2C_OPR                (*(volatile unsigned long *)(APB0_I2C + 0x28))

/* SD card controller */
#define APB0_SD                (ARM_BUS0_BASE + 0x00024000)
#define MMU_CTRL               (*(volatile unsigned long *)(APB0_SD + 0x00))
#define MMU_BIG_ENDIAN         (1<<12)
#define MMU_DMA_START          (1<<11)
#define MMU_DMA_WRITE          (1<<10)
#define MMU_MMU0_BUFI          (0<<9)
#define MMU_MMU0_BUFII         (1<<9)
#define MMU_CPU_BUFI           (0<<8)
#define MMU_CPU_BUFII          (1<<8)
#define MMU_BUFII_RESET        (1<<7)
#define MMU_BUFII_END          (1<<6)
#define MMU_BUFII_BYTE         (0<<4)
#define MMU_BUFII_HALFWORD     (1<<4)
#define MMU_BUFII_WORD         (3<<4)
#define MMU_BUFI_RESET         (1<<3)
#define MMU_BUFI_END           (1<<2)
#define MMU_BUFI_BYTE          (0<<0)
#define MMU_BUFI_HALFWORD      (1<<0)
#define MMU_BUFI_WORD          (3<<0)

#define MMU_PNRI               (*(volatile unsigned long *)(APB0_SD + 0x04))
#define CUR_PNRI               (*(volatile unsigned long *)(APB0_SD + 0x08))
#define MMU_PNRII              (*(volatile unsigned long *)(APB0_SD + 0x0C))
#define CUR_PNRII              (*(volatile unsigned long *)(APB0_SD + 0x10))
#define MMU_ADDR               (*(volatile unsigned long *)(APB0_SD + 0x14))
#define CUR_ADDR               (*(volatile unsigned long *)(APB0_SD + 0x18))
#define MMU_DATA               (*(volatile unsigned long *)(APB0_SD + 0x1C))

#define SD_CTRL                (*(volatile unsigned long *)(APB0_SD + 0x20))
#define SD_PWR_CD              (1<<13)
#define SD_PWR_CPU             (0<<13)
#define SD_DETECT_CDDAT3       (1<<12)
#define SD_DETECT_MECH         (0<<12)
#define SD_CLOCK_DIS           (1<<11)
#define SD_CLOCK_EN            (0<<11)
#define SD_DIV(x)              ((x)&0x7ff)
                 
#define SD_INT                 (*(volatile unsigned long *)(APB0_SD + 0x24))
#define CMD_RES_STAT           (1<<6)
#define DATA_XFER_STAT         (1<<5)
#define CD_DETECT_STAT         (1<<4)
#define CMD_RES_INT_EN         (1<<2)
#define DATA_XFER_INT_EN       (1<<1)
#define CD_DETECT_IN_EN        (1<<0)

#define SD_CARD                (*(volatile unsigned long *)(APB0_SD + 0x28))
#define SD_CARD_SELECT         (1<<7)
#define SD_CARD_PWR_EN         (1<<6)
#define SD_CARD_DETECT_INT_EN  (1<<5)
#define SD_CARD_BSY            (1<<2)
#define SD_CARD_WRITE_PROTECT  (1<<1)
#define SD_CARD_DETECT         (1<<0)

#define SD_CMDREST             (*(volatile unsigned long *)(APB0_SD + 0x30))
#define CMD_XFER_START         (1<<13)
#define CMD_XFER_END           (0<<13)
#define RES_XFER_START         (1<<12)
#define RES_XFER_END           (0<<12)
#define RES_R1                 (0<<9)
#define RES_R1b                (1<<9)
#define RES_R2                 (2<<9)
#define RES_R3                 (3<<9)
#define RES_R6                 (6<<9)
#define CMD_RES_ERROR          (1<<8)
/* bits 0-5 cmd index */

#define SD_CMDRES              (*(volatile unsigned long *)(APB0_SD + 0x34))
#define STAT_CMD_XFER_START    (1<<8)
#define STAT_RES_XFER_START    (1<<7)
#define STAT_CMD_RES_ERR       (1<<6)
#define STAT_CMD_RES_BUS_ERR   (1<<5)
#define STAT_RES_TIMEOUT_ERR   (1<<4)
#define STAT_RES_STARTBIT_ERR  (1<<3)
#define STAT_RES_INDEX_ERR     (1<<2)
#define STAT_RES_CRC_ERR       (1<<1)
#define STAT_RES_ENDBIT_ERR    (1<<0)

#define SD_DATAT               (*(volatile unsigned long *)(APB0_SD + 0x3C))
#define DATA_XFER_START        (1<<13)
#define DATA_XFER_WRITE        (1<<12)
#define DATA_XFER_READ         (0<<12)
#define DATA_BUS_4LINES        (1<<11) /* rk2705/6/8 does not support this mode */
#define DATA_BUS_1LINE         (0<<11)
#define DATA_XFER_DMA_EN       (1<<10)
#define DATA_XFER_DMA_DIS      (0<<10)
#define DATA_XFER_MULTI        (1<<9)
#define DATA_XFER_SINGLE       (0<<9)
#define DATA_XFER_ERR          (1<<8)
#define DATA_BUS_ERR           (1<<7)
#define DATA_TIMEOUT_ERR       (1<<6)
#define DATA_CRC_ERR           (1<<5)
#define READ_DAT_STARTBIT_ERR  (1<<4)
#define READ_DAT_ENDBIT_ERR    (1<<3)
#define WRITE_DAT_NOERR        (2<<0)
#define WRITE_DAT_CRC_ERR      (5<<0)
#define WRITE_DAT_NO_RES       (7<<0)

#define SD_CMD                 (*(volatile unsigned long *)(APB0_SD + 0x40))
#define SD_RES3                (*(volatile unsigned long *)(APB0_SD + 0x44))
#define SD_RES2                (*(volatile unsigned long *)(APB0_SD + 0x48))
#define SD_RES1                (*(volatile unsigned long *)(APB0_SD + 0x4C))
#define SD_RES0                (*(volatile unsigned long *)(APB0_SD + 0x50))

/* I2S controller */
#define APB0_I2S               (ARM_BUS0_BASE + 0x00028000)
#define I2S_OPR                (*(volatile unsigned long *)(APB0_I2S + 0x00))
#define I2S_TXR                (*(volatile unsigned long *)(APB0_I2S + 0x04))
#define I2S_RXR                (*(volatile unsigned long *)(APB0_I2S + 0x08))
#define I2S_TXCTL              (*(volatile unsigned long *)(APB0_I2S + 0x0C))
#define I2S_RXCTL              (*(volatile unsigned long *)(APB0_I2S + 0x10))
#define I2S_FIFOSTS            (*(volatile unsigned long *)(APB0_I2S + 0x14))
#define I2S_IER                (*(volatile unsigned long *)(APB0_I2S + 0x18))
#define I2S_ISR                (*(volatile unsigned long *)(APB0_I2S + 0x1C))

/* PWM timer */
#define APB0_PWM               (ARM_BUS0_BASE + 0x0002C000)
#define PWMT0_CNTR             (*(volatile unsigned long *)(APB0_PWM + 0x00))
#define PWMT0_HRC              (*(volatile unsigned long *)(APB0_PWM + 0x04))
#define PWMT0_LRC              (*(volatile unsigned long *)(APB0_PWM + 0x08))
#define PWMT0_CTRL             (*(volatile unsigned long *)(APB0_PWM + 0x0C))
#define PWMT1_CNTR             (*(volatile unsigned long *)(APB0_PWM + 0x10))
#define PWMT1_HRC              (*(volatile unsigned long *)(APB0_PWM + 0x14))
#define PWMT1_LRC              (*(volatile unsigned long *)(APB0_PWM + 0x18))
#define PWMT1_CTRL             (*(volatile unsigned long *)(APB0_PWM + 0x1C))
#define PWMT2_CNTR             (*(volatile unsigned long *)(APB0_PWM + 0x20))
#define PWMT2_HRC              (*(volatile unsigned long *)(APB0_PWM + 0x24))
#define PWMT2_LRC              (*(volatile unsigned long *)(APB0_PWM + 0x28))
#define PWMT2_CTRL             (*(volatile unsigned long *)(APB0_PWM + 0x2C))
#define PWMT3_CNTR             (*(volatile unsigned long *)(APB0_PWM + 0x30))
#define PWMT3_HRC              (*(volatile unsigned long *)(APB0_PWM + 0x34))
#define PWMT3_LRC              (*(volatile unsigned long *)(APB0_PWM + 0x38))
#define PWMT3_CTRL             (*(volatile unsigned long *)(APB0_PWM + 0x3C))

/* ADC converter */
#define APB0_ADC0              (ARM_BUS0_BASE + 0x00030000)
#define ADC_DATA               (*(volatile unsigned long *)(APB0_ADC0 + 0x00))
#define ADC_STAT               (*(volatile unsigned long *)(APB0_ADC0 + 0x04))
#define ADC_CTRL               (*(volatile unsigned long *)(APB0_ADC0 + 0x08))

/* 0x18034000 - 0x18038000 reserved */

/* GPIO ports E,F */
#define APB0_GPIO1             (ARM_BUS0_BASE + 0x00038000)
#define GPIO_PEDR              (*(volatile unsigned long *)(APB0_GPIO1 + 0x00))
#define GPIO_PECON             (*(volatile unsigned long *)(APB0_GPIO1 + 0x04))
#define GPIO_PFDR              (*(volatile unsigned long *)(APB0_GPIO1 + 0x08))
#define GPIO_PFCON             (*(volatile unsigned long *)(APB0_GPIO1 + 0x0C))

#define GPIO1_TEST             (*(volatile unsigned long *)(APB0_GPIO1 + 0x20))
#define GPIO_IEE               (*(volatile unsigned long *)(APB0_GPIO1 + 0x24))
#define GPIO_IEF               (*(volatile unsigned long *)(APB0_GPIO1 + 0x28))

#define GPIO_ISE               (*(volatile unsigned long *)(APB0_GPIO1 + 0x34))
#define GPIO_ISF               (*(volatile unsigned long *)(APB0_GPIO1 + 0x38))

#define GPIO_IBEE              (*(volatile unsigned long *)(APB0_GPIO1 + 0x44))
#define GPIO_IBEF              (*(volatile unsigned long *)(APB0_GPIO1 + 0x48))

#define GPIO_IEVE              (*(volatile unsigned long *)(APB0_GPIO1 + 0x54))
#define GPIO_IEVF              (*(volatile unsigned long *)(APB0_GPIO1 + 0x58))

#define GPIO_ICE               (*(volatile unsigned long *)(APB0_GPIO1 + 0x64))
#define GPIO_ICF               (*(volatile unsigned long *)(APB0_GPIO1 + 0x68))

#define GPIO1_ISR              (*(volatile unsigned long *)(APB0_GPIO1 + 0x74))


/* 0x1803C000 - 0x18080000 reserved */

/* Interrupt controller */
#define AHB0_INTC              (ARM_BUS0_BASE + 0x00080000)
#define INTC_SCR0              (*(volatile unsigned long *)(AHB0_INTC + 0x00))
#define INTC_SCR1              (*(volatile unsigned long *)(AHB0_INTC + 0x04))
#define INTC_SCR2              (*(volatile unsigned long *)(AHB0_INTC + 0x08))
#define INTC_SCR3              (*(volatile unsigned long *)(AHB0_INTC + 0x0C))
#define INTC_SCR4              (*(volatile unsigned long *)(AHB0_INTC + 0x10))
#define INTC_SCR5              (*(volatile unsigned long *)(AHB0_INTC + 0x14))
#define INTC_SCR6              (*(volatile unsigned long *)(AHB0_INTC + 0x18))
#define INTC_SCR7              (*(volatile unsigned long *)(AHB0_INTC + 0x1C))
#define INTC_SCR8              (*(volatile unsigned long *)(AHB0_INTC + 0x20))
#define INTC_SCR9              (*(volatile unsigned long *)(AHB0_INTC + 0x24))
#define INTC_SCR10             (*(volatile unsigned long *)(AHB0_INTC + 0x28))
#define INTC_SCR11             (*(volatile unsigned long *)(AHB0_INTC + 0x2C))
#define INTC_SCR12             (*(volatile unsigned long *)(AHB0_INTC + 0x30))
#define INTC_SCR13             (*(volatile unsigned long *)(AHB0_INTC + 0x34))
#define INTC_SCR14             (*(volatile unsigned long *)(AHB0_INTC + 0x38))
#define INTC_SCR15             (*(volatile unsigned long *)(AHB0_INTC + 0x3C))
#define INTC_SCR16             (*(volatile unsigned long *)(AHB0_INTC + 0x40))
#define INTC_SCR17             (*(volatile unsigned long *)(AHB0_INTC + 0x44))
#define INTC_SCR18             (*(volatile unsigned long *)(AHB0_INTC + 0x48))
#define INTC_SCR19             (*(volatile unsigned long *)(AHB0_INTC + 0x4C))
#define INTC_SCR20             (*(volatile unsigned long *)(AHB0_INTC + 0x50))
#define INTC_SCR21             (*(volatile unsigned long *)(AHB0_INTC + 0x54))
#define INTC_SCR22             (*(volatile unsigned long *)(AHB0_INTC + 0x58))
#define INTC_SCR23             (*(volatile unsigned long *)(AHB0_INTC + 0x5C))
#define INTC_SCR24             (*(volatile unsigned long *)(AHB0_INTC + 0x60))
#define INTC_SCR25             (*(volatile unsigned long *)(AHB0_INTC + 0x64))
#define INTC_SCR26             (*(volatile unsigned long *)(AHB0_INTC + 0x68))
#define INTC_SCR27             (*(volatile unsigned long *)(AHB0_INTC + 0x6C))
#define INTC_SCR28             (*(volatile unsigned long *)(AHB0_INTC + 0x70))
#define INTC_SCR29             (*(volatile unsigned long *)(AHB0_INTC + 0x74))
#define INTC_SCR30             (*(volatile unsigned long *)(AHB0_INTC + 0x78))
#define INTC_SCR31             (*(volatile unsigned long *)(AHB0_INTC + 0x7C))

#define INTC_ISR               (*(volatile unsigned long *)(AHB0_INTC + 0x104))
#define INTC_IPR               (*(volatile unsigned long *)(AHB0_INTC + 0x108))
#define INTC_IMR               (*(volatile unsigned long *)(AHB0_INTC + 0x10C))

#define INTC_IECR              (*(volatile unsigned long *)(AHB0_INTC + 0x114))
#define INTC_ICCR              (*(volatile unsigned long *)(AHB0_INTC + 0x118))
#define INTC_ISCR              (*(volatile unsigned long *)(AHB0_INTC + 0x11C))

#define INTC_TEST              (*(volatile unsigned long *)(AHB0_INTC + 0x124))

/* Bus arbiter module */
#define AHB0_ARBITER           (ARM_BUS0_BASE + 0x00084000)
#define ARB_MODE               (*(volatile unsigned long *)(AHB0_ARBITER + 0x00))
#define ARB_PRIO1              (*(volatile unsigned long *)(AHB0_ARBITER + 0x04))
#define ARB_PRIO2              (*(volatile unsigned long *)(AHB0_ARBITER + 0x08))
#define ARB_PRIO3              (*(volatile unsigned long *)(AHB0_ARBITER + 0x0C))
#define ARB_PRIO4              (*(volatile unsigned long *)(AHB0_ARBITER + 0x10))
#define ARB_PRIO5              (*(volatile unsigned long *)(AHB0_ARBITER + 0x14))
#define ARB_PRIO6              (*(volatile unsigned long *)(AHB0_ARBITER + 0x18))
#define ARB_PRIO7              (*(volatile unsigned long *)(AHB0_ARBITER + 0x1C))
#define ARB_PRIO8              (*(volatile unsigned long *)(AHB0_ARBITER + 0x20))
#define ARB_PRIO9              (*(volatile unsigned long *)(AHB0_ARBITER + 0x24))
#define ARB_PRIO10             (*(volatile unsigned long *)(AHB0_ARBITER + 0x28))
#define ARB_PRIO11             (*(volatile unsigned long *)(AHB0_ARBITER + 0x2C))
#define ARB_PRIO12             (*(volatile unsigned long *)(AHB0_ARBITER + 0x30))
#define ARB_PRIO13             (*(volatile unsigned long *)(AHB0_ARBITER + 0x34))
#define ARB_PRIO14             (*(volatile unsigned long *)(AHB0_ARBITER + 0x38))
#define ARB_PRIO15             (*(volatile unsigned long *)(AHB0_ARBITER + 0x3C))

/* Interprocessor communication module */
#define AHB0_CPU_MAILBOX       (ARM_BUS0_BASE + 0x00088000)
#define MAILBOX_ID             (*(volatile unsigned long *)(AHB0_CPU_MAILBOX + 0x00))
#define H2C_STA                (*(volatile unsigned long *)(AHB0_CPU_MAILBOX + 0x10))
#define H2C0_DATA              (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x20))
#define H2C0_CMD               (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x24))
#define H2C1_DATA              (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x28))
#define H2C1_CMD               (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x2C))
#define H2C2_DATA              (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x30))
#define H2C2_CMD               (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x24))
#define H2C3_DATA              (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x38))
#define H2C3_CMD               (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x3C))

#define C2H_STA                (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x40))
#define C2H0_DATA              (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x50))
#define C2H0_CMD               (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x54))
#define C2H1_DATA              (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x58))
#define C2H1_CMD               (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x5C))
#define C2H2_DATA              (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x60))
#define C2H2_CMD               (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x64))
#define C2H3_DATA              (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x68))
#define C2H3_CMD               (*(volatile unsigned long *)(AHB0_CPU_MAILBOC + 0x6C))

/* Debug module */
#define AHB0_CPU_DEBUGIF       (ARM_BUS0_BASE + 0x0008C000)

/* AHB DMA */
#define AHB0_HDMA              (ARM_BUS0_BASE + 0x00090000)
#define HDMA_CON0              (*(volatile unsigned long *)(AHB0_HDMA + 0x00))
#define HDMA_CON1              (*(volatile unsigned long *)(AHB0_HDMA + 0x04))
#define HDMA_ISRC0             (*(volatile unsigned long *)(AHB0_HDMA + 0x08))
#define HDMA_IDST0             (*(volatile unsigned long *)(AHB0_HDMA + 0x0C))
#define HDMA_ICNT0             (*(volatile unsigned long *)(AHB0_HDMA + 0x10))
#define HDMA_ISRC1             (*(volatile unsigned long *)(AHB0_HDMA + 0x14))
#define HDMA_IDST1             (*(volatile unsigned long *)(AHB0_HDMA + 0x18))
#define HDMA_ICNT1             (*(volatile unsigned long *)(AHB0_HDMA + 0x1C))
#define HDMA_CSRC0             (*(volatile unsigned long *)(AHB0_HDMA + 0x20))
#define HDMA_CDST0             (*(volatile unsigned long *)(AHB0_HDMA + 0x24))
#define HDMA_CCNT0             (*(volatile unsigned long *)(AHB0_HDMA + 0x28))
#define HDMA_CSRC1             (*(volatile unsigned long *)(AHB0_HDMA + 0x2C))
#define HDMA_CDST1             (*(volatile unsigned long *)(AHB0_HDMA + 0x30))
#define HDMA_CCNT1             (*(volatile unsigned long *)(AHB0_HDMA + 0x34))
#define HDMA_ISR               (*(volatile unsigned long *)(AHB0_HDMA + 0x38))
#define HDMA_DSR               (*(volatile unsigned long *)(AHB0_HDMA + 0x3C))
#define HDMA_ISCNT0            (*(volatile unsigned long *)(AHB0_HDMA + 0x40))
#define HDMA_IPNCNTD0          (*(volatile unsigned long *)(AHB0_HDMA + 0x44))
#define HDMA_IADDR_BS0         (*(volatile unsigned long *)(AHB0_HDMA + 0x48))
#define HDMA_ISCNT1            (*(volatile unsigned long *)(AHB0_HDMA + 0x4C))
#define HDMA_IPNCNTD1          (*(volatile unsigned long *)(AHB0_HDMA + 0x50))
#define HDMA_IADDR_BS1         (*(volatile unsigned long *)(AHB0_HDMA + 0x54))
#define HDMA_CSCNT0            (*(volatile unsigned long *)(AHB0_HDMA + 0x58))
#define HDMA_CPNCNTD0          (*(volatile unsigned long *)(AHB0_HDMA + 0x5C))
#define HDMA_CADDR_BS0         (*(volatile unsigned long *)(AHB0_HDMA + 0x60))
#define HDMA_CSCNT1            (*(volatile unsigned long *)(AHB0_HDMA + 0x64))
#define HDMA_CPNCNTD1          (*(volatile unsigned long *)(AHB0_HDMA + 0x68))
#define HDMA_CADDR_BS1         (*(volatile unsigned long *)(AHB0_HDMA + 0x6C))
#define HDMA_PACNT0            (*(volatile unsigned long *)(AHB0_HDMA + 0x70))
#define HDMA_PACNT1            (*(volatile unsigned long *)(AHB0_HDMA + 0x74))

/* AHB-to-AHB bridge controller */
#define AHB0_A2A_DMA           (ARM_BUS0_BASE + 0x00094000)
#define A2A_CON0               (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x00))
#define A2A_ISRC0              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x04))
#define A2A_IDST0              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x08))
#define A2A_ICNT0              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x0C))
#define A2A_CSRC0              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x10))
#define A2A_CDST0              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x14))
#define A2A_CCNT0              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x18))
#define A2A_CON1               (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x1C))
#define A2A_ISRC1              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x20))
#define A2A_IDST1              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x24))
#define A2A_ICNT1              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x28))
#define A2A_CSRC1              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x2C))
#define A2A_CDST1              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x30))
#define A2A_CCNT1              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x34))
#define A2A_INT_STS            (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x38))
#define A2A_DMA_STS            (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x3C))
#define A2A_ERR_ADR0           (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x40))
#define A2A_ERR_OP0            (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x44))
#define A2A_ERR_ADR1           (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x48))
#define A2A_ERR_OP1            (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x4C))
#define A2A_LCNT0              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x50))
#define A2A_LCNT1              (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x54))
#define A2A_DOMAIN             (*(volatile unsigned long *)(AHB0_A2A_DMA + 0x58))

/* 0x18098000 - 0x180A000 reserved */

/* USB device controller */
#define AHB0_UDC               (ARM_BUS0_BASE + 0x000A0000)
#define PHY_TEST_EN            (*(volatile unsigned long *)(AHB0_UDC + 0x00))
#define PHY_TEST               (*(volatile unsigned long *)(AHB0_UDC + 0x04))
#define DEV_CTL                (*(volatile unsigned long *)(AHB0_UDC + 0x08))

#define DEV_INFO               (*(volatile unsigned long *)(AHB0_UDC + 0x10))
#define EN_INT                 (*(volatile unsigned long *)(AHB0_UDC + 0x14))
#define EN_SOF_INTR            (1<<0)
#define EN_SETUP_INTR          (1<<1)
#define EN_IN0_INTR            (1<<2)
#define EN_OUT0_INTR           (1<<3)
#define EN_USBRST_INTR         (1<<4)
#define EN_RESUME_INTR         (1<<5)
#define EN_SUSP_INTR           (1<<6)
/* bit 7 reserved */
#define EN_BOUT1_INTR          (1<<8)
#define EN_BIN2_INTR           (1<<9)
#define EN_IIN3_INTR           (1<<10)
#define EN_BOUT4_INTR          (1<<11)
#define EN_BIN5_INTR           (1<<12)
#define EN_IIN6_INTR           (1<<13)
#define EN_BOUT7_INTR          (1<<14)
#define EN_BIN8_INTR           (1<<15)
#define EN_IIN9_INTR           (1<<16)
#define EN_BOUT10_INTR         (1<<17)
#define EN_BIN11_INTR          (1<<18)
#define EN_IIN12_INTR          (1<<19)
#define EN_BOUT13_INTR         (1<<20)
#define EN_BIN14_INTR          (1<<21)
#define EN_IIN15_INTR          (1<<22)
/* bits 23-26 TEST */
/* bits 27-31 reserved */

#define INT2FLAG               (*(volatile unsigned long *)(AHB0_UDC + 0x18))
#define SOF_INTR              (1<<0)
#define SETUP_INTR            (1<<1)
#define IN0_INTR              (1<<2)
#define OUT0_INTR             (1<<3)
#define USBRST_INTR           (1<<4)
#define RESUME_INTR           (1<<5)
#define SUSP_INTR             (1<<6)
/* bit 7 reserved */
#define BOUT1_INTR            (1<<8)
#define BIN2_INTR             (1<<9)
#define IIN3_INTR             (1<<10)
#define BOUT4_INTR            (1<<11)
#define BIN5_INTR             (1<<12)
#define IIN6_INTR             (1<<13)
#define BOUT7_INTR            (1<<14)
#define BIN8_INTR             (1<<15)
#define IIN9_INTR             (1<<16)
#define BOUT10_INTR           (1<<17)
#define BIN11_INTR            (1<<18)
#define IIN12_INTR            (1<<19)
#define BOUT13_INTR           (1<<20)
#define BIN14_INTR            (1<<21)
#define IIN15_INTR            (1<<22)
/* bits 23-26 TEST */
/* bits 27-31 reserved */

#define INTCON                 (*(volatile unsigned long *)(AHB0_UDC + 0x1C))
#define SETUP1                 (*(volatile unsigned long *)(AHB0_UDC + 0x20))
#define SETUP2                 (*(volatile unsigned long *)(AHB0_UDC + 0x24))
#define AHBCON                 (*(volatile unsigned long *)(AHB0_UDC + 0x28))

#define RX0STAT                (*(volatile unsigned long *)(AHB0_UDC + 0x30))
#define RX0CON                 (*(volatile unsigned long *)(AHB0_UDC + 0x34))
#define RX0FFRC                (1<<0)
#define RX0CLR                 (1<<1)
#define RX0STALL               (1<<2)
#define RX0NAK                 (1<<3)
#define EP0EN                  (1<<4)
#define RX0VOIDINTEN           (1<<5)
#define RX0ERRINTEN            (1<<6)
#define RX0ACKINTEN            (1<<7)
/* bits 8-31 reserved */

#define RX0DMACTLO             (*(volatile unsigned long *)(AHB0_UDC + 0x38))
#define RX0DMAOUTLMADDR        (*(volatile unsigned long *)(AHB0_UDC + 0x3C))
#define TX0STAT                (*(volatile unsigned long *)(AHB0_UDC + 0x40))
#define TX0CON                 (*(volatile unsigned long *)(AHB0_UDC + 0x44))
#define TX0CLR                 (1<<0)
#define TX0STALL               (1<<1)
#define TX0NAK                 (1<<2)
/* bit 3 reserved */
#define TX0VOIDINTEN           (1<<4)
#define TX0ERRINTEN            (1<<5)
#define TX0ACKINTEN            (1<<6)
/* bits 7-31 reserved */

#define TX0BUF                 (*(volatile unsigned long *)(AHB0_UDC + 0x48))
#define TX0FULL                (1<<0)
#define TX0URF                 (1<<1)
/* bits 2-31 reserved */

#define TX0DMAINCTL            (*(volatile unsigned long *)(AHB0_UDC + 0x4C))
#define TX0DMAINSTA            (1<<0)
/* bits 1-31 reserved */

#define TX0DMALM_IADDR         (*(volatile unsigned long *)(AHB0_UDC + 0x50))
#define RX1STAT                (*(volatile unsigned long *)(AHB0_UDC + 0x54))
#define RX1CON                 (*(volatile unsigned long *)(AHB0_UDC + 0x58))
#define RX1DMACTLO             (*(volatile unsigned long *)(AHB0_UDC + 0x5C))
#define RX1DMAOUTLMADDR        (*(volatile unsigned long *)(AHB0_UDC + 0x60))
#define TX2STAT                (*(volatile unsigned long *)(AHB0_UDC + 0x64))
#define TX2CON                 (*(volatile unsigned long *)(AHB0_UDC + 0x68))
#define TX2BUF                 (*(volatile unsigned long *)(AHB0_UDC + 0x6C))
#define TX2DMAINCTL            (*(volatile unsigned long *)(AHB0_UDC + 0x70))
#define TX2DMALM_IADDR         (*(volatile unsigned long *)(AHB0_UDC + 0x74))
#define TX3STAT                (*(volatile unsigned long *)(AHB0_UDC + 0x78))
#define TX3CON                 (*(volatile unsigned long *)(AHB0_UDC + 0x7C))
#define TX3BUF                 (*(volatile unsigned long *)(AHB0_UDC + 0x80))
#define TX3DMAINCTL            (*(volatile unsigned long *)(AHB0_UDC + 0x84))
#define TX3DMALM_IADDR         (*(volatile unsigned long *)(AHB0_UDC + 0x88))
#define RX4STAT                (*(volatile unsigned long *)(AHB0_UDC + 0x8C))
#define RX4CON                 (*(volatile unsigned long *)(AHB0_UDC + 0x90))
#define RX4DMACTLO             (*(volatile unsigned long *)(AHB0_UDC + 0x94))
#define RX4DMAOUTLMADDR        (*(volatile unsigned long *)(AHB0_UDC + 0x98))
#define TX5STAT                (*(volatile unsigned long *)(AHB0_UDC + 0x9C))
#define TX5CON                 (*(volatile unsigned long *)(AHB0_UDC + 0xA0))
#define TX5BUF                 (*(volatile unsigned long *)(AHB0_UDC + 0xA4))
#define TX5DMAINCTL            (*(volatile unsigned long *)(AHB0_UDC + 0xA8))
#define TX5DMALM_IADDR         (*(volatile unsigned long *)(AHB0_UDC + 0xAC))
#define TX6STAT                (*(volatile unsigned long *)(AHB0_UDC + 0xB0))
#define TX6CON                 (*(volatile unsigned long *)(AHB0_UDC + 0xB4))
#define TX6BUF                 (*(volatile unsigned long *)(AHB0_UDC + 0xB8))
#define TX6DMAINCTL            (*(volatile unsigned long *)(AHB0_UDC + 0xBC))
#define TX6DMALM_IADDR         (*(volatile unsigned long *)(AHB0_UDC + 0xC0))
#define RX7STAT                (*(volatile unsigned long *)(AHB0_UDC + 0xC4))
#define RX7CON                 (*(volatile unsigned long *)(AHB0_UDC + 0xC8))
#define RX7DMACTLO             (*(volatile unsigned long *)(AHB0_UDC + 0xCC))
#define RX7DMAOUTLMADDR        (*(volatile unsigned long *)(AHB0_UDC + 0xD0))
#define TX8STAT                (*(volatile unsigned long *)(AHB0_UDC + 0xD4))
#define TX8CON                 (*(volatile unsigned long *)(AHB0_UDC + 0xD8))
#define TX8BUF                 (*(volatile unsigned long *)(AHB0_UDC + 0xDC))
#define TX8DMAINCTL            (*(volatile unsigned long *)(AHB0_UDC + 0xE0))
#define TX8DMALM_IADDR         (*(volatile unsigned long *)(AHB0_UDC + 0xE4))
#define TX9STAT                (*(volatile unsigned long *)(AHB0_UDC + 0xE8))
#define TX9CON                 (*(volatile unsigned long *)(AHB0_UDC + 0xEC))
#define TX9BUF                 (*(volatile unsigned long *)(AHB0_UDC + 0xF0))
#define TX9DMAINCTL            (*(volatile unsigned long *)(AHB0_UDC + 0xF4))
#define TX9DMALM_IADDR         (*(volatile unsigned long *)(AHB0_UDC + 0xF8))
#define RX10STAT               (*(volatile unsigned long *)(AHB0_UDC + 0xFC))
#define RX10CON                (*(volatile unsigned long *)(AHB0_UDC + 0x100))
#define RX10DMACTLO            (*(volatile unsigned long *)(AHB0_UDC + 0x104))
#define RX10DMAOUTLMADDR       (*(volatile unsigned long *)(AHB0_UDC + 0x108))
#define TX11STAT               (*(volatile unsigned long *)(AHB0_UDC + 0x10C))
#define TX11CON                (*(volatile unsigned long *)(AHB0_UDC + 0x110))
#define TX11BUF                (*(volatile unsigned long *)(AHB0_UDC + 0x114))
#define TX11DMAINCTL           (*(volatile unsigned long *)(AHB0_UDC + 0x118))
#define TX11DMALM_IADDR        (*(volatile unsigned long *)(AHB0_UDC + 0x11C))
#define TX12STAT               (*(volatile unsigned long *)(AHB0_UDC + 0x120))
#define TX12CON                (*(volatile unsigned long *)(AHB0_UDC + 0x124))
#define TX12BUF                (*(volatile unsigned long *)(AHB0_UDC + 0x128))
#define TX12DMAINCTL           (*(volatile unsigned long *)(AHB0_UDC + 0x12C))
#define TX12DMALM_IADDR        (*(volatile unsigned long *)(AHB0_UDC + 0x130))
#define RX13STAT               (*(volatile unsigned long *)(AHB0_UDC + 0x134))
#define RX13CON                (*(volatile unsigned long *)(AHB0_UDC + 0x138))
#define RX13DMACTLO            (*(volatile unsigned long *)(AHB0_UDC + 0x13C))
#define RX13DMAOUTLMADDR       (*(volatile unsigned long *)(AHB0_UDC + 0x140))
#define TX14STAT               (*(volatile unsigned long *)(AHB0_UDC + 0x144))
#define TX14CON                (*(volatile unsigned long *)(AHB0_UDC + 0x148))
#define TX14BUF                (*(volatile unsigned long *)(AHB0_UDC + 0x14C))
#define TX14DMAINCTL           (*(volatile unsigned long *)(AHB0_UDC + 0x150))
#define TX14DMALM_IADDR        (*(volatile unsigned long *)(AHB0_UDC + 0x154))
#define TX15STAT               (*(volatile unsigned long *)(AHB0_UDC + 0x158))
#define TX15CON                (*(volatile unsigned long *)(AHB0_UDC + 0x15C))
#define TX15BUF                (*(volatile unsigned long *)(AHB0_UDC + 0x160))
#define TX15DMAINCTL           (*(volatile unsigned long *)(AHB0_UDC + 0x164))
#define TX15DMALM_IADDR        (*(volatile unsigned long *)(AHB0_UDC + 0x168))

/* USB host controller */
#define AHB0_UHC               (ARM_BUS0_BASE + 0x000A4000)
/* documentation missing */

/* 0x180A8000 - 0x180B0000 reserved */

/* Static/SDRAM memory controller */
#define AHB0_SDRSTMC           (ARM_BUS0_BASE + 0x000B0000)
#define MCSDR_MODE             (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x100))
#define MCSDR_ADDMAP           (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x104))
#define MCSDR_ADDCFG           (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x108))
#define MCSDR_BASIC            (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x10C))
#define MCSDR_T_REF            (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x110))
#define MCSDR_T_RFC            (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x114))
#define MCSDR_T_MRD            (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x118))
#define MCSDR_T_RP             (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x120))
#define MCSDR_T_RCD            (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x124))

#define MCST0_T_CEWD           (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x200))
#define MCST0_T_CE2WE          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x204))
#define MCST0_WEWD             (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x208))
#define MCST0_T_WE2CE          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x20C))
#define MCST0_T_CEWDR          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x210))
#define MCST0_T_CE2RD          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x214))
#define MCST0_T_RDWD           (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x218))
#define MCST0_T_RD2CE          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x21C))
#define MCST0_BASIC            (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x220))

#define MCST1_T_CEWD           (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x300))
#define MCST1_T_CE2WE          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x304))
#define MCST1_WEWD             (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x308))
#define MCST1_T_WE2CE          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x30C))
#define MCST1_T_CEWDR          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x310))
#define MCST1_T_CE2RD          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x314))
#define MCST1_T_RDWD           (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x318))
#define MCST1_T_RD2CE          (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x31C))
#define MCST1_BASIC            (*(volatile unsigned long *)(AHB0_SDRSTMC + 0x320))

/* 0x180B4000 - 0x180C000 reserved */

/* VIP - video input processor */
#define AHB0_VIP               (ARM_BUS0_BASE + 0x000C0000)

/* 0x180C4000 - 0x180E8000 reserved */

/* NAND flash controller */
#define AHB0_NANDC             (ARM_BUS0_BASE + 0x000E8000)

#define FMCTL                  (*(volatile unsigned long *)(AHB0_NANDC))
#define FM_RDY                 (1<<5) /* status of line R/B# */
#define FM_PROTECT             (1<<4) /* WP# line (active low) */
/* bits 0-3 are chip selects */

#define FMWAIT                 (*(volatile unsigned long *)(AHB0_NANDC + 0x04))
#define FLCTL                  (*(volatile unsigned long *)(AHB0_NANDC + 0x08))
#define FL_RDY                 (1<<12)
#define FL_COR_EN              (1<<11)
#define FL_INT_EN              (1<<10)
#define FL_XFER_EN             (1<<9)
#define FL_INTCLR_EN           (1<<8)
/* bits 3-7 unknown */
#define FL_START               (1<<2)
#define FL_WR                  (1<<1)
#define FL_RST                 (1<<0)

#define BCHCTL                 (*(volatile unsigned long *)(AHB0_NANDC + 0x0C))
/* bit 13 is used but unknown */
/* bit 12 is used but unknown */
#define BCH_WR                 (1<<1)
#define BCH_RST                (1<<0)

#define BCHST                  (*(volatile unsigned long *)(AHB0_NANDC + 0xD0))
/* bit 2 ERR ?? */
/* bit 0 ?? */

#define FLASH_DATA(n)          (*(volatile unsigned char *)(AHB0_NANDC + 0x200 + (n<<9)))
#define FLASH_ADDR(n)          (*(volatile unsigned char *)(AHB0_NANDC + 0x204 + (n<<9)))
#define FLASH_CMD(n)           (*(volatile unsigned char *)(AHB0_NANDC + 0x208 + (n<<9)))

#define PAGE_BUF               (*(volatile unsigned char *)(AHB0_NANDC + 0xA00))
#define SPARE_BUF              (*(volatile unsigned char *)(AHB0_NANDC + 0x1200))

#define AHB0_ROM               (ARM_BUS0_BASE + 0x000EC000)
#define AHB0_ES3               (ARM_BUS0_BASE + 0x000F4000)
#define AHB0_ES4               (ARM_BUS0_BASE + 0x000F8000)
#define AHB0_ES5               (ARM_BUS0_BASE + 0x000FC000)
#define AHB0_ES6               (ARM_BUS0_BASE + 0x00100000)
#define AHB0_EMD_SRAM          (ARM_BUS0_BASE + 0x00200000)

/* 0x18204000 - 0x1840000 reserved */

/* 0x18400000 - 0x18484000 reserved*/

#define AHB1_ARBITER           0x18484000
/* 0x18488000 - 0x186E8000 reserved*/

/* LCD controller */
#define AHB1_LCDC            0x186E8000
#define LCDC_CTRL            (*(volatile unsigned long *)(AHB1_LCDC + 0x00))
/* bits 14-31 reserved */
#define ALPHA24B             (1<<13)
#define UVBUFEXCH            (1<<12)
#define ALPHA(x)             (((x)&0x07)<<9)
#define Y_MIX                (1<<8)
#define LCDC_MCU             (1<<7)
#define RGB24B               (1<<6)
#define START_EVEN           (1<<5)
#define EVEN_EN              (1<<4)
#define RGB_DUMMY(x)         (((x)&0x03)<<2)
#define LCDC_EN              (1<<1)
#define LCDC_STOP            (1<<0)
#define MCU_CTRL             (*(volatile unsigned long *)(AHB1_LCDC + 0x04))

#define ALPHA_BASE(x)        (((x)&0x3f)<<8)
#define MCU_CTRL_FIFO_EN     (1<<6)
#define MCU_CTRL_RS_HIGH     (1<<5)
#define MCU_CTRL_BUFF_WRITE  (1<<2)
#define MCU_CTRL_BUFF_START  (1<<1)
#define MCU_CTRL_BYPASS      (1<<0)

#define HOR_PERIOD           (*(volatile unsigned long *)(AHB1_LCDC + 0x08))
#define VERT_PERIOD          (*(volatile unsigned long *)(AHB1_LCDC + 0x0C))
#define HOR_PW               (*(volatile unsigned long *)(AHB1_LCDC + 0x10))
#define VERT_PW              (*(volatile unsigned long *)(AHB1_LCDC + 0x14))
#define HOR_ACT              (*(volatile unsigned long *)(AHB1_LCDC + 0x18))
#define VERT_ACT             (*(volatile unsigned long *)(AHB1_LCDC + 0x1C))
#define HOR_BP               (*(volatile unsigned long *)(AHB1_LCDC + 0x20))
#define VERT_BP              (*(volatile unsigned long *)(AHB1_LCDC + 0x24))
#define LINE0_YADDR          (*(volatile unsigned long *)(AHB1_LCDC + 0x28))
#define LINE_ALPHA_EN        (1<<14)
#define LINE_SCALE_EN        (1<<13)
#define LINE_GBR             (1<<12)
#define LINE_RGB             (0<<12)
#define LINE_YUV_SRC         (1<<11)
#define LINE_RGB_SRC         (0<<11)
/* bits 0-10 Y_BASE */

#define LINE0_UVADDR         (*(volatile unsigned long *)(AHB1_LCDC + 0x2C))
#define LINE1_YADDR          (*(volatile unsigned long *)(AHB1_LCDC + 0x30))
#define LINE1_UVADDR         (*(volatile unsigned long *)(AHB1_LCDC + 0x34))
#define LINE2_YADDR          (*(volatile unsigned long *)(AHB1_LCDC + 0x38))
#define LINE2_UVADDR         (*(volatile unsigned long *)(AHB1_LCDC + 0x3C))
#define LINE3_YADDR          (*(volatile unsigned long *)(AHB1_LCDC + 0x40))
#define LINE3_UVADDR         (*(volatile unsigned long *)(AHB1_LCDC + 0x44))
#define START_X              (*(volatile unsigned long *)(AHB1_LCDC + 0x48))
#define START_Y              (*(volatile unsigned long *)(AHB1_LCDC + 0x4C))
#define DELTA_X              (*(volatile unsigned long *)(AHB1_LCDC + 0x50))
#define DELTA_Y              (*(volatile unsigned long *)(AHB1_LCDC + 0x54))
#define LCDC_INTR_MASK       (*(volatile unsigned long *)(AHB1_LCDC + 0x58))
#define INTR_MASK_LINE       (1<<3)
#define INTR_MASK_EVENLINE   (0<<3)
#define INTR_MASK_BUFF       (1<<2)
#define INTR_MASK_VERT       (1<<1)
#define INTR_MASK_HOR        (1<<0)

#define LCDC_STA             (*(volatile unsigned long *)(AHB1_LCDC + 0x7C))
#define LCDC_MCU_IDLE        (1<<12)

#define LCD_COMMAND          (*(volatile unsigned long *)(AHB1_LCDC + 0x1000))
#define LCD_DATA             (*(volatile unsigned long *)(AHB1_LCDC + 0x1004))

#define LCD_BUFF             (*(volatile unsigned long *)(AHB1_LCDC + 0x2000))
/* High speed ADC interface */
#define AHB1_HS_ADC            0x186EC000
#define HSADC_DATA           (*(volatile unsigned long *)(AHB1_HS_ADC + 0x00))
#define HSADC_CTRL           (*(volatile unsigned long *)(AHB1_HS_ADC + 0x04))
#define HSADC_IER            (*(volatile unsigned long *)(AHB1_HS_ADC + 0x08))
#define HSADC_ISR            (*(volatile unsigned long *)(AHB1_HS_ADC + 0x0C))

/* AHB-to-AHB DMA controller */
#define AHB1_DWDMA             0x186F0000
#define DWDMA_SAR(n)         (*(volatile unsigned long *)(AHB1_DWDMA + 0x00 + 0x58*n))
#define DWDMA_DAR(n)         (*(volatile unsigned long *)(AHB1_DWDMA + 0x08 + 0x58*n))
#define DWDMA_LLP(n)         (*(volatile unsigned long *)(AHB1_DWDMA + 0x10 + 0x58*n))
#define DWDMA_CTL_L(n)       (*(volatile unsigned long *)(AHB1_DWDMA + 0x18 + 0x58*n))
#define CTLL_LLP_SRC_EN      (1<<28)
#define CTLL_LLP_DST_EN      (1<<27)
#define CTLL_SMS_M2          (1<<25)
#define CTLL_SMS_M1          (0<<25)
#define CTLL_DMS_M2          (1<<23)
#define CTLL_DMS_M1          (0<<23)
#define CTLL_FC_PER2PER      (3<<20)
#define CTLL_FC_PER2MEM      (2<<20)
#define CTLL_FC_MEM2PER      (1<<20)
#define CTLL_FC_MEM2MEM      (0<<20)
/* bit 19 reserved */
#define CTLL_DST_SCATTER_EN  (1<<18)
#define CTLL_SRC_GATHER_EN   (1<<17)
#define CTLL_SRC_MSIZE_32    (4<<14)
#define CTLL_SRC_MSIZE_16    (3<<14)
#define CTLL_SRC_MSIZE_8     (2<<14)
#define CTLL_SRC_MSIZE_4     (1<<14)
#define CTLL_SRC_MSIZE_1     (0<<14)
#define CTLL_DST_MSIZE_32    (4<<11)
#define CTLL_DST_MSIZE_16    (3<<11)
#define CTLL_DST_MSIZE_8     (2<<11)
#define CTLL_DST_MSIZE_4     (1<<11)
#define CTLL_DST_MSIZE_1     (0<<11)
#define CTLL_SINC_NO         (2<<9)
#define CTLL_SINC_DEC        (1<<9)
#define CTLL_SINC_INC        (0<<9)
#define CTLL_DINC_NO         (2<<7)
#define CTLL_DINC_DEC        (1<<7)
#define CTLL_DINC_INC        (0<<7)
#define CTLL_SRC_TR_WIDTH_32 (2<<4)
#define CTLL_SRC_TR_WIDTH_16 (1<<4)
#define CTLL_SRC_TR_WIDTH_8  (0<<4)     
#define CTLL_DST_TR_WIDTH_32 (2<<1)
#define CTLL_DST_TR_WIDTH_16 (1<<1)
#define CTLL_DST_TR_WIDTH_8  (0<<1)     
#define CTLL_INT_EN          (1<<0)

#define DWDMA_CTL_H(n)       (*(volatile unsigned long *)(AHB1_DWDMA + 0x1C + 0x58*n))
#define DWDMA_SSTAT(n)       (*(volatile unsigned long *)(AHB1_DWDMA + 0x20 + 0x58*n))
#define DWDMA_DSTAT(n)       (*(volatile unsigned long *)(AHB1_DWDMA + 0x28 + 0x58*n))
#define DWDMA_SSTATAR(n)     (*(volatile unsigned long *)(AHB1_DWDMA + 0x30 + 0x58*n))
#define DWDMA_DSTATAR(n)     (*(volatile unsigned long *)(AHB1_DWDMA + 0x38 + 0x58*n))
#define DWDMA_CFG_L(n)       (*(volatile unsigned long *)(AHB1_DWDMA + 0x40 + 0x58*n))
#define CFGL_RELOAD_DST      (1<<31)
#define CFGL_RELOAD_SRC      (1<<30)
#define CFGL_MAX_ABRST(n)    ((n)<<20)
#define CFGL_SRC_HS_POL_LOW  (1<<19)
#define CFGL_DST_HS_POL_LOW  (1<<18)
#define CFGL_LOCK_B          (1<<17)
#define CFGL_LOCK_CH         (1<<16)
#define CFGL_LOCK_B_L(n)     (((n)&0x03)<<14)
#define CFGL_LOCK_CH_L(n)    (((n)&0x03)<<12)
#define CFGL_HS_SEL_SRC      (1<<11)
#define CFGL_HS_SEL_DST      (1<<10)
#define CFGL_FIFO_EMPTY      (1<<9)
#define CFGL_CH_SUSP         (1<<8)
#define CFGL_CH_PRIOR(n)     (((n) & 0x03)<<5)
/* bits 0-4 reserved */
#define DWDMA_CFG_H(n)       (*(volatile unsigned long *)(AHB1_DWDMA + 0x44 + 0x58*n))
#define CFGH_DST_PER(n)      (((n)&0x0F)<<11)
#define CFGH_SRC_PER(n)      (((n)&0x0F)<<7)
#define CFGH_SRC_UPD_EN      (1<<6)
#define CFGH_DST_UPD_EN      (1<<5)
#define CFGH_PROTCTL(n)      (((n)&0x07)<<2)
#define CFGH_FIFO_MODE       (1<<1)
#define CFGH_FC_MODE         (1<<0)

#define DWDMA_SGR(n)         (*(volatile unsigned long *)(AHB1_DWDMA + 0x48 + 0x58*n))
#define DWDMA_DSR(n)         (*(volatile unsigned long *)(AHB1_DWDMA + 0x50 + 0x58*n))

#define DWDMA_RAW_TFR        (*(volatile unsigned long *)(AHB1_DWDMA + 0x2C0))
#define DWDMA_RAW_BLOCK      (*(volatile unsigned long *)(AHB1_DWDMA + 0x2C8))
#define DWDMA_RAW_SRCTRAN    (*(volatile unsigned long *)(AHB1_DWDMA + 0x2D0))
#define DWDMA_RAW_DSTTRAN    (*(volatile unsigned long *)(AHB1_DWDMA + 0x2D8))
#define DWDMA_RAW_ERR        (*(volatile unsigned long *)(AHB1_DWDMA + 0x2E0))

#define DWDMA_STATUS_TFR     (*(volatile unsigned long *)(AHB1_DWDMA + 0x2E8))
#define DWDMA_STATUS_BLOCK   (*(volatile unsigned long *)(AHB1_DWDMA + 0x2F0))
#define DWDMA_STATUS_SRCTRAN (*(volatile unsigned long *)(AHB1_DWDMA + 0x2F8))
#define DWDMA_STATUS_DSTTRAN (*(volatile unsigned long *)(AHB1_DWDMA + 0x300))
#define DWDMA_STATUS_ERR     (*(volatile unsigned long *)(AHB1_DWDMA + 0x308))

#define DWDMA_MASK_TFR       (*(volatile unsigned long *)(AHB1_DWDMA + 0x310))
#define DWDMA_MASK_BLOCK     (*(volatile unsigned long *)(AHB1_DWDMA + 0x318))
#define DWDMA_MASK_SRCTRAN   (*(volatile unsigned long *)(AHB1_DWDMA + 0x320))
#define DWDMA_MASK_DSTTRAN   (*(volatile unsigned long *)(AHB1_DWDMA + 0x328))
#define DWDMA_MASK_ERR       (*(volatile unsigned long *)(AHB1_DWDMA + 0x330))

#define DWDMA_CLEAR_TFR      (*(volatile unsigned long *)(AHB1_DWDMA + 0x338))
#define DWDMA_CLEAR_BLOCK    (*(volatile unsigned long *)(AHB1_DWDMA + 0x340))
#define DWDMA_CLEAR_SRCTRAN  (*(volatile unsigned long *)(AHB1_DWDMA + 0x348))
#define DWDMA_CLEAR_DSTTRAN  (*(volatile unsigned long *)(AHB1_DWDMA + 0x350))
#define DWDMA_CLEAR_ERR      (*(volatile unsigned long *)(AHB1_DWDMA + 0x358))

#define DWDMA_STATUS_INT     (*(volatile unsigned long *)(AHB1_DWDMA + 0x360))

#define DWDMA_REQ_SRC        (*(volatile unsigned long *)(AHB1_DWDMA + 0x368))
#define DWDMA_REQ_DST        (*(volatile unsigned long *)(AHB1_DWDMA + 0x370))
#define DWDMA_S_REQ_SRC      (*(volatile unsigned long *)(AHB1_DWDMA + 0x378))
#define DWDMA_S_REQ_DST      (*(volatile unsigned long *)(AHB1_DWDMA + 0x380))
#define DWDMA_L_REQ_SRC      (*(volatile unsigned long *)(AHB1_DWDMA + 0x388))
#define DWDMA_L_REQ_DST      (*(volatile unsigned long *)(AHB1_DWDMA + 0x390))

#define DWDMA_DMA_CFG        (*(volatile unsigned long *)(AHB1_DWDMA + 0x398))
#define GLOB_EN              (1<<0)
#define DWDMA_DMA_CHEN       (*(volatile unsigned long *)(AHB1_DWDMA + 0x3A0))
#define DMACHEN_CH0          (0x101<<0)
#define DMACHEN_CH1          (0x101<<1)
#define DMACHEN_CH2          (0x101<<2)
#define DMACHEN_CH3          (0x101<<3)

/* ARM7 cache controller */
#define ARM_CACHE_CTRL      0xEFFF0000
#define DEVID               (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x00))
#define CACHEOP             (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x04))
#define CACHELKDN           (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x08))

#define MEMMAPA             (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x10))
#define MEMMAPB             (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x14))
#define MEMMAPC             (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x18))
#define MEMMAPD             (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x1C))
#define PFCNTRA_CTRL        (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x20))
#define PFCNTRA             (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x24))
#define PFCNTRB_CTRL        (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x28))
#define PFCNTRB             (*(volatile unsigned long *)(ARM_CACHE_CTRL + 0x2C))

/* Timer frequency */
#define TIMER_FREQ 50000000
