/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (C) 2009 Michael Sparmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/
#ifndef USB_S3C6400X_H
#define USB_S3C6400X_H




/*** OTG PHY CONTROL REGISTERS ***/
#define OPHYPWR     (*((uint32_t volatile*)(PHYBASE + 0x000)))
#define OPHYCLK     (*((uint32_t volatile*)(PHYBASE + 0x004)))
#define ORSTCON     (*((uint32_t volatile*)(PHYBASE + 0x008)))
#define OPHYUNK3    (*((uint32_t volatile*)(PHYBASE + 0x018)))
#define OPHYUNK1    (*((uint32_t volatile*)(PHYBASE + 0x01c)))
#define OPHYUNK2    (*((uint32_t volatile*)(PHYBASE + 0x044)))

/*** OTG LINK CORE REGISTERS ***/
/* Core Global Registers */
#define GOTGCTL     (*((uint32_t volatile*)(OTGBASE + 0x000)))
#define GOTGINT     (*((uint32_t volatile*)(OTGBASE + 0x004)))
#define GAHBCFG     (*((uint32_t volatile*)(OTGBASE + 0x008)))
#define GUSBCFG     (*((uint32_t volatile*)(OTGBASE + 0x00C)))
#define GRSTCTL     (*((uint32_t volatile*)(OTGBASE + 0x010)))
#define GINTSTS     (*((uint32_t volatile*)(OTGBASE + 0x014)))
#define GINTMSK     (*((uint32_t volatile*)(OTGBASE + 0x018)))
#define GRXSTSR     (*((uint32_t volatile*)(OTGBASE + 0x01C)))
#define GRXSTSP     (*((uint32_t volatile*)(OTGBASE + 0x020)))
#define GRXFSIZ     (*((uint32_t volatile*)(OTGBASE + 0x024)))
#define GNPTXFSIZ   (*((uint32_t volatile*)(OTGBASE + 0x028)))
#define GNPTXSTS    (*((uint32_t volatile*)(OTGBASE + 0x02C)))
#define HPTXFSIZ    (*((uint32_t volatile*)(OTGBASE + 0x100)))
#define DPTXFSIZ(x) (*((uint32_t volatile*)(OTGBASE + 0x100 + 4 * (x))))
#define DPTXFSIZ1   (*((uint32_t volatile*)(OTGBASE + 0x104)))
#define DPTXFSIZ2   (*((uint32_t volatile*)(OTGBASE + 0x108)))
#define DPTXFSIZ3   (*((uint32_t volatile*)(OTGBASE + 0x10C)))
#define DPTXFSIZ4   (*((uint32_t volatile*)(OTGBASE + 0x110)))
#define DPTXFSIZ5   (*((uint32_t volatile*)(OTGBASE + 0x114)))
#define DPTXFSIZ6   (*((uint32_t volatile*)(OTGBASE + 0x118)))
#define DPTXFSIZ7   (*((uint32_t volatile*)(OTGBASE + 0x11C)))
#define DPTXFSIZ8   (*((uint32_t volatile*)(OTGBASE + 0x120)))
#define DPTXFSIZ9   (*((uint32_t volatile*)(OTGBASE + 0x124)))
#define DPTXFSIZ10  (*((uint32_t volatile*)(OTGBASE + 0x128)))
#define DPTXFSIZ11  (*((uint32_t volatile*)(OTGBASE + 0x12C)))
#define DPTXFSIZ12  (*((uint32_t volatile*)(OTGBASE + 0x130)))
#define DPTXFSIZ13  (*((uint32_t volatile*)(OTGBASE + 0x134)))
#define DPTXFSIZ14  (*((uint32_t volatile*)(OTGBASE + 0x138)))
#define DPTXFSIZ15  (*((uint32_t volatile*)(OTGBASE + 0x13C)))

/*** HOST MODE REGISTERS ***/
/* Host Global Registers */
#define HCFG        (*((uint32_t volatile*)(OTGBASE + 0x400)))
#define HFIR        (*((uint32_t volatile*)(OTGBASE + 0x404)))
#define HFNUM       (*((uint32_t volatile*)(OTGBASE + 0x408)))
#define HPTXSTS     (*((uint32_t volatile*)(OTGBASE + 0x410)))
#define HAINT       (*((uint32_t volatile*)(OTGBASE + 0x414)))
#define HAINTMSK    (*((uint32_t volatile*)(OTGBASE + 0x418)))

/* Host Port Control and Status Registers */
#define HPRT        (*((uint32_t volatile*)(OTGBASE + 0x440)))

/* Host Channel-Specific Registers */
#define HCCHAR(x)   (*((uint32_t volatile*)(OTGBASE + 0x500 + 0x20 * (x))))
#define HCSPLT(x)   (*((uint32_t volatile*)(OTGBASE + 0x504 + 0x20 * (x))))
#define HCINT(x)    (*((uint32_t volatile*)(OTGBASE + 0x508 + 0x20 * (x))))
#define HCINTMSK(x) (*((uint32_t volatile*)(OTGBASE + 0x50C + 0x20 * (x))))
#define HCTSIZ(x)   (*((uint32_t volatile*)(OTGBASE + 0x510 + 0x20 * (x))))
#define HCDMA(x)    (*((uint32_t volatile*)(OTGBASE + 0x514 + 0x20 * (x))))
#define HCCHAR0     (*((uint32_t volatile*)(OTGBASE + 0x500)))
#define HCSPLT0     (*((uint32_t volatile*)(OTGBASE + 0x504)))
#define HCINT0      (*((uint32_t volatile*)(OTGBASE + 0x508)))
#define HCINTMSK0   (*((uint32_t volatile*)(OTGBASE + 0x50C)))
#define HCTSIZ0     (*((uint32_t volatile*)(OTGBASE + 0x510)))
#define HCDMA0      (*((uint32_t volatile*)(OTGBASE + 0x514)))
#define HCCHAR1     (*((uint32_t volatile*)(OTGBASE + 0x520)))
#define HCSPLT1     (*((uint32_t volatile*)(OTGBASE + 0x524)))
#define HCINT1      (*((uint32_t volatile*)(OTGBASE + 0x528)))
#define HCINTMSK1   (*((uint32_t volatile*)(OTGBASE + 0x52C)))
#define HCTSIZ1     (*((uint32_t volatile*)(OTGBASE + 0x530)))
#define HCDMA1      (*((uint32_t volatile*)(OTGBASE + 0x534)))
#define HCCHAR2     (*((uint32_t volatile*)(OTGBASE + 0x540)))
#define HCSPLT2     (*((uint32_t volatile*)(OTGBASE + 0x544)))
#define HCINT2      (*((uint32_t volatile*)(OTGBASE + 0x548)))
#define HCINTMSK2   (*((uint32_t volatile*)(OTGBASE + 0x54C)))
#define HCTSIZ2     (*((uint32_t volatile*)(OTGBASE + 0x550)))
#define HCDMA2      (*((uint32_t volatile*)(OTGBASE + 0x554)))
#define HCCHAR3     (*((uint32_t volatile*)(OTGBASE + 0x560)))
#define HCSPLT3     (*((uint32_t volatile*)(OTGBASE + 0x564)))
#define HCINT3      (*((uint32_t volatile*)(OTGBASE + 0x568)))
#define HCINTMSK3   (*((uint32_t volatile*)(OTGBASE + 0x56C)))
#define HCTSIZ3     (*((uint32_t volatile*)(OTGBASE + 0x570)))
#define HCDMA3      (*((uint32_t volatile*)(OTGBASE + 0x574)))
#define HCCHAR4     (*((uint32_t volatile*)(OTGBASE + 0x580)))
#define HCSPLT4     (*((uint32_t volatile*)(OTGBASE + 0x584)))
#define HCINT4      (*((uint32_t volatile*)(OTGBASE + 0x588)))
#define HCINTMSK4   (*((uint32_t volatile*)(OTGBASE + 0x58C)))
#define HCTSIZ4     (*((uint32_t volatile*)(OTGBASE + 0x590)))
#define HCDMA4      (*((uint32_t volatile*)(OTGBASE + 0x594)))
#define HCCHAR5     (*((uint32_t volatile*)(OTGBASE + 0x5A0)))
#define HCSPLT5     (*((uint32_t volatile*)(OTGBASE + 0x5A4)))
#define HCINT5      (*((uint32_t volatile*)(OTGBASE + 0x5A8)))
#define HCINTMSK5   (*((uint32_t volatile*)(OTGBASE + 0x5AC)))
#define HCTSIZ5     (*((uint32_t volatile*)(OTGBASE + 0x5B0)))
#define HCDMA5      (*((uint32_t volatile*)(OTGBASE + 0x5B4)))
#define HCCHAR6     (*((uint32_t volatile*)(OTGBASE + 0x5C0)))
#define HCSPLT6     (*((uint32_t volatile*)(OTGBASE + 0x5C4)))
#define HCINT6      (*((uint32_t volatile*)(OTGBASE + 0x5C8)))
#define HCINTMSK6   (*((uint32_t volatile*)(OTGBASE + 0x5CC)))
#define HCTSIZ6     (*((uint32_t volatile*)(OTGBASE + 0x5D0)))
#define HCDMA6      (*((uint32_t volatile*)(OTGBASE + 0x5D4)))
#define HCCHAR7     (*((uint32_t volatile*)(OTGBASE + 0x5E0)))
#define HCSPLT7     (*((uint32_t volatile*)(OTGBASE + 0x5E4)))
#define HCINT7      (*((uint32_t volatile*)(OTGBASE + 0x5E8)))
#define HCINTMSK7   (*((uint32_t volatile*)(OTGBASE + 0x5EC)))
#define HCTSIZ7     (*((uint32_t volatile*)(OTGBASE + 0x5F0)))
#define HCDMA7      (*((uint32_t volatile*)(OTGBASE + 0x5F4)))
#define HCCHAR8     (*((uint32_t volatile*)(OTGBASE + 0x600)))
#define HCSPLT8     (*((uint32_t volatile*)(OTGBASE + 0x604)))
#define HCINT8      (*((uint32_t volatile*)(OTGBASE + 0x608)))
#define HCINTMSK8   (*((uint32_t volatile*)(OTGBASE + 0x60C)))
#define HCTSIZ8     (*((uint32_t volatile*)(OTGBASE + 0x610)))
#define HCDMA8      (*((uint32_t volatile*)(OTGBASE + 0x614)))
#define HCCHAR9     (*((uint32_t volatile*)(OTGBASE + 0x620)))
#define HCSPLT9     (*((uint32_t volatile*)(OTGBASE + 0x624)))
#define HCINT9      (*((uint32_t volatile*)(OTGBASE + 0x628)))
#define HCINTMSK9   (*((uint32_t volatile*)(OTGBASE + 0x62C)))
#define HCTSIZ9     (*((uint32_t volatile*)(OTGBASE + 0x630)))
#define HCDMA9      (*((uint32_t volatile*)(OTGBASE + 0x634)))
#define HCCHAR10    (*((uint32_t volatile*)(OTGBASE + 0x640)))
#define HCSPLT10    (*((uint32_t volatile*)(OTGBASE + 0x644)))
#define HCINT10     (*((uint32_t volatile*)(OTGBASE + 0x648)))
#define HCINTMSK10  (*((uint32_t volatile*)(OTGBASE + 0x64C)))
#define HCTSIZ10    (*((uint32_t volatile*)(OTGBASE + 0x650)))
#define HCDMA10     (*((uint32_t volatile*)(OTGBASE + 0x654)))
#define HCCHAR11    (*((uint32_t volatile*)(OTGBASE + 0x660)))
#define HCSPLT11    (*((uint32_t volatile*)(OTGBASE + 0x664)))
#define HCINT11     (*((uint32_t volatile*)(OTGBASE + 0x668)))
#define HCINTMSK11  (*((uint32_t volatile*)(OTGBASE + 0x66C)))
#define HCTSIZ11    (*((uint32_t volatile*)(OTGBASE + 0x670)))
#define HCDMA11     (*((uint32_t volatile*)(OTGBASE + 0x674)))
#define HCCHAR12    (*((uint32_t volatile*)(OTGBASE + 0x680)))
#define HCSPLT12    (*((uint32_t volatile*)(OTGBASE + 0x684)))
#define HCINT12     (*((uint32_t volatile*)(OTGBASE + 0x688)))
#define HCINTMSK12  (*((uint32_t volatile*)(OTGBASE + 0x68C)))
#define HCTSIZ12    (*((uint32_t volatile*)(OTGBASE + 0x690)))
#define HCDMA12     (*((uint32_t volatile*)(OTGBASE + 0x694)))
#define HCCHAR13    (*((uint32_t volatile*)(OTGBASE + 0x6A0)))
#define HCSPLT13    (*((uint32_t volatile*)(OTGBASE + 0x6A4)))
#define HCINT13     (*((uint32_t volatile*)(OTGBASE + 0x6A8)))
#define HCINTMSK13  (*((uint32_t volatile*)(OTGBASE + 0x6AC)))
#define HCTSIZ13    (*((uint32_t volatile*)(OTGBASE + 0x6B0)))
#define HCDMA13     (*((uint32_t volatile*)(OTGBASE + 0x6B4)))
#define HCCHAR14    (*((uint32_t volatile*)(OTGBASE + 0x6C0)))
#define HCSPLT14    (*((uint32_t volatile*)(OTGBASE + 0x6C4)))
#define HCINT14     (*((uint32_t volatile*)(OTGBASE + 0x6C8)))
#define HCINTMSK14  (*((uint32_t volatile*)(OTGBASE + 0x6CC)))
#define HCTSIZ14    (*((uint32_t volatile*)(OTGBASE + 0x6D0)))
#define HCDMA14     (*((uint32_t volatile*)(OTGBASE + 0x6D4)))
#define HCCHAR15    (*((uint32_t volatile*)(OTGBASE + 0x6E0)))
#define HCSPLT15    (*((uint32_t volatile*)(OTGBASE + 0x6E4)))
#define HCINT15     (*((uint32_t volatile*)(OTGBASE + 0x6E8)))
#define HCINTMSK15  (*((uint32_t volatile*)(OTGBASE + 0x6EC)))
#define HCTSIZ15    (*((uint32_t volatile*)(OTGBASE + 0x6F0)))
#define HCDMA15     (*((uint32_t volatile*)(OTGBASE + 0x6F4)))

/*** DEVICE MODE REGISTERS ***/
/* Device Global Registers */
#define DCFG        (*((uint32_t volatile*)(OTGBASE + 0x800)))
#define DCTL        (*((uint32_t volatile*)(OTGBASE + 0x804)))
#define DSTS        (*((uint32_t volatile*)(OTGBASE + 0x808)))
#define DIEPMSK     (*((uint32_t volatile*)(OTGBASE + 0x810)))
#define DOEPMSK     (*((uint32_t volatile*)(OTGBASE + 0x814)))
#define DAINT       (*((uint32_t volatile*)(OTGBASE + 0x818)))
#define DAINTMSK    (*((uint32_t volatile*)(OTGBASE + 0x81C)))
#define DTKNQR1     (*((uint32_t volatile*)(OTGBASE + 0x820)))
#define DTKNQR2     (*((uint32_t volatile*)(OTGBASE + 0x824)))
#define DVBUSDIS    (*((uint32_t volatile*)(OTGBASE + 0x828)))
#define DVBUSPULSE  (*((uint32_t volatile*)(OTGBASE + 0x82C)))
#define DTKNQR3     (*((uint32_t volatile*)(OTGBASE + 0x830)))
#define DTKNQR4     (*((uint32_t volatile*)(OTGBASE + 0x834)))

/* Device Logical IN Endpoint-Specific Registers */
#define DIEPCTL(x)  (*((uint32_t volatile*)(OTGBASE + 0x900 + 0x20 * (x))))
#define DIEPINT(x)  (*((uint32_t volatile*)(OTGBASE + 0x908 + 0x20 * (x))))
#define DIEPTSIZ(x) (*((uint32_t volatile*)(OTGBASE + 0x910 + 0x20 * (x))))
#define DIEPDMA(x)  (*((const void* volatile*)(OTGBASE + 0x914 + 0x20 * (x))))
#define DIEPCTL0    (*((uint32_t volatile*)(OTGBASE + 0x900)))
#define DIEPINT0    (*((uint32_t volatile*)(OTGBASE + 0x908)))
#define DIEPTSIZ0   (*((uint32_t volatile*)(OTGBASE + 0x910)))
#define DIEPDMA0    (*((const void* volatile*)(OTGBASE + 0x914)))
#define DIEPCTL1    (*((uint32_t volatile*)(OTGBASE + 0x920)))
#define DIEPINT1    (*((uint32_t volatile*)(OTGBASE + 0x928)))
#define DIEPTSIZ1   (*((uint32_t volatile*)(OTGBASE + 0x930)))
#define DIEPDMA1    (*((const void* volatile*)(OTGBASE + 0x934)))
#define DIEPCTL2    (*((uint32_t volatile*)(OTGBASE + 0x940)))
#define DIEPINT2    (*((uint32_t volatile*)(OTGBASE + 0x948)))
#define DIEPTSIZ2   (*((uint32_t volatile*)(OTGBASE + 0x950)))
#define DIEPDMA2    (*((const void* volatile*)(OTGBASE + 0x954)))
#define DIEPCTL3    (*((uint32_t volatile*)(OTGBASE + 0x960)))
#define DIEPINT3    (*((uint32_t volatile*)(OTGBASE + 0x968)))
#define DIEPTSIZ3   (*((uint32_t volatile*)(OTGBASE + 0x970)))
#define DIEPDMA3    (*((const void* volatile*)(OTGBASE + 0x974)))
#define DIEPCTL4    (*((uint32_t volatile*)(OTGBASE + 0x980)))
#define DIEPINT4    (*((uint32_t volatile*)(OTGBASE + 0x988)))
#define DIEPTSIZ4   (*((uint32_t volatile*)(OTGBASE + 0x990)))
#define DIEPDMA4    (*((const void* volatile*)(OTGBASE + 0x994)))
#define DIEPCTL5    (*((uint32_t volatile*)(OTGBASE + 0x9A0)))
#define DIEPINT5    (*((uint32_t volatile*)(OTGBASE + 0x9A8)))
#define DIEPTSIZ5   (*((uint32_t volatile*)(OTGBASE + 0x9B0)))
#define DIEPDMA5    (*((const void* volatile*)(OTGBASE + 0x9B4)))
#define DIEPCTL6    (*((uint32_t volatile*)(OTGBASE + 0x9C0)))
#define DIEPINT6    (*((uint32_t volatile*)(OTGBASE + 0x9C8)))
#define DIEPTSIZ6   (*((uint32_t volatile*)(OTGBASE + 0x9D0)))
#define DIEPDMA6    (*((const void* volatile*)(OTGBASE + 0x9D4)))
#define DIEPCTL7    (*((uint32_t volatile*)(OTGBASE + 0x9E0)))
#define DIEPINT7    (*((uint32_t volatile*)(OTGBASE + 0x9E8)))
#define DIEPTSIZ7   (*((uint32_t volatile*)(OTGBASE + 0x9F0)))
#define DIEPDMA7    (*((const void* volatile*)(OTGBASE + 0x9F4)))
#define DIEPCTL8    (*((uint32_t volatile*)(OTGBASE + 0xA00)))
#define DIEPINT8    (*((uint32_t volatile*)(OTGBASE + 0xA08)))
#define DIEPTSIZ8   (*((uint32_t volatile*)(OTGBASE + 0xA10)))
#define DIEPDMA8    (*((const void* volatile*)(OTGBASE + 0xA14)))
#define DIEPCTL9    (*((uint32_t volatile*)(OTGBASE + 0xA20)))
#define DIEPINT9    (*((uint32_t volatile*)(OTGBASE + 0xA28)))
#define DIEPTSIZ9   (*((uint32_t volatile*)(OTGBASE + 0xA30)))
#define DIEPDMA9    (*((const void* volatile*)(OTGBASE + 0xA34)))
#define DIEPCTL10   (*((uint32_t volatile*)(OTGBASE + 0xA40)))
#define DIEPINT10   (*((uint32_t volatile*)(OTGBASE + 0xA48)))
#define DIEPTSIZ10  (*((uint32_t volatile*)(OTGBASE + 0xA50)))
#define DIEPDMA10   (*((const void* volatile*)(OTGBASE + 0xA54)))
#define DIEPCTL11   (*((uint32_t volatile*)(OTGBASE + 0xA60)))
#define DIEPINT11   (*((uint32_t volatile*)(OTGBASE + 0xA68)))
#define DIEPTSIZ11  (*((uint32_t volatile*)(OTGBASE + 0xA70)))
#define DIEPDMA11   (*((const void* volatile*)(OTGBASE + 0xA74)))
#define DIEPCTL12   (*((uint32_t volatile*)(OTGBASE + 0xA80)))
#define DIEPINT12   (*((uint32_t volatile*)(OTGBASE + 0xA88)))
#define DIEPTSIZ12  (*((uint32_t volatile*)(OTGBASE + 0xA90)))
#define DIEPDMA12   (*((const void* volatile*)(OTGBASE + 0xA94)))
#define DIEPCTL13   (*((uint32_t volatile*)(OTGBASE + 0xAA0)))
#define DIEPINT13   (*((uint32_t volatile*)(OTGBASE + 0xAA8)))
#define DIEPTSIZ13  (*((uint32_t volatile*)(OTGBASE + 0xAB0)))
#define DIEPDMA13   (*((const void* volatile*)(OTGBASE + 0xAB4)))
#define DIEPCTL14   (*((uint32_t volatile*)(OTGBASE + 0xAC0)))
#define DIEPINT14   (*((uint32_t volatile*)(OTGBASE + 0xAC8)))
#define DIEPTSIZ14  (*((uint32_t volatile*)(OTGBASE + 0xAD0)))
#define DIEPDMA14   (*((const void* volatile*)(OTGBASE + 0xAD4)))
#define DIEPCTL15   (*((uint32_t volatile*)(OTGBASE + 0xAE0)))
#define DIEPINT15   (*((uint32_t volatile*)(OTGBASE + 0xAE8)))
#define DIEPTSIZ15  (*((uint32_t volatile*)(OTGBASE + 0xAF0)))
#define DIEPDMA15   (*((const void* volatile*)(OTGBASE + 0xAF4)))

/* Device Logical OUT Endpoint-Specific Registers */
#define DOEPCTL(x)  (*((uint32_t volatile*)(OTGBASE + 0xB00 + 0x20 * (x))))
#define DOEPINT(x)  (*((uint32_t volatile*)(OTGBASE + 0xB08 + 0x20 * (x))))
#define DOEPTSIZ(x) (*((uint32_t volatile*)(OTGBASE + 0xB10 + 0x20 * (x))))
#define DOEPDMA(x)  (*((void* volatile*)(OTGBASE + 0xB14 + 0x20 * (x))))
#define DOEPCTL0    (*((uint32_t volatile*)(OTGBASE + 0xB00)))
#define DOEPINT0    (*((uint32_t volatile*)(OTGBASE + 0xB08)))
#define DOEPTSIZ0   (*((uint32_t volatile*)(OTGBASE + 0xB10)))
#define DOEPDMA0    (*((void* volatile*)(OTGBASE + 0xB14)))
#define DOEPCTL1    (*((uint32_t volatile*)(OTGBASE + 0xB20)))
#define DOEPINT1    (*((uint32_t volatile*)(OTGBASE + 0xB28)))
#define DOEPTSIZ1   (*((uint32_t volatile*)(OTGBASE + 0xB30)))
#define DOEPDMA1    (*((void* volatile*)(OTGBASE + 0xB34)))
#define DOEPCTL2    (*((uint32_t volatile*)(OTGBASE + 0xB40)))
#define DOEPINT2    (*((uint32_t volatile*)(OTGBASE + 0xB48)))
#define DOEPTSIZ2   (*((uint32_t volatile*)(OTGBASE + 0xB50)))
#define DOEPDMA2    (*((void* volatile*)(OTGBASE + 0xB54)))
#define DOEPCTL3    (*((uint32_t volatile*)(OTGBASE + 0xB60)))
#define DOEPINT3    (*((uint32_t volatile*)(OTGBASE + 0xB68)))
#define DOEPTSIZ3   (*((uint32_t volatile*)(OTGBASE + 0xB70)))
#define DOEPDMA3    (*((void* volatile*)(OTGBASE + 0xB74)))
#define DOEPCTL4    (*((uint32_t volatile*)(OTGBASE + 0xB80)))
#define DOEPINT4    (*((uint32_t volatile*)(OTGBASE + 0xB88)))
#define DOEPTSIZ4   (*((uint32_t volatile*)(OTGBASE + 0xB90)))
#define DOEPDMA4    (*((void* volatile*)(OTGBASE + 0xB94)))
#define DOEPCTL5    (*((uint32_t volatile*)(OTGBASE + 0xBA0)))
#define DOEPINT5    (*((uint32_t volatile*)(OTGBASE + 0xBA8)))
#define DOEPTSIZ5   (*((uint32_t volatile*)(OTGBASE + 0xBB0)))
#define DOEPDMA5    (*((void* volatile*)(OTGBASE + 0xBB4)))
#define DOEPCTL6    (*((uint32_t volatile*)(OTGBASE + 0xBC0)))
#define DOEPINT6    (*((uint32_t volatile*)(OTGBASE + 0xBC8)))
#define DOEPTSIZ6   (*((uint32_t volatile*)(OTGBASE + 0xBD0)))
#define DOEPDMA6    (*((void* volatile*)(OTGBASE + 0xBD4)))
#define DOEPCTL7    (*((uint32_t volatile*)(OTGBASE + 0xBE0)))
#define DOEPINT7    (*((uint32_t volatile*)(OTGBASE + 0xBE8)))
#define DOEPTSIZ7   (*((uint32_t volatile*)(OTGBASE + 0xBF0)))
#define DOEPDMA7    (*((void* volatile*)(OTGBASE + 0xBF4)))
#define DOEPCTL8    (*((uint32_t volatile*)(OTGBASE + 0xC00)))
#define DOEPINT8    (*((uint32_t volatile*)(OTGBASE + 0xC08)))
#define DOEPTSIZ8   (*((uint32_t volatile*)(OTGBASE + 0xC10)))
#define DOEPDMA8    (*((void* volatile*)(OTGBASE + 0xC14)))
#define DOEPCTL9    (*((uint32_t volatile*)(OTGBASE + 0xC20)))
#define DOEPINT9    (*((uint32_t volatile*)(OTGBASE + 0xC28)))
#define DOEPTSIZ9   (*((uint32_t volatile*)(OTGBASE + 0xC30)))
#define DOEPDMA9    (*((void* volatile*)(OTGBASE + 0xC34)))
#define DOEPCTL10   (*((uint32_t volatile*)(OTGBASE + 0xC40)))
#define DOEPINT10   (*((uint32_t volatile*)(OTGBASE + 0xC48)))
#define DOEPTSIZ10  (*((uint32_t volatile*)(OTGBASE + 0xC50)))
#define DOEPDMA10   (*((void* volatile*)(OTGBASE + 0xC54)))
#define DOEPCTL11   (*((uint32_t volatile*)(OTGBASE + 0xC60)))
#define DOEPINT11   (*((uint32_t volatile*)(OTGBASE + 0xC68)))
#define DOEPTSIZ11  (*((uint32_t volatile*)(OTGBASE + 0xC70)))
#define DOEPDMA11   (*((void* volatile*)(OTGBASE + 0xC74)))
#define DOEPCTL12   (*((uint32_t volatile*)(OTGBASE + 0xC80)))
#define DOEPINT12   (*((uint32_t volatile*)(OTGBASE + 0xC88)))
#define DOEPTSIZ12  (*((uint32_t volatile*)(OTGBASE + 0xC90)))
#define DOEPDMA12   (*((void* volatile*)(OTGBASE + 0xC94)))
#define DOEPCTL13   (*((uint32_t volatile*)(OTGBASE + 0xCA0)))
#define DOEPINT13   (*((uint32_t volatile*)(OTGBASE + 0xCA8)))
#define DOEPTSIZ13  (*((uint32_t volatile*)(OTGBASE + 0xCB0)))
#define DOEPDMA13   (*((void* volatile*)(OTGBASE + 0xCB4)))
#define DOEPCTL14   (*((uint32_t volatile*)(OTGBASE + 0xCC0)))
#define DOEPINT14   (*((uint32_t volatile*)(OTGBASE + 0xCC8)))
#define DOEPTSIZ14  (*((uint32_t volatile*)(OTGBASE + 0xCD0)))
#define DOEPDMA14   (*((void* volatile*)(OTGBASE + 0xCD4)))
#define DOEPCTL15   (*((uint32_t volatile*)(OTGBASE + 0xCE0)))
#define DOEPINT15   (*((uint32_t volatile*)(OTGBASE + 0xCE8)))
#define DOEPTSIZ15  (*((uint32_t volatile*)(OTGBASE + 0xCF0)))
#define DOEPDMA15   (*((void* volatile*)(OTGBASE + 0xCF4)))

/* Power and Clock Gating Register */
#define PCGCCTL     (*((uint32_t volatile*)(OTGBASE + 0xE00)))


#endif /* USB_S3C6400X_H */
