/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (C) 2007 Jonathan Gordon
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/

#include <stdbool.h>
#include <string.h>
#include "config.h"
#include "lang.h"
#include "action.h"
#include "settings.h"
#include "menu.h"
#include "playlist_menu.h"

#include "file.h"
#include "keyboard.h"
#include "playlist.h"
#include "tree.h"
#include "playlist_viewer.h"
#include "talk.h"
#include "playlist_catalog.h"

int save_playlist_screen(struct playlist_info* playlist)
{
    char temp[MAX_PATH+1];
    int len;

    playlist_get_name(playlist, temp, sizeof(temp)-1);
    len = strlen(temp);

    if (len > 4 && !strcasecmp(&temp[len-4], ".m3u"))
        strcat(temp, "8");
    
    if (len <= 5 || strcasecmp(&temp[len-5], ".m3u8"))
        strcpy(temp, DEFAULT_DYNAMIC_PLAYLIST_NAME);

    if (!kbd_input(temp, sizeof(temp)))
    {
        playlist_save(playlist, temp);

        /* reload in case playlist was saved to cwd */
        reload_directory();
    }

    return 0;
}

static int playlist_view_(void)
{
    return GO_TO_PLAYLIST_VIEWER;
}

MENUITEM_FUNCTION(create_playlist_item, 0, ID2P(LANG_CREATE_PLAYLIST), 
                  (int(*)(void))create_playlist, NULL, NULL, Icon_NOICON);
MENUITEM_FUNCTION(view_cur_playlist, MENU_FUNC_CHECK_RETVAL,
                  ID2P(LANG_VIEW_DYNAMIC_PLAYLIST), 
                  (int(*)(void))playlist_view_, NULL, NULL, Icon_NOICON);
MENUITEM_FUNCTION(save_playlist, MENU_FUNC_USEPARAM, ID2P(LANG_SAVE_DYNAMIC_PLAYLIST), 
                         (int(*)(void*))save_playlist_screen, 
                        NULL, NULL, Icon_NOICON);
MENUITEM_FUNCTION(catalog, 0, ID2P(LANG_CATALOG_VIEW), 
                  (int(*)(void))catalog_view_playlists,
                   NULL, NULL, Icon_NOICON);
MENUITEM_SETTING(recursive_dir_insert, &global_settings.recursive_dir_insert, NULL);
MENUITEM_SETTING(warn_on_erase, &global_settings.warnon_erase_dynplaylist, NULL);

MAKE_MENU(playlist_settings, ID2P(LANG_PLAYLISTS), NULL,
          Icon_Playlist,
          &recursive_dir_insert, &warn_on_erase);
MAKE_MENU(playlist_options, ID2P(LANG_PLAYLISTS), NULL,
          Icon_Playlist,
          &create_playlist_item, &view_cur_playlist, &save_playlist, &catalog);

