/***************************************************************************
 *             __________               __   ___.
 *   Open      \______   \ ____   ____ |  | _\_ |__   _______  ___
 *   Source     |       _//  _ \_/ ___\|  |/ /| __ \ /  _ \  \/  /
 *   Jukebox    |    |   (  <_> )  \___|    < | \_\ (  <_> > <  <
 *   Firmware   |____|_  /\____/ \___  >__|_ \|___  /\____/__/\_ \
 *                     \/            \/     \/    \/            \/
 * $Id$
 *
 * Copyright (C) 2008 by Jens Arnold
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 ****************************************************************************/

#include "config.h"
#include "cpu.h"

    .text
    .align      2


    .global     lcd_write_data
    .type       lcd_write_data,%function

lcd_write_data:
    ldr     r12, =LCD1_BASE

.loop:
    ldrb    r2, [r0], #1
1:
    ldr     r3, [r12]
    tst     r3, #LCD1_BUSY_MASK
    bne     1b
    str     r2, [r12, #0x10]

    subs    r1, r1, #1
    bne     .loop

    bx      lr
    .size   lcd_write_data,.-lcd_write_data


    .global     lcd_grey_data
    .type       lcd_grey_data,%function

/* A high performance function to write grey phase data to the display,
 * one or multiple pixels.
 *
 * Arguments:
 *   r0 - pixel value data address
 *   r1 - pixel phase data address
 *   r2 - pixel block count
 *
 * Register usage:
 *   r3/r4 - current block of phases
 *   r5/r6 - current block of values
 *   r7  - lcd data accumulator
 *   r12 - phase signs mask
 *   lr  - lcd bridge address
 */
 
lcd_grey_data:
    stmfd   sp!, {r4-r7, lr}
    mov     r12, #0x80
    orr     r12, r12, r12, lsl #8
    orr     r12, r12, r12, lsl #16
    ldr     lr, =LCD1_BASE

.greyloop:
    ldmia   r1, {r3-r4}
    
    and     r5, r12, r3         /* r5 = 3.......2.......1.......0....... */
    and     r6, r12, r4         /* r6 = 7.......6.......5.......4....... */
    orr     r5, r5, r6, lsr #4  /* r5 = 3...7...2...6...1...5...0...4... */
    orr     r5, r5, r5, lsr #9  /* r5 = 3...7...23..67..12..56..01..45.. */
    orr     r5, r5, r5, lsr #9  /* r5 = 3...7...23..67..123.567.012.456. */
    orr     r5, r5, r5, lsr #9  /* r5 = 3...7...23..67..123.567.01234567 */
    
    ldmia   r0!, {r6-r7}
    bic     r3, r3, r12
    add     r3, r3, r6
    bic     r4, r4, r12
    add     r4, r4, r7
    stmia   r1!, {r3-r4}

1:
    ldr     r6, [lr]
    tst     r6, #LCD1_BUSY_MASK
    bne     1b
    str     r5, [lr, #0x10]

    subs    r2, r2, #1
    bne     .greyloop

    ldmpc   regs=r4-r7
    .size   lcd_grey_data,.-lcd_grey_data

