/* Template boards for the game generator */

#include "templates.h"

const unsigned short templates[NUM_TEMPLATES][9] = {
{
    0x016d,   /*   #.##.##.#   */
    0x006c,   /*   ..##.##..   */
    0x0089,   /*   .#...#..#   */
    0x0116,   /*   #...#.##.   */
    0x0082,   /*   .#.....#.   */
    0x00d1,   /*   .##.#...#   */
    0x0122,   /*   #..#...#.   */
    0x006c,   /*   ..##.##..   */
    0x016d,   /*   #.##.##.#   */
},
{
    0x0143,   /*   #.#....##   */
    0x0031,   /*   ...##...#   */
    0x01d1,   /*   ###.#...#   */
    0x0023,   /*   ...#...##   */
    0x016d,   /*   #.##.##.#   */
    0x0188,   /*   ##...#...   */
    0x0117,   /*   #...#.###   */
    0x0118,   /*   #...##...   */
    0x0185,   /*   ##....#.#   */
},
{
    0x0185,   /*   ##....#.#   */
    0x00e3,   /*   .###...##   */
    0x0132,   /*   #..##..#.   */
    0x002e,   /*   ...#.###.   */
    0x0054,   /*   ..#.#.#..   */
    0x00e8,   /*   .###.#...   */
    0x0099,   /*   .#..##..#   */
    0x018e,   /*   ##...###.   */
    0x0143,   /*   #.#....##   */
},
{
    0x0189,   /*   ##...#..#   */
    0x001a,   /*   ....##.#.   */
    0x01e2,   /*   ####...#.   */
    0x0055,   /*   ..#.#.#.#   */
    0x0129,   /*   #..#.#..#   */
    0x0154,   /*   #.#.#.#..   */
    0x008f,   /*   .#...####   */
    0x00b0,   /*   .#.##....   */
    0x0123,   /*   #..#...##   */
},
{
    0x018b,   /*   ##...#.##   */
    0x0199,   /*   ##..##..#   */
    0x0014,   /*   ....#.#..   */
    0x008e,   /*   .#...###.   */
    0x006c,   /*   ..##.##..   */
    0x00e2,   /*   .###...#.   */
    0x0050,   /*   ..#.#....   */
    0x0133,   /*   #..##..##   */
    0x01a3,   /*   ##.#...##   */
},
{
    0x002e,   /*   ...#.###.   */
    0x018a,   /*   ##...#.#.   */
    0x0164,   /*   #.##..#..   */
    0x01ad,   /*   ##.#.##.#   */
    0x0000,   /*   .........   */
    0x016b,   /*   #.##.#.##   */
    0x004d,   /*   ..#..##.#   */
    0x00a3,   /*   .#.#...##   */
    0x00e8,   /*   .###.#...   */
},
{
    0x005c,   /*   ..#.###..   */
    0x01a8,   /*   ##.#.#...   */
    0x00d4,   /*   .##.#.#..   */
    0x0195,   /*   ##..#.#.#   */
    0x0082,   /*   .#.....#.   */
    0x0153,   /*   #.#.#..##   */
    0x0056,   /*   ..#.#.##.   */
    0x002b,   /*   ...#.#.##   */
    0x0074,   /*   ..###.#..   */
},
{
    0x006c,   /*   ..##.##..   */
    0x00e2,   /*   .###...#.   */
    0x0113,   /*   #...#..##   */
    0x0113,   /*   #...#..##   */
    0x006c,   /*   ..##.##..   */
    0x0191,   /*   ##..#...#   */
    0x0191,   /*   ##..#...#   */
    0x008e,   /*   .#...###.   */
    0x006c,   /*   ..##.##..   */
},
{
    0x0098,   /*   .#..##...   */
    0x0195,   /*   ##..#.#.#   */
    0x0066,   /*   ..##..##.   */
    0x00cb,   /*   .##..#.##   */
    0x0028,   /*   ...#.#...   */
    0x01a6,   /*   ##.#..##.   */
    0x00cc,   /*   .##..##..   */
    0x0153,   /*   #.#.#..##   */
    0x0032,   /*   ...##..#.   */
},
{
    0x0164,   /*   #.##..#..   */
    0x00a5,   /*   .#.#..#.#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x005c,   /*   ..#.###..   */
    0x0183,   /*   ##.....##   */
    0x0074,   /*   ..###.#..   */
    0x00aa,   /*   .#.#.#.#.   */
    0x014a,   /*   #.#..#.#.   */
    0x004d,   /*   ..#..##.#   */
},
{
    0x0144,   /*   #.#...#..   */
    0x00dc,   /*   .##.###..   */
    0x00aa,   /*   .#.#.#.#.   */
    0x01a2,   /*   ##.#...#.   */
    0x0038,   /*   ...###...   */
    0x008b,   /*   .#...#.##   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0076,   /*   ..###.##.   */
    0x0045,   /*   ..#...#.#   */
},
{
    0x0113,   /*   #...#..##   */
    0x01a2,   /*   ##.#...#.   */
    0x006c,   /*   ..##.##..   */
    0x0056,   /*   ..#.#.##.   */
    0x0129,   /*   #..#.#..#   */
    0x00d4,   /*   .##.#.#..   */
    0x006c,   /*   ..##.##..   */
    0x008b,   /*   .#...#.##   */
    0x0191,   /*   ##..#...#   */
},
{
    0x006a,   /*   ..##.#.#.   */
    0x0174,   /*   #.###.#..   */
    0x0083,   /*   .#.....##   */
    0x012b,   /*   #..#.#.##   */
    0x0092,   /*   .#..#..#.   */
    0x01a9,   /*   ##.#.#..#   */
    0x0182,   /*   ##.....#.   */
    0x005d,   /*   ..#.###.#   */
    0x00ac,   /*   .#.#.##..   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x0129,   /*   #..#.#..#   */
    0x0092,   /*   .#..#..#.   */
    0x0044,   /*   ..#...#..   */
    0x0183,   /*   ##.....##   */
    0x0044,   /*   ..#...#..   */
    0x0092,   /*   .#..#..#.   */
    0x0129,   /*   #..#.#..#   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x00ba,   /*   .#.###.#.   */
    0x0082,   /*   .#.....#.   */
    0x00ba,   /*   .#.###.#.   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x00ba,   /*   .#.###.#.   */
    0x0101,   /*   #.......#   */
    0x0044,   /*   ..#...#..   */
    0x01ab,   /*   ##.#.#.##   */
    0x0010,   /*   ....#....   */
    0x01ab,   /*   ##.#.#.##   */
    0x0044,   /*   ..#...#..   */
    0x0101,   /*   #.......#   */
    0x00ba,   /*   .#.###.#.   */
},
{
    0x0082,   /*   .#.....#.   */
    0x00d6,   /*   .##.#.##.   */
    0x0129,   /*   #..#.#..#   */
    0x006c,   /*   ..##.##..   */
    0x0000,   /*   .........   */
    0x006c,   /*   ..##.##..   */
    0x0129,   /*   #..#.#..#   */
    0x00d6,   /*   .##.#.##.   */
    0x0082,   /*   .#.....#.   */
},
{
    0x000a,   /*   .....#.#.   */
    0x018c,   /*   ##...##..   */
    0x00a4,   /*   .#.#..#..   */
    0x009a,   /*   .#..##.#.   */
    0x0101,   /*   #.......#   */
    0x00b2,   /*   .#.##..#.   */
    0x004a,   /*   ..#..#.#.   */
    0x0063,   /*   ..##...##   */
    0x00a0,   /*   .#.#.....   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x0101,   /*   #.......#   */
    0x0054,   /*   ..#.#.#..   */
    0x00d6,   /*   .##.#.##.   */
    0x0092,   /*   .#..#..#.   */
    0x00d6,   /*   .##.#.##.   */
    0x0054,   /*   ..#.#.#..   */
    0x0101,   /*   #.......#   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x00c6,   /*   .##...##.   */
    0x0028,   /*   ...#.#...   */
    0x0193,   /*   ##..#..##   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0193,   /*   ##..#..##   */
    0x0028,   /*   ...#.#...   */
    0x00c6,   /*   .##...##.   */
},
{
    0x01b8,   /*   ##.###...   */
    0x0001,   /*   ........#   */
    0x00e4,   /*   .###..#..   */
    0x0111,   /*   #...#...#   */
    0x0044,   /*   ..#...#..   */
    0x0111,   /*   #...#...#   */
    0x004e,   /*   ..#..###.   */
    0x0100,   /*   #........   */
    0x003b,   /*   ...###.##   */
},
{
    0x0000,   /*   .........   */
    0x00aa,   /*   .#.#.#.#.   */
    0x00ee,   /*   .###.###.   */
    0x0129,   /*   #..#.#..#   */
    0x006c,   /*   ..##.##..   */
    0x0129,   /*   #..#.#..#   */
    0x00ee,   /*   .###.###.   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0000,   /*   .........   */
},
{
    0x0031,   /*   ...##...#   */
    0x0154,   /*   #.#.#.#..   */
    0x0009,   /*   .....#..#   */
    0x00f4,   /*   .####.#..   */
    0x0044,   /*   ..#...#..   */
    0x005e,   /*   ..#.####.   */
    0x0120,   /*   #..#.....   */
    0x0055,   /*   ..#.#.#.#   */
    0x0118,   /*   #...##...   */
},
{
    0x00b0,   /*   .#.##....   */
    0x00a3,   /*   .#.#...##   */
    0x0064,   /*   ..##..#..   */
    0x0007,   /*   ......###   */
    0x0111,   /*   #...#...#   */
    0x01c0,   /*   ###......   */
    0x004c,   /*   ..#..##..   */
    0x018a,   /*   ##...#.#.   */
    0x001a,   /*   ....##.#.   */
},
{
    0x0129,   /*   #..#.#..#   */
    0x0048,   /*   ..#..#...   */
    0x0012,   /*   ....#..#.   */
    0x0191,   /*   ##..#...#   */
    0x006c,   /*   ..##.##..   */
    0x0113,   /*   #...#..##   */
    0x0090,   /*   .#..#....   */
    0x0024,   /*   ...#..#..   */
    0x0129,   /*   #..#.#..#   */
},
{
    0x00a0,   /*   .#.#.....   */
    0x0051,   /*   ..#.#...#   */
    0x005e,   /*   ..#.####.   */
    0x0041,   /*   ..#.....#   */
    0x00d6,   /*   .##.#.##.   */
    0x0104,   /*   #.....#..   */
    0x00f4,   /*   .####.#..   */
    0x0114,   /*   #...#.#..   */
    0x000a,   /*   .....#.#.   */
},
{
    0x0008,   /*   .....#...   */
    0x0090,   /*   .#..#....   */
    0x001f,   /*   ....#####   */
    0x00d3,   /*   .##.#..##   */
    0x006c,   /*   ..##.##..   */
    0x0196,   /*   ##..#.##.   */
    0x01f0,   /*   #####....   */
    0x0012,   /*   ....#..#.   */
    0x0020,   /*   ...#.....   */
},
{
    0x0145,   /*   #.#...#.#   */
    0x0155,   /*   #.#.#.#.#   */
    0x0028,   /*   ...#.#...   */
    0x006c,   /*   ..##.##..   */
    0x0000,   /*   .........   */
    0x006c,   /*   ..##.##..   */
    0x0028,   /*   ...#.#...   */
    0x0155,   /*   #.#.#.#.#   */
    0x0145,   /*   #.#...#.#   */
},
{
    0x0006,   /*   ......##.   */
    0x0170,   /*   #.###....   */
    0x0031,   /*   ...##...#   */
    0x00c3,   /*   .##....##   */
    0x0101,   /*   #.......#   */
    0x0186,   /*   ##....##.   */
    0x0118,   /*   #...##...   */
    0x001d,   /*   ....###.#   */
    0x00c0,   /*   .##......   */
},
{
    0x0038,   /*   ...###...   */
    0x0129,   /*   #..#.#..#   */
    0x0044,   /*   ..#...#..   */
    0x0145,   /*   #.#...#.#   */
    0x0082,   /*   .#.....#.   */
    0x0145,   /*   #.#...#.#   */
    0x0044,   /*   ..#...#..   */
    0x0129,   /*   #..#.#..#   */
    0x0038,   /*   ...###...   */
},
{
    0x0082,   /*   .#.....#.   */
    0x0111,   /*   #...#...#   */
    0x0129,   /*   #..#.#..#   */
    0x006c,   /*   ..##.##..   */
    0x0010,   /*   ....#....   */
    0x006c,   /*   ..##.##..   */
    0x0129,   /*   #..#.#..#   */
    0x0111,   /*   #...#...#   */
    0x0082,   /*   .#.....#.   */
},
{
    0x0183,   /*   ##.....##   */
    0x0092,   /*   .#..#..#.   */
    0x006c,   /*   ..##.##..   */
    0x0028,   /*   ...#.#...   */
    0x0101,   /*   #.......#   */
    0x0028,   /*   ...#.#...   */
    0x006c,   /*   ..##.##..   */
    0x0092,   /*   .#..#..#.   */
    0x0183,   /*   ##.....##   */
},
{
    0x00d0,   /*   .##.#....   */
    0x0109,   /*   #....#..#   */
    0x0184,   /*   ##....#..   */
    0x0160,   /*   #.##.....   */
    0x0044,   /*   ..#...#..   */
    0x000d,   /*   .....##.#   */
    0x0043,   /*   ..#....##   */
    0x0121,   /*   #..#....#   */
    0x0016,   /*   ....#.##.   */
},
{
    0x0060,   /*   ..##.....   */
    0x0140,   /*   #.#......   */
    0x0093,   /*   .#..#..##   */
    0x010e,   /*   #....###.   */
    0x0054,   /*   ..#.#.#..   */
    0x00e1,   /*   .###....#   */
    0x0192,   /*   ##..#..#.   */
    0x0005,   /*   ......#.#   */
    0x000c,   /*   .....##..   */
},
{
    0x001a,   /*   ....##.#.   */
    0x0091,   /*   .#..#...#   */
    0x00a1,   /*   .#.#....#   */
    0x00c2,   /*   .##....#.   */
    0x0028,   /*   ...#.#...   */
    0x0086,   /*   .#....##.   */
    0x010a,   /*   #....#.#.   */
    0x0112,   /*   #...#..#.   */
    0x00b0,   /*   .#.##....   */
},
{
    0x0162,   /*   #.##...#.   */
    0x0049,   /*   ..#..#..#   */
    0x004c,   /*   ..#..##..   */
    0x0016,   /*   ....#.##.   */
    0x0000,   /*   .........   */
    0x00d0,   /*   .##.#....   */
    0x0064,   /*   ..##..#..   */
    0x0124,   /*   #..#..#..   */
    0x008d,   /*   .#...##.#   */
},
{
    0x0025,   /*   ...#..#.#   */
    0x0050,   /*   ..#.#....   */
    0x0053,   /*   ..#.#..##   */
    0x0032,   /*   ...##..#.   */
    0x0028,   /*   ...#.#...   */
    0x0098,   /*   .#..##...   */
    0x0194,   /*   ##..#.#..   */
    0x0014,   /*   ....#.#..   */
    0x0148,   /*   #.#..#...   */
},
{
    0x0129,   /*   #..#.#..#   */
    0x0000,   /*   .........   */
    0x00c6,   /*   .##...##.   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0092,   /*   .#..#..#.   */
    0x00aa,   /*   .#.#.#.#.   */
    0x00c6,   /*   .##...##.   */
    0x0000,   /*   .........   */
    0x0129,   /*   #..#.#..#   */
},
{
    0x0095,   /*   .#..#.#.#   */
    0x002b,   /*   ...#.#.##   */
    0x0000,   /*   .........   */
    0x00ca,   /*   .##..#.#.   */
    0x0028,   /*   ...#.#...   */
    0x00a6,   /*   .#.#..##.   */
    0x0000,   /*   .........   */
    0x01a8,   /*   ##.#.#...   */
    0x0153,   /*   #.#.#..##   */
},
{
    0x0008,   /*   .....#...   */
    0x0153,   /*   #.#.#..##   */
    0x0070,   /*   ..###....   */
    0x0141,   /*   #.#.....#   */
    0x0082,   /*   .#.....#.   */
    0x0105,   /*   #.....#.#   */
    0x001c,   /*   ....###..   */
    0x0195,   /*   ##..#.#.#   */
    0x0020,   /*   ...#.....   */
},
{
    0x000c,   /*   .....##..   */
    0x0100,   /*   #........   */
    0x0076,   /*   ..###.##.   */
    0x0013,   /*   ....#..##   */
    0x0101,   /*   #.......#   */
    0x0190,   /*   ##..#....   */
    0x00dc,   /*   .##.###..   */
    0x0001,   /*   ........#   */
    0x0060,   /*   ..##.....   */
},
{
    0x00ba,   /*   .#.###.#.   */
    0x0101,   /*   #.......#   */
    0x0044,   /*   ..#...#..   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0000,   /*   .........   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0044,   /*   ..#...#..   */
    0x0101,   /*   #.......#   */
    0x00ba,   /*   .#.###.#.   */
},
{
    0x0189,   /*   ##...#..#   */
    0x00a3,   /*   .#.#...##   */
    0x0010,   /*   ....#....   */
    0x0102,   /*   #......#.   */
    0x0054,   /*   ..#.#.#..   */
    0x0081,   /*   .#......#   */
    0x0010,   /*   ....#....   */
    0x018a,   /*   ##...#.#.   */
    0x0123,   /*   #..#...##   */
},
{
    0x0189,   /*   ##...#..#   */
    0x00a3,   /*   .#.#...##   */
    0x0010,   /*   ....#....   */
    0x0102,   /*   #......#.   */
    0x0054,   /*   ..#.#.#..   */
    0x0081,   /*   .#......#   */
    0x0010,   /*   ....#....   */
    0x018a,   /*   ##...#.#.   */
    0x0123,   /*   #..#...##   */
},
{
    0x0044,   /*   ..#...#..   */
    0x00ee,   /*   .###.###.   */
    0x0183,   /*   ##.....##   */
    0x0038,   /*   ...###...   */
    0x0010,   /*   ....#....   */
    0x0038,   /*   ...###...   */
    0x0183,   /*   ##.....##   */
    0x00ee,   /*   .###.###.   */
    0x0044,   /*   ..#...#..   */
},
{
    0x0064,   /*   ..##..#..   */
    0x0096,   /*   .#..#.##.   */
    0x0081,   /*   .#......#   */
    0x010a,   /*   #....#.#.   */
    0x0010,   /*   ....#....   */
    0x00a1,   /*   .#.#....#   */
    0x0102,   /*   #......#.   */
    0x00d2,   /*   .##.#..#.   */
    0x004c,   /*   ..#..##..   */
},
{
    0x0180,   /*   ##.......   */
    0x0190,   /*   ##..#....   */
    0x00a8,   /*   .#.#.#...   */
    0x0124,   /*   #..#..#..   */
    0x0145,   /*   #.#...#.#   */
    0x0049,   /*   ..#..#..#   */
    0x002a,   /*   ...#.#.#.   */
    0x0013,   /*   ....#..##   */
    0x0003,   /*   .......##   */
},
{
    0x010d,   /*   #....##.#   */
    0x0104,   /*   #.....#..   */
    0x00a2,   /*   .#.#...#.   */
    0x0038,   /*   ...###...   */
    0x0044,   /*   ..#...#..   */
    0x0038,   /*   ...###...   */
    0x008a,   /*   .#...#.#.   */
    0x0041,   /*   ..#.....#   */
    0x0161,   /*   #.##....#   */
},
{
    0x004c,   /*   ..#..##..   */
    0x00b2,   /*   .#.##..#.   */
    0x0165,   /*   #.##..#.#   */
    0x0116,   /*   #...#.##.   */
    0x00aa,   /*   .#.#.#.#.   */
    0x00d1,   /*   .##.#...#   */
    0x014d,   /*   #.#..##.#   */
    0x009a,   /*   .#..##.#.   */
    0x0064,   /*   ..##..#..   */
},
{
    0x0111,   /*   #...#...#   */
    0x0092,   /*   .#..#..#.   */
    0x0129,   /*   #..#.#..#   */
    0x0145,   /*   #.#...#.#   */
    0x006c,   /*   ..##.##..   */
    0x0145,   /*   #.#...#.#   */
    0x0129,   /*   #..#.#..#   */
    0x0092,   /*   .#..#..#.   */
    0x0111,   /*   #...#...#   */
},
{
    0x00ac,   /*   .#.#.##..   */
    0x0182,   /*   ##.....#.   */
    0x0032,   /*   ...##..#.   */
    0x001c,   /*   ....###..   */
    0x0000,   /*   .........   */
    0x0070,   /*   ..###....   */
    0x0098,   /*   .#..##...   */
    0x0083,   /*   .#.....##   */
    0x006a,   /*   ..##.#.#.   */
},
{
    0x0052,   /*   ..#.#..#.   */
    0x0008,   /*   .....#...   */
    0x012a,   /*   #..#.#.#.   */
    0x01a4,   /*   ##.#..#..   */
    0x0082,   /*   .#.....#.   */
    0x004b,   /*   ..#..#.##   */
    0x00a9,   /*   .#.#.#..#   */
    0x0020,   /*   ...#.....   */
    0x0094,   /*   .#..#.#..   */
},
{
    0x0049,   /*   ..#..#..#   */
    0x0030,   /*   ...##....   */
    0x0026,   /*   ...#..##.   */
    0x00c6,   /*   .##...##.   */
    0x0010,   /*   ....#....   */
    0x00c6,   /*   .##...##.   */
    0x00c8,   /*   .##..#...   */
    0x0018,   /*   ....##...   */
    0x0124,   /*   #..#..#..   */
},
{
    0x0029,   /*   ...#.#..#   */
    0x01a4,   /*   ##.#..#..   */
    0x00a0,   /*   .#.#.....   */
    0x0005,   /*   ......#.#   */
    0x0183,   /*   ##.....##   */
    0x0140,   /*   #.#......   */
    0x000a,   /*   .....#.#.   */
    0x004b,   /*   ..#..#.##   */
    0x0128,   /*   #..#.#...   */
},
{
    0x0014,   /*   ....#.#..   */
    0x0164,   /*   #.##..#..   */
    0x0161,   /*   #.##....#   */
    0x0040,   /*   ..#......   */
    0x0038,   /*   ...###...   */
    0x0004,   /*   ......#..   */
    0x010d,   /*   #....##.#   */
    0x004d,   /*   ..#..##.#   */
    0x0050,   /*   ..#.#....   */
},
{
    0x0101,   /*   #.......#   */
    0x00c6,   /*   .##...##.   */
    0x0038,   /*   ...###...   */
    0x007c,   /*   ..#####..   */
    0x0183,   /*   ##.....##   */
    0x007c,   /*   ..#####..   */
    0x0038,   /*   ...###...   */
    0x00c6,   /*   .##...##.   */
    0x0101,   /*   #.......#   */
},
{
    0x0020,   /*   ...#.....   */
    0x0054,   /*   ..#.#.#..   */
    0x0063,   /*   ..##...##   */
    0x0149,   /*   #.#..#..#   */
    0x0101,   /*   #.......#   */
    0x0125,   /*   #..#..#.#   */
    0x018c,   /*   ##...##..   */
    0x0054,   /*   ..#.#.#..   */
    0x0008,   /*   .....#...   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x0044,   /*   ..#...#..   */
    0x002a,   /*   ...#.#.#.   */
    0x0081,   /*   .#......#   */
    0x0038,   /*   ...###...   */
    0x0102,   /*   #......#.   */
    0x00a8,   /*   .#.#.#...   */
    0x0044,   /*   ..#...#..   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x0014,   /*   ....#.#..   */
    0x0140,   /*   #.#......   */
    0x000f,   /*   .....####   */
    0x0003,   /*   .......##   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0180,   /*   ##.......   */
    0x01e0,   /*   ####.....   */
    0x0005,   /*   ......#.#   */
    0x0050,   /*   ..#.#....   */
},
{
    0x002d,   /*   ...#.##.#   */
    0x0010,   /*   ....#....   */
    0x0091,   /*   .#..#...#   */
    0x0074,   /*   ..###.#..   */
    0x0101,   /*   #.......#   */
    0x005c,   /*   ..#.###..   */
    0x0112,   /*   #...#..#.   */
    0x0010,   /*   ....#....   */
    0x0168,   /*   #.##.#...   */
},
{
    0x0096,   /*   .#..#.##.   */
    0x009a,   /*   .#..##.#.   */
    0x00e4,   /*   .###..#..   */
    0x0190,   /*   ##..#....   */
    0x01ab,   /*   ##.#.#.##   */
    0x0013,   /*   ....#..##   */
    0x004e,   /*   ..#..###.   */
    0x00b2,   /*   .#.##..#.   */
    0x00d2,   /*   .##.#..#.   */
},
{
    0x0150,   /*   #.#.#....   */
    0x0022,   /*   ...#...#.   */
    0x0094,   /*   .#..#.#..   */
    0x016c,   /*   #.##.##..   */
    0x0082,   /*   .#.....#.   */
    0x006d,   /*   ..##.##.#   */
    0x0052,   /*   ..#.#..#.   */
    0x0088,   /*   .#...#...   */
    0x0015,   /*   ....#.#.#   */
},
{
    0x000d,   /*   .....##.#   */
    0x01b1,   /*   ##.##...#   */
    0x0080,   /*   .#.......   */
    0x014c,   /*   #.#..##..   */
    0x0101,   /*   #.......#   */
    0x0065,   /*   ..##..#.#   */
    0x0002,   /*   .......#.   */
    0x011b,   /*   #...##.##   */
    0x0160,   /*   #.##.....   */
},
{
    0x0016,   /*   ....#.##.   */
    0x0160,   /*   #.##.....   */
    0x010a,   /*   #....#.#.   */
    0x0052,   /*   ..#.#..#.   */
    0x0129,   /*   #..#.#..#   */
    0x0094,   /*   .#..#.#..   */
    0x00a1,   /*   .#.#....#   */
    0x000d,   /*   .....##.#   */
    0x00d0,   /*   .##.#....   */
},
{
    0x00e9,   /*   .###.#..#   */
    0x00c1,   /*   .##.....#   */
    0x0120,   /*   #..#.....   */
    0x0188,   /*   ##...#...   */
    0x00c6,   /*   .##...##.   */
    0x0023,   /*   ...#...##   */
    0x0009,   /*   .....#..#   */
    0x0106,   /*   #.....##.   */
    0x012e,   /*   #..#.###.   */
},
{
    0x000d,   /*   .....##.#   */
    0x0090,   /*   .#..#....   */
    0x0188,   /*   ##...#...   */
    0x0059,   /*   ..#.##..#   */
    0x0028,   /*   ...#.#...   */
    0x0134,   /*   #..##.#..   */
    0x0023,   /*   ...#...##   */
    0x0012,   /*   ....#..#.   */
    0x0160,   /*   #.##.....   */
},
{
    0x0108,   /*   #....#...   */
    0x0116,   /*   #...#.##.   */
    0x0148,   /*   #.#..#...   */
    0x01c4,   /*   ###...#..   */
    0x0101,   /*   #.......#   */
    0x0047,   /*   ..#...###   */
    0x0025,   /*   ...#..#.#   */
    0x00d1,   /*   .##.#...#   */
    0x0021,   /*   ...#....#   */
},
{
    0x0151,   /*   #.#.#...#   */
    0x0024,   /*   ...#..#..   */
    0x004a,   /*   ..#..#.#.   */
    0x0042,   /*   ..#....#.   */
    0x006c,   /*   ..##.##..   */
    0x0084,   /*   .#....#..   */
    0x00a4,   /*   .#.#..#..   */
    0x0048,   /*   ..#..#...   */
    0x0115,   /*   #...#.#.#   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x0044,   /*   ..#...#..   */
    0x00aa,   /*   .#.#.#.#.   */
    0x00c6,   /*   .##...##.   */
    0x0101,   /*   #.......#   */
    0x00c6,   /*   .##...##.   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0044,   /*   ..#...#..   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x0004,   /*   ......#..   */
    0x0061,   /*   ..##....#   */
    0x0023,   /*   ...#...##   */
    0x0184,   /*   ##....#..   */
    0x0139,   /*   #..###..#   */
    0x0043,   /*   ..#....##   */
    0x0188,   /*   ##...#...   */
    0x010c,   /*   #....##..   */
    0x0040,   /*   ..#......   */
},
{
    0x0141,   /*   #.#.....#   */
    0x0082,   /*   .#.....#.   */
    0x00a2,   /*   .#.#...#.   */
    0x003d,   /*   ...####.#   */
    0x0010,   /*   ....#....   */
    0x0178,   /*   #.####...   */
    0x008a,   /*   .#...#.#.   */
    0x0082,   /*   .#.....#.   */
    0x0105,   /*   #.....#.#   */
},
{
    0x01a3,   /*   ##.#...##   */
    0x01ac,   /*   ##.#.##..   */
    0x0049,   /*   ..#..#..#   */
    0x0106,   /*   #.....##.   */
    0x0129,   /*   #..#.#..#   */
    0x00c1,   /*   .##.....#   */
    0x0124,   /*   #..#..#..   */
    0x006b,   /*   ..##.#.##   */
    0x018b,   /*   ##...#.##   */
},
{
    0x0044,   /*   ..#...#..   */
    0x0015,   /*   ....#.#.#   */
    0x0132,   /*   #..##..#.   */
    0x0021,   /*   ...#....#   */
    0x006c,   /*   ..##.##..   */
    0x0108,   /*   #....#...   */
    0x0099,   /*   .#..##..#   */
    0x0150,   /*   #.#.#....   */
    0x0044,   /*   ..#...#..   */
},
{
    0x0112,   /*   #...#..#.   */
    0x0024,   /*   ...#..#..   */
    0x014c,   /*   #.#..##..   */
    0x0041,   /*   ..#.....#   */
    0x016d,   /*   #.##.##.#   */
    0x0104,   /*   #.....#..   */
    0x0065,   /*   ..##..#.#   */
    0x0048,   /*   ..#..#...   */
    0x0091,   /*   .#..#...#   */
},
{
    0x0139,   /*   #..###..#   */
    0x008c,   /*   .#...##..   */
    0x0010,   /*   ....#....   */
    0x0142,   /*   #.#....#.   */
    0x00c6,   /*   .##...##.   */
    0x0085,   /*   .#....#.#   */
    0x0010,   /*   ....#....   */
    0x0062,   /*   ..##...#.   */
    0x0139,   /*   #..###..#   */
},
{
    0x00e9,   /*   .###.#..#   */
    0x0078,   /*   ..####...   */
    0x00a0,   /*   .#.#.....   */
    0x0047,   /*   ..#...###   */
    0x0000,   /*   .........   */
    0x01c4,   /*   ###...#..   */
    0x000a,   /*   .....#.#.   */
    0x003c,   /*   ...####..   */
    0x012e,   /*   #..#.###.   */
},
{
    0x0004,   /*   ......#..   */
    0x0087,   /*   .#....###   */
    0x0023,   /*   ...#...##   */
    0x0025,   /*   ...#..#.#   */
    0x0111,   /*   #...#...#   */
    0x0148,   /*   #.#..#...   */
    0x0188,   /*   ##...#...   */
    0x01c2,   /*   ###....#.   */
    0x0040,   /*   ..#......   */
},
{
    0x010e,   /*   #....###.   */
    0x0096,   /*   .#..#.##.   */
    0x0121,   /*   #..#....#   */
    0x0013,   /*   ....#..##   */
    0x0044,   /*   ..#...#..   */
    0x0190,   /*   ##..#....   */
    0x0109,   /*   #....#..#   */
    0x00d2,   /*   .##.#..#.   */
    0x00e1,   /*   .###....#   */
},
{
    0x010c,   /*   #....##..   */
    0x0034,   /*   ...##.#..   */
    0x0094,   /*   .#..#.#..   */
    0x0138,   /*   #..###...   */
    0x0000,   /*   .........   */
    0x0039,   /*   ...###..#   */
    0x0052,   /*   ..#.#..#.   */
    0x0058,   /*   ..#.##...   */
    0x0061,   /*   ..##....#   */
},
{
    0x0112,   /*   #...#..#.   */
    0x01a1,   /*   ##.#....#   */
    0x0048,   /*   ..#..#...   */
    0x0190,   /*   ##..#....   */
    0x0082,   /*   .#.....#.   */
    0x0013,   /*   ....#..##   */
    0x0024,   /*   ...#..#..   */
    0x010b,   /*   #....#.##   */
    0x0091,   /*   .#..#...#   */
},
{
    0x0031,   /*   ...##...#   */
    0x0004,   /*   ......#..   */
    0x00a9,   /*   .#.#.#..#   */
    0x00c4,   /*   .##...#..   */
    0x0054,   /*   ..#.#.#..   */
    0x0046,   /*   ..#...##.   */
    0x012a,   /*   #..#.#.#.   */
    0x0040,   /*   ..#......   */
    0x0118,   /*   #...##...   */
},
{
    0x01b0,   /*   ##.##....   */
    0x010e,   /*   #....###.   */
    0x0000,   /*   .........   */
    0x0102,   /*   #......#.   */
    0x00ba,   /*   .#.###.#.   */
    0x0081,   /*   .#......#   */
    0x0000,   /*   .........   */
    0x00e1,   /*   .###....#   */
    0x001b,   /*   ....##.##   */
},
{
    0x006c,   /*   ..##.##..   */
    0x00d2,   /*   .##.#..#.   */
    0x0147,   /*   #.#...###   */
    0x0129,   /*   #..#.#..#   */
    0x0092,   /*   .#..#..#.   */
    0x0129,   /*   #..#.#..#   */
    0x01c5,   /*   ###...#.#   */
    0x0096,   /*   .#..#.##.   */
    0x006c,   /*   ..##.##..   */
},
{
    0x0111,   /*   #...#...#   */
    0x008e,   /*   .#...###.   */
    0x00b0,   /*   .#.##....   */
    0x0084,   /*   .#....#..   */
    0x0145,   /*   #.#...#.#   */
    0x0042,   /*   ..#....#.   */
    0x001a,   /*   ....##.#.   */
    0x00e2,   /*   .###...#.   */
    0x0111,   /*   #...#...#   */
},
{
    0x0040,   /*   ..#......   */
    0x0096,   /*   .#..#.##.   */
    0x00cd,   /*   .##..##.#   */
    0x0050,   /*   ..#.#....   */
    0x00ba,   /*   .#.###.#.   */
    0x0014,   /*   ....#.#..   */
    0x0166,   /*   #.##..##.   */
    0x00d2,   /*   .##.#..#.   */
    0x0004,   /*   ......#..   */
},
{
    0x000f,   /*   .....####   */
    0x0152,   /*   #.#.#..#.   */
    0x011c,   /*   #...###..   */
    0x00b1,   /*   .#.##...#   */
    0x0145,   /*   #.#...#.#   */
    0x011a,   /*   #...##.#.   */
    0x0071,   /*   ..###...#   */
    0x0095,   /*   .#..#.#.#   */
    0x01e0,   /*   ####.....   */
},
{
    0x0128,   /*   #..#.#...   */
    0x0183,   /*   ##.....##   */
    0x0094,   /*   .#..#.#..   */
    0x00b1,   /*   .#.##...#   */
    0x0044,   /*   ..#...#..   */
    0x011a,   /*   #...##.#.   */
    0x0052,   /*   ..#.#..#.   */
    0x0183,   /*   ##.....##   */
    0x0029,   /*   ...#.#..#   */
},
{
    0x0081,   /*   .#......#   */
    0x0060,   /*   ..##.....   */
    0x0159,   /*   #.#.##..#   */
    0x000b,   /*   .....#.##   */
    0x0054,   /*   ..#.#.#..   */
    0x01a0,   /*   ##.#.....   */
    0x0135,   /*   #..##.#.#   */
    0x000c,   /*   .....##..   */
    0x0102,   /*   #......#.   */
},
{
    0x00dc,   /*   .##.###..   */
    0x0089,   /*   .#...#..#   */
    0x0030,   /*   ...##....   */
    0x0046,   /*   ..#...##.   */
    0x0028,   /*   ...#.#...   */
    0x00c4,   /*   .##...#..   */
    0x0018,   /*   ....##...   */
    0x0122,   /*   #..#...#.   */
    0x0076,   /*   ..###.##.   */
},
{
    0x00e0,   /*   .###.....   */
    0x0082,   /*   .#.....#.   */
    0x0081,   /*   .#......#   */
    0x0149,   /*   #.#..#..#   */
    0x0092,   /*   .#..#..#.   */
    0x0125,   /*   #..#..#.#   */
    0x0102,   /*   #......#.   */
    0x0082,   /*   .#.....#.   */
    0x000e,   /*   .....###.   */
},
{
    0x0199,   /*   ##..##..#   */
    0x0025,   /*   ...#..#.#   */
    0x0010,   /*   ....#....   */
    0x00a2,   /*   .#.#...#.   */
    0x0044,   /*   ..#...#..   */
    0x008a,   /*   .#...#.#.   */
    0x0010,   /*   ....#....   */
    0x0148,   /*   #.#..#...   */
    0x0133,   /*   #..##..##   */
},
{
    0x0101,   /*   #.......#   */
    0x0129,   /*   #..#.#..#   */
    0x007c,   /*   ..#####..   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0082,   /*   .#.....#.   */
    0x00aa,   /*   .#.#.#.#.   */
    0x007c,   /*   ..#####..   */
    0x0129,   /*   #..#.#..#   */
    0x0101,   /*   #.......#   */
},
{
    0x0112,   /*   #...#..#.   */
    0x014e,   /*   #.#..###.   */
    0x0002,   /*   .......#.   */
    0x0108,   /*   #....#...   */
    0x0038,   /*   ...###...   */
    0x0021,   /*   ...#....#   */
    0x0080,   /*   .#.......   */
    0x00e5,   /*   .###..#.#   */
    0x0091,   /*   .#..#...#   */
},
{
    0x01c3,   /*   ###....##   */
    0x0032,   /*   ...##..#.   */
    0x0008,   /*   .....#...   */
    0x00c4,   /*   .##...#..   */
    0x0028,   /*   ...#.#...   */
    0x0046,   /*   ..#...##.   */
    0x0020,   /*   ...#.....   */
    0x0098,   /*   .#..##...   */
    0x0187,   /*   ##....###   */
},
{
    0x00e2,   /*   .###...#.   */
    0x0001,   /*   ........#   */
    0x00e0,   /*   .###.....   */
    0x0052,   /*   ..#.#..#.   */
    0x0145,   /*   #.#...#.#   */
    0x0094,   /*   .#..#.#..   */
    0x000e,   /*   .....###.   */
    0x0100,   /*   #........   */
    0x008e,   /*   .#...###.   */
},
{
    0x0185,   /*   ##....#.#   */
    0x0124,   /*   #..#..#..   */
    0x0060,   /*   ..##.....   */
    0x0011,   /*   ....#...#   */
    0x016d,   /*   #.##.##.#   */
    0x0110,   /*   #...#....   */
    0x000c,   /*   .....##..   */
    0x0049,   /*   ..#..#..#   */
    0x0143,   /*   #.#....##   */
},
{
    0x0082,   /*   .#.....#.   */
    0x0155,   /*   #.#.#.#.#   */
    0x006c,   /*   ..##.##..   */
    0x0082,   /*   .#.....#.   */
    0x0028,   /*   ...#.#...   */
    0x0082,   /*   .#.....#.   */
    0x006c,   /*   ..##.##..   */
    0x0155,   /*   #.#.#.#.#   */
    0x0082,   /*   .#.....#.   */
},
{
    0x008a,   /*   .#...#.#.   */
    0x0169,   /*   #.##.#..#   */
    0x014d,   /*   #.#..##.#   */
    0x0118,   /*   #...##...   */
    0x00c6,   /*   .##...##.   */
    0x0031,   /*   ...##...#   */
    0x0165,   /*   #.##..#.#   */
    0x012d,   /*   #..#.##.#   */
    0x00a2,   /*   .#.#...#.   */
},
{
    0x0145,   /*   #.#...#.#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0129,   /*   #..#.#..#   */
    0x006c,   /*   ..##.##..   */
    0x0000,   /*   .........   */
    0x006c,   /*   ..##.##..   */
    0x0129,   /*   #..#.#..#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0145,   /*   #.#...#.#   */
},
{
    0x0122,   /*   #..#...#.   */
    0x0011,   /*   ....#...#   */
    0x010a,   /*   #....#.#.   */
    0x0154,   /*   #.#.#.#..   */
    0x0000,   /*   .........   */
    0x0055,   /*   ..#.#.#.#   */
    0x00a1,   /*   .#.#....#   */
    0x0110,   /*   #...#....   */
    0x0089,   /*   .#...#..#   */
},
{
    0x01c9,   /*   ###..#..#   */
    0x00e6,   /*   .###..##.   */
    0x0114,   /*   #...#.#..   */
    0x001e,   /*   ....####.   */
    0x0028,   /*   ...#.#...   */
    0x00f0,   /*   .####....   */
    0x0051,   /*   ..#.#...#   */
    0x00ce,   /*   .##..###.   */
    0x0127,   /*   #..#..###   */
},
{
    0x0117,   /*   #...#.###   */
    0x0009,   /*   .....#..#   */
    0x005c,   /*   ..#.###..   */
    0x011c,   /*   #...###..   */
    0x0000,   /*   .........   */
    0x0071,   /*   ..###...#   */
    0x0074,   /*   ..###.#..   */
    0x0120,   /*   #..#.....   */
    0x01d1,   /*   ###.#...#   */
},
{
    0x0091,   /*   .#..#...#   */
    0x0023,   /*   ...#...##   */
    0x0044,   /*   ..#...#..   */
    0x0031,   /*   ...##...#   */
    0x0111,   /*   #...#...#   */
    0x0118,   /*   #...##...   */
    0x0044,   /*   ..#...#..   */
    0x0188,   /*   ##...#...   */
    0x0112,   /*   #...#..#.   */
},
{
    0x0020,   /*   ...#.....   */
    0x011a,   /*   #...##.#.   */
    0x00d7,   /*   .##.#.###   */
    0x0086,   /*   .#....##.   */
    0x0028,   /*   ...#.#...   */
    0x00c2,   /*   .##....#.   */
    0x01d6,   /*   ###.#.##.   */
    0x00b1,   /*   .#.##...#   */
    0x0008,   /*   .....#...   */
},
{
    0x000c,   /*   .....##..   */
    0x0034,   /*   ...##.#..   */
    0x01c4,   /*   ###...#..   */
    0x012a,   /*   #..#.#.#.   */
    0x0082,   /*   .#.....#.   */
    0x00a9,   /*   .#.#.#..#   */
    0x0047,   /*   ..#...###   */
    0x0058,   /*   ..#.##...   */
    0x0060,   /*   ..##.....   */
},
{
    0x0101,   /*   #.......#   */
    0x0028,   /*   ...#.#...   */
    0x00ee,   /*   .###.###.   */
    0x0092,   /*   .#..#..#.   */
    0x0101,   /*   #.......#   */
    0x0092,   /*   .#..#..#.   */
    0x00ee,   /*   .###.###.   */
    0x0028,   /*   ...#.#...   */
    0x0101,   /*   #.......#   */
},
{
    0x0111,   /*   #...#...#   */
    0x0155,   /*   #.#.#.#.#   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x0028,   /*   ...#.#...   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0155,   /*   #.#.#.#.#   */
    0x0111,   /*   #...#...#   */
},
{
    0x0188,   /*   ##...#...   */
    0x0110,   /*   #...#....   */
    0x008c,   /*   .#...##..   */
    0x0091,   /*   .#..#...#   */
    0x0155,   /*   #.#.#.#.#   */
    0x0112,   /*   #...#..#.   */
    0x0062,   /*   ..##...#.   */
    0x0011,   /*   ....#...#   */
    0x0023,   /*   ...#...##   */
},
{
    0x00b5,   /*   .#.##.#.#   */
    0x0100,   /*   #........   */
    0x0048,   /*   ..#..#...   */
    0x0019,   /*   ....##..#   */
    0x0183,   /*   ##.....##   */
    0x0130,   /*   #..##....   */
    0x0024,   /*   ...#..#..   */
    0x0001,   /*   ........#   */
    0x015a,   /*   #.#.##.#.   */
},
{
    0x0195,   /*   ##..#.#.#   */
    0x0041,   /*   ..#.....#   */
    0x010a,   /*   #....#.#.   */
    0x0068,   /*   ..##.#...   */
    0x0111,   /*   #...#...#   */
    0x002c,   /*   ...#.##..   */
    0x00a1,   /*   .#.#....#   */
    0x0104,   /*   #.....#..   */
    0x0153,   /*   #.#.#..##   */
},
{
    0x0000,   /*   .........   */
    0x0032,   /*   ...##..#.   */
    0x007b,   /*   ..####.##   */
    0x004e,   /*   ..#..###.   */
    0x0000,   /*   .........   */
    0x00e4,   /*   .###..#..   */
    0x01bc,   /*   ##.####..   */
    0x0098,   /*   .#..##...   */
    0x0000,   /*   .........   */
},
{
    0x0019,   /*   ....##..#   */
    0x0060,   /*   ..##.....   */
    0x0105,   /*   #.....#.#   */
    0x0142,   /*   #.#....#.   */
    0x0044,   /*   ..#...#..   */
    0x0085,   /*   .#....#.#   */
    0x0141,   /*   #.#.....#   */
    0x000c,   /*   .....##..   */
    0x0130,   /*   #..##....   */
},
{
    0x00f0,   /*   .####....   */
    0x008f,   /*   .#...####   */
    0x00a9,   /*   .#.#.#..#   */
    0x00c5,   /*   .##...#.#   */
    0x0111,   /*   #...#...#   */
    0x0146,   /*   #.#...##.   */
    0x012a,   /*   #..#.#.#.   */
    0x01e2,   /*   ####...#.   */
    0x001e,   /*   ....####.   */
},
{
    0x0105,   /*   #.....#.#   */
    0x0068,   /*   ..##.#...   */
    0x0108,   /*   #....#...   */
    0x0042,   /*   ..#....#.   */
    0x00fe,   /*   .#######.   */
    0x0084,   /*   .#....#..   */
    0x0021,   /*   ...#....#   */
    0x002c,   /*   ...#.##..   */
    0x0141,   /*   #.#.....#   */
},
{
    0x01b0,   /*   ##.##....   */
    0x0071,   /*   ..###...#   */
    0x010e,   /*   #....###.   */
    0x014a,   /*   #.#..#.#.   */
    0x00aa,   /*   .#.#.#.#.   */
    0x00a5,   /*   .#.#..#.#   */
    0x00e1,   /*   .###....#   */
    0x011c,   /*   #...###..   */
    0x001b,   /*   ....##.##   */
},
{
    0x0038,   /*   ...###...   */
    0x0092,   /*   .#..#..#.   */
    0x00c6,   /*   .##...##.   */
    0x0044,   /*   ..#...#..   */
    0x0155,   /*   #.#.#.#.#   */
    0x0044,   /*   ..#...#..   */
    0x00c6,   /*   .##...##.   */
    0x0092,   /*   .#..#..#.   */
    0x0038,   /*   ...###...   */
},
{
    0x00a2,   /*   .#.#...#.   */
    0x0051,   /*   ..#.#...#   */
    0x0080,   /*   .#.......   */
    0x0191,   /*   ##..#...#   */
    0x0054,   /*   ..#.#.#..   */
    0x0113,   /*   #...#..##   */
    0x0002,   /*   .......#.   */
    0x0114,   /*   #...#.#..   */
    0x008a,   /*   .#...#.#.   */
},
{
    0x0139,   /*   #..###..#   */
    0x000c,   /*   .....##..   */
    0x00e4,   /*   .###..#..   */
    0x01ad,   /*   ##.#.##.#   */
    0x0101,   /*   #.......#   */
    0x016b,   /*   #.##.#.##   */
    0x004e,   /*   ..#..###.   */
    0x0060,   /*   ..##.....   */
    0x0139,   /*   #..###..#   */
},
{
    0x00c4,   /*   .##...#..   */
    0x0031,   /*   ...##...#   */
    0x0109,   /*   #....#..#   */
    0x006a,   /*   ..##.#.#.   */
    0x0092,   /*   .#..#..#.   */
    0x00ac,   /*   .#.#.##..   */
    0x0121,   /*   #..#....#   */
    0x0118,   /*   #...##...   */
    0x0046,   /*   ..#...##.   */
},
{
    0x0122,   /*   #..#...#.   */
    0x0024,   /*   ...#..#..   */
    0x008a,   /*   .#...#.#.   */
    0x0112,   /*   #...#..#.   */
    0x0054,   /*   ..#.#.#..   */
    0x0091,   /*   .#..#...#   */
    0x00a2,   /*   .#.#...#.   */
    0x0048,   /*   ..#..#...   */
    0x0089,   /*   .#...#..#   */
},
{
    0x0052,   /*   ..#.#..#.   */
    0x0004,   /*   ......#..   */
    0x01f1,   /*   #####...#   */
    0x0164,   /*   #.##..#..   */
    0x0010,   /*   ....#....   */
    0x004d,   /*   ..#..##.#   */
    0x011f,   /*   #...#####   */
    0x0040,   /*   ..#......   */
    0x0094,   /*   .#..#.#..   */
},
{
    0x00e4,   /*   .###..#..   */
    0x0015,   /*   ....#.#.#   */
    0x0189,   /*   ##...#..#   */
    0x0041,   /*   ..#.....#   */
    0x0082,   /*   .#.....#.   */
    0x0104,   /*   #.....#..   */
    0x0123,   /*   #..#...##   */
    0x0150,   /*   #.#.#....   */
    0x004e,   /*   ..#..###.   */
},
{
    0x0063,   /*   ..##...##   */
    0x0120,   /*   #..#.....   */
    0x0080,   /*   .#.......   */
    0x0052,   /*   ..#.#..#.   */
    0x00ee,   /*   .###.###.   */
    0x0094,   /*   .#..#.#..   */
    0x0002,   /*   .......#.   */
    0x0009,   /*   .....#..#   */
    0x018c,   /*   ##...##..   */
},
{
    0x0082,   /*   .#.....#.   */
    0x0044,   /*   ..#...#..   */
    0x01bb,   /*   ##.###.##   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0101,   /*   #.......#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x01bb,   /*   ##.###.##   */
    0x0044,   /*   ..#...#..   */
    0x0082,   /*   .#.....#.   */
},
{
    0x0028,   /*   ...#.#...   */
    0x0044,   /*   ..#...#..   */
    0x01ab,   /*   ##.#.#.##   */
    0x0082,   /*   .#.....#.   */
    0x0145,   /*   #.#...#.#   */
    0x0082,   /*   .#.....#.   */
    0x01ab,   /*   ##.#.#.##   */
    0x0044,   /*   ..#...#..   */
    0x0028,   /*   ...#.#...   */
},
{
    0x0121,   /*   #..#....#   */
    0x0034,   /*   ...##.#..   */
    0x0088,   /*   .#...#...   */
    0x0043,   /*   ..#....##   */
    0x0092,   /*   .#..#..#.   */
    0x0184,   /*   ##....#..   */
    0x0022,   /*   ...#...#.   */
    0x0058,   /*   ..#.##...   */
    0x0109,   /*   #....#..#   */
},
{
    0x00ac,   /*   .#.#.##..   */
    0x0098,   /*   .#..##...   */
    0x0042,   /*   ..#....#.   */
    0x0049,   /*   ..#..#..#   */
    0x0101,   /*   #.......#   */
    0x0124,   /*   #..#..#..   */
    0x0084,   /*   .#....#..   */
    0x0032,   /*   ...##..#.   */
    0x006a,   /*   ..##.#.#.   */
},
{
    0x0092,   /*   .#..#..#.   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x0145,   /*   #.#...#.#   */
    0x0028,   /*   ...#.#...   */
    0x0145,   /*   #.#...#.#   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0092,   /*   .#..#..#.   */
},
{
    0x000c,   /*   .....##..   */
    0x0091,   /*   .#..#...#   */
    0x0089,   /*   .#...#..#   */
    0x0048,   /*   ..#..#...   */
    0x0183,   /*   ##.....##   */
    0x0024,   /*   ...#..#..   */
    0x0122,   /*   #..#...#.   */
    0x0112,   /*   #...#..#.   */
    0x0060,   /*   ..##.....   */
},
{
    0x006c,   /*   ..##.##..   */
    0x0146,   /*   #.#...##.   */
    0x0018,   /*   ....##...   */
    0x001d,   /*   ....###.#   */
    0x0101,   /*   #.......#   */
    0x0170,   /*   #.###....   */
    0x0030,   /*   ...##....   */
    0x00c5,   /*   .##...#.#   */
    0x006c,   /*   ..##.##..   */
},
{
    0x0015,   /*   ....#.#.#   */
    0x0088,   /*   .#...#...   */
    0x0140,   /*   #.#......   */
    0x009a,   /*   .#..##.#.   */
    0x0101,   /*   #.......#   */
    0x00b2,   /*   .#.##..#.   */
    0x0005,   /*   ......#.#   */
    0x0022,   /*   ...#...#.   */
    0x0150,   /*   #.#.#....   */
},
{
    0x0000,   /*   .........   */
    0x00aa,   /*   .#.#.#.#.   */
    0x01c7,   /*   ###...###   */
    0x007c,   /*   ..#####..   */
    0x0000,   /*   .........   */
    0x007c,   /*   ..#####..   */
    0x01c7,   /*   ###...###   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0000,   /*   .........   */
},
{
    0x0192,   /*   ##..#..#.   */
    0x0093,   /*   .#..#..##   */
    0x0088,   /*   .#...#...   */
    0x0068,   /*   ..##.#...   */
    0x0101,   /*   #.......#   */
    0x002c,   /*   ...#.##..   */
    0x0022,   /*   ...#...#.   */
    0x0192,   /*   ##..#..#.   */
    0x0093,   /*   .#..#..##   */
},
{
    0x0129,   /*   #..#.#..#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0044,   /*   ..#...#..   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0044,   /*   ..#...#..   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0129,   /*   #..#.#..#   */
},
{
    0x0113,   /*   #...#..##   */
    0x0130,   /*   #..##....   */
    0x01c0,   /*   ###......   */
    0x0025,   /*   ...#..#.#   */
    0x0082,   /*   .#.....#.   */
    0x0148,   /*   #.#..#...   */
    0x0007,   /*   ......###   */
    0x0019,   /*   ....##..#   */
    0x0191,   /*   ##..#...#   */
},
{
    0x0094,   /*   .#..#.#..   */
    0x0013,   /*   ....#..##   */
    0x001d,   /*   ....###.#   */
    0x018a,   /*   ##...#.#.   */
    0x0010,   /*   ....#....   */
    0x00a3,   /*   .#.#...##   */
    0x0170,   /*   #.###....   */
    0x0190,   /*   ##..#....   */
    0x0052,   /*   ..#.#..#.   */
},
{
    0x0017,   /*   ....#.###   */
    0x01b2,   /*   ##.##..#.   */
    0x0004,   /*   ......#..   */
    0x0021,   /*   ...#....#   */
    0x01ab,   /*   ##.#.#.##   */
    0x0108,   /*   #....#...   */
    0x0040,   /*   ..#......   */
    0x009b,   /*   .#..##.##   */
    0x01d0,   /*   ###.#....   */
},
{
    0x0129,   /*   #..#.#..#   */
    0x0000,   /*   .........   */
    0x01c7,   /*   ###...###   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x01c7,   /*   ###...###   */
    0x0000,   /*   .........   */
    0x0129,   /*   #..#.#..#   */
},
{
    0x00d8,   /*   .##.##...   */
    0x0093,   /*   .#..#..##   */
    0x008a,   /*   .#...#.#.   */
    0x0110,   /*   #...#....   */
    0x0145,   /*   #.#...#.#   */
    0x0011,   /*   ....#...#   */
    0x00a2,   /*   .#.#...#.   */
    0x0192,   /*   ##..#..#.   */
    0x0036,   /*   ...##.##.   */
},
{
    0x0056,   /*   ..#.#.##.   */
    0x01a2,   /*   ##.#...#.   */
    0x0048,   /*   ..#..#...   */
    0x0050,   /*   ..#.#....   */
    0x0145,   /*   #.#...#.#   */
    0x0014,   /*   ....#.#..   */
    0x0024,   /*   ...#..#..   */
    0x008b,   /*   .#...#.##   */
    0x00d4,   /*   .##.#.#..   */
},
{
    0x0066,   /*   ..##..##.   */
    0x0105,   /*   #.....#.#   */
    0x0091,   /*   .#..#...#   */
    0x008c,   /*   .#...##..   */
    0x0028,   /*   ...#.#...   */
    0x0062,   /*   ..##...#.   */
    0x0112,   /*   #...#..#.   */
    0x0141,   /*   #.#.....#   */
    0x00cc,   /*   .##..##..   */
},
{
    0x01a0,   /*   ##.#.....   */
    0x00b9,   /*   .#.###..#   */
    0x000b,   /*   .....#.##   */
    0x0120,   /*   #..#.....   */
    0x0101,   /*   #.......#   */
    0x0009,   /*   .....#..#   */
    0x01a0,   /*   ##.#.....   */
    0x013a,   /*   #..###.#.   */
    0x000b,   /*   .....#.##   */
},
{
    0x0000,   /*   .........   */
    0x01ad,   /*   ##.#.##.#   */
    0x0056,   /*   ..#.#.##.   */
    0x0018,   /*   ....##...   */
    0x0145,   /*   #.#...#.#   */
    0x0030,   /*   ...##....   */
    0x00d4,   /*   .##.#.#..   */
    0x016b,   /*   #.##.#.##   */
    0x0000,   /*   .........   */
},
{
    0x0028,   /*   ...#.#...   */
    0x0082,   /*   .#.....#.   */
    0x01c7,   /*   ###...###   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x01c7,   /*   ###...###   */
    0x0082,   /*   .#.....#.   */
    0x0028,   /*   ...#.#...   */
},
{
    0x0024,   /*   ...#..#..   */
    0x0152,   /*   #.#.#..#.   */
    0x0124,   /*   #..#..#..   */
    0x0059,   /*   ..#.##..#   */
    0x0082,   /*   .#.....#.   */
    0x0134,   /*   #..##.#..   */
    0x0049,   /*   ..#..#..#   */
    0x0095,   /*   .#..#.#.#   */
    0x0048,   /*   ..#..#...   */
},
{
    0x016d,   /*   #.##.##.#   */
    0x006c,   /*   ..##.##..   */
    0x0082,   /*   .#.....#.   */
    0x0028,   /*   ...#.#...   */
    0x0101,   /*   #.......#   */
    0x0028,   /*   ...#.#...   */
    0x0082,   /*   .#.....#.   */
    0x006c,   /*   ..##.##..   */
    0x016d,   /*   #.##.##.#   */
},
{
    0x0091,   /*   .#..#...#   */
    0x0069,   /*   ..##.#..#   */
    0x0038,   /*   ...###...   */
    0x0084,   /*   .#....#..   */
    0x0183,   /*   ##.....##   */
    0x0042,   /*   ..#....#.   */
    0x0038,   /*   ...###...   */
    0x012c,   /*   #..#.##..   */
    0x0112,   /*   #...#..#.   */
},
{
    0x0101,   /*   #.......#   */
    0x0021,   /*   ...#....#   */
    0x01d4,   /*   ###.#.#..   */
    0x012a,   /*   #..#.#.#.   */
    0x0082,   /*   .#.....#.   */
    0x00a9,   /*   .#.#.#..#   */
    0x0057,   /*   ..#.#.###   */
    0x0108,   /*   #....#...   */
    0x0101,   /*   #.......#   */
},
{
    0x0156,   /*   #.#.#.##.   */
    0x00c0,   /*   .##......   */
    0x0021,   /*   ...#....#   */
    0x0160,   /*   #.##.....   */
    0x0129,   /*   #..#.#..#   */
    0x000d,   /*   .....##.#   */
    0x0108,   /*   #....#...   */
    0x0006,   /*   ......##.   */
    0x00d5,   /*   .##.#.#.#   */
},
{
    0x00c2,   /*   .##....#.   */
    0x010a,   /*   #....#.#.   */
    0x012c,   /*   #..#.##..   */
    0x0095,   /*   .#..#.#.#   */
    0x0000,   /*   .........   */
    0x0152,   /*   #.#.#..#.   */
    0x0069,   /*   ..##.#..#   */
    0x00a1,   /*   .#.#....#   */
    0x0086,   /*   .#....##.   */
},
{
    0x0003,   /*   .......##   */
    0x0048,   /*   ..#..#...   */
    0x0168,   /*   #.##.#...   */
    0x0195,   /*   ##..#.#.#   */
    0x0028,   /*   ...#.#...   */
    0x0153,   /*   #.#.#..##   */
    0x002d,   /*   ...#.##.#   */
    0x0024,   /*   ...#..#..   */
    0x0180,   /*   ##.......   */
},
{
    0x00c2,   /*   .##....#.   */
    0x01b0,   /*   ##.##....   */
    0x000d,   /*   .....##.#   */
    0x0007,   /*   ......###   */
    0x0082,   /*   .#.....#.   */
    0x01c0,   /*   ###......   */
    0x0160,   /*   #.##.....   */
    0x001b,   /*   ....##.##   */
    0x0086,   /*   .#....##.   */
},
{
    0x016d,   /*   #.##.##.#   */
    0x0044,   /*   ..#...#..   */
    0x0082,   /*   .#.....#.   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0082,   /*   .#.....#.   */
    0x0044,   /*   ..#...#..   */
    0x016d,   /*   #.##.##.#   */
},
{
    0x0022,   /*   ...#...#.   */
    0x0006,   /*   ......##.   */
    0x0135,   /*   #..##.#.#   */
    0x0112,   /*   #...#..#.   */
    0x0183,   /*   ##.....##   */
    0x0091,   /*   .#..#...#   */
    0x0159,   /*   #.#.##..#   */
    0x00c0,   /*   .##......   */
    0x0088,   /*   .#...#...   */
},
{
    0x0044,   /*   ..#...#..   */
    0x006c,   /*   ..##.##..   */
    0x0111,   /*   #...#...#   */
    0x00ee,   /*   .###.###.   */
    0x0000,   /*   .........   */
    0x00ee,   /*   .###.###.   */
    0x0111,   /*   #...#...#   */
    0x006c,   /*   ..##.##..   */
    0x0044,   /*   ..#...#..   */
},
{
    0x0043,   /*   ..#....##   */
    0x014c,   /*   #.#..##..   */
    0x0050,   /*   ..#.#....   */
    0x0034,   /*   ...##.#..   */
    0x0129,   /*   #..#.#..#   */
    0x0058,   /*   ..#.##...   */
    0x0014,   /*   ....#.#..   */
    0x0065,   /*   ..##..#.#   */
    0x0184,   /*   ##....#..   */
},
{
    0x00a8,   /*   .#.#.#...   */
    0x018c,   /*   ##...##..   */
    0x0010,   /*   ....#....   */
    0x0184,   /*   ##....#..   */
    0x0101,   /*   #.......#   */
    0x0043,   /*   ..#....##   */
    0x0010,   /*   ....#....   */
    0x0063,   /*   ..##...##   */
    0x002a,   /*   ...#.#.#.   */
},
{
    0x0145,   /*   #.#...#.#   */
    0x00ee,   /*   .###.###.   */
    0x0101,   /*   #.......#   */
    0x0028,   /*   ...#.#...   */
    0x0092,   /*   .#..#..#.   */
    0x0028,   /*   ...#.#...   */
    0x0101,   /*   #.......#   */
    0x00ee,   /*   .###.###.   */
    0x0145,   /*   #.#...#.#   */
},
{
    0x01a0,   /*   ##.#.....   */
    0x0054,   /*   ..#.#.#..   */
    0x0021,   /*   ...#....#   */
    0x008a,   /*   .#...#.#.   */
    0x0129,   /*   #..#.#..#   */
    0x00a2,   /*   .#.#...#.   */
    0x0108,   /*   #....#...   */
    0x0054,   /*   ..#.#.#..   */
    0x000b,   /*   .....#.##   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x0054,   /*   ..#.#.#..   */
    0x0101,   /*   #.......#   */
    0x0054,   /*   ..#.#.#..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x0074,   /*   ..###.#..   */
    0x0041,   /*   ..#.....#   */
    0x0126,   /*   #..#..##.   */
    0x00d8,   /*   .##.##...   */
    0x0000,   /*   .........   */
    0x0036,   /*   ...##.##.   */
    0x00c9,   /*   .##..#..#   */
    0x0104,   /*   #.....#..   */
    0x005c,   /*   ..#.###..   */
},
{
    0x0111,   /*   #...#...#   */
    0x0183,   /*   ##.....##   */
    0x0028,   /*   ...#.#...   */
    0x0093,   /*   .#..#..##   */
    0x0044,   /*   ..#...#..   */
    0x0192,   /*   ##..#..#.   */
    0x0028,   /*   ...#.#...   */
    0x0183,   /*   ##.....##   */
    0x0111,   /*   #...#...#   */
},
{
    0x0044,   /*   ..#...#..   */
    0x0028,   /*   ...#.#...   */
    0x0183,   /*   ##.....##   */
    0x006c,   /*   ..##.##..   */
    0x0183,   /*   ##.....##   */
    0x006c,   /*   ..##.##..   */
    0x0183,   /*   ##.....##   */
    0x0028,   /*   ...#.#...   */
    0x0044,   /*   ..#...#..   */
},
{
    0x0037,   /*   ...##.###   */
    0x0013,   /*   ....#..##   */
    0x0044,   /*   ..#...#..   */
    0x0122,   /*   #..#...#.   */
    0x0044,   /*   ..#...#..   */
    0x0089,   /*   .#...#..#   */
    0x0044,   /*   ..#...#..   */
    0x0190,   /*   ##..#....   */
    0x01d8,   /*   ###.##...   */
},
{
    0x0007,   /*   ......###   */
    0x014a,   /*   #.#..#.#.   */
    0x0094,   /*   .#..#.#..   */
    0x0112,   /*   #...#..#.   */
    0x0082,   /*   .#.....#.   */
    0x0091,   /*   .#..#...#   */
    0x0052,   /*   ..#.#..#.   */
    0x00a5,   /*   .#.#..#.#   */
    0x01c0,   /*   ###......   */
},
{
    0x00ee,   /*   .###.###.   */
    0x0000,   /*   .........   */
    0x0183,   /*   ##.....##   */
    0x006c,   /*   ..##.##..   */
    0x0092,   /*   .#..#..#.   */
    0x006c,   /*   ..##.##..   */
    0x0183,   /*   ##.....##   */
    0x0000,   /*   .........   */
    0x00ee,   /*   .###.###.   */
},
{
    0x01ab,   /*   ##.#.#.##   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0101,   /*   #.......#   */
    0x0028,   /*   ...#.#...   */
    0x0082,   /*   .#.....#.   */
    0x0028,   /*   ...#.#...   */
    0x0101,   /*   #.......#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x01ab,   /*   ##.#.#.##   */
},
{
    0x01aa,   /*   ##.#.#.#.   */
    0x0152,   /*   #.#.#..#.   */
    0x0012,   /*   ....#..#.   */
    0x002c,   /*   ...#.##..   */
    0x0000,   /*   .........   */
    0x0068,   /*   ..##.#...   */
    0x0090,   /*   .#..#....   */
    0x0095,   /*   .#..#.#.#   */
    0x00ab,   /*   .#.#.#.##   */
},
{
    0x0046,   /*   ..#...##.   */
    0x0182,   /*   ##.....#.   */
    0x002c,   /*   ...#.##..   */
    0x004d,   /*   ..#..##.#   */
    0x0028,   /*   ...#.#...   */
    0x0164,   /*   #.##..#..   */
    0x0068,   /*   ..##.#...   */
    0x0083,   /*   .#.....##   */
    0x00c4,   /*   .##...#..   */
},
{
    0x00a9,   /*   .#.#.#..#   */
    0x0015,   /*   ....#.#.#   */
    0x0016,   /*   ....#.##.   */
    0x0083,   /*   .#.....##   */
    0x0028,   /*   ...#.#...   */
    0x0182,   /*   ##.....#.   */
    0x00d0,   /*   .##.#....   */
    0x0150,   /*   #.#.#....   */
    0x012a,   /*   #..#.#.#.   */
},
{
    0x00a4,   /*   .#.#..#..   */
    0x0121,   /*   #..#....#   */
    0x0059,   /*   ..#.##..#   */
    0x0059,   /*   ..#.##..#   */
    0x0000,   /*   .........   */
    0x0134,   /*   #..##.#..   */
    0x0134,   /*   #..##.#..   */
    0x0109,   /*   #....#..#   */
    0x004a,   /*   ..#..#.#.   */
},
{
    0x00e4,   /*   .###..#..   */
    0x0094,   /*   .#..#.#..   */
    0x00a8,   /*   .#.#.#...   */
    0x0022,   /*   ...#...#.   */
    0x0129,   /*   #..#.#..#   */
    0x0088,   /*   .#...#...   */
    0x002a,   /*   ...#.#.#.   */
    0x0052,   /*   ..#.#..#.   */
    0x004e,   /*   ..#..###.   */
},
{
    0x0128,   /*   #..#.#...   */
    0x0044,   /*   ..#...#..   */
    0x0025,   /*   ...#..#.#   */
    0x004e,   /*   ..#..###.   */
    0x0111,   /*   #...#...#   */
    0x00e4,   /*   .###..#..   */
    0x0148,   /*   #.#..#...   */
    0x0044,   /*   ..#...#..   */
    0x0029,   /*   ...#.#..#   */
},
{
    0x002d,   /*   ...#.##.#   */
    0x0062,   /*   ..##...#.   */
    0x01c1,   /*   ###.....#   */
    0x0010,   /*   ....#....   */
    0x0183,   /*   ##.....##   */
    0x0010,   /*   ....#....   */
    0x0107,   /*   #.....###   */
    0x008c,   /*   .#...##..   */
    0x0168,   /*   #.##.#...   */
},
{
    0x0101,   /*   #.......#   */
    0x00ba,   /*   .#.###.#.   */
    0x0082,   /*   .#.....#.   */
    0x006c,   /*   ..##.##..   */
    0x0082,   /*   .#.....#.   */
    0x006c,   /*   ..##.##..   */
    0x0082,   /*   .#.....#.   */
    0x00ba,   /*   .#.###.#.   */
    0x0101,   /*   #.......#   */
},
{
    0x016d,   /*   #.##.##.#   */
    0x0044,   /*   ..#...#..   */
    0x0183,   /*   ##.....##   */
    0x0028,   /*   ...#.#...   */
    0x0082,   /*   .#.....#.   */
    0x0028,   /*   ...#.#...   */
    0x0183,   /*   ##.....##   */
    0x0044,   /*   ..#...#..   */
    0x016d,   /*   #.##.##.#   */
},
{
    0x00e1,   /*   .###....#   */
    0x001b,   /*   ....##.##   */
    0x00c0,   /*   .##......   */
    0x0051,   /*   ..#.#...#   */
    0x0082,   /*   .#.....#.   */
    0x0114,   /*   #...#.#..   */
    0x0006,   /*   ......##.   */
    0x01b0,   /*   ##.##....   */
    0x010e,   /*   #....###.   */
},
{
    0x0103,   /*   #......##   */
    0x01a9,   /*   ##.#.#..#   */
    0x0110,   /*   #...#....   */
    0x0088,   /*   .#...#...   */
    0x0145,   /*   #.#...#.#   */
    0x0022,   /*   ...#...#.   */
    0x0011,   /*   ....#...#   */
    0x012b,   /*   #..#.#.##   */
    0x0181,   /*   ##......#   */
},
{
    0x0082,   /*   .#.....#.   */
    0x00ee,   /*   .###.###.   */
    0x0145,   /*   #.#...#.#   */
    0x0038,   /*   ...###...   */
    0x0010,   /*   ....#....   */
    0x0038,   /*   ...###...   */
    0x0145,   /*   #.#...#.#   */
    0x00ee,   /*   .###.###.   */
    0x0082,   /*   .#.....#.   */
},
{
    0x0052,   /*   ..#.#..#.   */
    0x00d0,   /*   .##.#....   */
    0x0148,   /*   #.#..#...   */
    0x00c1,   /*   .##.....#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0106,   /*   #.....##.   */
    0x0025,   /*   ...#..#.#   */
    0x0016,   /*   ....#.##.   */
    0x0094,   /*   .#..#.#..   */
},
{
    0x0017,   /*   ....#.###   */
    0x0041,   /*   ..#.....#   */
    0x008a,   /*   .#...#.#.   */
    0x0024,   /*   ...#..#..   */
    0x01ab,   /*   ##.#.#.##   */
    0x0048,   /*   ..#..#...   */
    0x00a2,   /*   .#.#...#.   */
    0x0104,   /*   #.....#..   */
    0x01d0,   /*   ###.#....   */
},
{
    0x0162,   /*   #.##...#.   */
    0x0010,   /*   ....#....   */
    0x0019,   /*   ....##..#   */
    0x014c,   /*   #.#..##..   */
    0x0145,   /*   #.#...#.#   */
    0x0065,   /*   ..##..#.#   */
    0x0130,   /*   #..##....   */
    0x0010,   /*   ....#....   */
    0x008d,   /*   .#...##.#   */
},
{
    0x00a6,   /*   .#.#..##.   */
    0x0032,   /*   ...##..#.   */
    0x0100,   /*   #........   */
    0x00e9,   /*   .###.#..#   */
    0x0082,   /*   .#.....#.   */
    0x012e,   /*   #..#.###.   */
    0x0001,   /*   ........#   */
    0x0098,   /*   .#..##...   */
    0x00ca,   /*   .##..#.#.   */
},
{
    0x0123,   /*   #..#...##   */
    0x0090,   /*   .#..#....   */
    0x018a,   /*   ##...#.#.   */
    0x0158,   /*   #.#.##...   */
    0x0000,   /*   .........   */
    0x0035,   /*   ...##.#.#   */
    0x00a3,   /*   .#.#...##   */
    0x0012,   /*   ....#..#.   */
    0x0189,   /*   ##...#..#   */
},
{
    0x0145,   /*   #.#...#.#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0082,   /*   .#.....#.   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0145,   /*   #.#...#.#   */
},
{
    0x002d,   /*   ...#.##.#   */
    0x01a1,   /*   ##.#....#   */
    0x0008,   /*   .....#...   */
    0x00e3,   /*   .###...##   */
    0x0000,   /*   .........   */
    0x018e,   /*   ##...###.   */
    0x0020,   /*   ...#.....   */
    0x010b,   /*   #....#.##   */
    0x0168,   /*   #.##.#...   */
},
{
    0x019c,   /*   ##..###..   */
    0x00a5,   /*   .#.#..#.#   */
    0x0180,   /*   ##.......   */
    0x0021,   /*   ...#....#   */
    0x0028,   /*   ...#.#...   */
    0x0108,   /*   #....#...   */
    0x0003,   /*   .......##   */
    0x014a,   /*   #.#..#.#.   */
    0x0073,   /*   ..###..##   */
},
{
    0x0068,   /*   ..##.#...   */
    0x0086,   /*   .#....##.   */
    0x018c,   /*   ##...##..   */
    0x0162,   /*   #.##...#.   */
    0x0010,   /*   ....#....   */
    0x008d,   /*   .#...##.#   */
    0x0063,   /*   ..##...##   */
    0x00c2,   /*   .##....#.   */
    0x002c,   /*   ...#.##..   */
},
{
    0x0023,   /*   ...#...##   */
    0x0188,   /*   ##...#...   */
    0x0113,   /*   #...#..##   */
    0x0094,   /*   .#..#.#..   */
    0x0101,   /*   #.......#   */
    0x0052,   /*   ..#.#..#.   */
    0x0191,   /*   ##..#...#   */
    0x0023,   /*   ...#...##   */
    0x0188,   /*   ##...#...   */
},
{
    0x00f3,   /*   .####..##   */
    0x0040,   /*   ..#......   */
    0x01a4,   /*   ##.#..#..   */
    0x0094,   /*   .#..#.#..   */
    0x0000,   /*   .........   */
    0x0052,   /*   ..#.#..#.   */
    0x004b,   /*   ..#..#.##   */
    0x0004,   /*   ......#..   */
    0x019e,   /*   ##..####.   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x00c6,   /*   .##...##.   */
    0x0101,   /*   #.......#   */
    0x007c,   /*   ..#####..   */
    0x0000,   /*   .........   */
    0x007c,   /*   ..#####..   */
    0x0101,   /*   #.......#   */
    0x00c6,   /*   .##...##.   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x00ae,   /*   .#.#.###.   */
    0x0009,   /*   .....#..#   */
    0x0105,   /*   #.....#.#   */
    0x00a6,   /*   .#.#..##.   */
    0x0010,   /*   ....#....   */
    0x00ca,   /*   .##..#.#.   */
    0x0141,   /*   #.#.....#   */
    0x0120,   /*   #..#.....   */
    0x00ea,   /*   .###.#.#.   */
},
{
    0x0009,   /*   .....#..#   */
    0x0194,   /*   ##..#.#..   */
    0x0029,   /*   ...#.#..#   */
    0x0034,   /*   ...##.#..   */
    0x0145,   /*   #.#...#.#   */
    0x0058,   /*   ..#.##...   */
    0x0128,   /*   #..#.#...   */
    0x0053,   /*   ..#.#..##   */
    0x0120,   /*   #..#.....   */
},
{
    0x0106,   /*   #.....##.   */
    0x011a,   /*   #...##.#.   */
    0x0080,   /*   .#.......   */
    0x002c,   /*   ...#.##..   */
    0x00ee,   /*   .###.###.   */
    0x0068,   /*   ..##.#...   */
    0x0002,   /*   .......#.   */
    0x00b1,   /*   .#.##...#   */
    0x00c1,   /*   .##.....#   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x006c,   /*   ..##.##..   */
    0x00c6,   /*   .##...##.   */
    0x0028,   /*   ...#.#...   */
    0x0101,   /*   #.......#   */
    0x0028,   /*   ...#.#...   */
    0x00c6,   /*   .##...##.   */
    0x006c,   /*   ..##.##..   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x0024,   /*   ...#..#..   */
    0x0182,   /*   ##.....#.   */
    0x004a,   /*   ..#..#.#.   */
    0x00f2,   /*   .####..#.   */
    0x0101,   /*   #.......#   */
    0x009e,   /*   .#..####.   */
    0x00a4,   /*   .#.#..#..   */
    0x0083,   /*   .#.....##   */
    0x0048,   /*   ..#..#...   */
},
{
    0x010b,   /*   #....#.##   */
    0x0021,   /*   ...#....#   */
    0x0122,   /*   #..#...#.   */
    0x003a,   /*   ...###.#.   */
    0x0082,   /*   .#.....#.   */
    0x00b8,   /*   .#.###...   */
    0x0089,   /*   .#...#..#   */
    0x0108,   /*   #....#...   */
    0x01a1,   /*   ##.#....#   */
},
{
    0x0064,   /*   ..##..#..   */
    0x0198,   /*   ##..##...   */
    0x0122,   /*   #..#...#.   */
    0x0111,   /*   #...#...#   */
    0x0044,   /*   ..#...#..   */
    0x0111,   /*   #...#...#   */
    0x0089,   /*   .#...#..#   */
    0x0033,   /*   ...##..##   */
    0x004c,   /*   ..#..##..   */
},
{
    0x00a2,   /*   .#.#...#.   */
    0x0023,   /*   ...#...##   */
    0x006e,   /*   ..##.###.   */
    0x00c0,   /*   .##......   */
    0x0101,   /*   #.......#   */
    0x0006,   /*   ......##.   */
    0x00ec,   /*   .###.##..   */
    0x0188,   /*   ##...#...   */
    0x008a,   /*   .#...#.#.   */
},
{
    0x0075,   /*   ..###.#.#   */
    0x0161,   /*   #.##....#   */
    0x0080,   /*   .#.......   */
    0x0148,   /*   #.#..#...   */
    0x0044,   /*   ..#...#..   */
    0x0025,   /*   ...#..#.#   */
    0x0002,   /*   .......#.   */
    0x010d,   /*   #....##.#   */
    0x015c,   /*   #.#.###..   */
},
{
    0x0088,   /*   .#...#...   */
    0x0136,   /*   #..##.##.   */
    0x0142,   /*   #.#....#.   */
    0x00d0,   /*   .##.#....   */
    0x0028,   /*   ...#.#...   */
    0x0016,   /*   ....#.##.   */
    0x0085,   /*   .#....#.#   */
    0x00d9,   /*   .##.##..#   */
    0x0022,   /*   ...#...#.   */
},
{
    0x0023,   /*   ...#...##   */
    0x00a2,   /*   .#.#...#.   */
    0x004c,   /*   ..#..##..   */
    0x0118,   /*   #...##...   */
    0x00c6,   /*   .##...##.   */
    0x0031,   /*   ...##...#   */
    0x0064,   /*   ..##..#..   */
    0x008a,   /*   .#...#.#.   */
    0x0188,   /*   ##...#...   */
},
{
    0x012c,   /*   #..#.##..   */
    0x006a,   /*   ..##.#.#.   */
    0x0004,   /*   ......#..   */
    0x0098,   /*   .#..##...   */
    0x006c,   /*   ..##.##..   */
    0x0032,   /*   ...##..#.   */
    0x0040,   /*   ..#......   */
    0x00ac,   /*   .#.#.##..   */
    0x0069,   /*   ..##.#..#   */
},
{
    0x00d4,   /*   .##.#.#..   */
    0x0101,   /*   #.......#   */
    0x0150,   /*   #.#.#....   */
    0x0164,   /*   #.##..#..   */
    0x0082,   /*   .#.....#.   */
    0x004d,   /*   ..#..##.#   */
    0x0015,   /*   ....#.#.#   */
    0x0101,   /*   #.......#   */
    0x0056,   /*   ..#.#.##.   */
},
{
    0x000e,   /*   .....###.   */
    0x0164,   /*   #.##..#..   */
    0x0010,   /*   ....#....   */
    0x0103,   /*   #......##   */
    0x01ab,   /*   ##.#.#.##   */
    0x0181,   /*   ##......#   */
    0x0010,   /*   ....#....   */
    0x004d,   /*   ..#..##.#   */
    0x00e0,   /*   .###.....   */
},
{
    0x010a,   /*   #....#.#.   */
    0x0032,   /*   ...##..#.   */
    0x00a1,   /*   .#.#....#   */
    0x00d0,   /*   .##.#....   */
    0x0129,   /*   #..#.#..#   */
    0x0016,   /*   ....#.##.   */
    0x010a,   /*   #....#.#.   */
    0x0098,   /*   .#..##...   */
    0x00a1,   /*   .#.#....#   */
},
{
    0x014a,   /*   #.#..#.#.   */
    0x0019,   /*   ....##..#   */
    0x0114,   /*   #...#.#..   */
    0x0042,   /*   ..#....#.   */
    0x006c,   /*   ..##.##..   */
    0x0084,   /*   .#....#..   */
    0x0051,   /*   ..#.#...#   */
    0x0130,   /*   #..##....   */
    0x00a5,   /*   .#.#..#.#   */
},
{
    0x0120,   /*   #..#.....   */
    0x0159,   /*   #.#.##..#   */
    0x00e0,   /*   .###.....   */
    0x0006,   /*   ......##.   */
    0x0145,   /*   #.#...#.#   */
    0x00c0,   /*   .##......   */
    0x000e,   /*   .....###.   */
    0x0135,   /*   #..##.#.#   */
    0x0009,   /*   .....#..#   */
},
{
    0x0131,   /*   #..##...#   */
    0x0086,   /*   .#....##.   */
    0x0099,   /*   .#..##..#   */
    0x0009,   /*   .....#..#   */
    0x0044,   /*   ..#...#..   */
    0x0120,   /*   #..#.....   */
    0x0132,   /*   #..##..#.   */
    0x00c2,   /*   .##....#.   */
    0x0119,   /*   #...##..#   */
},
{
    0x0044,   /*   ..#...#..   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0183,   /*   ##.....##   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0183,   /*   ##.....##   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0044,   /*   ..#...#..   */
},
{
    0x0168,   /*   #.##.#...   */
    0x010c,   /*   #....##..   */
    0x008a,   /*   .#...#.#.   */
    0x0091,   /*   .#..#...#   */
    0x0082,   /*   .#.....#.   */
    0x0112,   /*   #...#..#.   */
    0x00a2,   /*   .#.#...#.   */
    0x0061,   /*   ..##....#   */
    0x002d,   /*   ...#.##.#   */
},
{
    0x0043,   /*   ..#....##   */
    0x00d8,   /*   .##.##...   */
    0x0120,   /*   #..#.....   */
    0x0168,   /*   #.##.#...   */
    0x0082,   /*   .#.....#.   */
    0x002d,   /*   ...#.##.#   */
    0x0009,   /*   .....#..#   */
    0x0036,   /*   ...##.##.   */
    0x0184,   /*   ##....#..   */
},
{
    0x01ab,   /*   ##.#.#.##   */
    0x0010,   /*   ....#....   */
    0x0082,   /*   .#.....#.   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0082,   /*   .#.....#.   */
    0x0010,   /*   ....#....   */
    0x01ab,   /*   ##.#.#.##   */
},
{
    0x0120,   /*   #..#.....   */
    0x0190,   /*   ##..#....   */
    0x0046,   /*   ..#...##.   */
    0x00a9,   /*   .#.#.#..#   */
    0x0129,   /*   #..#.#..#   */
    0x012a,   /*   #..#.#.#.   */
    0x00c4,   /*   .##...#..   */
    0x0013,   /*   ....#..##   */
    0x0009,   /*   .....#..#   */
},
{
    0x00a0,   /*   .#.#.....   */
    0x0185,   /*   ##....#.#   */
    0x0051,   /*   ..#.#...#   */
    0x0158,   /*   #.#.##...   */
    0x0082,   /*   .#.....#.   */
    0x0035,   /*   ...##.#.#   */
    0x0114,   /*   #...#.#..   */
    0x0143,   /*   #.#....##   */
    0x000a,   /*   .....#.#.   */
},
{
    0x0101,   /*   #.......#   */
    0x00d6,   /*   .##.#.##.   */
    0x0145,   /*   #.#...#.#   */
    0x006c,   /*   ..##.##..   */
    0x0000,   /*   .........   */
    0x006c,   /*   ..##.##..   */
    0x0145,   /*   #.#...#.#   */
    0x00d6,   /*   .##.#.##.   */
    0x0101,   /*   #.......#   */
},
{
    0x00e0,   /*   .###.....   */
    0x0111,   /*   #...#...#   */
    0x0011,   /*   ....#...#   */
    0x014a,   /*   #.#..#.#.   */
    0x0183,   /*   ##.....##   */
    0x00a5,   /*   .#.#..#.#   */
    0x0110,   /*   #...#....   */
    0x0111,   /*   #...#...#   */
    0x000e,   /*   .....###.   */
},
{
    0x0183,   /*   ##.....##   */
    0x0028,   /*   ...#.#...   */
    0x0145,   /*   #.#...#.#   */
    0x006c,   /*   ..##.##..   */
    0x0082,   /*   .#.....#.   */
    0x006c,   /*   ..##.##..   */
    0x0145,   /*   #.#...#.#   */
    0x0028,   /*   ...#.#...   */
    0x0183,   /*   ##.....##   */
},
{
    0x018c,   /*   ##...##..   */
    0x0131,   /*   #..##...#   */
    0x000c,   /*   .....##..   */
    0x0051,   /*   ..#.#...#   */
    0x0082,   /*   .#.....#.   */
    0x0114,   /*   #...#.#..   */
    0x0060,   /*   ..##.....   */
    0x0119,   /*   #...##..#   */
    0x0063,   /*   ..##...##   */
},
{
    0x0163,   /*   #.##...##   */
    0x0018,   /*   ....##...   */
    0x000b,   /*   .....#.##   */
    0x0043,   /*   ..#....##   */
    0x0000,   /*   .........   */
    0x0184,   /*   ##....#..   */
    0x01a0,   /*   ##.#.....   */
    0x0030,   /*   ...##....   */
    0x018d,   /*   ##...##.#   */
},
{
    0x0155,   /*   #.#.#.#.#   */
    0x0000,   /*   .........   */
    0x0027,   /*   ...#..###   */
    0x0031,   /*   ...##...#   */
    0x0129,   /*   #..#.#..#   */
    0x0118,   /*   #...##...   */
    0x01c8,   /*   ###..#...   */
    0x0000,   /*   .........   */
    0x0155,   /*   #.#.#.#.#   */
},
{
    0x0033,   /*   ...##..##   */
    0x0199,   /*   ##..##..#   */
    0x0000,   /*   .........   */
    0x008a,   /*   .#...#.#.   */
    0x00c6,   /*   .##...##.   */
    0x00a2,   /*   .#.#...#.   */
    0x0000,   /*   .........   */
    0x0133,   /*   #..##..##   */
    0x0198,   /*   ##..##...   */
},
{
    0x0183,   /*   ##.....##   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0183,   /*   ##.....##   */
},
{
    0x008e,   /*   .#...###.   */
    0x0043,   /*   ..#....##   */
    0x0015,   /*   ....#.#.#   */
    0x0031,   /*   ...##...#   */
    0x0082,   /*   .#.....#.   */
    0x0118,   /*   #...##...   */
    0x0150,   /*   #.#.#....   */
    0x0184,   /*   ##....#..   */
    0x00e2,   /*   .###...#.   */
},
{
    0x00b8,   /*   .#.###...   */
    0x0021,   /*   ...#....#   */
    0x0081,   /*   .#......#   */
    0x0103,   /*   #......##   */
    0x00ee,   /*   .###.###.   */
    0x0181,   /*   ##......#   */
    0x0102,   /*   #......#.   */
    0x0108,   /*   #....#...   */
    0x003a,   /*   ...###.#.   */
},
{
    0x0162,   /*   #.##...#.   */
    0x0034,   /*   ...##.#..   */
    0x0108,   /*   #....#...   */
    0x0103,   /*   #......##   */
    0x0145,   /*   #.#...#.#   */
    0x0181,   /*   ##......#   */
    0x0021,   /*   ...#....#   */
    0x0058,   /*   ..#.##...   */
    0x008d,   /*   .#...##.#   */
},
{
    0x0132,   /*   #..##..#.   */
    0x00c8,   /*   .##..#...   */
    0x0090,   /*   .#..#....   */
    0x005e,   /*   ..#.####.   */
    0x0010,   /*   ....#....   */
    0x00f4,   /*   .####.#..   */
    0x0012,   /*   ....#..#.   */
    0x0026,   /*   ...#..##.   */
    0x0099,   /*   .#..##..#   */
},
{
    0x0031,   /*   ...##...#   */
    0x0107,   /*   #.....###   */
    0x0042,   /*   ..#....#.   */
    0x0031,   /*   ...##...#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0118,   /*   #...##...   */
    0x0084,   /*   .#....#..   */
    0x01c1,   /*   ###.....#   */
    0x0118,   /*   #...##...   */
},
{
    0x0042,   /*   ..#....#.   */
    0x0183,   /*   ##.....##   */
    0x0066,   /*   ..##..##.   */
    0x011a,   /*   #...##.#.   */
    0x0010,   /*   ....#....   */
    0x00b1,   /*   .#.##...#   */
    0x00cc,   /*   .##..##..   */
    0x0183,   /*   ##.....##   */
    0x0084,   /*   .#....#..   */
},
{
    0x00aa,   /*   .#.#.#.#.   */
    0x0028,   /*   ...#.#...   */
    0x0145,   /*   #.#...#.#   */
    0x006c,   /*   ..##.##..   */
    0x0101,   /*   #.......#   */
    0x006c,   /*   ..##.##..   */
    0x0145,   /*   #.#...#.#   */
    0x0028,   /*   ...#.#...   */
    0x00aa,   /*   .#.#.#.#.   */
},
{
    0x0032,   /*   ...##..#.   */
    0x003a,   /*   ...###.#.   */
    0x010c,   /*   #....##..   */
    0x0105,   /*   #.....#.#   */
    0x0028,   /*   ...#.#...   */
    0x0141,   /*   #.#.....#   */
    0x0061,   /*   ..##....#   */
    0x00b8,   /*   .#.###...   */
    0x0098,   /*   .#..##...   */
},
{
    0x0106,   /*   #.....##.   */
    0x00c8,   /*   .##..#...   */
    0x004c,   /*   ..#..##..   */
    0x0112,   /*   #...#..#.   */
    0x00c6,   /*   .##...##.   */
    0x0091,   /*   .#..#...#   */
    0x0064,   /*   ..##..#..   */
    0x0026,   /*   ...#..##.   */
    0x00c1,   /*   .##.....#   */
},
{
    0x0049,   /*   ..#..#..#   */
    0x0110,   /*   #...#....   */
    0x0046,   /*   ..#...##.   */
    0x0131,   /*   #..##...#   */
    0x0129,   /*   #..#.#..#   */
    0x0119,   /*   #...##..#   */
    0x00c4,   /*   .##...#..   */
    0x0011,   /*   ....#...#   */
    0x0124,   /*   #..#..#..   */
},
{
    0x0095,   /*   .#..#.#.#   */
    0x0118,   /*   #...##...   */
    0x0021,   /*   ...#....#   */
    0x003e,   /*   ...#####.   */
    0x0010,   /*   ....#....   */
    0x00f8,   /*   .#####...   */
    0x0108,   /*   #....#...   */
    0x0031,   /*   ...##...#   */
    0x0152,   /*   #.#.#..#.   */
},
{
    0x0009,   /*   .....#..#   */
    0x014c,   /*   #.#..##..   */
    0x0083,   /*   .#.....##   */
    0x0051,   /*   ..#.#...#   */
    0x0028,   /*   ...#.#...   */
    0x0114,   /*   #...#.#..   */
    0x0182,   /*   ##.....#.   */
    0x0065,   /*   ..##..#.#   */
    0x0120,   /*   #..#.....   */
},
{
    0x0014,   /*   ....#.#..   */
    0x008b,   /*   .#...#.##   */
    0x0110,   /*   #...#....   */
    0x004b,   /*   ..#..#.##   */
    0x0101,   /*   #.......#   */
    0x01a4,   /*   ##.#..#..   */
    0x0011,   /*   ....#...#   */
    0x01a2,   /*   ##.#...#.   */
    0x0050,   /*   ..#.#....   */
},
{
    0x0114,   /*   #...#.#..   */
    0x010d,   /*   #....##.#   */
    0x0024,   /*   ...#..#..   */
    0x006d,   /*   ..##.##.#   */
    0x0000,   /*   .........   */
    0x016c,   /*   #.##.##..   */
    0x0048,   /*   ..#..#...   */
    0x0161,   /*   #.##....#   */
    0x0051,   /*   ..#.#...#   */
},
{
    0x0092,   /*   .#..#..#.   */
    0x002a,   /*   ...#.#.#.   */
    0x0013,   /*   ....#..##   */
    0x010e,   /*   #....###.   */
    0x00aa,   /*   .#.#.#.#.   */
    0x00e1,   /*   .###....#   */
    0x0190,   /*   ##..#....   */
    0x00a8,   /*   .#.#.#...   */
    0x0092,   /*   .#..#..#.   */
},
{
    0x00d1,   /*   .##.#...#   */
    0x0084,   /*   .#....#..   */
    0x0158,   /*   #.#.##...   */
    0x0064,   /*   ..##..#..   */
    0x0028,   /*   ...#.#...   */
    0x004c,   /*   ..#..##..   */
    0x0035,   /*   ...##.#.#   */
    0x0042,   /*   ..#....#.   */
    0x0116,   /*   #...#.##.   */
},
{
    0x000b,   /*   .....#.##   */
    0x0180,   /*   ##.......   */
    0x000d,   /*   .....##.#   */
    0x019a,   /*   ##..##.#.   */
    0x0082,   /*   .#.....#.   */
    0x00b3,   /*   .#.##..##   */
    0x0160,   /*   #.##.....   */
    0x0003,   /*   .......##   */
    0x01a0,   /*   ##.#.....   */
},
{
    0x00a6,   /*   .#.#..##.   */
    0x0115,   /*   #...#.#.#   */
    0x0110,   /*   #...#....   */
    0x00ca,   /*   .##..#.#.   */
    0x0010,   /*   ....#....   */
    0x00a6,   /*   .#.#..##.   */
    0x0011,   /*   ....#...#   */
    0x0151,   /*   #.#.#...#   */
    0x00ca,   /*   .##..#.#.   */
},
{
    0x0058,   /*   ..#.##...   */
    0x0064,   /*   ..##..#..   */
    0x0023,   /*   ...#...##   */
    0x0065,   /*   ..##..#.#   */
    0x0082,   /*   .#.....#.   */
    0x014c,   /*   #.#..##..   */
    0x0188,   /*   ##...#...   */
    0x004c,   /*   ..#..##..   */
    0x0034,   /*   ...##.#..   */
},
{
    0x0120,   /*   #..#.....   */
    0x00b9,   /*   .#.###..#   */
    0x005a,   /*   ..#.##.#.   */
    0x0108,   /*   #....#...   */
    0x0044,   /*   ..#...#..   */
    0x0021,   /*   ...#....#   */
    0x00b4,   /*   .#.##.#..   */
    0x013a,   /*   #..###.#.   */
    0x0009,   /*   .....#..#   */
},
{
    0x0183,   /*   ##.....##   */
    0x0064,   /*   ..##..#..   */
    0x0128,   /*   #..#.#...   */
    0x0116,   /*   #...#.##.   */
    0x0010,   /*   ....#....   */
    0x00d1,   /*   .##.#...#   */
    0x0029,   /*   ...#.#..#   */
    0x004c,   /*   ..#..##..   */
    0x0183,   /*   ##.....##   */
},
{
    0x006c,   /*   ..##.##..   */
    0x00aa,   /*   .#.#.#.#.   */
    0x0101,   /*   #.......#   */
    0x007c,   /*   ..#####..   */
    0x0000,   /*   .........   */
    0x007c,   /*   ..#####..   */
    0x0101,   /*   #.......#   */
    0x00aa,   /*   .#.#.#.#.   */
    0x006c,   /*   ..##.##..   */
},
{
    0x009a,   /*   .#..##.#.   */
    0x0100,   /*   #........   */
    0x001b,   /*   ....##.##   */
    0x0154,   /*   #.#.#.#..   */
    0x0028,   /*   ...#.#...   */
    0x0055,   /*   ..#.#.#.#   */
    0x01b0,   /*   ##.##....   */
    0x0001,   /*   ........#   */
    0x00b2,   /*   .#.##..#.   */
},
{
    0x0188,   /*   ##...#...   */
    0x0023,   /*   ...#...##   */
    0x0171,   /*   #.###...#   */
    0x00b0,   /*   .#.##....   */
    0x0000,   /*   .........   */
    0x001a,   /*   ....##.#.   */
    0x011d,   /*   #...###.#   */
    0x0188,   /*   ##...#...   */
    0x0023,   /*   ...#...##   */
},
{
    0x011d,   /*   #...###.#   */
    0x0182,   /*   ##.....#.   */
    0x001a,   /*   ....##.#.   */
    0x0084,   /*   .#....#..   */
    0x0028,   /*   ...#.#...   */
    0x0042,   /*   ..#....#.   */
    0x00b0,   /*   .#.##....   */
    0x0083,   /*   .#.....##   */
    0x0171,   /*   #.###...#   */
},
{
    0x0082,   /*   .#.....#.   */
    0x0054,   /*   ..#.#.#..   */
    0x0183,   /*   ##.....##   */
    0x007c,   /*   ..#####..   */
    0x0000,   /*   .........   */
    0x007c,   /*   ..#####..   */
    0x0183,   /*   ##.....##   */
    0x0054,   /*   ..#.#.#..   */
    0x0082,   /*   .#.....#.   */
},
{
    0x0028,   /*   ...#.#...   */
    0x0082,   /*   .#.....#.   */
    0x0145,   /*   #.#...#.#   */
    0x007c,   /*   ..#####..   */
    0x0101,   /*   #.......#   */
    0x007c,   /*   ..#####..   */
    0x0145,   /*   #.#...#.#   */
    0x0082,   /*   .#.....#.   */
    0x0028,   /*   ...#.#...   */
},
{
    0x0044,   /*   ..#...#..   */
    0x000b,   /*   .....#.##   */
    0x01b0,   /*   ##.##....   */
    0x0003,   /*   .......##   */
    0x01c7,   /*   ###...###   */
    0x0180,   /*   ##.......   */
    0x001b,   /*   ....##.##   */
    0x01a0,   /*   ##.#.....   */
    0x0044,   /*   ..#...#..   */
},
{
    0x0116,   /*   #...#.##.   */
    0x00b4,   /*   .#.##.#..   */
    0x0008,   /*   .....#...   */
    0x00c5,   /*   .##...#.#   */
    0x0101,   /*   #.......#   */
    0x0146,   /*   #.#...##.   */
    0x0020,   /*   ...#.....   */
    0x005a,   /*   ..#.##.#.   */
    0x00d1,   /*   .##.#...#   */
},
{
    0x0081,   /*   .#......#   */
    0x0039,   /*   ...###..#   */
    0x010e,   /*   #....###.   */
    0x0088,   /*   .#...#...   */
    0x0044,   /*   ..#...#..   */
    0x0022,   /*   ...#...#.   */
    0x00e1,   /*   .###....#   */
    0x0138,   /*   #..###...   */
    0x0102,   /*   #......#.   */
},
{
    0x0014,   /*   ....#.#..   */
    0x0182,   /*   ##.....#.   */
    0x00e4,   /*   .###..#..   */
    0x0066,   /*   ..##..##.   */
    0x0028,   /*   ...#.#...   */
    0x00cc,   /*   .##..##..   */
    0x004e,   /*   ..#..###.   */
    0x0083,   /*   .#.....##   */
    0x0050,   /*   ..#.#....   */
},
{
    0x00a1,   /*   .#.#....#   */
    0x0023,   /*   ...#...##   */
    0x01a0,   /*   ##.#.....   */
    0x00b5,   /*   .#.##.#.#   */
    0x0000,   /*   .........   */
    0x015a,   /*   #.#.##.#.   */
    0x000b,   /*   .....#.##   */
    0x0188,   /*   ##...#...   */
    0x010a,   /*   #....#.#.   */
},
{
    0x0159,   /*   #.#.##..#   */
    0x00a1,   /*   .#.#....#   */
    0x00a2,   /*   .#.#...#.   */
    0x0102,   /*   #......#.   */
    0x006c,   /*   ..##.##..   */
    0x0081,   /*   .#......#   */
    0x008a,   /*   .#...#.#.   */
    0x010a,   /*   #....#.#.   */
    0x0134,   /*   #..##.#..   */
},
{
    0x008b,   /*   .#...#.##   */
    0x004c,   /*   ..#..##..   */
    0x0001,   /*   ........#   */
    0x01a4,   /*   ##.#..#..   */
    0x0129,   /*   #..#.#..#   */
    0x004b,   /*   ..#..#.##   */
    0x0100,   /*   #........   */
    0x0064,   /*   ..##..#..   */
    0x01a2,   /*   ##.#...#.   */
},
{
    0x0028,   /*   ...#.#...   */
    0x00ee,   /*   .###.###.   */
    0x00c6,   /*   .##...##.   */
    0x0028,   /*   ...#.#...   */
    0x0101,   /*   #.......#   */
    0x0028,   /*   ...#.#...   */
    0x00c6,   /*   .##...##.   */
    0x00ee,   /*   .###.###.   */
    0x0028,   /*   ...#.#...   */
},
{
    0x0159,   /*   #.#.##..#   */
    0x005c,   /*   ..#.###..   */
    0x0000,   /*   .........   */
    0x0052,   /*   ..#.#..#.   */
    0x0145,   /*   #.#...#.#   */
    0x0094,   /*   .#..#.#..   */
    0x0000,   /*   .........   */
    0x0074,   /*   ..###.#..   */
    0x0135,   /*   #..##.#.#   */
},
{
    0x0130,   /*   #..##....   */
    0x0116,   /*   #...#.##.   */
    0x0088,   /*   .#...#...   */
    0x0107,   /*   #.....###   */
    0x0028,   /*   ...#.#...   */
    0x01c1,   /*   ###.....#   */
    0x0022,   /*   ...#...#.   */
    0x00d1,   /*   .##.#...#   */
    0x0019,   /*   ....##..#   */
},
{
    0x0102,   /*   #......#.   */
    0x012c,   /*   #..#.##..   */
    0x000b,   /*   .....#.##   */
    0x01c8,   /*   ###..#...   */
    0x0044,   /*   ..#...#..   */
    0x0027,   /*   ...#..###   */
    0x01a0,   /*   ##.#.....   */
    0x0069,   /*   ..##.#..#   */
    0x0081,   /*   .#......#   */
}
};
