// *************************************************************************************************
//
// QPropertyEditor v 0.1
//
// --------------------------------------
// Copyright (C) 2007 Volker Wiendl
//
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
//
// *************************************************************************************************
#ifndef QPROPERTYMODEL_H_
#define QPROPERTYMODEL_H_

#include <Qt/qabstractitemmodel.h>
#include <Qt/qmap.h>

#include "QPropertyEditorWidget.h"

class Property;

/**
 * The QPropertyModel handles the user defined properties of QObjects
 */
class QPropertyModel : public QAbstractItemModel {
    Q_OBJECT
public:
    /**
     * Constructor
     * @param parent optional parent object
     */
    QPropertyModel(QObject* parent = 0);
    /// Destructor
    virtual ~QPropertyModel();

    /// QAbstractItemModel implementation
    QModelIndex index ( int row, int column, const QModelIndex & parent = QModelIndex() ) const;

    /// QAbstractItemModel implementation
    QModelIndex parent ( const QModelIndex & index ) const;
    /// QAbstractItemModel implementation
    int rowCount ( const QModelIndex & parent = QModelIndex() ) const;
    /// QAbstractItemModel implementation
    int columnCount ( const QModelIndex & parent = QModelIndex() ) const;
    /// QAbstractItemModel implementation
    QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;

    /// QAbstractItemModel implementation
    bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
    /// QAbstractItemModel implementation
    Qt::ItemFlags flags ( const QModelIndex & index ) const;

    /// QAbstractItemModel implementation
    QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;

    /// QAbstractItemModel implementation
    QModelIndex buddy ( const QModelIndex & index ) const;

    /**
     * Adds the user properties of the given class to the QPropertyModel instance
     * 
     * @param propertyObject the class inherited from QObject that contains user properties that should be 
     *        managed by this instance
     */
    void addItem(QObject* propertyObject);

    /**
     * Creates a dataChanged signal for the given object
     * @param propertyObject the instance of a QObject based class that should be updated 
     * @param parent optional model index the propertyObject is child of
     */
    void updateItem ( QObject* propertyObject, const QModelIndex& parent = QModelIndex() ) ;

    /**
     * Removes all objects from the model
     */
    void clear();

    /**
     * Sets custom callback that will be used to create Property instances for custom datatypes
     */
    void setCustomPropertyCB(QPropertyEditorWidget::UserTypeCB callback);

private:

    /// The Root Property for all objects
    Property*       m_rootItem;

    /// Custom callback
    QPropertyEditorWidget::UserTypeCB m_userCallback;

};
#endif
