/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include "ringtone.h"

gboolean
pcr_ringtone_equal (const gchar *ringtone1,
                    const gchar *ringtone2)
{
    return g_strcmp0 (ringtone1, ringtone2) == 0;
}

gboolean
pcr_ringtone_is_default (const gchar *ringtone)
{
    return pcr_ringtone_equal (ringtone, PCR_RINGTONE_DEFAULT);
}

gboolean
pcr_ringtone_is_silent (const gchar *ringtone)
{
    return pcr_ringtone_equal (ringtone, PCR_RINGTONE_SILENT);
}
