/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __PCR_CONTACT_H__
#define __PCR_CONTACT_H__

#include <libosso-abook/osso-abook.h>


G_BEGIN_DECLS

typedef void (*PCRContactUpdatedCallback) (OssoABookContact *,
                                           EBookStatus,
                                           gpointer);

const gchar *   pcr_contact_get_custom_ringtone     (OssoABookContact          *contact);

void            pcr_contact_set_custom_ringtone     (OssoABookContact          *contact,
                                                     const gchar               *new_ringtone,
                                                     PCRContactUpdatedCallback  cb,
                                                     gpointer                   user_data);

G_END_DECLS

#endif
