/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef RINGTONED_IS_COMPILING_LIB
#error "Don't include this file directly, use libringtoned/ringtoned.h instead"
#endif


#ifndef __RINGTONED_PROFILE_H__
#define __RINGTONED_PROFILE_H__

#include <glib-object.h>


G_BEGIN_DECLS
 
void            ringtoned_profile_init                  (void);

const gchar *   ringtoned_profile_get_default_ringtone  (void);
gboolean        ringtoned_profile_is_default_ringtone   (const gchar *path);
const gchar *   ringtoned_profile_get_playable_path     (const gchar *path);

G_END_DECLS

#endif /* __RINGTONED_PROFILE_H__ */
