/*************************************************************************}
{ qwidgethelper.h - some convenience widget functions                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 04 Sep 2012                                              }
{*************************************************************************/

#ifndef QWIDGETHELPER_H
#define QWIDGETHELPER_H

#include <QtCore>
#include <QtGui>

enum ScreenOrientation {
    ScreenOrientationLockPortrait,
    ScreenOrientationLockLandscape,
    ScreenOrientationAuto
};

class QWidgetHelper
{
public:
    inline void setupDefaults(){setupDefaults((QWidget*)this);}
    inline void fullyActivate(){fullyActivate((QWidget*)this);}
    inline void setScreenOrientation(ScreenOrientation orientation){setScreenOrientation((QWidget*)this, orientation);}
    inline void showExpanded(){showExpanded((QWidget*)this);}

    static void setupDefaults(QWidget* widget);
    static void fullyActivate(QWidget* widget);
    static void setScreenOrientation(QWidget* widget, ScreenOrientation orientation);
    static void showExpanded(QWidget* widget);

    static bool simpleResize(QResizeEvent* event, int &width, int &height);
    static bool maximizedAutoResize(QWidget* widget, QResizeEvent* event);
};

#endif // QWIDGETHELPER_H
