/*************************************************************************}
{ alkatraz.h - common functions                                           }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 16 Nov 2012                                              }
{*************************************************************************/

#ifndef ALKATRAZ_H
#define ALKATRAZ_H

#include <QtCore>
#ifdef QT_GUI_LIB
    #include <QtGui>
#endif
#include <stdlib.h>

#ifdef Q_OS_SYMBIAN
    #include <e32const.h>
#endif

#define __SETERROR_NODATA(err) {lastError = err; emit onError(this, __FILE__, __LINE__, err, NULL);}
#define __SETERROR_DATA(err, data) {lastError = err; emit onError(this, __FILE__, __LINE__, err, data);}
#define __SETERROR_CHOOSER(__ARG1, __ARG2, __F, ...) __F
#define SETERROR(...) __SETERROR_CHOOSER(__VA_ARGS__, __SETERROR_DATA(__VA_ARGS__), __SETERROR_NODATA(__VA_ARGS__))

#define CHECK(s, err, data...) if(!(s)) {SETERROR(err, ## data); return false;}
#define CHECKV(s, err, data...) if(!(s)) {SETERROR(err, ## data); return;}
#define CHECKB(s, err, data...) if(!(s)) {SETERROR(err, ## data); break;}
#define CHECKN(s, err, data...) if(!(s)) {SETERROR(err, ## data); return -1;}
#define TRY(s, err, data...) try {s;} catch(...){SETERROR(err, ## data); return false;}
#define TRYV(s, err, data...) try {s;} catch(...){SETERROR(err, ## data); return;}
#define TRYB(s, err, data...) try {s;} catch(...){SETERROR(err, ## data); break;}
#define TRYN(s, err, data...) try {s;} catch(...){SETERROR(err, ## data); return -1;}
#define CHECKTRY(s, err, data...) try {CHECK(s, err, ## data);} catch(...) {SETERROR(err, ## data); return false;}
#define CHECKVTRY(s, err, data...) try {CHECKV(s, err, ## data);} catch(...) {SETERROR(err, ## data); return;}
#define CHECKBTRY(s, err, data...) try {CHECKB(s, err, ## data);} catch(...) {SETERROR(err, ## data); break;}
#define CHECKNTRY(s, err, data...) try {CHECKN(s, err, ## data);} catch(...) {SETERROR(err, ## data); return -1;}

#define CONNECT(sender,definition) connect(sender,SIGNAL(definition),SLOT(definition))

#define err_NoError -1

#ifdef Q_OS_SYMBIAN
        const int MAX_PATH_LENGTH = KMaxPath;
#else
    #ifdef Q_OS_WIN
        const int MAX_PATH_LENGTH = MAX_PATH;
    #else
        const int MAX_PATH_LENGTH = 255; // stub for others
    #endif
#endif

class ErrorHandler
{
protected:
    int lastError;

public:
    explicit ErrorHandler(){resetLastError();}
    inline int getLastError() const {return lastError;}
    inline void resetLastError(){lastError=err_NoError;}

    static QString errorCodeToString(int errorCode);
    static QString errorDataToString(int errorCode, const void* data);
    static QString errorToString(int errorCode, const void* data);
};

void randomize();
inline int rnd(quint32 limit){return qrand()%limit;}
QString md5(const QString& s);
QString randomHash();

inline int sgn(qint32 val)
{
    if(val>0)return 1;
    if(val==0)return 0;
    return -1;
}

void sleep(int msecs);
void* safeRealloc(void* mem, qint32 size);

#ifdef QT_GUI_LIB
QStringList wordwrap(const QString& text, int maxWidth, const QFontMetrics& fontMetrics);
#endif

inline QString getParentDir(const QString &path)
{
    return (QFileInfo(path)).absoluteDir().absolutePath();
}

#endif // ALKATRAZ_H
