/*************************************************************************}
{ alkatraz.cpp - common functions                                         }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 23 Oct 2012                                              }
{*************************************************************************/

#include "alkatraz.h"

void randomize()
{
    QTime c = QDateTime::currentDateTimeUtc().time();
    int seed = c.msec()+c.second()*1000+c.minute()*1000*60+c.hour()*60*60*1000;
    qsrand(seed);
}

QString md5(const QString& s)
{
    QByteArray b = s.toUtf8();
    b = QCryptographicHash::hash(b, QCryptographicHash::Md5);
    b = b.toHex();
    return QString::fromAscii(b.constData());
}

QString randomHash()
{
    return md5(QString::number(qrand())+QString::number(QDateTime::currentMSecsSinceEpoch()));
}

void sleep(int msecs)
{
    QEventLoop eventLoop;
    QTimer::singleShot(msecs, &eventLoop, SLOT(quit()));
    eventLoop.exec();
}

void* safeRealloc(void* mem, qint32 size)
{
    if(mem)
    {
        try{
            return realloc(mem, size);
        }catch(...){
            return NULL;
        }
    }
    else
    {
        try{
            return malloc(size);
        }catch(...){
            return NULL;
        }
    }
}

QString ErrorHandler::errorCodeToString(int errorCode)
{
    if(errorCode == err_NoError)
        return "No Error";
    else
        return "";
}

QString ErrorHandler::errorDataToString(int errorCode, const void *data)
{
    Q_UNUSED(errorCode);
    Q_UNUSED(data);
    return "";
}

QString ErrorHandler::errorToString(int errorCode, const void *data)
{
    QString errString = errorCodeToString(errorCode);
    if(errString.isEmpty())
        return errString;
    QString dataString = errorDataToString(errorCode, data);
    if(dataString.isEmpty())
        return errString;
    else
        return errString+": "+dataString;
}

#ifdef QT_GUI_LIB
QStringList wordwrap(const QString& text, int maxWidth, const QFontMetrics &fontMetrics)
{
    QStringList words = text.split(" ");
    QStringList lines;
    QString line;
    QString tmpLine;
    QString wordSpaced;
    foreach(QString word, words)
    {
        wordSpaced = word + " ";
        tmpLine = line + wordSpaced;
        if(fontMetrics.width(tmpLine) > maxWidth)
        {
            line.chop(1);
            lines.append(line);
            line = wordSpaced;
        }
        else
        {
            line = tmpLine;
        }
    }
    line.chop(1);
    if(!line.isEmpty())
        lines.append(line);
    return lines;
}
#endif
