/*************************************************************************}
{ commondialog.cpp -dialog template                                       }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 06 Jun 2012                                              }
{*************************************************************************/

#include "commondialog.h"
#include "mainwindow.h"

int CommonDialog::showDialog(ScreenOrientation forceScreenOrientation)
{
    resize(MAINWINDOW->size());

#ifdef MAEMO5
    // prevent screen rotation while displaying the dialog,
    // but only if the dialog was not called from another dialog
    bool doOrientationChange = !qobject_cast<QDialog*>(parent());
    if(doOrientationChange)
    {
        if(forceScreenOrientation == ScreenOrientationAuto)
        {
            if(width() > height())
                MAINWINDOW->setScreenOrientation(ScreenOrientationLockLandscape);
            else
                MAINWINDOW->setScreenOrientation(ScreenOrientationLockPortrait);
        }
        else
        {
            MAINWINDOW->setScreenOrientation(forceScreenOrientation);
        }
    }
#endif

    int result = exec();

#ifdef MAEMO5
    // restore screen orientation from settings, if needed
    if(doOrientationChange)
        MAINWINDOW->updateScreenOrientation();
#endif

    return result;
}
