/*************************************************************************}
{ searchwindow.h - search window                                          }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 28 May 2012                                              }
{*************************************************************************/

#ifndef SEARCHWINDOW_H
#define SEARCHWINDOW_H

#include "containerdialog.h"

class SearchWindow : public ContainerDialog
{
    Q_OBJECT

public:
    explicit SearchWindow(QWidget *parent = 0);
    ~SearchWindow();

    static void showSearchWindow(const QString &txt);

protected:
    FSMan* fs;

    QPushButton* btnGo;
    QLineEdit* editExp;
    QLabel* lblNotFound;
    bool isRealSearch;
    int lastCursorPos;
    bool skipEnterPress;

    void initGui();
    void deinitGui();
    void reposition(const QSize &sz, int rows);
    void setFocusToEdit(int cursorPos = -1);

    void keyPressEvent(QKeyEvent *event);
    
protected slots:
    void onSearchResult(bool isDir, const QString& basename, const QString& parentDir);
    void onSearchFinished();
    void onItemClick(QWidget* item);
    void onItemUp(QWidget* item, bool isClicked);
    void onContextMenuShow(QWidget* item, QContextMenuEvent *event);
    void onBtnGoClick();
    void onDeselect();
    void onReturnPressed();
};

#endif // SEARCHWINDOW_H
