/*************************************************************************}
{ mainwindow.h - main window with a folder view                           }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 19 May 2012                                              }
{*************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "kineticlistitem.h"
#include "includes.h"
#include "optionswindow.h"
#include "typeswindow.h"
#include "equalizerwindow.h"
#include "timerwindow.h"
#include "aboutwindow.h"
#include "searchwindow.h"
#include "phononplayer.h"
#include "button.h"

class MainWindow : public QMainWindow, public QWidgetHelper
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    inline const Skin& getSkin() const {return *skin;}
    inline QSettings* getIniSettings() const {return iniSettings;}
    inline PhononPlayer* getPlayer() const {return player;}
    inline FSMan* getFSMan() const {return fs;}

    inline static MainWindow* getInstance() {return instance;}
    inline OptionsWindow* getOptionsWindow(){return optionsWindow;}
    inline const QString& getAppDir() const {return appDir;}
    void updateScreenOrientation();
    void showNotification(const QString& text);
    void changeSkin(const QString& skinName);

protected:
    void initGUI();
    void initLocations();
    void initPlayer();
    void initFSMan();
    QString getLocation(QDesktopServices::StandardLocation loc);
    void deinitGUI();
    void updateNameFilters(const QStringList& extsList);
    void reposition(const QSize &sz);
    bool cd(const QString& dir);
    void buildList();
    void updateListIcons(bool playMode = false);
    void play(const QString& filename, bool doCloseCurrent = true);
    void playIndex(int index, bool doCloseCurrent = true);
    void stop();
    void shuffle();
    void straighten();
    void saveY();
    void restoreY();
    void openInis();
    void openIni(QSettings *&ini, const QString& filename);
    void closeInis();
    void loadGUI();
    void addFromDir(const QString& dirname);
    bool passFile(const QString& filename);
    bool passDir(const QString& dirname, const QString &fullDirName);
    void updateEqualizerActionLabel();
    bool runNext(bool doCloseCurrent = true);
    bool runPrev();
    void showStopNotification();
    void cancelResumeCheck();
    void killTheTimer();
    void endTimer();
    void cacheNext();
    void showStopTimerNotification();
    void stopByTimer();
    void updateTimerActionLabel();
    void updateCurrentFileIndex();
    void savePlaylist();
    void loadPlaylist(const QString& autoPlayFile = QString());
    QString getCurrentFilename() const;

    void resizeEvent(QResizeEvent *event);
    void timerEvent(QTimerEvent *event);
    void keyPressEvent(QKeyEvent *event);

    OptionsWindow* optionsWindow;

    QKineticWidget* itemsContainer;
    QLabel* labelDir;
    KineticListItem* currentFileItem;
    KineticListItem* currentDirItem;

    Button *btnPrev, *btnStop, *btnPlay, *btnNext, *btnParent;
    Skin* skin;
    QAction* actionEqualizer;
    QAction* actionTimer;

    QStringList nameFilters;
    QStringList playlist;
    QStringList straightPlaylist;
    int currentFileIndex;
    QString currentFileDir;
    QHash<QString, int> yCache;
    QString settingsDir;
    bool isMovingBackwards;
    int errCount;
    bool checkResumeOnPlugin;
    bool checkResumeOnHangup;
    QString currentPreset;
    QString appDir;
    QStringList queue;
    KineticListItem* contextMenuOwner;

    int timerId;
    int timerMinsLeft;

    QMenu *menuFolder, *menuFile;
    KineticListItem* currentContextItem;

    PhononPlayer* player;
    FSMan* fs;
    QSettings *iniState, *iniSettings;

    QString locDesktop, locDocuments, locMusic, locMovies, locPictures, locHome;

    QFontMetrics* notificationMetrics;

public slots:
    void onItemClick(QWidget* item);
    void onContextMenuShow(QWidget* item, QContextMenuEvent *event);

protected slots:
    void checkTimerCancel();
    void onBtnPrevClick();
    void onBtnStopClick();
    void onBtnPlayClick();
    void onBtnNextClick();
    void onBtnParentClick();

    void onPlayEnd();
    void onError();
    void onStateChanged();
    void onTitleChange();

    void onMenuClearClick();
    void onMenuCurrentClick();
    void onMenuTypesClick();
    void onMenuOptionsClick();
    void onMenuEqualizerClick();
    void onMenuTimerClick();
    void onMenuShuffleClick();
    void onMenuAboutClick();
    void onMenuFolderAllClick();
    void onMenuFolderAllAddClick();
    void onMenuFileSetNextClick();
    void onMenuFileAddQueueClick();

    void onHeadsetStatusChange(bool isConnected);
    void onCallStart();
    void onCallEnd();

    void onFileFilter(bool *pass, const QString& basename, const QString& parentDir);
    void onDirFilter(bool *pass, const QString& basename, const QString& parentDir);

    void jumpToCurrentItem();
    void doCacheNext();

signals:
    void onResize(const QSize& sz);

private:
    static MainWindow* instance;
};

#endif // MAINWINDOW_H
