/*************************************************************************}
{ button.cpp - graphical button                                           }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 26 May 2012                                              }
{*************************************************************************/

#include "button.h"
#include "mainwindow.h"

Button::Button(QWidget *parent) :
    QCommandLinkButton(parent)
{
    connect(this, SIGNAL(pressed()), SLOT(onBtnDown()));
    connect(this, SIGNAL(released()), SLOT(onBtnUp()));
    QSize sz(CONTROLBUTTON_SIZE, CONTROLBUTTON_SIZE);
    setIconSize(sz);
    resize(CONTROLBUTTON_SIZE + CONTROLBUTTON_PADDING*2, CONTROLBUTTON_SIZE + CONTROLBUTTON_PADDING*2);
    setFocusPolicy(Qt::NoFocus);
}

void Button::onBtnDown()
{
    move(x(), y() + CONTROLBUTTON_PUSHOFFSET);
}

void Button::onBtnUp()
{
    move(x(), y() - CONTROLBUTTON_PUSHOFFSET);
}
