###########################################################################
# rhapsodie.pro - main project file                                       #
#                                                                         #
# This file is a part of the project                                      #
#   Rhapsodie - Music player for N900                                     #
#                                                                         #
# (c) Alkatraz Studio, 2012                                               #
#                                                                         #
# author: Parfenov Alexey a.k.a. ZXED                                     #
# author's e-mail: zxed@alkatrazstudio.net                                #
# official project site: http://rhapsodie.garage.maemo.org/               #
#                                                                         #
# This program is free software; you can redistribute it and/or           #
# modify it under the terms of the GNU General Public License             #
# as published by the Free Software Foundation; either version 3 of       #
# the License, or (at your option) any later version.                     #
#                                                                         #
# This program is distributed in the hope that it will be useful,         #
# but WITHOUT ANY WARRANTY; without even the implied warranty of          #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        #
# General Public License for more details.                                #
#                                                                         #
# You may read GNU General Public License at:                             #
#   http://www.gnu.org/copyleft/gpl.html                                  #
#                                                                         #
# project started: 09 Feb 2012                                            #
# project version: 0.3                                                    #
# project last modified: 28 May 2012                                      #
#                                                                         #
# last modified: 19 May 2012                                              #
###########################################################################

TARGET=rhapsodie
QT += phonon dbus

INCLUDEPATH = src

SOURCES += \
    src/main.cpp \
    src/mainwindow.cpp \
    src/phononplayer.cpp \
    src/phononsound.cpp \
    src/kineticlistitem.cpp \
    src/app.cpp \
    src/typeswindow.cpp \
    src/optionswindow.cpp \
    src/optionitem.cpp \
    src/selectwindow.cpp \
    src/containerdialog.cpp \
    src/equalizer.cpp \
    src/commondialog.cpp \
    src/equalizerwindow.cpp \
    src/searchwindow.cpp \
    src/button.cpp \
    src/aboutwindow.cpp \
    src/skin.cpp \
    src/timerwindow.cpp \
    src/spinnumber.cpp \
    src/../inc/alkatraz.cpp \
    src/../inc/qiodevicehelper.cpp \
    src/../inc/fsman.cpp \
    src/../inc/controls/qkineticwidget.cpp \
    src/../inc/qwidgethelper.cpp \
    src/../inc/stringhash.cpp

HEADERS += \
    src/mainwindow.h \
    src/phononplayer.h \
    src/phononsound.h \
    src/kineticlistitem.h \
    src/app.h \
    src/includes.h \
    src/typeswindow.h \
    src/skin.h \
    src/optionswindow.h \
    src/optionitem.h \
    src/selectwindow.h \
    src/containerdialog.h \
    src/equalizer.h \
    src/commondialog.h \
    src/equalizerwindow.h \
    src/searchwindow.h \
    src/button.h \
    src/aboutwindow.h \
    src/timerwindow.h \
    src/spinnumber.h \
    src/../inc/alkatraz.h \
    src/../inc/qiodevicehelper.h \
    src/../inc/fsman.h \
    src/../inc/controls/qkineticwidget.h \
    src/../inc/qwidgethelper.h \
    src/../inc/stringhash.h

include(deployment.pri)
qtcAddDeployment()

TRANSLATIONS = translations/rhapsodie_ru.ts

maemo5 {
    DEFINES += MAEMO5

    DESTDIR = ./bin/

    i_tr.path = /opt/rhapsodie/translations
    i_tr.files = translations/rhapsodie_ru.qm
    INSTALLS += i_tr
    i_skins.path = /opt/rhapsodie
    i_skins.files = skins
    INSTALLS += i_skins
    i_data.path = /opt/rhapsodie
    i_data.files = data
    INSTALLS += i_data
    i_html.path = /opt/rhapsodie
    i_html.files = html
    INSTALLS += i_html
}

VERSION=0.3

DEFINES += \
    APP_VERSION=\\\"$$VERSION\\\" \
    APP_NAME=\\\"$$TARGET\\\" \
    APP_TITLE=\\\"Rhapsodie\\\"
