/*************************************************************************}
{ containerdialog.cpp - dialog with a kinetic scroller                    }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 19 May 2012                                              }
{*************************************************************************/

#include "containerdialog.h"
#include "mainwindow.h"
#include "optionswindow.h"

void ContainerDialog::initGui()
{
    CommonDialog::initGui();

    itemsContainer = new QKineticWidget(this);
    itemsContainer->setMoveByX(false);
    itemsContainer->setBackSpeedX(50);
    itemsContainer->setThresholdY(10);
    itemsContainer->move(0, 0);

    connect(itemsContainer, SIGNAL(onItemClick(QWidget*)), SLOT(onItemClick(QWidget*)));
    connect(itemsContainer,
            SIGNAL(onContextMenu(QWidget*,QContextMenuEvent*)),
            SLOT(onContextMenuShow(QWidget*,QContextMenuEvent*)));

    MAINWINDOW->getSkin().initKineticWidget(itemsContainer);
}

void ContainerDialog::deinitGui()
{
    itemsContainer->deleteAllChildren();
    delete itemsContainer;

    CommonDialog::deinitGui();
}

int ContainerDialog::showDialog()
{
    MAINWINDOW->getSkin().initKineticWidget(itemsContainer);

    int result = CommonDialog::showDialog();

    itemsContainer->setY(0);

    return result;
}

void ContainerDialog::reposition(const QSize &sz, int rows)
{
    itemsContainer->resize(sz);
    itemsContainer->repositionChildrenV(ITEM_HEIGHT, rows);
}
