/*************************************************************************}
{ containerdialog.h - dialog with a kinetic scroller                      }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef CONTAINERDIALOG_H
#define CONTAINERDIALOG_H

#include "includes.h"
#include "commondialog.h"

class ContainerDialog : public CommonDialog
{
    Q_OBJECT

public:
    explicit ContainerDialog(QWidget *parent = 0):CommonDialog(parent){}
    
protected:
    virtual void initGui();
    virtual void deinitGui();
    virtual int showDialog();

    virtual void reposition(const QSize& sz, int rows = 1);
    virtual void resizeEvent(QResizeEvent *event){reposition(event->size(), 1);}

    QKineticWidget* itemsContainer;

protected slots:
    virtual void onItemClick(QWidget* item){Q_UNUSED(item);}
};

#endif // CONTAINERDIALOG_H
