/*************************************************************************}
{ spinnumber.h - number display with inc/dec buttons                      }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef SPINNUMBER_H
#define SPINNUMBER_H

#include "includes.h"
#include "button.h"

class SpinNumber : public QWidget
{
    Q_OBJECT

public:
    explicit SpinNumber(QWidget *parent = 0);
    ~SpinNumber();
    inline int getValue() const {return value;}
    int setValue(int newValue);
    inline int getMinValue() const {return minValue;}
    inline int getMaxValue() const {return maxValue;}
    inline void setMinValue(int newValue){minValue = newValue;}
    inline void setMaxValue(int newValue){maxValue = newValue;}
    inline int getStep() const {return step;}
    inline void setStep(int newStep){step = newStep;}
    inline bool isCycled(){return cycled;}
    inline void setCycled(bool doCycled){cycled = doCycled;}
    
protected:
    void resizeEvent(QResizeEvent *event);
    void updateDisplay();
    void cycleValue(int valueStep);

    Button* btnUp;
    Button* btnDown;
    QLabel* label;

    int value;
    int minValue, maxValue;
    bool cycled;
    int step;

protected slots:
    void onBtnUpClick();
    void onBtnDownClick();
};

#endif // SPINNUMBER_H
