/*************************************************************************}
{ qkineticwidget.h - QWidget with kinetic scrolling                       }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: AlkatrazStudio@yandex.ru                                        }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 12 Feb 2012                                             }
{*************************************************************************/

#ifndef QKINETICWIDGET_H
#define QKINETICWIDGET_H

#include <QtGui>

#include "../inc/alkatraz.h"

class QKineticWidget : public QWidget
{
    Q_OBJECT
protected:
    QWidget* inner;

    int ix, iy;
    float x, y;
    int mx, my;
    float spdX, spdY;
    float accX, accY;
    float frictionX, frictionY;
    float backFrictionX, backFrictionY;
    float backSpeedX, backSpeedY;
    int thresholdX, thresholdY;
    int offX, offY;
    int minX, minY;
    bool moveByX, moveByY;
    bool isClick;
    bool isDown;
    int timer;
    int timerInterval;
    int innerWidth, innerHeight;
    int stopSteps, stopStepsLeft;
    QString cssNormal, cssActive;
    QWidget* activeWidget;

    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void timerEvent(QTimerEvent *event);
    void resizeEvent(QResizeEvent *event);
    void contextMenuEvent(QContextMenuEvent *event);
    void childEvent(QChildEvent *event);

    QWidget* getChildAt(int xPos, int yPos);
    void updateConstraintsX();
    void updateConstraintsY();

public:
    explicit QKineticWidget(QWidget *parent = 0);
    ~QKineticWidget();

    void deleteAllChildren();
    void repositionChildrenV(int itemsHeight = -1, int rows = 1);
    void centerWidgetV(const QWidget* widget);

    const QString& getCssNormal(){return cssNormal;}
    const QString& getCssActive(){return cssActive;}
    void setCssNormal(const QString& css);
    void setCssActive(const QString& css);

    bool isMoveByX(){return moveByX;}
    bool isMoveByY(){return moveByY;}
    void setMoveByX(bool canMove){moveByX = canMove;}
    void setMoveByY(bool canMove){moveByY = canMove;}

    float getFrictionX(){return frictionX;}
    float getFrictionY(){return frictionY;}
    void setFrictionX(float value){frictionX = value;}
    void setFrictionY(float value){frictionY = value;}

    int getMinX(){return minX;}
    int getMinY(){return minY;}

    float getBackFrictionX(){return backFrictionX;}
    float getBackFrictionY(){return backFrictionY;}
    void setBackFrictionX(float value){backFrictionX = value;}
    void setBackFrictionY(float value){backFrictionY = value;}

    float getBackSpeedX(){return backSpeedX;}
    float getBackSpeedY(){return backSpeedY;}
    void setBackSpeedX(float value){backSpeedX = value;}
    void setBackSpeedY(float value){backSpeedY = value;}

    int getThresholdX(){return thresholdX;}
    int getThresholdY(){return thresholdY;}
    void setThresholdX(int value){thresholdX = value;}
    void setThresholdY(int value){thresholdY = value;}

    float getX(){return x;}
    float getY(){return y;}
    void setX(float value);
    void setY(float value);

    void setSpeedX(float speed){spdX = speed;}
    void setSpeedY(float speed){spdY = speed;}
    float getSpeedX(){return spdX;}
    float getSpeedY(){return spdY;}

    void scrollX(float offset);
    void scrollY(float offset);

    void setTimerInterval(int msecs);
    int getTimerInterval(){return timerInterval;}

    void setInnerWidth(int value);
    void setInnerHeight(int value);
    int getInnerWidth(){return innerWidth;}
    int getInnerHeight(){return innerHeight;}

    void setStopSteps(int value){stopSteps = value;}
    int setStopSteps(){return stopSteps;}

    QWidget* getActiveWidget(){return activeWidget;}

signals:
    void onItemClick(QWidget* item);
    void onItemDown(QWidget* item);
    void onItemUp(QWidget* item, bool isClicked);
    void onContextMenu(QWidget* item, QContextMenuEvent *event);
};

#endif // QKINETICWIDGET_H
