/*************************************************************************}
{ alkatraz.cpp - common functions                                         }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 11 Dec 2011                                              }
{*************************************************************************/

#include "alkatraz.h"
#include <QEventLoop>
#include <QTimer>

int rnd(int limit)
{
    int result = qrand()/qreal(RAND_MAX)*limit;
    if(result>=limit)
        return limit-1;
    else
        return result;
}

int sgn(int val)
{
    if(val>0)return 1;
    if(val==0)return 0;
    return -1;
}

void sleep(int msecs)
{
    QEventLoop eventLoop;
    QTimer::singleShot(msecs, &eventLoop, SLOT(quit()));
    eventLoop.exec();
}

void* safeRealloc(void* mem, qint32 size)
{
    if(mem)
    {
        try{
            return realloc(mem, size);
        }catch(...){
            return NULL;
        }
    }
    else
    {
        try{
            return malloc(size);
        }catch(...){
            return NULL;
        }
    }
}
