/*************************************************************************}
{ optionswindow.h - options window                                        }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef OPTIONSWINDOW_H
#define OPTIONSWINDOW_H

#include "includes.h"
#include "optionitem.h"
#include "containerdialog.h"

class OptionItem;

typedef enum {
    pmo_playlistOnce = 0,
    pmo_playlistLoop = 1,
    pmo_random = 2,
    pmo_trackOnce = 3,
    pmo_trackLoop = 4
} PlayModeOption;

typedef enum {
    bao_Pause = 0,
    bao_Stop = 1,
    bao_None = 2
} BreakActionOption;

typedef enum {
    soo_Portrait = 0,
    soo_Landscape = 1,
    soo_Auto = 2
} ScreenOrientationOption;

typedef struct {
    bool hideHiddenFolders;
    bool showUserFolders;
    bool hideHiddenFiles;
    bool useFileFilters;
    PlayModeOption playMode;
    BreakActionOption headsetUnplugAction;
    bool resumeOnPlugin;
    BreakActionOption incomingCallAction;
    bool resumeOnHangup;
    bool popupTrackTitles;
    ScreenOrientationOption screenOrientation;
    bool letTrackEnd;
    bool buttonsCancelTimer;
    QString skinName;
} AppOptions;

class OptionsWindow : public ContainerDialog
{
    Q_OBJECT

public:
    explicit OptionsWindow(QWidget *parent = 0);
    ~OptionsWindow();
    int showDialog();
    inline const AppOptions& getOptions(){return options;}

protected:
    void initGui();
    void deinitGui();
    void fillOptions();
    void updateSkin();
    void reposition(const QSize& sz, int rows=1);

    QList<OptionItem*> items;
    bool isChanged;

    OptionItem
        *opt_hideHiddenFolders,
        *opt_showUserFolders,
        *opt_hideHiddenFiles,
        *opt_useFileFilters,
        *opt_playMode,
        *opt_headsetUnplugAction,
        *opt_resumeOnPlugin,
        *opt_incomingCallAction,
        *opt_resumeOnHangup,
        *opt_popupTrackTitles,
        *opt_screenOrientation,
        *opt_letTrackEnd,
        *opt_buttonsCancelTimer,
        *opt_skinName;

    AppOptions options;

protected slots:
    void onItemClick(QWidget *item);
};

#endif // OPTIONSWINDOW_H
