/*************************************************************************}
{ fsman.h - filesystem functions using shell                              }
{                                                                         }
{ (c) Alexey Parfenov, 2011                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This library is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This library is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 11 Dec 2011                                              }
{*************************************************************************/

#ifndef FSMAN_H
#define FSMAN_H

#include <QObject>
#include <QHash>
#include <QDir>

typedef struct {
    QStringList files;
    QStringList dirs;
} FSManCacheRecord;

class FSManCache : public QObject, public QHash<QString, FSManCacheRecord>
{
    Q_OBJECT
public:
    FSManCache():QHash<QString, FSManCacheRecord>(){}
};

class FSMan : public QObject
{
    Q_OBJECT

    QStringList files;
    QStringList dirs;
    FSManCache cache;

    QString curDir;
    QDir dir;

    bool doFetchLists;
    bool doUseCache;
    bool doUseNativeMethods;
    bool doUpOnFail;
    bool doUseCallbackFilters;
    QStringList nameFilters;

    bool _cd();
    void _fetch();
    void _fetchForce();

public:
    explicit FSMan(QObject *parent = 0);

    void clearCache(){cache.clear();}
    bool isListFetch(){return doFetchLists;}
    void setListFetch(bool doFetch){doFetchLists = doFetch;}
    bool isUsingCache(){return doUseCache;}
    void setUsingCache(bool doUse){doUseCache = doUse;}
    bool isUsingCallbackFilters(){return doUseCallbackFilters;}
    void setUsingCallbackFilters(bool doUse){doUseCallbackFilters = doUse;}
    bool isUsingNativeMethods(){return doUseNativeMethods;}
    void setUsingNativeMethods(bool doUse);
    bool isUpOnFail(){return doUpOnFail;}
    void setUpOnFail(bool doUp){doUpOnFail = doUp;}
    const QStringList& getNameFilters(){return nameFilters;}
    void setNameFilters(const QStringList& newNameFilters){nameFilters = newNameFilters;clearCache();}

    const QString& getCurrentDirectory(){return curDir;}
    const QStringList& getCurrentFiles(){return files;}
    const QStringList& getCurrentDirs(){return dirs;}
    void getCurrentFilesFull(QStringList& list);
    void getCurrentDirsFull(QStringList& list);
    bool cd(const QString& dirPath);

    static QString getParentDir(const QString& dirPath);
    static bool isDirAccessible(const QString& dirPath, bool useNativeMethod = false);
    static QString which(const QString& program);
    static void ls(const QString& path, QStringList& dirsList, QStringList& filesList, bool useNativeMethod = false);
    static bool getRawProcessOutput(QByteArray& dest, const QString& cmd, const QStringList& args = QStringList());
    static QString getProcessOutput(const QString& cmd, const QStringList& args);
    static QString getProcessOutput(const QString& cmd);
    static QString getShellCommandOutput(const QString& cmd);
    static QString shellEscape(const QString& line);

signals:
    void onFileFilter(bool *pass, const QString& basename, const QString& parentDir);
    void onDirFilter(bool *pass, const QString& basename, const QString& parentDir);

};

#endif // FSMAN_H
