import sys
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from models import *
from GUI.main_window import *
from GUI.inbox_window import *
from GUI.message_window import *
from GUI.sent_window import *
from csv_service import *
from notification_service import Notifier
#import gtk
"""
#from windows import *


"""

def showInboxMessages():
	#ui.stackedWidget.setCurrentIndex(1)
	inboxWindow.show()

def showSentMessages():
	#ui.stackedWidget.setCurrentIndex(3)
	sentWindow.show()
	
def showMsg():
	#ui.stackedWidget.setCurrentIndex(2)
	msg = msgs.getMsg(inboxWindow.listView.currentIndex().row())
	#print msg.getMsgText()
	inboxMsgWindow.msg_text.setText(msg.getMsgText())
	inboxMsgWindow.msg_address.setText(msg.getSenderName())
	inboxMsgWindow.msg_date.setText(msg.getDate())
	
	#####################################
	
	
	if msg.getImageData() == "":
		inboxMsgWindow.frame.setPixmap(QPixmap("/opt/retroconv/graphics/contact_trans_120.png"))
	else:
	
		arr=QByteArray(msg.getImageData())
		img = QPixmap()
		img.loadFromData(arr)
		
		inboxMsgWindow.frame.setPixmap(img.scaled(120,120, Qt.KeepAspectRatioByExpanding))
		
	inboxMsgWindow.show()


def showSentMsg():
	#ui.stackedWidget.setCurrentIndex(4)
	msg = msgs.getMsg(sentWindow.listView.currentIndex().row(), 1)
	sentMsgWindow.msg_text.setText(msg.getMsgText())
	sentMsgWindow.msg_address.setText(msg.getRecName())
	sentMsgWindow.msg_date.setText(msg.getDate())
	
	#####################################
	
	if msg.getImageData() == "":
		sentMsgWindow.frame.setPixmap(QPixmap("/opt/retroconv/graphics/contact_trans_120.png"))
	else:
		arr=QByteArray(msg.getImageData())
		img = QPixmap()
		img.loadFromData(arr)
		
		sentMsgWindow.frame.setPixmap(img.scaled(120,120, Qt.KeepAspectRatioByExpanding))
	
	sentMsgWindow.show()
	
def populateInbox():
	#allSenders=msgs.getAllSenders()
	#for x in allSenders:
	
	recvModel=RecvModel(msgs.recvLst)
	inboxWindow.listView.setModel(recvModel)
		
def populateSent():
	#allSenders=msgs.getAllSenders()
	#for x in allSenders:
	
	sentModel=SentModel(msgs.sentLst)
	sentWindow.listView.setModel(sentModel)
	
	#for x in msgs.sentLst:
		#print x.getRecName()
	
msgs=csvServ()
notifier = Notifier()

def init():
	################## Connect SIGNALS #######################
	
	QObject.connect(mainWindow.inbox_button, SIGNAL("clicked()"), showInboxMessages)
	QObject.connect(mainWindow.sent_button, SIGNAL("clicked()"),showSentMessages)
	QObject.connect(inboxWindow.listView, SIGNAL("clicked(QModelIndex)"),showMsg)
	QObject.connect(sentWindow.listView, SIGNAL("clicked(QModelIndex)"),showSentMsg)
	QObject.connect(mainWindow.actionImport, SIGNAL("triggered()"),showInboxDialog)
	QObject.connect(mainWindow.actionImport_Sent, SIGNAL("triggered()"),showSentDialog)
	QObject.connect(inboxDialog, SIGNAL("fileSelected(QString)"), importInbox)
	QObject.connect(sentDialog, SIGNAL("fileSelected(QString)"), importSent)
	
	#QObject.connect(dialog, SIGNAL("fileSelected(QString)"), importInboxFile)
        #QObject.connect(ui.msg_back, SIGNAL("clicked()"),showInboxMessages)
        #QObject.connect(ui.sent_msg_back, SIGNAL("clicked()"),showSentMessages)
        #QObject.connect(ui.sentView, SIGNAL("clicked(QModelIndex)"),showSentMsg)
        
        ###########################################################
        
        ###########################################################
        
        
        
        ###########################################################
        
        ################ Other Init functions #####################
        
        
        fetch = False
        
        if msgs.hasImportedSent():
        	fetch = True
        	msgs.fetchSent()
        	populateSent()
        
        if msgs.hasImportedInbox():
        	fetch = True
        	msgs.fetchInbox()
		populateInbox()
		
	if fetch:
		msgs.fetchContactsInfo()
	
	
	###########################################################

#def showImportInboxFileDialog():
	#name = QFileDialog.getOpenFileName(None, "Open Image", "/home/user/", "Image Files (*.png *.jpg *.bmp)");
	#chooser = gtk.FileChooserDialog(title=None,action=gtk.FILE_CHOOSER_ACTION_OPEN, buttons=(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))


def importInbox(path):
	if msgs.importInbox(path):
		notifier.requestPatience()
		
		msgs.fetchContactsInfo()
		populateInbox()
		
		notifier.showSuccess(len(msgs.recvLst))
	else:
		notifier.showFailure()
		
def importSent(path):
	if msgs.importSent(path):
		notifier.requestPatience()
		
		msgs.fetchContactsInfo()
		populateSent()
		
		notifier.showSuccess(len(msgs.sentLst))
	else:
		notifier.showFailure()
		
	
def showInboxDialog():
	if not msgs.hasImportedInbox() :
		 inboxDialog.open()
	else:
		res = QMessageBox.question(mainWindow, "Retro Conversations",
                                "This will overwrite previously imported Inbox SMS. Proceed?", QMessageBox.Yes | QMessageBox.No);
                                
                if res == QMessageBox.Yes:
                	inboxDialog.open()
		
def showSentDialog():
	if not msgs.hasImportedSent():
		 sentDialog.open()
	else:
		res = QMessageBox.question(mainWindow, "Retro Conversations",
                                "This will overwrite previously imported Sent SMS. Proceed?", QMessageBox.Yes | QMessageBox.No);
                                
                if res == QMessageBox.Yes:
                	sentDialog.open()

if __name__ == '__main__':
	app = QApplication(sys.argv)
	#MainWindow = QtGui.QMainWindow()
	#ui = Ui_MainWindow()
	#ui.setupUi(MainWindow)
	#MainWindow.show()
	
	####### Initialization #########
	
	mainWindow = Ui_MainWindow()
	inboxWindow = Ui_InboxWindow(mainWindow)
	sentWindow = Ui_SentWindow(mainWindow)
	inboxMsgWindow = Ui_MessageWindow(inboxWindow)
	sentMsgWindow = Ui_MessageWindow(sentWindow)
	
	
	
	inboxDialog = QFileDialog(mainWindow);
	inboxDialog.setFilter("Recieved SMS CSV Files (*.csv)");
	inboxDialog.setViewMode(QFileDialog.List);
	
	sentDialog = QFileDialog(mainWindow);
	sentDialog.setFilter("Sent SMS CSV Files (*.csv)");
	sentDialog.setViewMode(QFileDialog.List);

	
	
	
	
	#mainWindow=QMainWindow()
	init()
	
	################################


	mainWindow.show()


	################################

	#win = QMainWindow()
	#win.show()

	#name = QFileDialog.getOpenFileName(None,"Open Image", "/home/user/", "Image Files (*.png *.jpg *.bmp)");
	
	sys.exit(app.exec_())




