#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import traceback
import dbus
import dbus.mainloop.qt
import alarm
import os
import cPickle
from time import time, strftime
from PyQt4 import QtGui, QtCore

from rest_in_peace_gui import *

class MyForm(QtGui.QMainWindow):
    def __init__(self, parent=None):
        self.enableLogging = False
        self.enableAlarm = True
        self.enableGSMAlarm = False
        self.searchCellID = None
        self.selected_group = None

        self.cellID_list_changed=False

        self.cellID_list = {}
        self.cellID_name = ""
        self.current_cellid = 0

        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)

        self.setup_settings()
        self.load_settings()

        # Populate the combobox with predefined cellID list (updated from QSettings)
        for cellName in self.cellID_list.keys():
            self.ui.comboBoxFav.addItem(cellName, self.cellID_list[cellName])
        self.ui.comboBoxFav.setCurrentIndex(-1)

        #connect the buttons
        QtCore.QObject.connect(self.ui.pushButtonStart, QtCore.SIGNAL('clicked()'), self.doStart)
        QtCore.QObject.connect(self.ui.pushButtonFav, QtCore.SIGNAL('clicked()'), self.doSaveCurrent)
#        QtCore.QObject.connect(self.ui.checkBoxAlarm, QtCore.SIGNAL('stateChanged(int)'), self.setAlarm)
        QtCore.QObject.connect(self.ui.checkBoxGSMAlarm, QtCore.SIGNAL('stateChanged(int)'), self.setGSMAlarm)
        QtCore.QObject.connect(self.ui.checkBoxLogging, QtCore.SIGNAL('stateChanged(int)'), self.setLogging)
        QtCore.QObject.connect(self.ui.comboBoxFav, QtCore.SIGNAL('currentIndexChanged(QString)'), self.select_group)
        QtCore.QObject.connect(self.ui.comboBoxFav, QtCore.SIGNAL('editTextChanged(QString)'), self.enableSaveButton)
        QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), self.closeEvent)
        QtCore.QObject.connect(self.ui.actionMenuAbout, QtCore.SIGNAL('triggered()'), self.showAbout)
        QtCore.QObject.connect(self.ui.actionMenuTips, QtCore.SIGNAL('triggered()'), self.showTips)
        QtCore.QObject.connect(self.ui.actionMenuEdit, QtCore.SIGNAL('triggered()'), self.edit_dialog)

#        self.ui.checkBoxAlarm.setTristate(self.enableAlarm)
        self.ui.checkBoxGSMAlarm.setTristate(self.enableGSMAlarm)

        dbus.mainloop.qt.DBusQtMainLoop(set_as_default=True)
        bus = dbus.SystemBus()
        # get Current registered Cell ID
        dbus_object = bus.get_object('com.nokia.phone.net', '/com/nokia/phone/net')
        cellinfo = dbus.Interface(dbus_object, 'Phone.Net')
#        cell_signal_handler(cellinfo.get_registration_status())

        if int(cellinfo.get_selected_radio_access_technology()[0]) != 1:
            QtGui.QMessageBox.information(self, "3G networks are allowed in settings", "Please use 2G-only (GSM) networks to ensure stable behaviour. Go to Settings > Phone > Network mode to change it.")
        #update UI with current CellID
        self.current_cellid = cellinfo.get_registration_status()[2]
        self.update_name()

        bus.add_signal_receiver(cell_signal_handler, dbus_interface = "Phone.Net", signal_name = "registration_status_change")
        bus.add_signal_receiver(cell_signal_handler, dbus_interface = "Phone.Net", signal_name = "cell_info_change")

    def setup_settings(self):
        QtCore.QCoreApplication.setOrganizationName('Rest In Peace')
        QtCore.QCoreApplication.setOrganizationDomain('Rest In Peace')
        QtCore.QCoreApplication.setApplicationName('Rest In Peace')
        self.settings = QtCore.QSettings()

    def load_settings(self):
        # check to see if there is a save file
        if(self.settings.value("CellID_List", 0xDEADDEAD) != 0xDEADDEAD ):
            # load the save file into a temp dict
            self.cellID_savelist = cPickle.loads(str(self.settings.value("CellID_List").toString()))


            # overwrite dictionary with what we just loaded
            for cellName in self.cellID_savelist.keys():
                self.cellID_list[cellName] = self.cellID_savelist[cellName]

                #one-time conversion
                try:
                    list(self.cellID_list[cellName]) # TODO: find better check?
                except:
                    self.cellID_list[cellName] = [self.cellID_list[cellName],]

            #TODO: cellnames hierarchy


    def doStart(self):
        if self.cellID_list.__contains__(str(self.selected_group)):
            self.searchCellID = self.cellID_list[str(self.selected_group)]
            self.ui.pushButtonStart.setText("Waiting for a CellID from [" + str(self.ui.comboBoxFav.currentText()) + "] group.\nClick again to set new destination.")

    # Change the CellID to search for when User hits "go"
    def select_group(self, group):
        self.selected_group = group

    # Enable button when user modifies the text in the comboBox
    # just to give some feedback that the two controls are linked
    def enableSaveButton(self, text):
        if self.current_cellid != 0:
            self.ui.pushButtonFav.setEnabled( True )

 #   def setAlarm(self, value):
 #       self.enableAlarm = not(self.enableAlarm)
 #       self.ui.checkBoxAlarm.setTristate(self.enableAlarm)

    def setGSMAlarm(self, value):
        self.enableGSMAlarm = not(self.enableGSMAlarm)
        self.ui.checkBoxGSMAlarm.setChecked(self.enableGSMAlarm)

    # enable Logging of cellID
    def setLogging(self, value):
        self.enableLogging = not self.enableLogging
        self.ui.checkBoxLogging.setTristate(self.enableLogging)
        self.fileObj = open("/home/user/MyDocs/restinpeace_cellid_log.txt","a")

    # Save currentCellID and add it to the dictionary
    def doSaveCurrent(self):
        print "Trying to add " + self.ui.comboBoxFav.currentText() + " : " + str(self.ui.spinBoxCellID.value()) + " to list"
        cellName = str(self.ui.comboBoxFav.currentText())
        cellNumber = self.ui.spinBoxCellID.value()
        try:
            if ((cellName in self.cellID_list) and
               (cellNumber in self.cellID_list[cellName])):
                print(str(cellNumber) + " found in " + cellName)
                return
            else:
                try:
                    self.cellID_list[cellName].append(cellNumber)
                except:
                    #new name
                    self.cellID_list[cellName] = [cellNumber,]
                    self.ui.comboBoxFav.addItem(cellName, cellNumber)

        except:
            return
        self.cellID_list_changed=True
        print "OK"
        self.update_name()

    def update_name(self):
        self.ui.spinBoxCellID.setSuffix("")
        self.cellID_name = ""
        self.ui.spinBoxCellID.setValue(self.current_cellid)
        for key in self.cellID_list.iterkeys():
            if self.cellID_list[key].__contains__(self.current_cellid):
                if self.cellID_name:
                    self.cellID_name += ", " + key
                else:
                    self.cellID_name = key
        if self.cellID_name:
            self.ui.spinBoxCellID.setSuffix(": "+self.cellID_name)

    def closeEvent(self, event):
        #Save settings
        # Pickle and save the python object
        if self.cellID_list_changed:
            saveData = cPickle.dumps(self.cellID_list)
            self.settings.setValue("CellID_List", saveData)
            print "Settings saved. Quitting!"
        else:
            print "Settings didn't change. Quitting!"

    def edit_dialog(self):
        dialog_object = QtGui.QInputDialog()
        proceed = True
        while proceed:
            items = []
            for item in self.cellID_list:
                items.append(str(item).decode())

            selected_item, proceed = dialog_object.getItem(self, 'Group selection', 'Select a group to edit or type new name to add:', items, 0, True)
            if not(proceed): continue
            selected_item = str(selected_item.toAscii()).decode()
            if self.cellID_list.__contains__(selected_item):
                self.sub_edit_dialog(selected_item)
            else:
                self.cellID_list[selected_item] = []
                self.cellID_list_changed = True
        for cellName in self.cellID_list.keys():
            self.ui.comboBoxFav.addItem(cellName, self.cellID_list[cellName])
        self.ui.comboBoxFav.setCurrentIndex(-1)

    def sub_edit_dialog(self, selected_item):
        delete_group_text = "Delete this group" # TODO: i18n, UTF-8 support
        sub_dialog_object = QtGui.QInputDialog()
        sub_proceed = True
        while sub_proceed:
            items = [delete_group_text,]
            for item in self.cellID_list[selected_item]:
                items.append(str(item).decode())

            sub_selected_item, sub_proceed = sub_dialog_object.getItem(self, str(selected_item), 'Select any existing CellID to delete or type a new one to add', items, 0, True)
            if not(sub_proceed): continue
            if sub_selected_item == delete_group_text:
                self.cellID_list.pop(selected_item)
                self.cellID_list_changed = True
                sub_proceed = False
                continue
            try:
                sub_selected_item = int(sub_selected_item)
            except:
                QtGui.QMessageBox.information(self, " ", "CellID value has to be integer")
                continue
#            print self.cellID_list[selected_item][sub_selected_item]
            if self.cellID_list[selected_item].__contains__(sub_selected_item):
                self.cellID_list[selected_item].remove(sub_selected_item)
                self.cellID_list_changed = True
            else:
                try:
                    new_cellid = sub_selected_item
                    self.cellID_list[selected_item].append(new_cellid)
                    self.cellID_list_changed = True
                except: pass

    def showTips(self):
        tipsString = """
Choose one of the favorites, enable the alarm and hit 'Go'. As long as the app is running, it will sound an alarm when the phone registers itself with the GSM basestation at the destination.<br>To save the currently registered CellID, just give it a name in the dropdown and hit 'Add CellID'
"""
	QtGui.QMessageBox.information(self, "Tips", tipsString)

    def showAbout(self):
        aboutString = "Rest in Peace:\nGirish Gopi (rip@gman.me.uk) - version 0.1\nSerhiy Zahoriya (xintx.ua@gmail.com) - version 0.2\nMany thanks to qwerty12, lma, mikec, fatalsaint, Dvortygirl (icon) plus all of t.m.o (& w.m.o)"
        QtGui.QMessageBox.information(self, "About R.I.P", aboutString)

    def closeTips(self):
	self.scrollArea.close()

def add_two_button_alarm( message = "R.I.P. alarm"):
    event = alarm.Event()
    event.appid = 'restinpeace'
    event.message = "[ "+str(app_object.cellID_name)+" ] "+message

    event.alarm_time = time() + 1

    action_stop, action_snooze = event.add_actions(2)
    action_stop.label = 'Stop'
    action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP
    action_snooze.label = 'Snooze'
    action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE

    cookie = alarm.add_event(event)
    return cookie

def cell_signal_handler(*args):
    if( app_object.enableLogging ):
        app_object.fileObj.write( strftime("%Y-%m-%d %H:%M:%S") + ', ' + str(args[4]) + ', ' + str(args[3]) + ', ' + str(args[2]) + '\n' )

    app_object.current_cellid = args[2]
    # Update UI with current CellID
    app_object.update_name()
    #print app_object.current_cellid , " in ",app_object.searchCellID
    # Does it match the preset CellID?
    if( app_object.searchCellID ):
        if( app_object.current_cellid in app_object.searchCellID ):
            if( app_object.enableAlarm ):
                add_two_button_alarm()
            app_object.ui.pushButtonStart.setText("Arrived at ["+app_object.cellID_name+"]. Click again to set new destination.")
            app_object.searchCellID = None

    if( app_object.enableGSMAlarm and (args[3] != 0 and args[4] != 0) ):
        app_object.enableGSMAlarm = False
        app_object.ui.checkBoxGSMAlarm.setChecked(app_object.enableGSMAlarm)
        add_two_button_alarm("GSM network available. You may not see it in the status panel if that's not your operator's station.")

if __name__ == '__main__':
    app = QtGui.QApplication(sys.argv)
    app_object = MyForm()
    app_object.show()
    sys.exit(app.exec_())
