#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import traceback

import dbus
import dbus.mainloop.glib
import alarm
#import timer
import os
import cPickle

from time import time

from PyQt4 import QtGui, QtCore

from rest_in_peace_gui import *

#mytimer = timer.Timer()

class MyForm(QtGui.QMainWindow):
    enableLogging = False;
    enableAlarm = False;
    enableGSMAlarm = False;
    searchCellID = 0;  #modified when you choose a favorite. This variable holds the match the system searches for

    cellID_list_changed=False

    cellID_list = {}
    cellID_name = ""

    def __init__(self, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)

        self.setup_settings()
        self.load_settings()

        # Populate the combobox with predefined cellID list (updated from QSettings)
        for cellName in self.cellID_list.keys():
            self.ui.comboBoxFav.addItem(cellName, self.cellID_list[cellName])
        self.ui.comboBoxFav.setCurrentIndex(-1)

        #connect the buttons
        QtCore.QObject.connect(self.ui.pushButtonStart, QtCore.SIGNAL('clicked()'), self.doStart)
        QtCore.QObject.connect(self.ui.pushButtonFav, QtCore.SIGNAL('clicked()'), self.doSaveCurrent)
        QtCore.QObject.connect(self.ui.checkBoxAlarm, QtCore.SIGNAL('stateChanged(int)'), self.setAlarm)
        QtCore.QObject.connect(self.ui.checkBoxGSMAlarm, QtCore.SIGNAL('stateChanged(int)'), self.setGSMAlarm)
        QtCore.QObject.connect(self.ui.checkBoxLogging, QtCore.SIGNAL('stateChanged(int)'), self.setLogging)
        QtCore.QObject.connect(self.ui.comboBoxFav, QtCore.SIGNAL('currentIndexChanged(QString)'), self.changeCellID)
        QtCore.QObject.connect(self.ui.comboBoxFav, QtCore.SIGNAL('editTextChanged(QString)'), self.enableSaveButton)
        QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), self.closeEvent)
        QtCore.QObject.connect(self.ui.actionMenuAbout, QtCore.SIGNAL('triggered()'), self.showAbout)
        QtCore.QObject.connect(self.ui.actionMenuTips, QtCore.SIGNAL('triggered()'), self.showTips)
        QtCore.QObject.connect(self.ui.actionMenuEdit, QtCore.SIGNAL('triggered()'), self.edit_dialog)

        dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
        bus = dbus.SystemBus()
        # get Current registered Cell ID
        dbus_object = bus.get_object('com.nokia.phone.net', '/com/nokia/phone/net')
        cellinfo = dbus.Interface(dbus_object, 'Phone.Net')
#        cell_signal_handler(cellinfo.get_registration_status())
        #cellinfo.get_registration_status()[2]
        #cellinfo.get_selected_radio_access_technology()
        #update UI with current CellID
        self.ui.spinBoxCellID.setValue(cellinfo.get_registration_status()[2])

        bus.add_signal_receiver(cell_signal_handler, dbus_interface = "Phone.Net", signal_name = "registration_status_change")
        bus.add_signal_receiver(cell_signal_handler, dbus_interface = "Phone.Net", signal_name = "cell_info_change")


    def setup_settings(self):
        QtCore.QCoreApplication.setOrganizationName('Rest In Peace')
        QtCore.QCoreApplication.setOrganizationDomain('Rest In Peace')
        QtCore.QCoreApplication.setApplicationName('Rest In Peace')
        settings = QtCore.QSettings()
        self.settings = settings

    def load_settings(self):
        # check to see if there is a save file
        if(self.settings.value("CellID_List", 0xDEADDEAD) != 0xDEADDEAD ):
            # load the save file into a temp dict
            self.cellID_savelist = cPickle.loads(str(self.settings.value("CellID_List").toString()))


            # overwrite dictionary with what we just loaded
            for cellName in self.cellID_savelist.keys():
                self.cellID_list[cellName] = self.cellID_savelist[cellName]

                #one-time conversion
                try:
                    list(self.cellID_list[cellName]) # TODO: find better check?
                except:
                    self.cellID_list[cellName] = [self.cellID_list[cellName],]

            #TODO: cellnames hierarchy


    def doStart(self):
        self.ui.pushButtonStart.setText("Waiting for " + str(self.ui.comboBoxFav.currentText()) + ": CellIDs " + str(self.searchCellID) + ".\n Click again to change.")

    # Change the CellID to search for when User hits "go"
    def changeCellID(self, favorite):
        self.searchCellID = self.cellID_list[str(favorite)]
        print "Pre-stored CellID: " + str( self.searchCellID )

    # Enable button when user modifies the text in the comboBox
    # just to give some feedback that the two controls are linked
    def enableSaveButton(self, text):
        self.ui.pushButtonFav.setEnabled( True )

    # Could probably do with defaulting this to "on"
    def setAlarm(self, value):
        self.enableAlarm = not self.enableAlarm
        self.ui.checkBoxAlarm.setTristate(self.enableAlarm)
        print "alarm state set to: " + str(self.enableAlarm)

    def setGSMAlarm(self, value):
        print "GSM alarm checkbox changed ", str(value)
        self.enableGSMAlarm = self.ui.checkBoxGSMAlarm.isChecked()
        print "GSM alarm state set to: " + str(self.enableGSMAlarm)

    # enable Logging of cellID
    def setLogging(self, value):
        self.enableLogging = not self.enableLogging
        self.ui.checkBoxLogging.setTristate(self.enableLogging)
        self.fileObj = open("/home/user/cellID_log.txt","a")
        print "logging state set to: " + str(self.enableLogging)

    # Save currentCellID and add it to the dictionary
    def doSaveCurrent(self): # TODO: change for lists handling
        print "Trying to add " + self.ui.comboBoxFav.currentText() + " : " + str(self.ui.spinBoxCellID.value()) + " to list"
        # self.cellID_list[str(self.ui.comboBoxFav.currentText())] = self.ui.spinBoxCellID.value()
        cellName = str(self.ui.comboBoxFav.currentText())
        cellNumber = self.ui.spinBoxCellID.value()
        try:
            #TODO: rewrite if?
            if ((cellName in self.cellID_list) and
               (cellNumber in self.cellID_list[cellName])):
                print(str(cellNumber) + " found in " + cellName)
                return
            else:
                try:
                    self.cellID_list[cellName].append(cellNumber)
                except:
                    #new name
                    self.cellID_list[cellName] = [cellNumber,]
                    self.ui.comboBoxFav.addItem(cellName, cellNumber)

        except:
            return
        self.cellID_list_changed=True
        print "OK"


    def closeEvent(self, event):
        #Save settings
        # Pickle and save the python object
        if self.cellID_list_changed:
            saveData = cPickle.dumps(self.cellID_list)
            self.settings.setValue("CellID_List", saveData)
            print "Settings saved. Quitting!"
        else:
            print "Settings didn't change. Quitting!"

    def edit_dialog(self):
        dialog_object = QtGui.QInputDialog()
        proceed = True
        while proceed:
            items = []
            for item in self.cellID_list:
                items.append(str(item).decode())

            selected_item, proceed = dialog_object.getItem(self, 'Group selection', 'Select a group to edit or type new name to add:', items, 0, True)
            if not(proceed): continue
            selected_item = str(selected_item.toAscii()).decode()
            if self.cellID_list.__contains__(selected_item):
                self.sub_edit_dialog(selected_item)
            else:
                self.cellID_list[selected_item] = []
                self.cellID_list_changed = True
        for cellName in self.cellID_list.keys():
            self.ui.comboBoxFav.addItem(cellName, self.cellID_list[cellName])
        self.ui.comboBoxFav.setCurrentIndex(-1)

    def sub_edit_dialog(self, selected_item):
        delete_group_text = "Delete this group" # TODO: i18n, UTF-8 support
        sub_dialog_object = QtGui.QInputDialog()
        sub_proceed = True
        while sub_proceed:
            items = [delete_group_text,]
            for item in self.cellID_list[selected_item]:
                items.append(str(item).decode())

            sub_selected_item, sub_proceed = sub_dialog_object.getItem(self, str(selected_item), 'Select any existing CellID to delete or type a new one to add', items, 0, True)
            if not(sub_proceed): continue
            if sub_selected_item == delete_group_text:
                self.cellID_list.pop(selected_item)
                sub_proceed = False
                continue
            try:
                sub_selected_item = int(sub_selected_item)
            except:
                continue
#            print self.cellID_list[selected_item][sub_selected_item]
            if self.cellID_list[selected_item].__contains__(sub_selected_item):
                self.cellID_list[selected_item].remove(sub_selected_item)
                self.cellID_list_changed = True
            else:
                try:
                    new_cellid = sub_selected_item
                    self.cellID_list[selected_item].append(new_cellid)
                    self.cellID_list_changed = True
                except: pass

    def showTips(self):
        tipsString = "Choose one of the favorites, enable the alarm and hit 'Go'. As long as the app is running, it will sound an alarm when the phone registers itself with the GSM basestation at the destination.<br>To save the currently registered CellID, just give it a name in the dropdown and hit 'Add CellID'"
        #TODO: update tips, change the return method

	self.label = QtGui.QLabel(tipsString)
        self.label.setWordWrap(True)
        self.label.setTextFormat(QtCore.Qt.RichText)
	self.label.setGeometry(QtCore.QRect(0, 0, 700, 400))
	self.scrollArea = QtGui.QScrollArea(self)
	self.scrollArea.setWidget(self.label)
        self.scrollArea.setWidgetResizable(True)
	self.scrollArea.setGeometry(QtCore.QRect(0, 0, 800, 400))
        self.scrollArea.setAttribute(QtCore.Qt.WA_DeleteOnClose)
	self.okButton = QtGui.QPushButton(self.scrollArea)
        okPosition = QtCore.QRect(700, 350, 100, 50)
	self.okButton.setGeometry(okPosition)
	self.okButton.setText("Back")
        QtCore.QObject.connect(self.okButton, QtCore.SIGNAL('clicked()'), self.closeTips)
	self.scrollArea.show()


    def showAbout(self):
        aboutString = "Rest in Peace:\nGirish Gopi (rip@gman.me.uk) - version 0.1\nSerhiy Zahoriya (xintx.ua@gmail.com) - version 0.2\nMany thanks to qwerty12, lma, mikec, fatalsaint, Dvortygirl (icon) plus all of t.m.o (& w.m.o)"
        QtGui.QMessageBox.information(self, "About R.I.P", aboutString)

    def closeTips(self):
	self.scrollArea.close()

def add_two_button_alarm( message = "We are HERE!"):
    event = alarm.Event()
    event.appid = 'restinpeace'
    event.message = message

    event.alarm_time = time() + 1

    action_stop, action_snooze = event.add_actions(2)
    action_stop.label = 'Stop'
    action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP

    action_snooze.label = 'Snooze'
    action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE

    cookie = alarm.add_event(event)

    return cookie

def cell_signal_handler(*args):
    if( app_object.enableLogging ):
        app_object.fileObj.write( time() + '--> ' + str(args[4]) + ', ' + str(args[3]) + ', ' + str(args[2]) + '\n' )

    # Update UI with current CellID
    app_object.ui.spinBoxCellID.setSuffix("")
    app_object.ui.spinBoxCellID.setValue(args[2])
    for key in app_object.cellID_list.iterkeys():
        if app_object.cellID_list[key].__contains__(args[2]):
            app_object.cellID_name = key
            break
    app_object.ui.spinBoxCellID.setSuffix(": "+app_object.cellID_name)

    # Does it match the preset CellID?
    if( app_object.searchCellID ):
        if( args[2] in app_object.searchCellID ):
            if( app_object.enableAlarm ):
                app_object.enableAlarm = False
                app_object.ui.checkBoxAlarm.setTristate(False)
                add_two_button_alarm()
                #sys.exit(app_object.exec_())
                #app_object.ui.centralwidget.setEnabled(True)

            # Even if there is no alarm, give some feedback to UI that we're arrived!
            app_object.ui.pushButtonStart.setText("We are HERE!")

    if( app_object.enableGSMAlarm and (args[3] != 0 and args[4] != 0) ):
        app_object.enableGSMAlarm = False
        app_object.ui.checkBoxGSMAlarm.setChecked(False)
        add_two_button_alarm("GSM network available. You may not see it in the status panel if that's not your operator's station.")

if __name__ == '__main__':
    app = QtGui.QApplication(sys.argv)

    #workaround for bug #6642
    import gobject
    app_object = MyForm()
    app_object.show()
    sys.exit(app.exec_())
