#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import traceback
import gobject
import dbus
import dbus.mainloop.glib
import alarm
import timer
import os
import cPickle

from time import time

from PyQt4 import QtGui, QtCore

from rest_in_peace_gui import *

CURRENTVERSION = "0.1.0"


mytimer = timer.Timer()

class MyForm(QtGui.QMainWindow):
    enableLogging = False;
    enableAlarm = False;
    searchCellID = 0000;  #modified when you choose a favorite. This variable holds the match the system searches for

    cellID_list = {"Surbiton" : 16568 , "Woking" : 6993, "F'Boro": 8509, "Clapham Jn": 23001, "Earlsfield": 19617}

    def __init__(self, parent=None):
        #build parent user interface
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)

        self.setup_settings()
        self.load_settings()

        # Populate the combobox with predefined cellID list (updated from QSettings)
        for cellName in self.cellID_list.keys():
            self.ui.comboBoxFav.addItem(cellName, self.cellID_list[cellName])
        self.ui.comboBoxFav.setCurrentIndex(-1)

        #connect the buttons
        QtCore.QObject.connect(self.ui.pushButtonStart, QtCore.SIGNAL('clicked()'), self.doStart)
        QtCore.QObject.connect(self.ui.pushButtonFav, QtCore.SIGNAL('clicked()'), self.doSaveCurrent)
        QtCore.QObject.connect(self.ui.checkBoxAlarm, QtCore.SIGNAL('stateChanged(int)'), self.setAlarm)
        QtCore.QObject.connect(self.ui.checkBoxLogging, QtCore.SIGNAL('stateChanged(int)'), self.setLogging)
        QtCore.QObject.connect(self.ui.comboBoxFav, QtCore.SIGNAL('currentIndexChanged(QString)'), self.changeCellID)
        QtCore.QObject.connect(self.ui.comboBoxFav, QtCore.SIGNAL('editTextChanged(QString)'), self.enableSaveButton)
        QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), self.closeEvent)
        QtCore.QObject.connect(self.ui.actionMenuAbout, QtCore.SIGNAL('triggered()'), self.showAbout)
        QtCore.QObject.connect(self.ui.actionMenuTips, QtCore.SIGNAL('triggered()'), self.showTips)


        # get Current registered Cell ID
        # can't get this to work in straight python, so cheat and run the command in bash
        # Many thanks to the maemo.org wiki!
        f=os.popen("dbus-send --system --print-reply --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.get_registration_status")
        dbusOP = f.readlines()
        currCellId = (dbusOP[3].split())[1]
        print "Currently registered CellID is: ", int(currCellId)
        #update UI with current CellID
        self.ui.spinBoxCellID.setValue(int(currCellId))

        dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
        bus = dbus.SystemBus()
        bus.add_signal_receiver(cell_signal_handler, dbus_interface = "Phone.Net", signal_name = "registration_status_change")
        bus.add_signal_receiver(cell_signal_handler, dbus_interface = "Phone.Net", signal_name = "cell_info_change")


    def setup_settings(self):
        settings = QtCore.QSettings()
        QtCore.QCoreApplication.setOrganizationName('gman.me.uk')
        QtCore.QCoreApplication.setOrganizationDomain('gman.me.uk')
        QtCore.QCoreApplication.setApplicationName('Rest In Peace')
        self.settings = settings

    def load_settings(self):
        # check to see if there is a save file
        if(self.settings.value("CellID_List", 0xDEADDEAD) != 0xDEADDEAD ):
            # load the save file into a temp dict
            self.cellID_savelist = cPickle.loads(str(self.settings.value("CellID_List").toString()))

            # overwrite dictionary with what we just loaded
            for cellName in self.cellID_savelist.keys():
                self.cellID_list[cellName] = self.cellID_savelist[cellName]


    def doStart(self):
        self.ui.pushButtonStart.setText("Now Rest In Peace")
        self.ui.centralwidget.setEnabled(False)
        print "Waiting for CellID: " + str(self.searchCellID)


    # Change the CellID to search for when User hits "go"
    def changeCellID(self, favorite):
        self.searchCellID = self.cellID_list[str(favorite)]
        print "Pre-stored CellID: " + str( self.searchCellID )

    # Enable button when user modifies the text in the comboBox
    # just to give some feedback that the two controls are linked
    def enableSaveButton(self, text):
        self.ui.pushButtonFav.setEnabled( True )

    # Could probanbly do with defaulting this to "on"
    def setAlarm(self, value):
        self.enableAlarm = not self.enableAlarm
        self.ui.checkBoxAlarm.setTristate(self.enableAlarm)
        print "alarm state set to: " + str(self.enableAlarm)

    # enable Logging of cellID
    def setLogging(self, value):
        self.enableLogging = not self.enableLogging
        self.ui.checkBoxLogging.setTristate(self.enableLogging)
        self.fileObj = open("/home/user/cellID_log.txt","a")
        print "logging state set to: " + str(self.enableLogging)

    # Save currentCellID and ad it to the dictionary
    def doSaveCurrent(self):
        print "add " + self.ui.comboBoxFav.currentText() + " : " + str(self.ui.spinBoxCellID.value()) + " to list"
        self.cellID_list[str(self.ui.comboBoxFav.currentText())] = self.ui.spinBoxCellID.value()
        self.ui.comboBoxFav.addItem(self.ui.comboBoxFav.currentText(), self.ui.spinBoxCellID.value())

    def closeEvent(self, event):
        #Save settings
        # Pickle and save the python object
        saveData = cPickle.dumps(self.cellID_list)
        self.settings.setValue("CellID_List", saveData)

        print "Settings saved. Quitting!"


    def showTips(self):
        tipsString = "I have pre-populated a few CellIDs for stations in the UK. Choose one of the favorites, enable the  alarm and hit 'Go'. As long as the app is running, it will sound an alarm when the phone registers itself with the GSM basestation at the destination.<br>To save the currently registered CellID, just give it a name in the dropdown and hit 'Save current CellID'<p><b>NOTE:</b> The current version only associates a single CellID with a destination. So if you are on dual GSM/3G mode, it is possible the alarm may not sound. <em>Please <b>ensure</b> you are on <b>GSM only</b> before falling asleep</em> (<a href='http://github.com/abrisse/AutoDisconnect'>AutoDisconnect</a> does this for me automatically. YMMV)"

	self.label = QtGui.QLabel(tipsString)
        self.label.setWordWrap(True)
        self.label.setTextFormat(QtCore.Qt.RichText)
	self.label.setGeometry(QtCore.QRect(0, 0, 700, 400))
	self.scrollArea = QtGui.QScrollArea(self)
	self.scrollArea.setWidget(self.label)
#        self.scrollArea.setWidgetResizable(True)
	self.scrollArea.setGeometry(QtCore.QRect(0, 0, 800, 400))
        self.scrollArea.setAttribute(QtCore.Qt.WA_DeleteOnClose)
	self.okButton = QtGui.QPushButton(self.scrollArea)
        okPosition = QtCore.QRect(700, 350, 100, 50)
	self.okButton.setGeometry(okPosition)
	self.okButton.setText("Back")
        QtCore.QObject.connect(self.okButton, QtCore.SIGNAL('clicked()'), self.closeTips)
	self.scrollArea.show()


    def showAbout(self):
        aboutString = "Rest in Peace: v" + CURRENTVERSION + "\nGirish Gopi (rip@gman.me.uk)\nMany thanks to qwerty12, lma, mikec, fatalsaint, Dvortygirl (icon) plus all of t.m.o (& w.m.o)"
        QtGui.QMessageBox.information(self, "About R.I.P", aboutString)

    def closeTips(self):
	self.scrollArea.close()

def add_two_button_alarm():
    event = alarm.Event()
    event.appid = 'myappid'
    event.message = 'We are HERE!!!!!!'

    event.alarm_time = time() + 5

    action_stop, action_snooze = event.add_actions(2)
    action_stop.label = 'Stop'
    action_stop.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_NOP

    action_snooze.label = 'Snooze'
    action_snooze.flags |= alarm.ACTION_WHEN_RESPONDED | alarm.ACTION_TYPE_SNOOZE

    print event.is_sane()

    cookie = alarm.add_event(event)

    return cookie

def cell_signal_handler(*args):
    print "%s,%s,%s" % (args[4], args[3], args[2])
    if( myapp.enableLogging ):
        myapp.fileObj.write( mytimer.cur_time() + '--> ' + str(args[4]) + ', ' + str(args[3]) + ', ' + str(args[2]) + '\n' )

    # Update UI with current CellID
    myapp.ui.spinBoxCellID.setValue(args[2])
    
    # Does it match the preset CellID?
    if( args[2] == myapp.searchCellID ): 
	if( myapp.enableAlarm ):
            myapp.enableAlarm = False
            myapp.ui.checkBoxAlarm.setTristate(False)
            add_two_button_alarm()

        # Even if there is no alarm, give soem feedback to UI that we're arrived!
        myapp.ui.pushButtonStart.setText("We are HERE!!")

   
if __name__ == '__main__':
    app = QtGui.QApplication(sys.argv)
    myapp = MyForm()
    myapp.show()
    sys.exit(app.exec_())
