#!/usr/bin/env python
# -*- coding: utf-8 -*-

#########################################################################
#    Copyright (C) 2010 Sergio Villar Senin <svillar@igalia.com>
#
#    This file is part of ReSiStance
#
#    ReSiStance is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    ReSiStance is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with ReSiStance.  If not, see <http://www.gnu.org/licenses/>.
#########################################################################

import os
import sys
import gtk

RSS_NAME = 'ReSiStance'
RSS_COMPACT_NAME = 'resistance'
RSS_VERSION = '0.3.1'
RSS_DESCRIPTION = 'ReSiStance is a RSS feeds reader'
RSS_URL = 'http://www.igalia.com'

HOME_PATH = os.path.expanduser('~')
RSS_CONF_FOLDER = os.path.join(HOME_PATH, '.osso/%s' % RSS_COMPACT_NAME)
RSS_CONF_FILE = os.path.join(RSS_CONF_FOLDER, '%s.conf' % RSS_COMPACT_NAME)
RSS_DB_FILE = os.path.join(RSS_CONF_FOLDER, '%s' % 'feeds.db')

DEFAULT_SYSTEM_APP_DIR = os.path.join(sys.prefix,
                                      'share',
                                      RSS_COMPACT_NAME)
APP_DIR = DEFAULT_SYSTEM_APP_DIR

if not os.path.exists(APP_DIR):
    APP_DIR = os.path.curdir
    APP_DIR = os.path.join(APP_DIR, 'data')

RSS_SPEC_FILE = os.path.join(APP_DIR, '%s_spec.ini' % RSS_COMPACT_NAME)

LOCALE_DIR = os.path.join(APP_DIR, 'locale')

DEFAULT_LANGUAGES = os.environ.get('LANGUAGE', '').split(':')
DEFAULT_LANGUAGES += ['en_US']

SECONDARY_TEXT_COLOR = 'SecondaryTextColor'
ACTIVE_TEXT_COLOR = 'ActiveTextColor'
DEFAULT_TEXT_COLOR = 'DefaultTextColor'

ICON_UP_NAME = "rss_reader_move_up"
ICON_DOWN_NAME = "rss_reader_move_down"

ASCENDING_ORDER, DESCENDING_ORDER = range(2)
font_size_range = range(12,28,4)
