import Qt 4.7
//import "Public"
//import "web"
import "SendPost.js" as SendPost
//import com.nokia.meego 1.0

//Page{
//    visible: true
//    status: PageStatus.PageStatus.Active
//    lockInPortrait: true

Item{
    id: friend
    property variant model
    property string sessionkey: ""
    property string uid: ""
    property string username:""
    property string head_url:""

    signal getfriendinfo;
    signal refresh;

    onGetfriendinfo: {
        function getFriendInfo(){}
        getFriendInfo.prototype = {
            update: function(a)
            {
                interact.closeBusy();

                if(a.error_msg != undefined)
                {
                    interact.show(a.error_msg);
                }

                userinfoform.frienduid = a.user_id;

                userinfoform.name = a.user_name;

                userinfoform.sex  = "" + a.gender;
                if(userinfoform.sex == "1")
                {
                  userinfoform.sex = "男";
                }
                else
                {
                  userinfoform.sex = "女";
                }

                userinfoform.birthday = a.birth.year + "年" + a.birth.month + "月" + a.birth.day + "日";
                if(a.birth.year == undefined || a.birth.month == undefined || a.birth.day == undefined)
                {
                    userinfoform.birthday = "对方设置为隐私";
                }

                userinfoform.home = a.hometown_province + a.hometown_city;
                if(userinfoform.home.length == 0)
                {
                    userinfoform.home = "对方设置为隐私";
                }


                userinfoform.network = a.network[0];
                if(userinfoform.network.length == 0)
                {
                    userinfoform.network = "对方设置为隐私";
                }

                userinfoform.imageurl = a.head_url;
            }
            }
        SendPost.getFriendInfo(sessionkey, friend.uid, new getFriendInfo());
        console.log("uid1 = " + friend.uid);
    }

    Item{
        id: userinfoform
        anchors.fill: parent
        opacity: 1
        property string frienduid:""
        property string name: ""
        property string sex: ""
        property string birthday: ""
        property string home: ""
        property string network: ""
        property string imageurl:""

        Image {
            id: background
            anchors.fill:  parent
            source: "LoginMidBackground.png"
        }

        HeadBack{
            id: userinfotop
            x : 0
            y : 0
            width: parent.width
            height: 80
            text: userinfoform.name
            onClicked: {
                mainview.state = "";
            }
            onRefresh: {
                interact.showBusy("数据加载中,请稍候");
                friend.getfriendinfo();
            }
        }

        Item{
            id: content
            x: 0
            y: userinfotop.height
            width: parent.width
            height: parent.height - userinfotop.height
            Item{
                id: head
                x: 35
                y: 35
                width: 80
                height: 80
                BorderImage {
                    anchors {
                        fill: headrect
                        leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
                    }
                    source: 'headborder.png'; smooth: true
                    border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
                }
                Rectangle {
                    id: headrect
                    anchors.fill: parent
                    BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
                    Image {
                        id: headImage;
                        source: head_url
                        x: 0;
                        y: 0
                        anchors.fill: parent
                        clip: true
                    }
                }
            }
            Text{
                id:name
                text: userinfoform.name
                x: head.x + head.width + 20
                y : head.y
                width: parent.width - x - 10
                font.pixelSize:  26
                elide: Text.ElideRight
                horizontalAlignment: Text.AlignLeft
                color: "#005EAC"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: jibenxinxi
                x: 0
                y: name.y + name.height + 70
                width: parent.width
                height: 60
                smooth: true
                source: "jibenxinxi.png"

                Text{
                    id: jibenxinxitext
                    text: "基本信息"
                    x:26
                    anchors.verticalCenter:  parent.verticalCenter
                    font.pixelSize:  26
                    color: "black"
                    font.bold: true
                    font.family: "宋体"
                }
            }
            Item{
                id:info
                x: 0
                y : jibenxinxi.y + jibenxinxi.height + 8
                height: parent.height-jibenxinxi.height-head.height-name.height
                width: parent.width
                VisualItemModel{
                    id:model
            Text{
                id:sex
                text: "性别:  " + userinfoform.sex
                x:26
                height: 45
                font.pixelSize:  20
                verticalAlignment: Text.AlignVCenter
                color: "black"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: line2
                x: 0
                width: view.width
                height: 3
                smooth: true
                source: "line.png"
            }

            Text{
                id:birthday
                text: "生日:  " + userinfoform.birthday
                x:26
                height: 45
                font.pixelSize:  20
                verticalAlignment: Text.AlignVCenter
                color: "black"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: line3
                x: 0
                width: view.width
                height: 3
                smooth: true
                source: "line.png"
            }

            Text{
                id:home
                text: "家乡:  " + userinfoform.home
                x:26
                width: view.width - x
                height: 45
                elide: Text.ElideRight
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                font.pixelSize:  20
                color: "black"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: line4
                x: 0
                width: view.width
                height: 3
                smooth: true
                source: "line.png"
            }

            Text{
                id:network
                text: "大学:  " + userinfoform.network
                x: 26
                font.pixelSize:  20
                width: view.width - x
                height: 45
                elide: Text.ElideRight
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                color: "black"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: line5
                x: 0
                width: view.width
                height: 3
                smooth: true
                source: "line.png"
            }
                }
                ListView{
                    id: view
                    model: model
                    anchors.fill: parent
                    clip: true
                }
            }
        }
    }
}
