import Qt 4.7
//import "common"
//import "../Public"
import "SendPost.js" as SendPost
//import com.nokia.meego 1.0

//Page{
//    id:statusview
//    lockInPortrait: true
//     visible: true
//     status: PageStatus.PageStatus.Active

Item{
    id:statusview
    property string headurl;
    property string name;
    property string time;
    property string title;
    property string  user_name;
    property string  rid: ""
    property string ownerid:""
    property string statusid:""

    property variant model

    signal enter;
    signal refresh;

    onEnter: {
        loaddata();
    }

    function loaddata()
    {
        interact.closeBusy();

        if(model.error_msg != undefined)
        {
            interact.show(a.error_msg);
            return;
        }
        replyListView.page = 1;
        replyListView.count = model.count;
        statusReplyModel.clear();
        for ( var index in model.comment_list)
            {
                statusReplyModel.append({
                                 "id" : model.comment_list[index].id,
                                 "head_url" : model.comment_list[index].head_url,
                                 "user_name": model.comment_list[index].user_name,
                                 "content": model.comment_list[index].content,
                                 "time": model.comment_list[index].time,
                                 "user_id":model.comment_list[index].user_id,
                              });
            }
        if(model.count > 20)
        {
            statusReplyModel.append({"id":1});
        }
    }

    signal getMore;
    onGetMore: {
        function getstatus(){}

        getstatus.prototype = {
            update:function(a)
                   {
                       var isHave = 0;
                       interact.closeBusy();

                       if(model.error_msg != undefined)
                       {
                           interact.show(a.error_msg);
                           return;
                       }

                       for ( var index in a.comment_list)
                           {
                               isHave = 1;
                               statusReplyModel.insert((statusReplyModel.count - 1), {
                                                "id" : a.comment_list[index].id,
                                                "head_url" : a.comment_list[index].head_url,
                                                "user_name": a.comment_list[index].user_name,
                                                "content": a.comment_list[index].content,
                                                "time": a.comment_list[index].time,
                                                "user_id":a.comment_list[index].user_id,
                                             });
                           }

                       if(isHave == 1)
                       {
                            replyListView.page++;
                       }

                       if(a.count == statusReplyModel.count - 1)
                       {
                           statusReplyModel.remove(statusReplyModel.count - 1);
                           return;
                       }
                   }
           }
        SendPost.getStatusReply(sessionkey, statusid, ownerid, replyListView.page + 1, new getstatus());
        interact.showBusy("正在加载数据,请稍候...");
    }

    onRefresh: {
        function getstatus(){}

        getstatus.prototype = {
            update:function(a)
                   {
                       interact.close();
                       statusview.model = a;
                       statusview.enter();
                   }
           }
        SendPost.getStatusReply(sessionkey, statusid, ownerid, 1, new getstatus());
        interact.showBusy("正在加载数据,请稍候...");
    }

    HeadBack{
        id: head
        x : 0
        y : 0
        width: parent.width
        height: 80
        text: "回复列表"
        onClicked: {
            message.state = "";
            message.init();
        }

        onRefresh: {
            statusview.refresh();
        }
    }

    Rectangle { //////////////original status
          id: originalStatus
          x:0
          y:head.height
          width: parent.width;
          height: thestatus.height + 65

          Image {
              anchors.fill: parent
              source: "itembg.png"
          }
          BorderImage {
              anchors {
                  fill: thehead
                  leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
              }
              source: 'box-shadow.png'; smooth: true
              border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
          }
          Item {
              id: thehead
              x: 11; y: 15; width: 50; height: 50;
              BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
              Image {
                  id: headImage;  x: 0; y: 0
                  anchors.fill:  parent; clip: true
                  source: headurl;
              }
          }
          Item {
              id: thenameTime
              x: 77; y: 15; width: parent.width - 95;
              Text {
                  text: name; color: "#005EAC"; wrapMode: Text.WordWrap; width: parent.width; font.family: "宋体";
                  font.bold: true; font.pixelSize: 21
                  smooth: true
              }
              Text { text: time; width: parent.width; elide: Text.ElideRight; color: "#808080"; horizontalAlignment: Text.AlignRight;font.family: "宋体"; font.pixelSize: 20 }
          }
          Item {
              id: thestatusFeed;
              x: 77; y: 46; width: parent.width - 95;
              Text {
                  id: thestatus; text: title;
                  color:"black";
                  width: parent.width
                  font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
                  wrapMode: Text.WrapAnywhere;
                  smooth: true
              }
          }
    }

    ListModel {
        id: statusReplyModel
    }

    Item{
        id: bottomItem
        anchors.bottom: parent.bottom
        width: parent.width
        height: 60

        Image {
            id: bottombg1
            anchors.fill:  parent
            source: "bottombg.png"
        }

        Item
        {
            id: select1
            width: parent.width / 2
            height: parent.height

            MouseArea {
                id: select_1
                anchors.fill: select1
                onClicked: {
                    statusview.rid = "";
                    share.state = "enter";
                }
            }

            Image {
                id: select11
                anchors.fill:  parent
                opacity: 0
                source: "select.png"
            }

            Image {
                id: select12
                anchors.centerIn: parent
                opacity: 0
                source: "focus.png"
            }

            Text {
                id: text13
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "转发"
            }
        }

        Item
        {
            id: select2
            x: select1.width
            width: parent.width / 2
            height: parent.height
            opacity: 1

            MouseArea {
                id: select_2
                anchors.fill: select2
                onClicked: {
                    statusview.rid = "";
                    reply.state = "enter";
                }
            }

            Image {
                id: select21
                anchors.fill:  parent
                opacity: 0
                source: "select.png"
            }

            Image {
                id: select22
                anchors.centerIn: parent
                opacity: 0
                source: "focus.png"
            }

            Text {
                id: text23
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "回复"
            }
        }

        states: [
            State {
                name: "zhuanfa"
                when: select_1.pressed == true
                PropertyChanges {target: select11; opacity: 1}
                PropertyChanges {target: select12; opacity: 1}
                PropertyChanges {target: select21; opacity: 0}
                PropertyChanges {target: select22; opacity: 0}
            },
            State {
                name: "huifu"
                when: select_2.pressed == true
                PropertyChanges {target: select11; opacity: 0}
                PropertyChanges {target: select12; opacity: 0}
                PropertyChanges {target: select21; opacity: 1}
                PropertyChanges {target: select22; opacity: 1}
            }
        ]
    }

    Item{
        id : mid

        width: parent.width
        height: parent.height - originalStatus.height - head.height - bottomItem.height
        y: originalStatus.height + head.height

        ListView {
            id: replyListView
            anchors.fill: parent
            clip: true
            model: statusReplyModel
            property int page: 1
            property alias modelcount:statusReplyModel.count
            property int count;
            delegate: StatusReplyDelegate {
                onClicked: {
                    function statusItemClicked(currentItem)
                    {
                        statusview.rid = replyListView.model.get(currentItem).user_id;
                        statusview.user_name = replyListView.model.get(currentItem).user_name;
                        reply.state = "enter";
                    }
                    statusItemClicked(currentItem);
                    replyListView.hlight();
                }
                onMore:{
                    statusview.getMore();
                }
            }
            function hlight()
            {
                replyListView.highlight = highlightBar;
                replyListView.highlightMoveSpeed = 999999
                replyListView.highlightMoveDuration = 300
            }
         }
    }

    Reply{
        id: share
        width: parent.width
        height: parent.height
        anchors.fill: parent
        opacity: 0

        lefttext: "取消"
        midtext:  "转发状态"
        righttext: "发送"
        maxtext: 140
        charStep: 1
        addtext: "转自"+ name + ": " + title

        onOpacityChanged:
        {
            share.addtext = "转自"+ name +": "+ title;
        }

        onExit:
        {
            share.state = "";
        }

        function setText()
        {
            var txt = "回复";
            if(statusview.fid == "")
                {
                txt = "回复";
            }
            else
                {
                txt = "回复" + statusview.user_name;
            }
            return txt;
        }

        onRightbuttonclicked:
        {

//            console.log(" @@@@@@" + statusview.fid+ "  " +statusview.uid)

            function Replystatus(){}
            Replystatus.prototype = {
                    update: function(a)
                    {

                                if(a.result == 1)
                                {
                                    console.log("Success");
                                    share.success("转发成功");
                                    share.state = "";
                                }
                                else
                                {
                                    if(a.result == 0)
                                    {
                                        share.fail("转发失败");
                                    }

                                    if(a.error_msg != undefined)
                                    {
                                        share.fail(a.error_msg);
                                    }
                                }
                    }
            }
         SendPost.sendStatus(sessionkey, inputtext,new Replystatus());
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: share; opacity:1; }
             PropertyChanges { target: replyListView; enabled: false; }
             PropertyChanges { target: bottomItem; opacity: 0; }
             }
        ]

        transitions: Transition {
            NumberAnimation { properties: "x,y,opacity"; duration: 600 }
        }
    }

    Reply{
        id: reply
        width: parent.width
        height: parent.height
        anchors.fill: parent
        opacity: 0

        lefttext: "取消"
        midtext:  setText()
        righttext: "发送"
        maxtext: 140
        charStep: 1

        onExit:
        {
            reply.state = "";
        }

        function setText()
        {
            var txt = "回复";
            if(statusview.fid == "")
                {
                txt = "回复";
            }
            else
                {
                txt = "回复" + statusview.user_name;
            }
            return txt;
        }

        onRightbuttonclicked:
        {

//            console.log(" @@@@@@" + statusview.fid+ "  " +statusview.uid)

            function Replystatus(){}
            Replystatus.prototype = {
                    update: function(a)
                    {

                                if(a.result == 1)
                                {
                                    console.log("Success");
                                    reply.success("回复成功");
                                    reply.state = "";
                                    statusview.refresh();
                                }
                                else
                                {
                                    if(a.result == 0)
                                    {
                                        reply.fail("回复失败");
                                    }

                                    if(a.error_msg != undefined)
                                    {
                                        reply.fail(a.error_msg);
                                    }
                                }
                    }
            }
         SendPost.replyStatus(sessionkey, statusview.ownerid ,statusview.statusid,statusview.rid, inputtext,new Replystatus());
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: reply; opacity:1; }
             PropertyChanges { target: replyListView; enabled: false; }
             PropertyChanges { target: mid; opacity: 0; }
             PropertyChanges { target: bottomItem; opacity: 0; }
             PropertyChanges { target: reply; addtext: statusview.rid == ""?"":"回复" + statusview.user_name + ": "}
             }
        ]

        transitions: Transition {
            NumberAnimation { properties: "x,y,opacity"; duration: 600 }
        }
    }
}
