import Qt 4.7
//import com.nokia.meego 1.0

//Page{
//    id: reply
//    lockInPortrait: true
//     visible: true
//     status: PageStatus.PageStatus.Active
Item{
    id: reply
    signal exit;
    signal rightbuttonclicked(string inputtext)

    property alias lefttext: leftbutton.text
    property alias midtext: middletitle.text
    property alias righttext: rightbutton.text
    property alias addtext: statusinput.text
    property alias maxtext: statusinput.maximumLength

    // add by leaf 2011.7.15
    property int charStep: 2

    // add by leaf 2011.7.9
    property alias inputFocus: statusinput.focus

//    function closeKeyBoard()
//    {
//        statusinput.focus = false;
//        statusinput.closeSoftwareInputPanel();
//        console.log("close key board");
//    }

    function countWords(text) {
       var i = 0;
       var character = 0;
       var chinese = 0;
       var sum = 0;
       while (i < text.length) {
           if (text.charCodeAt(i) >= 0x4e00) {// chinese
               ++chinese;
           }
           else {
               ++character;
           }
           ++i;
       }
       sum = chinese + character / charStep;
       return sum;
   }

    function success(text)
    {
        interact.show(text);
        statusinput.text = "";

        rightbutton.enabled = true;
    }

    function fail(text)
    {
        interact.show(text);
        rightbutton.enabled = true;
    }

    Image {
        id: background
        anchors.fill:  parent
        source: "LoginMidBackground.png"
    }

    Item{
        id: head
        x : 0
        y : 0
        width: parent.width
        height: 80

        Image {
            id: headbg1
            anchors.fill:  parent
            source: "headbg.png"
        }

        Text {
            id: middletitle
            width: parent.width - rightbutton.width - leftbutton.width - 50
            anchors.centerIn: parent
            elide: Text.ElideRight
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font.letterSpacing: -1
            color: "white"
            style: Text.Raised
            font.bold: true
            font.pixelSize: 26
            font.family: "宋体"
        }

        MyButton{
               id: rightbutton
               width: 80;
               height: 46
               anchors.verticalCenter: parent.verticalCenter
               anchors.right: parent.right
               anchors.rightMargin: 20
               imagesource: "ok.png"
               presssource: "ok_press.png"
               text: "发布"
               enabled: true
               onClicked: {
                    if(statusinput.text == "")
                    {
                        interact.show("您还未输入内容，请输入后再试");
                        return;
                    }
                    reply.rightbuttonclicked(statusinput.text);
               }
            }

        MyButton{
            id: leftbutton
            width: 80;
            height: 46
            anchors.verticalCenter: parent.verticalCenter
            anchors.left: parent.left
            anchors.leftMargin: 20
            imagesource: "ok.png"
            presssource: "ok_press.png"
            onClicked:
                {
                    reply.exit();
                    statusinput.text = "";
            }
        }
    }

    Item{
        id: bottomItem
        x: 0
        y: inputarea.y + inputarea.height
        width: parent.width
        height: 80

        Text {
            id: index
            anchors.right: parent.right
            anchors.rightMargin: 20
            opacity: 0
            text: "(" + statusinput.usednums +
                  "/" + statusinput.maximumLength +
                  ")"
            color: "steelblue"
            font.bold: true
            font.pixelSize: 15
            font.family: "宋体"
        }
    }

    Item{
        id: inputarea
        anchors.centerIn:  parent
        width:  parent.width
        height: 300
        BorderImage { source: "lineedit.sci"; anchors.fill: parent }
        Flickable {
             id: flick
             width: inputarea.width
             height: inputarea.height
             contentHeight: statusinput.paintedHeight
             clip: true

             function ensureVisible(r)
             {
                 if (contentY >= r.y)
                     contentY = r.y;
                 else if (contentY+height <= r.y+r.height)
                     contentY = r.y+r.height-height;
             }

             TextEdit{
                 id: statusinput
                 x : 10
                 y: 10
                 width: flick.width - 20
                 height: flick.height - 20

                 font.pixelSize: 23
                 font.bold: true
                 focus: true
                 clip: true
                 wrapMode: TextEdit.Wrap
                 property int maximumLength: 500
                 property int usednums: 0
                 property string previousText: statusinput.text
             } // end TextEdit
         }
    }
}
