import Qt 4.7
//import "../../Public"
import "SendPost.js" as SendPost

Item {
    id: pictureReply; width: pictureReply.ListView.view.width;
    height: id == 1? 60 : (status.height > 60? status.height + 60 : 100)
    signal clicked(int currentItem)
    signal more;

    Item {
        id: pictureReplyItem
        opacity: !moreItem.opacity
        anchors.fill:  parent
        BorderImage {
            anchors {
                fill: head
                leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
            }
            source: 'box-shadow.png'; smooth: true
            border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
        }
        Rectangle {
            id: head
            x: 11; y: 15; width: 50; height: 50;
            BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
            Image {
                id: headImage; source: head_url; x: 0; y: 0
                anchors.fill:  parent; clip: true
            }
        }
        Item {
            id: nameTime
            x: 77; y: 15; width: pictureReply.ListView.view.width - 95;
            Text {
                text: user_name; color: "#005EAC"; wrapMode: Text.WrapAnywhere; width: parent.width; font.family: "宋体";
                font.bold: true; font.pixelSize: 21
                smooth: true
            }
            Text { text: SendPost.getFullTime(time); width: parent.width; elide: Text.ElideRight; color: "#808080"; horizontalAlignment: Text.AlignRight ;font.family: "宋体"; font.pixelSize: 20}
        }
        Column {
            id: comment;
            x: 77; y: 46; width: pictureReply.ListView.view.width - 95;
            Text {
                id: status; text: content; color:"black"; wrapMode: Text.WrapAnywhere; width: parent.width;
                font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
                smooth: true
            }
        }
        Rectangle {
            id: lineone
            width: parent.width; height: 2; color: "#cccccc"
            anchors.bottom: parent.bottom;
            Image {
                id: lineImage
                anchors.fill: parent
                source: "line.png"
                fillMode: Image.Stretch;
            }
        }
    }

    Item{
        id: moreItem
        anchors.fill: parent
        opacity: (id == 1 && replyListView.count > (replyListView.modelcount - 1)?1:0)

        Text {
            id: moretext;
            text: "更多";
            anchors.centerIn: parent
            font.pixelSize:  21
            font.family: "宋体"
        }
    }

    MouseArea {
        anchors.fill: parent
        onClicked: {
           pictureReply.ListView.view.currentIndex = index
            if(id == 1)
            {
                console.log("more");
                pictureReply.more();
            }
            else
            {
                console.log("clicked");
                pictureReply.clicked(index)
            }
        }
    }
}
