import Qt 4.7
//import "../Public"
import "SendPost.js" as SendPost
//import com.nokia.meego 1.0

//Page{
//    lockInPortrait: true
//    visible: true
//    status: PageStatus.PageStatus.Active
Item{
    id: message
    property string sessionkey: ""
    property string uid: ""
    property string head_url:""

    property variant model;
    property alias listmodel: guestbookModel

    property string sourceId;
    property string typeId;

    onEnter: {
        console.log("XXX = " + message.head_url);
        loaddata();
    }

    signal enter;
    signal getBirthdayList;
    signal redmessage;
    signal getMessageList;

    signal init;
    onInit: {
        bottomItem.state = "init";
    }

    onGetMessageList: {
        function getMessageList() {}

        getMessageList.prototype = {
            update: function(a)
                    {
                        guestbookModel.clear();
                        for ( var index in a.news_list)
                            {
                            console.log("index = " + index);
                                guestbookModel.append({
                                                 "head_url" : a.news_list[index].head_url[0],
                                                 "user_name": a.news_list[index].user_name[0],
                                                 "prefix": a.news_list[index].prefix,
                                                 "sufix": a.news_list[index].sufix,
                                                 "user_id":a.news_list[index].user_id[0],
                                                 "time":a.news_list[index].time,
                                                 "title":a.news_list[index].title,
                                                 "type":a.news_list[index].type,
                                                 "id":a.news_list[index].id[0],
                                                 "source_id":a.news_list[index].source_id,
                                                 "owner_id":a.news_list[index].owner_id,
                                                 "owner_name":a.news_list[index].owner_name,
                                              });
                            }
                    }
        }
        SendPost.getNewMessageList(sessionkey, 1, new getMessageList());
    }

    onRedmessage: {
        function readMessage() {}

        readMessage.prototype = {
            update: function(a)
                    {
                        if(a.result == 1)
                        {
                            message.getMessageList();
                            console.log("读消息成功");
                        }
                        else
                        {
                            console.log("读消息失败");
                        }
                    }
        }
        console.log("sourceId = " + sourceId);
        console.log("typeId = " + typeId);
       SendPost.readNewMessage(mainview.sessionkey, sourceId, typeId, new readMessage());
    }

    function loaddata()
    {
        message.state = "guestbook";
        guestbookModel.clear();
        for ( var index in model.news_list)
            {
            console.log("index = " + index);
                guestbookModel.append({
                                 "head_url" : model.news_list[index].head_url[0],
                                 "user_name": model.news_list[index].user_name[0],
                                 "prefix": model.news_list[index].prefix,
                                 "sufix": model.news_list[index].sufix,
                                 "user_id":model.news_list[index].user_id[0],
                                 "time":model.news_list[index].time,
                                 "title":model.news_list[index].title,
                                 "type":model.news_list[index].type,
                                 "id":model.news_list[index].id[0],
                                 "source_id":model.news_list[index].source_id,
                                 "owner_id":model.news_list[index].owner_id,
                                 "owner_name":model.news_list[index].owner_name,
                              });
            }
    }


    onGetBirthdayList: {
        function getBirthdayList(){}

        getBirthdayList.prototype = {
            update:function(a)
                   {
                       interact.closeBusy();

                       message.state = "birthday";

                       if(a.error_msg != undefined)
                       {
                           interact.show(a.error_msg);
                           return;
                       }

                       birthdayModel.clear();
                       for ( var index in a.birthday_list)
                           {
                               birthdayModel.append({
                                                "user_name": a.birthday_list[index].user_name,
                                                "birthday": a.birthday_list[index].birthday,
                                                "head_url": a.birthday_list[index].head_url,
                                                "user_id":a.birthday_list[index].user_id,
                                             });
                           }
                   }
        }

        SendPost.getFriendBirthdayList(sessionkey, new getBirthdayList());
        interact.showBusy("正在加载数据,请稍候...");
    }

    HeadBack{
        id: top
        x : 0
        y : 0
        width: parent.width
        height: 80
        text: "消息"
        onClicked: {
            mainview.state = "";
        }

        onRefresh: {
            if(message.state == "guestbook")
            {
                message.getMessageList();
            }
            else
            {
                message.getBirthdayList();
            }
        }
    }

    Item{
        id: bottomItem
        anchors.bottom: parent.bottom
        width: parent.width
        height: 60

        Image {
            id: bottombg1
            anchors.fill:  parent
            source: "bottombg.png"
        }

        Item
        {
            id: select1
            width: parent.width / 2
            height: parent.height

            MouseArea {
                anchors.fill: select1
                onClicked: {
                   message.state = "guestbook";
                }
            }

            Image {
                id: select11
                anchors.fill:  parent
                source: "select.png"
            }

            Image {
                id: select12
                anchors.centerIn: parent
                source: "focus.png"
            }

            Text {
                id: text13
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "留言"
            }
        }

        Item
        {
            id: select2
            x: select1.width
            width: parent.width / 2
            height: parent.height
            opacity: 1

            MouseArea {
                anchors.fill: select2
                onClicked: {
                    if(message.state != "birthday")
                    {
                        message.getBirthdayList();
                    }
                }
            }

            Image {
                id: select21
                anchors.fill:  parent
                source: "select.png"
            }

            Image {
                id: select22
                anchors.centerIn: parent
                source: "focus.png"
            }

            Text {
                id: text23
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "生日"
            }
        }

        states: [
            State {
                name: "guestbook"
                when: message.state == "guestbook"
                PropertyChanges {target: select11; opacity: 1}
                PropertyChanges {target: select12; opacity: 1}
                PropertyChanges {target: select21; opacity: 0}
                PropertyChanges {target: select22; opacity: 0}
            },
            State {
                name: "birthday"
                when: message.state == "birthday"
                PropertyChanges {target: select11; opacity: 0}
                PropertyChanges {target: select12; opacity: 0}
                PropertyChanges {target: select21; opacity: 1}
                PropertyChanges {target: select22; opacity: 1}
            },
            State {
                name: "init"
                PropertyChanges {target: select11; opacity: 1}
                PropertyChanges {target: select12; opacity: 1}
                PropertyChanges {target: select21; opacity: 0}
                PropertyChanges {target: select22; opacity: 0}
            }
        ]
    }

    Item{
        id : midreplyList

        width: parent.width
        height: parent.height - top.height - bottomItem.height
        y: top.height
        opacity: 0

        ListModel {
            id: birthdayModel
        }

        ListView {
            id: birthdayListView
            anchors.fill: parent
            clip: true
            model: birthdayModel
            delegate: BirthdayListDelegate {
                onClicked: {

                }
            }
        }

    }

    Item{
        id : mid

        width: parent.width
        height: parent.height  - top.height - bottomItem.height
        y: top.height

        ListModel {
            id: guestbookModel
        }

        ListView {
            id: guestbookListView
            anchors.fill: parent
            clip: true
            model: guestbookModel
            delegate: GuestBookListDelegate {
                onClicked: {
                    feedItemClicked(currentItem, type);
                }
                function feedItemClicked(currentItem, type)
                {
                    var id, user_id;
                    function getblogabout(){}
                    function getstatus(){}
                    function getonepicture(){}
                    function getguestbook(){}

                    getguestbook.prototype = {
                        update:function(a)
                               {
                                   guestbookview.model = a;
                                   guestbookview.enter();
                                   message.state = "guest"
                                   interact.closeBusy();
                                   message.redmessage();
//                                   mainview.getNewsCount()
                               }
                    }

                    getonepicture.prototype = {
                        update:function(a)
                               {
                                   pictureview.model = a;
                                   pictureview.enter();
                                   interact.closeBusy();
                                   message.state = "picture";
                                   message.redmessage();
//                                   mainview.getNewsCount()
                               }
                    }

                    getstatus.prototype = {
                        update:function(a)
                               {
                                   statusview.model = a;
                                   statusview.enter();
                                   interact.closeBusy();
                                   message.state = "status";
                                   message.redmessage();
//                                   mainview.getNewsCount()
                               }
                    }

                 getblogabout.prototype = {
                         update:function(a)
                         {
                             blogview.model = a;
                             blogview.enter();
                             interact.closeBusy();
                             message.state = "blog";
                             message.redmessage();
                             mainview.getNewsCount()
                                }
                 }

                    console.log("type = " + type);

                    typeId = "" + type;
                    sourceId = "" + guestbookListView.model.get(currentItem).source_id;
                    console.log("&sourceId = " + sourceId);

                    switch(type)
                    {
                    case 14:
                        user_id = guestbookListView.model.get(currentItem).owner_id;
                        guestbookview.user_id = user_id;
                        console.log("user_id = " + user_id);
                        SendPost.getGuestBook(sessionkey, user_id, new getguestbook());
                        interact.showBusy("正在加载数据,请稍等...");
                        break;
                    case 16:
//                        var headurl = guestbookListView.model.get(currentItem).head_url;
                        var name = guestbookListView.model.get(currentItem).owner_name;
//                        var time = guestbookListView.model.get(currentItem).time;
                        var title = guestbookListView.model.get(currentItem).title;
                        id = guestbookListView.model.get(currentItem).source_id;
                        console.log("*sourceId = " + id);
                        user_id = guestbookListView.model.get(currentItem).owner_id;

                        console.log("message.head_url = " + message.head_url);
                        statusview.headurl = message.head_url;
                        statusview.name = name;
//                        statusview.time = time;
                        statusview.title = title;
                        statusview.statusid = id;
                        statusview.ownerid = user_id;
                        SendPost.getStatusReply(sessionkey, id, user_id, 1, new getstatus());
                        interact.showBusy("正在加载数据,请稍等...");
                        break;
                    case 17:
                        blogview.headurl = message.head_url;
                        blogview.name = guestbookListView.model.get(currentItem).owner_name;

                        id = guestbookListView.model.get(currentItem).source_id;
                        user_id = guestbookListView.model.get(currentItem).owner_id;

                        blogview.id = id;
                        blogview.userid = user_id;

                        console.log("id = " + id);
                        console.log("user_id = " + user_id);
                        SendPost.getBlogAbout(sessionkey, id, user_id,new getblogabout());
                        interact.showBusy("正在加载数据,请稍等...");
                        break;
                    case 18:
                        user_id = guestbookListView.model.get(currentItem).owner_id;
                        var pid = guestbookListView.model.get(currentItem).source_id;
                        pictureview.headurl = message.head_url;
                        pictureview.uid = user_id;
                        pictureview.pid = pid;
                        console.log("user_id = " + user_id);
                        console.log("pid = " + pid);
                        SendPost.getOnePicture(sessionkey, user_id, pid, new getonepicture());
                        interact.showBusy("正在加载数据,请稍等...");
                        break;
                    default:
                        break;
                    }
                }
             }
            }
         }

    StatusView{
        id: statusview
        anchors.fill: parent
        opacity: 0
    }

    BlogView{
        id: blogview
        anchors.fill: parent
        opacity: 0
    }

    PictureView{
        id: pictureview
        anchors.fill: parent
        opacity: 0
    }

    GuestBookView{
        id: guestbookview
        anchors.fill: parent
        opacity: 0
    }

    states: [
        State{
             name: "guestbook"
             PropertyChanges { target: mid; opacity:1; }
             PropertyChanges { target: midreplyList; opacity:0; }
         },
        State{
             name: "birthday"
             PropertyChanges { target: mid; opacity:0; }
             PropertyChanges { target: midreplyList; opacity:1; }
         },
        State {
            name: "status"
            PropertyChanges {target: statusview; opacity: 1;}
            PropertyChanges { target: mid; opacity:0; }
            PropertyChanges { target: midreplyList; opacity:0; }
        },
        State {
            name: "blog"
            PropertyChanges {target: blogview; opacity: 1;}
            PropertyChanges { target: mid; opacity:0; }
            PropertyChanges { target: midreplyList; opacity:0; }
        },
        State {
            name: "picture"
            PropertyChanges {target: pictureview; opacity: 1;}
            PropertyChanges { target: mid; opacity:0; }
            PropertyChanges { target: midreplyList; opacity:0; }
        },
        State {
            name: "guest"
            PropertyChanges {target: guestbookview; opacity: 1;}
            PropertyChanges { target: mid; opacity:0; }
            PropertyChanges { target: midreplyList; opacity:0; }
            PropertyChanges { target: bottomItem; opacity:0; }
        }
    ]

    transitions: Transition {
        NumberAnimation { properties: "x,y,opacity"; duration: 600 }
    }
}
