import Qt 4.7
//import "Public"
import "SendPost.js" as SendPost
import "GetData.js" as GetData
//import com.nokia.meego 1.0

//Page{
//    lockInPortrait: true
//    visible: true
//    status: PageStatus.PageStatus.Active
Item{
    id: root
    width:  480
    height: 800
    property string msg

    function orientationChanged(orientation) {
        if(orientation == 1) {
            form.rotation = 0
            form.width = root.width; form.height = root.height
        }
        else if(orientation == 2) {
            form.rotation = 180
            form.width = root.width; form.height = root.height
        }
        else if(orientation == 3) {
            form.rotation = 270
            form.width = root.height; form.height = root.width
        }
        else if(orientation == 4) {
            form.rotation = 90
            form.width = root.height; form.height = root.width
        }
    }
    MouseArea{
        id:interact
        anchors.fill: parent
        signal show(string msg)
        signal showBusy(string msg)
        signal closeBusy()
    }

    Connections{
        target: interact
        onShow:{
            console.log("msg = " + msg);
            errMsg.text = msg;
            errMsg.state = "enter";
        }
        onShowBusy:{
            busy.text = msg;
            busy.state = "enter";
        }
        onCloseBusy:{
            busy.state = "";
        }
    }

    Item{
        id: form
        width:  root.width
        height: root.height
        anchors.centerIn: parent
        opacity: 1

        property string ticket: ""
        property string sessionkey: ""
        property string uid: ""
        property string secret_key: ""
        property bool isSwitchUser: false
        state: "start"

        Timer{
            id: start
            interval: 2000
            running: true
            repeat: false
            onTriggered: {
                form.state = "loginview";
            }
        }

        Timer{
            id: getlocaldata
            interval: 10
            running: false
            repeat: false
            onTriggered: {
                if(form.isSwitchUser)
                {
                    console.log("clear data");
                    loginView.setusernameText = "";
                    loginView.setpwdText = "";
                }
                else
                {
                    console.log("load data");
                    GetData.createdb();
                    loginView.setusernameText = GetData.getname();
                    loginView.setpwdText = GetData.getpwd();
                }
                running = false;
            }
        }

        Image {
            id: startpicture
            anchors.fill:  parent
            source: "start.png"
        }

        Image {
            id: background
            anchors.fill:  parent
            source: "LoginMidBackground.png"
        }

        Item{
            id: head
            width: parent.width
            height: 80

            Image {
                id: headbg
                anchors.fill:  parent
                source: "headbg.png"
            }

            Image {
                id: logo
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: 20
                source: "LoginLogov.png"
            }

            Text {
                id: username1
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "white"
                font.bold: true
                font.pixelSize: 26
                font.family: "宋体"
                text: "登录"
            }
        }

        Flipable{
                id: flipable
                anchors.centerIn: parent
                width: 386
                height: 226
                opacity: 0

                front:
                LoginView
                {  //initial login view
                id: loginView
                anchors.fill: parent

                onSignbtnClicked: {
                    form.state = "register";
                    register.urlstr = "http://mreg.renren.com/reg/registermobile.do?r=1&from=reg"
                }


                onLoginClicked: {

                    if(loginView.username == "" || loginView.thepwd == "")
                    {
                        interact.show("帐号或密码为空，请重新输入");
                        return;
                    }

                    function requestLogin(){}

                    requestLogin.prototype = {
                        update: function(a)
                        {        
                            interact.closeBusy();

                            console.log(a.error_msg);
                            if(a.error_msg != undefined)
                            {
                                interact.show(a.error_msg);
                            }
                            else
                            {                         
                                GetData.setvalue(loginView.username,loginView.thepwd,a.secret_key);
                                mainview.sessionkey = a.session_key;
                                mainview.ticket = a.ticket;
                                mainview.uid = a.uid;
                                mainview.secret_key = a.secret_key;
                                mainview.username = a.user_name;
                                mainview.head_url = a.head_url;
                                console.log("head_url = " + mainview.head_url);
                                mainview.loginname = loginView.username;
                                mainview.loginpasswd = loginView.thepwd;

                                mainview.loaddata();
                                form.state = "mainview"
                            }
                        }
                    }

                    SendPost.Login(loginView.username, loginView.thepwd,new requestLogin());
                    interact.showBusy("正在登录,请稍候...");
                }
            }
                back: Column {
                    id: errormsgColumn
                    anchors.centerIn: loginView

                    Text{
                        id: errorText
                        clip: true
                        font.pixelSize: 26; font.bold: false; color: "black"; styleColor: "black"
                        font.family: "宋体"

                    }

                    MyButton{
                        id: errorbutton
                        anchors.horizontalCenter: errormsgColumn.horizontalCenter
                        width: 100
                        height: 32
                        opacity: 1
                        text: "返回"
                        onClicked: {
                            flipable.flipped = false;
                        }
                    }
                }
                property int angle: 0
                property bool flipped: false
                transform: Rotation {
                    origin.x: loginView.width/2; origin.y: loginView.height/2
                    axis.x: 0; axis.y: 1; axis.z: 0     // rotate around y-axis
                    angle: flipable.angle
                }
                states: State {
                    name: "back"
                    PropertyChanges { target: flipable; angle: 180 }
                    when: flipable.flipped
                }

                transitions: Transition {
                    NumberAnimation { properties: "angle"; duration: 300 }
                }
        }

        MainView{
            id:mainview
            sessionkey: form.sessionkey
            anchors.fill: parent
            opacity: 0
        }

        Register{
            id: register
            opacity: 0
            anchors.fill: parent
            onClicked:
            {
                form.state = "loginview";
            }
        }

        states: [
            State {
                name: "start";
                PropertyChanges { target: background; opacity: 0;}
                PropertyChanges { target: flipable; opacity: 0;}
                PropertyChanges { target: head; opacity: 0;}
                PropertyChanges { target: register; opacity: 0;}
            },
            State {
                name: "loginview";
                PropertyChanges { target: background; opacity: 1;}
                PropertyChanges { target: flipable; opacity: 1;}
                PropertyChanges { target: startpicture; opacity: 0;}
                PropertyChanges { target: head; opacity: 1;}
                PropertyChanges { target: getlocaldata; running: true}
                PropertyChanges { target: register; opacity: 0;}
            },
            State {
                name: "mainview";
                PropertyChanges { target: background; opacity: 1;}
                PropertyChanges { target: flipable; opacity: 0;}
                PropertyChanges { target: startpicture; opacity: 0;}
                PropertyChanges { target: head; opacity: 0;}
                PropertyChanges { target: mainview; opacity: 1;}
                PropertyChanges { target: register; opacity: 0;}
            },
            State {
                name: "register";
                PropertyChanges { target: background; opacity: 1;}
                PropertyChanges { target: flipable; opacity: 0;}
                PropertyChanges { target: startpicture; opacity: 0;}
                PropertyChanges { target: head; opacity: 0;}
                PropertyChanges { target: register; opacity: 1;}
            }
        ]

        transitions: [
            Transition {
                NumberAnimation { properties: "x,y,opacity"; duration: 600;}
            }
        ]
    }

    Item{
        id: busy
        width:  root.width
        height: root.height
        anchors.centerIn: parent
        property alias text: busytext.text
        opacity: 0
        onOpacityChanged: {
            if(opacity == 0)
            {
                closeMe.stop();
                closeMe.running = false;
            }
        }

        Timer{
           id: closeMe
           interval: 30000
           running: false
           repeat: false
           onTriggered: {
               running = false;
               busy.state = "";
               errMsg.text = "网络超时,请重试";
               errMsg.state = "enter";
           }
        }

        Rectangle{
            id: mask
            anchors.fill: parent
            color: "black"
            opacity: 0.1
        }

        Item{
            id:content
            width:  parent.width - 140
            height: 100
            anchors.centerIn:  parent

            Item{
                id:busybg
                anchors.fill: parent

                Image {
                    id: busyimagebg
                    anchors.fill: parent
                    source: "busybg.png"
                }

                BusyIndicator{
                    id: busyimage
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: 10
                    on: true
                }

                Text {
                    id: busytext
                    x: busyimage.x + busyimage.width + 20
                    width: parent.width - busyimage.width
                    anchors.verticalCenter: parent.verticalCenter
                    elide: Text.ElideRight
                    horizontalAlignment: Text.AlignLeft
                    font.letterSpacing: -1
                    color: "white"
                    style: Text.Raised
                    font.bold: true
                    font.pixelSize: 18
                    font.family: "宋体"
                    text: "数据加载中,请稍候..."
                }
            }
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: busy; opacity:1; }
             PropertyChanges { target: form; enabled:false; }
             PropertyChanges { target: closeMe; running:true; }
             }
        ]
    }

    Item{
        id: errMsg
        width:  root.width
        height: root.height
        anchors.centerIn: parent
        property alias text: errortext.text
        opacity: 0

        Timer{
           id: close
           interval: 3000
           running: false
           repeat: false
           onTriggered: {
               running = false;
               errMsg.state = "";
           }
        }

        Item{
            id:content1
            width:  parent.width - 100
            height: errortext.height + 30
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 100
            anchors.horizontalCenter: parent.horizontalCenter

            Item{
                id:content1dsad
                anchors.fill: parent

                MouseArea{
                    anchors.fill: parent
                    onClicked: {
                        console.log("clicked error");
                    }
                }

                Image {
                    id: errorbg
                    anchors.fill: parent
                    source: "errorbg.png"
                }

                Text {
                    id: errortext
                    width: parent.width
                    anchors.centerIn: parent
                    wrapMode: Text.WrapAnywhere
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    font.letterSpacing: -1
                    color: "white"
                    style: Text.Raised
                    font.bold: true
                    font.pixelSize: 18
                    font.family: "宋体"
                }
            }
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: errMsg; opacity:1; }
             PropertyChanges { target: close; running:true; }
             }
        ]
    }
}
