import Qt 4.7
//import "../Public"
import "SendPost.js" as SendPost

Item {
    id: guestbookItem
    width: parent.width
    height: timetext.y + timetext.height > 80 ? timetext.y + timetext.height + 10: 90

    signal clicked(int currentItem, int type)

    function getText()
    {
        var text;

        switch(type)
        {
        case 14:
            text = user_name + " " + prefix + sufix
            break;
        case 16:
        case 17:
            text = user_name + " " + prefix + sufix + " " + title;
            break;
        case 18:
            text = user_name + " " + prefix + " " + title + " 的" + sufix
            break;
        default:
            break;
        }

        return text;
    }


    BorderImage {
        anchors {
            fill: head
            leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
        }
        source: 'box-shadow.png'; smooth: true
        border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
    }
    Rectangle {
        id: head
        x: 11; y: 15; width: 50; height: 50;
        BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
        Image {
            id: headImage; source: head_url; x: 0; y: 0
            anchors.fill:  parent; clip: true
        }
    }
    Item {
        id: content
        x: 77; y: 15; width: guestbookItem.ListView.view.width - 95;height: contenttext.height
        Text {
            id: contenttext
            text: getText(); color:"black"; wrapMode: Text.WrapAnywhere; width: parent.width;
            font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
            smooth: true;
        }
    }
    Text {
        id: timetext
        text: SendPost.getFullTime(time);
        x: 77
        y: content.y + content.height
        width: parent.width;
        height: 30
        color: "#808080";
   //     horizontalAlignment: Text.AlignRight;
        font.family: "宋体"
        font.pixelSize: 20
    }

    //draw a line
    Rectangle {
        id: lineone
        width: guestbookItem.width; height: 2; color: "#cccccc"
        anchors.bottom: guestbookItem.bottom;
        Image {
            id: lineImage
            anchors.fill: parent
            source: "line.png"
            fillMode: Image.Stretch;
        }
    }

    MouseArea {
        anchors.fill: guestbookItem
        onClicked: {
           guestbookItem.ListView.view.currentIndex = index
           guestbookItem.clicked(index, type)
           console.log(index);
        }
    }
}
