import Qt 4.7
//import "../Public"
//import "../web"
import "SendPost.js" as SendPost
//import com.nokia.meego 1.0

//Page{
//    visible: true
//    status: PageStatus.PageStatus.Active
//    lockInPortrait: true

Item{
    id: friend
    property variant model
    property alias listmodel: friendsModel
    property string sessionkey: ""
    property string uid: ""
    property string username:""
    property string head_url:""

    signal enter;

    signal refreshrequest;

    signal refreshfriends;

    signal getfriendinfo;

    signal getMoreFriends;

    onEnter: {
        friend.state = "allfriend"
        friend.load();
    }

    function load()
    {
        friend.state = "allfriend";

        if(model.error_msg != undefined)
        {
            interact.show(model.error_msg);
        }

        friendsModel.clear();

        replyListView.page = 1;

        for ( var index in model.friend_list)
            {
                friendsModel.append({
                                 "id" : 1000,
                                 "user_id" : model.friend_list[index].user_id,
                                 "head_url" : model.friend_list[index].head_url,
                                 "user_name": model.friend_list[index].user_name,
                                });
            }
        replyListView.count = model.count;

        if(friendsModel.count == 0)
        {
            interact.show("您还没有好友");
        }

        if(model.count > 30)
        {
            friendsModel.append({"id" : 1});
        }
    }

    onRefreshfriends: {
        function getFriends() {}

        getFriends.prototype = {
            update: function(a)
                    {
                        interact.closeBusy();
                        friendsModel.clear();

                        replyListView.page = 1;

                        for ( var index in a.friend_list)
                            {
                                friendsModel.append({
                                                 "id" : 1000,
                                                 "user_id" : a.friend_list[index].user_id,
                                                 "head_url" : a.friend_list[index].head_url,
                                                 "user_name": a.friend_list[index].user_name,
                                                });
                            }
                        replyListView.count = a.count;

                        if(a.count > 30)
                        {
                            friendsModel.append({"id" : 1});
                        }
                    }
        }
        SendPost.getFriends(sessionkey, 1, new getFriends());
    }

    onGetMoreFriends: {
        function getFriends() {}

        getFriends.prototype = {
            update: function(a)
                    {
                        var isHave = 0;
                        interact.closeBusy();

                        for ( var index in a.friend_list)
                            {
                                isHave = 1;
                                friendsModel.insert(friendsModel.count - 1, {
                                                 "id" : 1000,
                                                 "user_id" : a.friend_list[index].user_id,
                                                 "head_url" : a.friend_list[index].head_url,
                                                 "user_name": a.friend_list[index].user_name,
                                                });
                            }

                        if(a.count == (friendsModel.count - 1))
                        {
                            interact.show("没有好友了");
                            friendsModel.remove(friendsModel.count - 1);
                            return;
                        }

                        if(isHave == 1)
                        {
                            replyListView.page++;
                        }
                    }
        }
        SendPost.getFriends(sessionkey, replyListView.page + 1, new getFriends());
    }


    onRefreshrequest: {
        function getRequestList(){}
        getRequestList.prototype = {
            update: function(a)
            {
                        interact.closeBusy();
                        requestfriendsModel.clear();

                        for ( var index in a.friend_apply_list)
                            {
                                requestfriendsModel.append({
                                                 "head_url" : a.friend_apply_list[index].head_url,
                                                 "user_name": a.friend_apply_list[index].user_name,
                                                 "content": a.friend_apply_list[index].content,
                                                 "user_id":a.friend_apply_list[index].user_id,
                                              });
                            }
                     friend.state = "requestfriend"

                     if(requestfriendsModel.count == 0)
                     {
                         interact.show("没有好友请求");
                     }
                    }

            }
        SendPost.getFriendRequest(sessionkey, 1, new getRequestList());
        interact.showBusy("数据加载中,请稍候...");
    }

    onGetfriendinfo: {
        function getFriendInfo(){}
        getFriendInfo.prototype = {
            update: function(a)
            {
                interact.closeBusy();

                if(a.error_msg != undefined)
                {
                    interact.show(a.error_msg);
                }

                userinfoform.frienduid = a.user_id;

                userinfoform.name = a.user_name;
                if(a.gender == undefined)
                {
                    userinfoform.sex = "对方设置为隐私";
                }
                else
                {
                userinfoform.sex  = "" + a.gender;
                if(userinfoform.sex == "1")
                {
                  userinfoform.sex = "男";
                }
                else
                {
                  userinfoform.sex = "女";
                }
                }
                if(a.birth == undefined || a.birth.year == undefined || a.birth.month == undefined || a.birth.day == undefined)
                {
                    userinfoform.birthday = "对方设置为隐私";
                }
                else
                {
                    userinfoform.birthday = a.birth.year + "年" + a.birth.month + "月" + a.birth.day + "日";
                }
                if(a.hometown_province == undefined || a.hometown_city == undefined)
                {
                    userinfoform.home = "对方设置为隐私";
                }
                else
                {
                    userinfoform.home = a.hometown_province + a.hometown_city;
                }
                if(a.network == undefined)
                {
                    userinfoform.network = "对方设置为隐私";
                }
                else
                {
                    userinfoform.network = a.network[0];
                }
                userinfoform.imageurl = a.head_url;
                friend.state = "userinfo"

            }

            }
        SendPost.getFriendInfo(sessionkey, friend.uid, new getFriendInfo());
        console.log("uid1 = " + friend.uid);
    }

    HeadBack{
        id: top
        x : 0
        y : 0
        width: parent.width
        height: 80
        text: "好友"
        onClicked: {
            mainview.state = "";
        }

        onRefresh: {
            if(friend.state == "allfriend")
            {
                interact.showBusy("数据加载中,请稍候...");
                friend.refreshfriends();
            }
            else
            {
                interact.showBusy("数据加载中,请稍候...");
                friend.refreshrequest()
            }
        }
    }

    Item{
        id: bottomItem
        anchors.bottom: parent.bottom
        width: parent.width
        height: 60

        Image {
            id: bottombg1
            anchors.fill:  parent
            source: "bottombg.png"
        }

        Item
        {
            id: select1
            width: parent.width / 2
            height: parent.height

            MouseArea {
                anchors.fill: select1
                onClicked: {
                   friend.state = "allfriend"
                }
            }

            Image {
                id: select11
                anchors.fill:  parent
                source: "select.png"
            }

            Image {
                id: select12
                anchors.centerIn: parent
                source: "focus.png"
            }

            Text {
                id: text13
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "全部好友"
            }
        }

        Item
        {
            id: select2
            x: select1.width
            width: parent.width / 2
            height: parent.height
            opacity: 1

            MouseArea {
                anchors.fill: select2
                onClicked: {
                   friend.refreshrequest();
                }
            }

            Image {
                id: select21
                anchors.fill:  parent
                source: "select.png"
            }

            Image {
                id: select22
                anchors.centerIn: parent
                source: "focus.png"
            }

            Text {
                id: text23
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "好友请求"
            }
        }

        states: [
            State {
                name: "allfriend"
                when: friend.state == "allfriend"
                PropertyChanges {target: select11; opacity: 1}
                PropertyChanges {target: select12; opacity: 1}
                PropertyChanges {target: select21; opacity: 0}
                PropertyChanges {target: select22; opacity: 0}
            },
            State {
                name: "requestfriend"
                when: friend.state == "requestfriend"
                PropertyChanges {target: select11; opacity: 0}
                PropertyChanges {target: select12; opacity: 0}
                PropertyChanges {target: select21; opacity: 1}
                PropertyChanges {target: select22; opacity: 1}
            }
        ]
    }

    Item{
        id : mid

        width: parent.width
        height: parent.height - head.height - bottomItem.height
        y: head.height

        ListModel { id: friendsModel }

        ListView {
            id: replyListView
            anchors.fill: parent
            clip: true
            model: friendsModel
            property int page: 1
            property alias modelcount:friendsModel.count
            property int count;
            delegate: FriendListDelegate {
                onClicked: {
                    console.log("clicked");
                    friend.uid = replyListView.model.get(currentItem).user_id;
                    console.log("uid = " + friend.uid);
                    username = replyListView.model.get(currentItem).user_name;
                    friend.head_url = replyListView.model.get(currentItem).head_url;
                    friend.getfriendinfo();
                }
                onMore:{
                    friend.getMoreFriends();
                }
            }
         }
    }

    Item{
        id : requestlist

        width: parent.width
        height: parent.height - head.height - bottomItem.height
        y: head.height
        opacity: 0

        ListModel { id: requestfriendsModel }

        ListView {
            id: requestListView
            anchors.fill: parent
            clip: true
            model: requestfriendsModel
            delegate: RequestFriendDelegate {
                sessionkey: friend.sessionkey
                onClicked: {
                    friend.refreshrequest();
                }
            }
         }
    }

    Item{
        id: userinfoform
        anchors.fill: parent
        opacity: 0
        property string frienduid:""
        property string name: ""
        property string sex: ""
        property string birthday: ""
        property string home: ""
        property string network: ""
        property string imageurl:""

        Image {
            id: background
            anchors.fill:  parent
            source: "LoginMidBackground.png"
        }

        HeadBack{
            id: userinfotop
            x : 0
            y : 0
            width: parent.width
            height: 80
            text: username
            onClicked: {
                friend.state = "allfriend";
            }

            onRefresh: {
                interact.showBusy("数据加载中,请稍候");
                friend.getfriendinfo();
            }
        }

        Item{
            id: content
            x: 0
            y: userinfotop.height
            width: parent.width
            height: parent.height - userinfotop.height

            Item{
                id: head
                x: 35
                y: 35
                width: 80
                height: 80
                BorderImage {
                    anchors {
                        fill: headrect
                        leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
                    }
                    source: 'headborder.png'; smooth: true
                    border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
                }
                Rectangle {
                    id: headrect
                    anchors.fill: parent
                    BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
                    Image {
                        id: headImage;
                        source: head_url
                        x: 0;
                        y: 0
                        anchors.fill: parent
                        clip: true
                    }
                }
            }

            Text{
                id:name
                text: userinfoform.name
                x: head.x + head.width + 20
                y : head.y
                width: parent.width - x - 10
                font.pixelSize:  26
                elide: Text.ElideRight
                horizontalAlignment: Text.AlignLeft
                color: "#005EAC"
                font.bold: true
                font.family: "宋体"
            }

            MyButton{
                id: message
                x: 0
                y : head.y + head.height + 15
                anchors.horizontalCenter: parent.horizontalCenter
                width: 415
                height: 60
                opacity: 1
                text: "留个言吧"
                textcolor: "black"
                keyUsing: true;
                imagesource: "geitaliuyan.png"
                presssource: "geitaliuyananya.png"
                onClicked: {
                    reply.state = "enter";
                }
            }

            Image {
                id: jibenxinxi
                x: 0
                y: message.y + message.height + 15
                width: parent.width
                height: 60
                smooth: true
                source: "jibenxinxi.png"

                Text{
                    id: jibenxinxitext
                    text: "基本信息"
                    x:26
                    anchors.verticalCenter:  parent.verticalCenter
                    font.pixelSize:  26
                    color: "black"
                    font.bold: true
                    font.family: "宋体"
                }
            }
            Item{
                id:info
                x: 0
                y : jibenxinxi.y + jibenxinxi.height + 8
                height: parent.height-jibenxinxi.height-head.height-name.height
                width: parent.width
            VisualItemModel{
                id:fmodel
            Text{
                id:sex
                text: "性别:  " + userinfoform.sex
                x:26
                height: 40
                font.pixelSize:  20
                verticalAlignment: Text.AlignVCenter
                color: "black"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: line2
                x: 0
                width: view.width
                height: 3
                smooth: true
                source: "line.png"
            }

            Text{
                id:birthday
                text: "生日:  " + userinfoform.birthday
                x:26
                height: 40
                font.pixelSize:  20
                verticalAlignment: Text.AlignVCenter
                color: "black"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: line3
                x: 0
                width: view.width
                height: 3
                smooth: true
                source: "line.png"
            }

            Text{
                id:home
                text: "家乡:  " + userinfoform.home
                x:26
                width: view.width - x
                height: 40
                elide: Text.ElideRight
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                font.pixelSize:  20
                color: "black"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: line4
                x: 0
                width: view.width
                height: 3
                smooth: true
                source: "line.png"
            }

            Text{
                id:network
                text: "大学:  " + userinfoform.network
                x: 26
                font.pixelSize:  20
                width: view.width - x
                height: 40
                elide: Text.ElideRight
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                color: "black"
                font.bold: true
                font.family: "宋体"
            }

            Image {
                id: line5
                x: 0
                width: view.width
                height: 3
                smooth: true
                source: "line.png"
            }
           }
            ListView{
                id: view
                model: fmodel
                anchors.fill: parent
                clip: true
            }
          }
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: userinfoform; opacity:1; }
             PropertyChanges { target: replyListView; enabled: false; }
             }
        ]

        transitions: Transition {
            NumberAnimation { properties: "x,y,opacity"; duration: 600 }
        }
    }

    Reply{
        id: reply
        width: parent.width
        height: parent.height
        anchors.fill: parent
        opacity: 0

        lefttext: "取消"
        midtext:  "留言"
        righttext: "发送"

        onExit:
        {
            reply.state = "";
        }

        onRightbuttonclicked:
        {
            function getMessage(){}
            getMessage.prototype = {
                    update: function(a)
                    {

                                if(a.result == 1)
                                {
                                    reply.success("留言成功");
                                    reply.state = "";
                                }
                                else
                                {
                                    reply.fail(a.error_msg);
                                }
                    }
            }
         SendPost.giveMessageToFriend(sessionkey, uid, inputtext, new getMessage());
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: reply; opacity:1; }
             PropertyChanges { target: replyListView; enabled: false; }
             PropertyChanges { target: bottomItem; opacity: 0; }
             }
        ]

        transitions: Transition {
            NumberAnimation { properties: "x,y,opacity"; duration: 600 }
        }
    }

    states: [
        State{
             name: "allfriend"
             PropertyChanges { target: mid; opacity:1; }
             PropertyChanges { target: requestlist; opacity:0; }
         },
        State{
             name: "requestfriend"
             PropertyChanges { target: mid; opacity:0; }
             PropertyChanges { target: requestlist; opacity:1; }
         },
        State{
             name: "userinfo"
             PropertyChanges { target: top; opacity:0; }
             PropertyChanges { target: mid; opacity:0; }
             PropertyChanges { target: bottomItem; opacity:0; }
             PropertyChanges { target: requestlist; opacity:0;}
             PropertyChanges { target: userinfoform; opacity:1; }
         }
    ]

    transitions: Transition {
        NumberAnimation { properties: "x,y,opacity"; duration: 600 }
    }

}
