import Qt 4.7
//import "../Public"
//import "../web"
import "SendPost.js" as SendPost
//import "common"
//import com.nokia.meego 1.0

//Page{
//    lockInPortrait: true
//    visible: true
//    status: PageStatus.PageStatus.Active

Item{
    id: blogview
    property alias htmlstr: webs.htmlstring

    property string headurl;
    property string name;
    property string title;
    property string id;
    property string userid;
    property string rid: "";
    property string user_name;


    property variant model
    signal enter()
    signal getReplyList;

    onGetReplyList: {
        function getBlogComment(){}

        getBlogComment.prototype = {
                update: function(a)
                {
                            interact.closeBusy();

                            if(a.error_msg != undefined)
                            {
                                interact.show(a.error_msg);
                                return;
                            }

                            replyListView.page = 1;

                            blogReplyModel.clear();
                            for ( var index in a.comment_list)
                                {
                                    blogReplyModel.append({
                                                     "id" : a.comment_list[index].id,
                                                     "head_url" : a.comment_list[index].head_url,
                                                     "user_name": a.comment_list[index].user_name,
                                                     "content": a.comment_list[index].content,
                                                     "time": a.comment_list[index].time,
                                                     "user_id":a.comment_list[index].user_id,
                                                  });
                                }

                            replyListView.count = a.count

                            if(a.count > 20)
                            {
                                blogReplyModel.append({"id":1});
                            }
                        }
        }

        SendPost.getBlogReply(sessionkey, id, userid, 1, new getBlogComment())
        blogview.state = "replylist";
        interact.showBusy("正在加载数据,请稍等...");
    }

    signal getMore;
    onGetMore: {
        function getBlogComment(){}

        getBlogComment.prototype = {
                update: function(a)
                {
                            var isHave = 0;

                            interact.closeBusy();

                            if(a.error_msg != undefined)
                            {
                                interact.show(a.error_msg);
                                return;
                            }

                            for ( var index in a.comment_list)
                                {
                                    isHave = 1;
                                    blogReplyModel.insert(blogReplyModel.count - 1,{
                                                     "id" : a.comment_list[index].id,
                                                     "head_url" : a.comment_list[index].head_url,
                                                     "user_name": a.comment_list[index].user_name,
                                                     "content": a.comment_list[index].content,
                                                     "time": a.comment_list[index].time,
                                                     "user_id":a.comment_list[index].user_id,
                                                  });
                                }

                            if(isHave == 1)
                            {
                                replyListView.page++;
                            }

                            if(a.count == blogReplyModel.count - 1)
                            {
                                blogReplyModel.remove(blogReplyModel.count - 1);
                                return;
                            }

                        }
        }

        SendPost.getBlogReply(sessionkey, id, userid, (replyListView.page + 1), new getBlogComment())
        interact.showBusy("正在加载数据,请稍等...");
    }


    onEnter: {
        loaddata();
    }

    function loaddata()
    {
   //     statusReplyModel.clear();
        blogview.state = "blogcontent";
        title = model.title;
        blogview.htmlstr = SendPost.strSplit(model.content, blogview.width);
    }

    HeadBack{
        id: top
        x : 0
        y : 0
        width: parent.width
        height: 80
        text: "日志"
        showRefresh: blogview.state == "replylist"? 1 : 0
        onClicked: {
            message.state = "";
            message.init();
        }

        onRefresh: {
            blogview.getReplyList();
        }
    }

    Rectangle { //////////////original status
          id: headimg
          x:0
          y:head.height
          width: parent.width;
          height: thestatus.height + 65

          Image {
              anchors.fill: parent
              source: "itembg.png"
          }
          BorderImage {
              anchors {
                  fill: thehead
                  leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
              }
              source: 'box-shadow.png'; smooth: true
              border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
          }
          Item {
              id: thehead
              x: 11; y: 15; width: 50; height: 50;
              BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
              Image {
                  id: headImage;  x: 0; y: 0
                  anchors.fill:  parent; clip: true
                  source: headurl;
              }
          }
          Item {
              id: thenameTime
              x: 77; y: 15; width: parent.width - 95;
              Text {
                  text: name; color: "#005EAC"; wrapMode: Text.WordWrap; width: parent.width; font.family: "宋体";
                  font.bold: true; font.pixelSize: 21
                  smooth: true
              }
          }
          Item {
              id: thestatusFeed;
              x: 77; y: 46; width: parent.width - 95;
              Text {
                  id: thestatus; text: title;
                  color:"black";
                  width: parent.width
                  font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
                  wrapMode: Text.WrapAnywhere;
                  smooth: true
              }
          }
    }

    Item{
        id : mid

        width: parent.width
        height: parent.height - headimg.height - top.height - bottomItem.height
        y: headimg.height + top.height

        Webbrowser{
            id: webs
            anchors.fill: parent
            opacity: 1
        }
    }

    ListModel {
        id: blogReplyModel
    }

    Item{
        id : midreplyList

        width: parent.width
        height: parent.height - headimg.height - top.height - bottomItem.height
        y: headimg.height + top.height

        ListView {
            id: replyListView
            anchors.fill: parent
            clip: true
            model: blogReplyModel
            property int page: 1
            property alias modelcount:blogReplyModel.count
            property int count;
            delegate: BlogReplyDelegate {
                onClicked: {
                    function statusItemClicked(currentItem)
                    {
                        blogview.rid = replyListView.model.get(currentItem).user_id;
                        blogview.user_name = replyListView.model.get(currentItem).user_name;
                        reply.state = "enter";
                    }
                    statusItemClicked(currentItem);
                }
                onMore:{
                    blogview.getMore();
                }
            }
         }
    }

    Item{
        id: bottomItem
        anchors.bottom: parent.bottom
        width: parent.width
        height: 60

        Image {
            id: bottombg1
            anchors.fill:  parent
            source: "bottombg.png"
        }

        Item
        {
            id: select1
            width: parent.width / 3
            height: parent.height
            anchors.left:  parent.left

            MouseArea {
                id: select_1
                anchors.fill: select1
                onClicked: {
                    blogview.state = "blogcontent";
                }
            }

            Image {
                id: select11
                anchors.fill:  parent
                opacity: 0
                source: "select.png"
            }

            Image {
                id: select12
                anchors.centerIn: parent
                opacity: 0
                source: "focus.png"
            }

            Text {
                id: text13
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "日志"
            }
        }

        Item
        {
            id: select2
            x: select1.width
            width: parent.width / 3
            height: parent.height
            anchors.centerIn: parent.Center
            opacity: 1

            MouseArea {
                id: select_2
                anchors.fill: select2
                onClicked: {
                    blogview.getReplyList();
                }
            }

            Image {
                id: select21
                anchors.fill:  parent
                opacity: 0
                source: "select.png"
            }

            Image {
                id: select22
                anchors.centerIn: parent
                opacity: 0
                source: "focus.png"
            }

            Text {
                id: text23
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "回复列表"
            }
        }

        Item
        {
            id: select3
            x: select1.width
            width: parent.width / 3
            height: parent.height
            anchors.right: parent.right
            opacity: 1

            MouseArea {
                id: select_3
                anchors.fill: select3
                onClicked: {
                    blogview.rid = "";
                    reply.state = "enter";
                }
            }

            Image {
                id: select31
                anchors.fill:  parent
                opacity: 0
                source: "select.png"
            }

            Image {
                id: select32
                anchors.centerIn: parent
                opacity: 0
                source: "focus.png"
            }

            Text {
                id: text33
                anchors.centerIn: parent
                font.letterSpacing: -1
                color: "black"
                font.pixelSize: 21
                font.family: "宋体"
                text: "回复"
            }
        }

        states: [
            State {
                name: "blogcontent"
                when: blogview.state == "blogcontent" && select_3.pressed == false
                PropertyChanges {target: select11; opacity: 1}
                PropertyChanges {target: select12; opacity: 1}
                PropertyChanges {target: select21; opacity: 0}
                PropertyChanges {target: select22; opacity: 0}
                PropertyChanges {target: select31; opacity: 0}
                PropertyChanges {target: select32; opacity: 0}
            },
            State {
                name: "replylist"
                when: blogview.state == "replylist" && select_3.pressed == false
                PropertyChanges {target: select11; opacity: 0}
                PropertyChanges {target: select12; opacity: 0}
                PropertyChanges {target: select21; opacity: 1}
                PropertyChanges {target: select22; opacity: 1}
                PropertyChanges {target: select31; opacity: 0}
                PropertyChanges {target: select32; opacity: 0}
            },
            State {
                name: "huifu"
                when: select_3.pressed == true
                PropertyChanges {target: select11; opacity: 0}
                PropertyChanges {target: select12; opacity: 0}
                PropertyChanges {target: select21; opacity: 0}
                PropertyChanges {target: select22; opacity: 0}
                PropertyChanges {target: select31; opacity: 1}
                PropertyChanges {target: select32; opacity: 1}
            }
        ]
    }

    Reply{
        id: reply
        width: parent.width
        height: parent.height
        anchors.fill: parent
        opacity: 0

        lefttext: "取消"
        midtext:  setText()
        righttext: "发送"
        maxtext: 140
        charStep: 1

        onExit:
        {
            reply.state = "";
        }

        function setText()
        {
            var txt = "回复";
            if(statusview.fid == "")
                {
                txt = "回复";
            }
            else
                {
                txt = "回复" + blogview.user_name;
            }
            return txt;
        }

        onRightbuttonclicked:
        {
            function ReplyBlog(){}
            ReplyBlog.prototype = {
                    update: function(a)
                    {

                                if(a.result == 1)
                                {
                                    reply.success("回复成功");
                                    reply.state = "";
                                }
                                else
                                {
                                    if(a.error_msg != undefined)
                                    {
                                        reply.fail(a.error_msg);
                                    }
                                }
                    }
            }
         SendPost.replyBlog(sessionkey, blogview.id ,blogview.userid,blogview.rid, inputtext,new ReplyBlog());
        }

        states: [
            State{
             name: "enter"
             PropertyChanges { target: reply; opacity:1; }
             PropertyChanges { target: replyListView; enabled:false; }
             PropertyChanges { target: midreplyList; opacity: 0; }
             PropertyChanges { target: bottomItem; opacity: 0; }
             PropertyChanges { target: reply; addtext: blogview.rid == ""?"":"回复" + blogview.user_name + ": "}
             }
        ]

        transitions: Transition {
            NumberAnimation { properties: "x,y,opacity"; duration: 600 }
        }
    }

    states: [
        State{
             name: "blogcontent"
             PropertyChanges { target: mid; opacity:1; }
             PropertyChanges { target: midreplyList; opacity:0; }
             PropertyChanges { target: top; text:"日志"; }
         },
        State{
             name: "replylist"
             PropertyChanges { target: mid; opacity:0; }
             PropertyChanges { target: midreplyList; opacity:1; }
             PropertyChanges { target: top; text:"评论"; }
         }
    ]

    transitions: Transition {
        NumberAnimation { properties: "x,y,opacity"; duration: 600 }
    }
}
