import Qt 4.7
//import "../Public"

Item {
    id: birthdayItem
    width: parent.width
    height: 80

    signal clicked(int currentItem)

    BorderImage {
        anchors {
            fill: head
            leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
        }
        source: 'box-shadow.png'; smooth: true
        border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
    }
    Rectangle {
        id: head
        x: 11; y: 15; width: 50; height: 50;
        BusyIndicator { anchors.fill: parent; on: headImage.status != Image.Ready }
        Image {
            id: headImage; source: head_url; x: 0; y: 0
            anchors.fill:  parent; clip: true
        }
    }
    Item {
        id: content
        x: 77; y: 15; width: birthdayItem.ListView.view.width - 95;height: contenttext.height
        Text {
            id: contenttext
            text: user_name; color:"black"; wrapMode: Text.WrapAnywhere; width: parent.width;
            font.bold: false; font.family: "宋体"; font.pixelSize: 21; font.letterSpacing: 1.8;
            smooth: true;
        }
    }
    Text {
        id: timetext
        text: birthday;
        x: 77
        y: content.y + content.height
        width: parent.width;
        height: 30
        color: "#808080";
   //     horizontalAlignment: Text.AlignRight;
        font.family: "宋体"
        font.pixelSize: 20
    }

    //draw a line
    Rectangle {
        id: lineone
        width: birthdayItem.width; height: 2; color: "#cccccc"
        anchors.bottom: birthdayItem.bottom;
        Image {
            id: lineImage
            anchors.fill: parent
            source: "line.png"
            fillMode: Image.Stretch;
        }
    }

    MouseArea {
        anchors.fill: birthdayItem
        onClicked: {
           birthdayItem.ListView.view.currentIndex = index
           birthdayItem.clicked(index)
           console.log(index);
        }
    }
}
