import Qt 4.7
//import "../Public"

Item {
    id: pictureList;
    x: 0
    y: 0
    width: 117; height: 100

    signal clicked(int currentItem)

    MouseArea {
        anchors.fill: pictureList
        onClicked: {
           pictureList.GridView.view.currentIndex = index;
           pictureList.clicked(index);
           console.log(index);
        }
    }

    Item {
        id: photoWrapper

        x: 5; y: 5; width: pictureList.width - 10; height: 80

        BorderImage {
            anchors {
                fill: border.visible ? border : placeHolder
                leftMargin: -6; topMargin: -6; rightMargin: -8; bottomMargin: -8
            }
            source: 'box-shadow.png'; smooth: true
            border.left: 10; border.top: 10; border.right: 10; border.bottom: 10
        }
        Rectangle {
            id: placeHolder

            color: 'white'; anchors.centerIn: parent; smooth: true
            anchors.fill: parent ; visible: originalImage.status != Image.Ready
            Rectangle {
                color: "#878787"; smooth: true
                anchors { fill: parent; topMargin: 3; bottomMargin: 3; leftMargin: 3; rightMargin: 3 }
            }
        }
        Rectangle {
            id: border; color: 'white'; anchors.centerIn: parent; smooth: true
            width: originalImage.paintedWidth + 6; height: originalImage.paintedHeight + 6
            visible: !placeHolder.visible
        }
        BusyIndicator { anchors.centerIn: parent; on: originalImage.status != Image.Ready }
        Image {
            id: originalImage; smooth: true; source: img_head
            anchors.fill: parent; x:0; y:0; width: photoWrapper.width; height: photoWrapper.height
        }
    }
}
