/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import buffertabs.BufferTabs;
import buffertabs.BufferTabsOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;

public class BufferTabsPlugin
extends EBPlugin {
    private static Map<EditPane, BufferTabs> tabsMap = new Hashtable<EditPane, BufferTabs>();
    private static JPopupMenu popupMenu;

    public void handleMessage(EBMessage msg) {
        if (msg instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)msg;
            if (epu.getWhat() == EditPaneUpdate.CREATED) {
                BufferTabsPlugin.editPaneCreated(epu.getEditPane());
            } else if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
                BufferTabsPlugin.editPaneDestroyed(epu.getEditPane());
            }
        } else if (msg instanceof PropertiesChanged) {
            BufferTabsPlugin.propertiesChanged();
        }
    }

    public void stop() {
        jEdit.visit((JEditVisitor)new JEditVisitorAdapter(){

            public void visit(EditPane editPane) {
                BufferTabsPlugin.editPaneDestroyed(editPane);
            }
        });
    }

    public void start() {
        jEdit.visit((JEditVisitor)new JEditVisitorAdapter(){

            public void visit(EditPane editPane) {
                BufferTabsPlugin.editPaneCreated(editPane);
            }
        });
    }

    private static void editPaneCreated(EditPane editPane) {
        if (jEdit.getBooleanProperty((String)"buffertabs.enable", (boolean)false)) {
            BufferTabsPlugin.addBufferTabsToEditPane(editPane);
        }
    }

    private static void editPaneDestroyed(EditPane editPane) {
        BufferTabsPlugin.removeBufferTabsFromEditPane(editPane);
    }

    private static void propertiesChanged() {
        final String location = BufferTabsOptionPane.getLocationProperty("buffertabs.location", "bottom");
        jEdit.visit((JEditVisitor)new JEditVisitorAdapter(){

            public void visit(EditPane editPane) {
                BufferTabs bt = (BufferTabs)tabsMap.get(editPane);
                if (bt != null) {
                    bt.setTabPlacement(location);
                    bt.updateTitles();
                }
            }
        });
    }

    public static BufferTabs getBufferTabsForEditPane(EditPane editPane) {
        return editPane != null ? tabsMap.get(editPane) : null;
    }

    public static void toggleBufferTabsForEditPane(EditPane editPane) {
        boolean vis;
        boolean bl = vis = !tabsMap.containsKey(editPane);
        if (vis) {
            BufferTabsPlugin.addBufferTabsToEditPane(editPane);
        } else {
            BufferTabsPlugin.removeBufferTabsFromEditPane(editPane);
        }
    }

    private static void addBufferTabsToEditPane(EditPane editPane) {
        JEditTextArea ta = editPane.getTextArea();
        Container container = ta.getParent();
        BufferTabs tabs = new BufferTabs(editPane);
        tabs.setTabPlacement(BufferTabsOptionPane.getLocationProperty("buffertabs.location", "bottom"));
        tabs.start();
        container.add(tabs);
        tabsMap.put(editPane, tabs);
    }

    private static void removeBufferTabsFromEditPane(EditPane editPane) {
        Container container;
        JEditTextArea ta = editPane.getTextArea();
        BufferTabs tabs = BufferTabsPlugin.getBufferTabsForEditPane(editPane);
        if (tabs == null) {
            return;
        }
        tabs.stop();
        container.remove(tabs);
        container.add((Component)ta);
        tabsMap.remove(editPane);
        editPane.getBufferSet().removeBufferSetListener((BufferSetListener)tabs);
        for (container = tabs.getParent(); container != null && !(container instanceof JComponent); container = container.getParent()) {
        }
        if (container != null) {
            ((JComponent)container).revalidate();
        }
    }

    protected static JPopupMenu getRightClickPopup() {
        if (popupMenu == null) {
            popupMenu = GUIUtilities.loadPopupMenu((String)"buffertabs.popup");
            return popupMenu;
        }
        return popupMenu;
    }
}

