/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputMethodRequests;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.JEditActionContext;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.DefaultFoldHandlerProvider;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.ExplicitFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.input.DefaultInputHandlerProvider;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.jedit.input.TextAreaInputHandler;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.AntiAlias;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.FastRepaintManager;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.InputMethodSupport;
import org.gjt.sp.jedit.textarea.MouseActions;
import org.gjt.sp.jedit.textarea.ScrollLayout;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.SelectionManager;
import org.gjt.sp.jedit.textarea.StatusListener;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaBorder;
import org.gjt.sp.jedit.textarea.TextAreaDropHandler;
import org.gjt.sp.jedit.textarea.TextAreaException;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.SyntaxUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextArea
extends JComponent {
    public static final int NO_SCROLL = 0;
    public static final int NORMAL_SCROLL = 1;
    public static final int ELECTRIC_SCROLL = 2;
    static TextArea focusedComponent;
    final Segment lineSegment = new Segment();
    MouseInputAdapter mouseHandler;
    final ChunkCache chunkCache;
    final FastRepaintManager repaintMgr;
    DisplayManager displayManager;
    final SelectionManager selectionManager;
    private JEditActionContext<JEditBeanShellAction, JEditActionSet<JEditBeanShellAction>> actionContext;
    boolean bufferChanging;
    int maxHorizontalScrollWidth;
    String wrap;
    boolean hardWrap;
    boolean softWrap;
    boolean wrapToWidth;
    int maxLineLen;
    int wrapMargin;
    float tabSize;
    int charWidth;
    boolean scrollBarsInitialized;
    final Point offsetXY;
    boolean lastLinePartial;
    boolean blink;
    private static final Timer caretTimer;
    private static final Timer structureTimer;
    protected Cursor hiddenCursor;
    private final Gutter gutter;
    protected final TextAreaPainter painter;
    private final EventListenerList listenerList;
    private final MutableCaretEvent caretEvent;
    private boolean caretBlinks;
    private InputHandlerProvider inputHandlerProvider;
    private InputMethodSupport inputMethodSupport;
    private int physLastLine;
    private int screenLastLine;
    private int visibleLines;
    private int electricScroll;
    private int horizontalOffset;
    private boolean quickCopy;
    private final Box verticalBox;
    private final JScrollBar vertical;
    private final JScrollBar horizontal;
    protected JEditBuffer buffer;
    protected int caret;
    protected int caretLine;
    private int caretScreenLine;
    private final List<StructureMatcher> structureMatchers;
    private StructureMatcher.Match match;
    private int magicCaret;
    protected boolean multi;
    private boolean overwrite;
    private boolean rectangularSelectionMode;
    private boolean dndEnabled;
    private boolean dndInProgress;
    private boolean queuedCaretUpdate;
    private int queuedScrollMode;
    private boolean queuedFireCaretEvent;
    private int oldCaretLine;
    private boolean joinNonWordChars;
    private boolean ctrlForRectangularSelection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextArea(IPropertyManager propertyManager, boolean insideJEdit) {
        this(propertyManager, null);
        Font font;
        int defaultFontSize;
        this.actionContext = new JEditActionContext<JEditBeanShellAction, JEditActionSet<JEditBeanShellAction>>(){

            @Override
            public void invokeAction(EventObject evt, JEditBeanShellAction action) {
                action.invoke(TextArea.this);
            }
        };
        this.setMouseHandler(new TextAreaMouseHandler(this));
        TextAreaInputHandler inputHandler = new TextAreaInputHandler(this){

            protected JEditBeanShellAction getAction(String action) {
                return (JEditBeanShellAction)TextArea.this.actionContext.getAction(action);
            }
        };
        this.inputHandlerProvider = new DefaultInputHandlerProvider(inputHandler);
        if (insideJEdit) {
            return;
        }
        if (SyntaxUtilities.propertyManager == null) {
            Properties props;
            block14: {
                props = new Properties();
                InputStream in = TextArea.class.getResourceAsStream("/org/gjt/sp/jedit/jedit.props");
                try {
                    Object var8_7;
                    try {
                        props.load(in);
                    }
                    catch (IOException e) {
                        Log.log(9, TextArea.class, e);
                        var8_7 = null;
                        IOUtilities.closeQuietly(in);
                        break block14;
                    }
                    var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    IOUtilities.closeQuietly(in);
                    throw throwable;
                }
                IOUtilities.closeQuietly(in);
            }
            SyntaxUtilities.propertyManager = new IPropertyManager(){

                public String getProperty(String name) {
                    return props.getProperty(name);
                }
            };
        }
        String defaultFont = SyntaxUtilities.propertyManager.getProperty("view.font");
        try {
            defaultFontSize = Integer.parseInt(SyntaxUtilities.propertyManager.getProperty("view.fontsize"));
        }
        catch (NumberFormatException e) {
            defaultFontSize = 12;
        }
        this.painter.setBlockCaretEnabled(false);
        String name = SyntaxUtilities.propertyManager.getProperty("view.font");
        String family = SyntaxUtilities.propertyManager.getProperty(name);
        String sizeString = SyntaxUtilities.propertyManager.getProperty(name + "size");
        String styleString = SyntaxUtilities.propertyManager.getProperty(name + "style");
        if (family == null || sizeString == null || styleString == null) {
            font = new Font("Monospaced", 0, 12);
        } else {
            int style;
            int size;
            try {
                size = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException nf) {
                size = 12;
            }
            try {
                style = Integer.parseInt(styleString);
            }
            catch (NumberFormatException nf) {
                style = 0;
            }
            font = new Font(family, style, size);
        }
        this.painter.setFont(font);
        this.painter.setStructureHighlightEnabled(true);
        this.painter.setStructureHighlightColor(Color.black);
        this.painter.setEOLMarkersPainted(false);
        this.painter.setEOLMarkerColor(new Color(255, 102, 51));
        this.painter.setWrapGuidePainted(true);
        this.painter.setWrapGuideColor(new Color(125, 125, 255));
        this.painter.setCaretColor(Color.red);
        this.painter.setSelectionColor(new Color(204, 204, 255));
        this.painter.setMultipleSelectionColor(new Color(204, 255, 204));
        this.painter.setBackground(Color.white);
        this.painter.setForeground(Color.black);
        this.painter.setBlockCaretEnabled(false);
        this.painter.setLineHighlightEnabled(true);
        this.painter.setLineHighlightColor(new Color(255, 204, 255));
        this.painter.setAntiAlias(new AntiAlias(0));
        this.painter.setFractionalFontMetricsEnabled(false);
        this.painter.setStyles(SyntaxUtilities.loadStyles(defaultFont, defaultFontSize));
        this.gutter.setExpanded(false);
        this.gutter.setHighlightInterval(5);
        this.gutter.setCurrentLineHighlightEnabled(true);
        this.gutter.setStructureHighlightEnabled(true);
        this.gutter.setStructureHighlightColor(new Color(102, 102, 153));
        this.gutter.setBackground(new Color(219, 219, 219));
        this.gutter.setForeground(Color.black);
        this.gutter.setHighlightedForeground(new Color(153, 0, 102));
        this.gutter.setFoldColor(new Color(131, 131, 131));
        this.gutter.setCurrentLineForeground(new Color(255, 0, 51));
        this.gutter.setLineNumberAlignment(4);
        this.gutter.setFont(new Font("Monospaced", 0, 10));
        this.gutter.setBorder(3, new Color(153, 0, 153), Color.white, this.painter.getBackground());
        this.setCaretBlinkEnabled(true);
        this.setElectricScroll(3);
        DefaultFoldHandlerProvider foldHandlerProvider = new DefaultFoldHandlerProvider();
        FoldHandler.foldHandlerProvider = foldHandlerProvider;
        foldHandlerProvider.addFoldHandler(new ExplicitFoldHandler());
        foldHandlerProvider.addFoldHandler(new IndentFoldHandler());
        foldHandlerProvider.addFoldHandler(new DummyFoldHandler());
        JEditBuffer buffer = new JEditBuffer();
        TokenMarker tokenMarker = new TokenMarker();
        tokenMarker.addRuleSet(new ParserRuleSet("text", "MAIN"));
        buffer.setTokenMarker(tokenMarker);
        this.setBuffer(buffer);
        Mode mode = new Mode("text");
        mode.setTokenMarker(tokenMarker);
        ModeProvider.instance.addMode(mode);
        KillRing.setInstance(new KillRing());
        KillRing.getInstance().propertiesChanged(100);
    }

    public TextArea(IPropertyManager propertyManager, InputHandlerProvider inputHandlerProvider) {
        this.inputHandlerProvider = inputHandlerProvider;
        this.enableEvents(12L);
        this.selectionManager = new SelectionManager(this);
        this.chunkCache = new ChunkCache(this);
        this.painter = new TextAreaPainter(this);
        this.repaintMgr = new FastRepaintManager(this, this.painter);
        this.gutter = new Gutter(this);
        this.gutter.setMouseActionsProvider(new MouseActions(propertyManager, "gutter"));
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.blink = true;
        this.offsetXY = new Point();
        this.structureMatchers = new LinkedList<StructureMatcher>();
        this.structureMatchers.add(new StructureMatcher.BracketMatcher());
        this.setLayout(new ScrollLayout());
        this.add("center", this.painter);
        this.add("left", this.gutter);
        this.verticalBox = new Box(0);
        this.vertical = new JScrollBar(1);
        this.verticalBox.add(this.vertical);
        this.vertical.setRequestFocusEnabled(false);
        this.add("right", this.verticalBox);
        this.horizontal = new JScrollBar(0);
        this.add("bottom", this.horizontal);
        this.horizontal.setRequestFocusEnabled(false);
        this.horizontal.setValues(0, 0, 0, 0);
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            this.setBorder(new TextAreaBorder());
            this.vertical.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
            this.horizontal.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.addFocusListener(new FocusHandler());
        this.addMouseWheelListener(new MouseWheelHandler());
        focusedComponent = this;
    }

    public void setMouseHandler(MouseInputAdapter mouseInputAdapter) {
        this.mouseHandler = mouseInputAdapter;
        this.painter.addMouseListener(this.mouseHandler);
        this.painter.addMouseMotionListener(this.mouseHandler);
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        super.setTransferHandler(newHandler);
        try {
            this.getDropTarget().addDropTargetListener(new TextAreaDropHandler(this));
        }
        catch (TooManyListenersException e) {
            Log.log(9, this, e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("caret: ").append(this.caret).append('\n');
        builder.append("caretLine: ").append(this.caretLine).append('\n');
        builder.append("caretScreenLine: ").append(this.caretScreenLine).append('\n');
        builder.append("electricScroll: ").append(this.electricScroll).append('\n');
        builder.append("horizontalOffset: ").append(this.horizontalOffset).append('\n');
        builder.append("magicCaret: ").append(this.magicCaret).append('\n');
        builder.append("offsetXY").append(this.offsetXY.toString()).append('\n');
        builder.append("oldCaretLine: ").append(this.oldCaretLine).append('\n');
        builder.append("screenLastLine: ").append(this.screenLastLine).append('\n');
        builder.append("visibleLines: ").append(this.visibleLines).append('\n');
        builder.append("firstPhysicalLine: ").append(this.getFirstPhysicalLine()).append('\n');
        builder.append("physLastLine: ").append(this.physLastLine).append('\n');
        return builder.toString();
    }

    public void dispose() {
        DisplayManager.textAreaDisposed(this);
    }

    public AbstractInputHandler getInputHandler() {
        return this.inputHandlerProvider.getInputHandler();
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final Gutter getGutter() {
        return this.gutter;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean caretBlinks) {
        this.caretBlinks = caretBlinks;
        if (!caretBlinks) {
            this.blink = false;
        }
        if (this.buffer != null) {
            this.invalidateLine(this.caretLine);
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int electricScroll) {
        this.electricScroll = electricScroll;
    }

    public final boolean isQuickCopyEnabled() {
        return this.quickCopy;
    }

    public final void setQuickCopyEnabled(boolean quickCopy) {
        this.quickCopy = quickCopy;
    }

    public final JEditBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(JEditBuffer buffer) {
        if (this.buffer == buffer) {
            return;
        }
        try {
            this.bufferChanging = true;
            if (this.buffer != null) {
                if (!buffer.isLoading()) {
                    this.selectNone();
                }
                this.caretScreenLine = 0;
                this.caret = 0;
                this.caretLine = 0;
                this.match = null;
            }
            boolean inCompoundEdit = false;
            if (this.buffer != null) {
                inCompoundEdit = this.buffer.insideCompoundEdit();
            }
            if (inCompoundEdit) {
                this.buffer.endCompoundEdit();
            }
            this.buffer = buffer;
            if (inCompoundEdit) {
                this.buffer.beginCompoundEdit();
            }
            this.chunkCache.setBuffer(buffer);
            this.repaintMgr.setFastScroll(false);
            this.propertiesChanged();
            if (this.displayManager != null) {
                this.displayManager.release();
            }
            this.displayManager = DisplayManager.getDisplayManager(buffer, this);
            this.displayManager.init();
            if (buffer.isLoading()) {
                this.updateScrollBar();
            }
            this.repaint();
            this.fireScrollEvent(true);
            Object var4_3 = null;
            this.bufferChanging = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.bufferChanging = false;
            throw throwable;
        }
    }

    public final boolean isEditable() {
        return this.buffer.isEditable();
    }

    @Deprecated
    public boolean isDragInProgress() {
        return this.dndInProgress;
    }

    @Deprecated
    public void setDragInProgress(boolean dndInProgress) {
        this.dndInProgress = dndInProgress;
    }

    public boolean isDragEnabled() {
        return this.dndEnabled;
    }

    public void setDragEnabled(boolean dndEnabled) {
        this.dndEnabled = dndEnabled;
    }

    public boolean getJoinNonWordChars() {
        return this.joinNonWordChars;
    }

    public void setJoinNonWordChars(boolean joinNonWordChars) {
        this.joinNonWordChars = joinNonWordChars;
    }

    public boolean isCtrlForRectangularSelection() {
        return this.ctrlForRectangularSelection;
    }

    public void setCtrlForRectangularSelection(boolean ctrlForRectangularSelection) {
        this.ctrlForRectangularSelection = ctrlForRectangularSelection;
    }

    public final int getFirstLine() {
        return this.displayManager.firstLine.scrollLine + this.displayManager.firstLine.skew;
    }

    public void setFirstLine(int firstLine) {
        int oldFirstLine;
        int max = this.displayManager.getScrollLineCount() - this.visibleLines + (this.lastLinePartial ? 1 : 0);
        if (firstLine > max) {
            firstLine = max;
        }
        if (firstLine < 0) {
            firstLine = 0;
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstLine() from " + this.getFirstLine() + " to " + firstLine);
        }
        if (firstLine == (oldFirstLine = this.getFirstLine())) {
            return;
        }
        this.displayManager.setFirstLine(oldFirstLine, firstLine);
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getFirstPhysicalLine() {
        return this.displayManager.firstLine.physicalLine;
    }

    public void setFirstPhysicalLine(int physFirstLine) {
        this.setFirstPhysicalLine(physFirstLine, 0);
    }

    public void setFirstPhysicalLine(int physFirstLine, int skew) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstPhysicalLine(" + physFirstLine + ',' + skew + ')');
        }
        int amount = physFirstLine - this.displayManager.firstLine.physicalLine;
        this.displayManager.setFirstPhysicalLine(amount, skew);
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getLastPhysicalLine() {
        return this.physLastLine;
    }

    public int getLastScreenLine() {
        return this.screenLastLine;
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        if (horizontalOffset > 0) {
            horizontalOffset = 0;
        }
        if (horizontalOffset == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = horizontalOffset;
        this.painter.repaint();
        this.fireScrollEvent(false);
    }

    public void scrollUpLine() {
        this.setFirstLine(this.getFirstLine() - 1);
    }

    public void scrollUpPage() {
        this.setFirstLine(this.getFirstLine() - this.getVisibleLines() + (this.lastLinePartial ? 1 : 0));
    }

    public void scrollDownLine() {
        this.setFirstLine(this.getFirstLine() + 1);
    }

    public void scrollDownPage() {
        this.setFirstLine(this.getFirstLine() + this.getVisibleLines() - (this.lastLinePartial ? 1 : 0));
    }

    public void scrollToCaret(boolean doElectricScroll) {
        this.scrollTo(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), doElectricScroll);
    }

    public void scrollTo(int offset, boolean doElectricScroll) {
        int line = this.buffer.getLineOfOffset(offset);
        this.scrollTo(line, offset - this.buffer.getLineStartOffset(line), doElectricScroll);
    }

    public void scrollTo(int line, int offset, boolean doElectricScroll) {
        int _electricScroll;
        int extraEndVirt;
        int lineLength;
        if (Debug.SCROLL_TO_DEBUG) {
            Log.log(1, this, "scrollTo(), lineCount=" + this.getLineCount());
        }
        if (offset > (lineLength = this.buffer.getLineLength(line))) {
            extraEndVirt = this.charWidth * (offset - lineLength);
            offset = lineLength;
        } else {
            extraEndVirt = 0;
        }
        int n = _electricScroll = doElectricScroll && this.visibleLines - 1 > this.electricScroll << 1 ? this.electricScroll : 0;
        if (this.visibleLines <= 1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "visibleLines <= 0");
            }
            this.setFirstPhysicalLine(line, _electricScroll);
            return;
        }
        int screenLine = this.chunkCache.getScreenLineOfOffset(line, offset);
        int visibleLines = this.getVisibleLines();
        if (screenLine == -1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "screenLine == -1");
            }
            ChunkCache.LineInfo[] infos = this.chunkCache.getLineInfosForPhysicalLine(line);
            int subregion = ChunkCache.getSubregionOfOffset(offset, infos);
            int prevLine = this.displayManager.getPrevVisibleLine(this.getFirstPhysicalLine());
            int nextLine = this.displayManager.getNextVisibleLine(this.getLastPhysicalLine());
            if (line == this.getFirstPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + this.getFirstPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion - _electricScroll);
            } else if (line == prevLine) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + prevLine);
                }
                this.setFirstPhysicalLine(prevLine, subregion - _electricScroll);
            } else if (line == this.getLastPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion + _electricScroll - visibleLines + (this.lastLinePartial ? 2 : 1));
            } else if (line == nextLine) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, line + " == " + nextLine);
                }
                this.setFirstPhysicalLine(nextLine, subregion + _electricScroll - visibleLines + (this.lastLinePartial ? 2 : 1));
            } else {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "neither");
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(line, subregion - (visibleLines >> 1));
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
            }
        } else if (screenLine < _electricScroll) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric up");
            }
            this.setFirstLine(this.getFirstLine() - _electricScroll + screenLine);
        } else if (screenLine > visibleLines - _electricScroll - (this.lastLinePartial ? 2 : 1)) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric down");
            }
            this.setFirstLine(this.getFirstLine() + _electricScroll - visibleLines + screenLine + (this.lastLinePartial ? 2 : 1));
        }
        if (!this.displayManager.isLineVisible(line)) {
            return;
        }
        Point point = this.offsetToXY(line, offset, this.offsetXY);
        point.x += extraEndVirt;
        if (point.x < 0) {
            this.setHorizontalOffset(this.horizontalOffset - point.x + this.charWidth + 5);
        } else if (point.x >= this.painter.getWidth() - this.charWidth - 5) {
            this.setHorizontalOffset(this.horizontalOffset + (this.painter.getWidth() - point.x) - this.charWidth - 5);
        }
    }

    public final void addScrollListener(ScrollListener listener) {
        this.listenerList.add(ScrollListener.class, listener);
    }

    public final void removeScrollListener(ScrollListener listener) {
        this.listenerList.remove(ScrollListener.class, listener);
    }

    public int getPhysicalLineOfScreenLine(int screenLine) {
        return this.chunkCache.getLineInfo((int)screenLine).physicalLine;
    }

    public int getScreenLineOfOffset(int offset) {
        int line = this.buffer.getLineOfOffset(offset);
        return this.chunkCache.getScreenLineOfOffset(line, offset -= this.buffer.getLineStartOffset(line));
    }

    public int getScreenLineStartOffset(int line) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(line);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset;
    }

    public int getScreenLineEndOffset(int line) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(line);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset + lineInfo.length;
    }

    public int xyToOffset(int x, int y) {
        return this.xyToOffset(x, y, true);
    }

    public int xyToOffset(int x, int y, boolean round) {
        FontMetrics fm = this.painter.getFontMetrics();
        int height = fm.getHeight();
        int line = y / height;
        if (line < 0 || line >= this.visibleLines) {
            return -1;
        }
        return this.xToScreenLineOffset(line, x, round);
    }

    public int xToScreenLineOffset(int screenLine, int x, boolean round) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(screenLine);
        if (lineInfo.physicalLine == -1) {
            return this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        }
        int offset = Chunk.xToOffset(lineInfo.chunks, x - this.horizontalOffset, round);
        if (offset == -1 || offset == lineInfo.offset + lineInfo.length) {
            offset = lineInfo.offset + lineInfo.length - 1;
        }
        return this.getLineStartOffset(lineInfo.physicalLine) + offset;
    }

    public Point offsetToXY(int offset) {
        int line = this.buffer.getLineOfOffset(offset);
        Point retVal = new Point();
        return this.offsetToXY(line, offset -= this.buffer.getLineStartOffset(line), retVal);
    }

    public Point offsetToXY(int line, int offset) {
        return this.offsetToXY(line, offset, new Point());
    }

    public Point offsetToXY(int line, int offset, Point retVal) {
        if (!this.displayManager.isLineVisible(line)) {
            return null;
        }
        int screenLine = this.chunkCache.getScreenLineOfOffset(line, offset);
        if (screenLine == -1) {
            return null;
        }
        FontMetrics fm = this.painter.getFontMetrics();
        retVal.y = screenLine * fm.getHeight();
        ChunkCache.LineInfo info = this.chunkCache.getLineInfo(screenLine);
        retVal.x = (int)((float)this.horizontalOffset + Chunk.offsetToX(info.chunks, offset));
        return retVal;
    }

    public void invalidateScreenLineRange(int start, int end) {
        if (this.buffer.isLoading()) {
            return;
        }
        if (start > end) {
            int tmp = end;
            end = start;
            start = tmp;
        }
        if (this.chunkCache.needFullRepaint()) {
            end = this.visibleLines;
        }
        FontMetrics fm = this.painter.getFontMetrics();
        int y = start * fm.getHeight();
        int height = (end - start + 1) * fm.getHeight();
        this.painter.repaint(0, y, this.painter.getWidth(), height);
        this.gutter.repaint(0, y, this.gutter.getWidth(), height);
    }

    public void invalidateLine(int line) {
        if (!this.isShowing() || this.buffer.isLoading() || line < this.getFirstPhysicalLine() || line > this.physLastLine || !this.displayManager.isLineVisible(line)) {
            return;
        }
        int startLine = -1;
        int endLine = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if ((info.physicalLine >= line || info.physicalLine == -1) && startLine == -1) {
                startLine = i;
            }
            if ((info.physicalLine < line || !info.lastSubregion) && info.physicalLine != -1) continue;
            endLine = i;
            break;
        }
        if (this.chunkCache.needFullRepaint() || endLine == -1) {
            endLine = this.visibleLines;
        }
        this.invalidateScreenLineRange(startLine, endLine);
    }

    public void invalidateLineRange(int start, int end) {
        if (!this.isShowing() || this.buffer.isLoading()) {
            return;
        }
        if (end < start) {
            int tmp = end;
            end = start;
            start = tmp;
        }
        if (end < this.getFirstPhysicalLine() || start > this.getLastPhysicalLine()) {
            return;
        }
        int startScreenLine = -1;
        int endScreenLine = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if ((info.physicalLine >= start || info.physicalLine == -1) && startScreenLine == -1) {
                startScreenLine = i;
            }
            if ((info.physicalLine < end || !info.lastSubregion) && info.physicalLine != -1) continue;
            endScreenLine = i;
            break;
        }
        if (startScreenLine == -1) {
            startScreenLine = 0;
        }
        if (this.chunkCache.needFullRepaint() || endScreenLine == -1) {
            endScreenLine = this.visibleLines;
        }
        this.invalidateScreenLineRange(startScreenLine, endScreenLine);
    }

    public final int getBufferLength() {
        return this.buffer.getLength();
    }

    public final int getLineCount() {
        return this.buffer.getLineCount();
    }

    public final int getLineOfOffset(int offset) {
        return this.buffer.getLineOfOffset(offset);
    }

    public int getLineStartOffset(int line) {
        return this.buffer.getLineStartOffset(line);
    }

    public int getLineEndOffset(int line) {
        return this.buffer.getLineEndOffset(line);
    }

    public int getLineLength(int line) {
        return this.buffer.getLineLength(line);
    }

    public final String getText(int start, int len) {
        return this.buffer.getText(start, len);
    }

    public final void getText(int start, int len, Segment segment) {
        this.buffer.getText(start, len, segment);
    }

    public final String getLineText(int lineIndex) {
        return this.buffer.getLineText(lineIndex);
    }

    public final void getLineText(int lineIndex, Segment segment) {
        this.buffer.getLineText(lineIndex, segment);
    }

    public String getText() {
        return this.buffer.getText(0, this.buffer.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.remove(0, this.buffer.getLength());
            this.buffer.insert(0, text);
            Object var3_2 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
    }

    public final void selectAll() {
        int firstLine = this.getFirstLine();
        int horizOffset = this.getHorizontalOffset();
        this.setSelection(new Selection.Range(0, this.buffer.getLength()));
        this.moveCaretPosition(this.buffer.getLength(), true);
        this.setFirstLine(firstLine);
        this.setHorizontalOffset(horizOffset);
    }

    public void selectLine() {
        int caretLine = this.getCaretLine();
        int start = this.getLineStartOffset(caretLine);
        int end = this.getLineEndOffset(caretLine) - 1;
        Selection.Range s = new Selection.Range(start, end);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(end);
    }

    public void selectParagraph() {
        int start;
        int caretLine = this.getCaretLine();
        if (this.getLineLength(caretLine) == 0) {
            this.getToolkit().beep();
            return;
        }
        int end = caretLine;
        for (start = caretLine; start >= 0 && this.getLineLength(start) != 0; --start) {
        }
        while (end < this.getLineCount() && this.getLineLength(end) != 0) {
            ++end;
        }
        int selectionStart = this.getLineStartOffset(start + 1);
        int selectionEnd = this.getLineEndOffset(end - 1) - 1;
        Selection.Range s = new Selection.Range(selectionStart, selectionEnd);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(selectionEnd);
    }

    public void selectWord() {
        int line = this.getCaretLine();
        int lineStart = this.getLineStartOffset(line);
        int offset = this.getCaretPosition() - lineStart;
        if (this.getLineLength(line) == 0) {
            return;
        }
        String lineText = this.getLineText(line);
        String noWordSep = this.buffer.getStringProperty("noWordSep");
        if (offset == this.getLineLength(line)) {
            --offset;
        }
        int wordStart = TextUtilities.findWordStart(lineText, offset, noWordSep, true, false, false);
        int wordEnd = TextUtilities.findWordEnd(lineText, offset + 1, noWordSep, true, false, false);
        Selection.Range s = new Selection.Range(lineStart + wordStart, lineStart + wordEnd);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(lineStart + wordEnd);
    }

    public Selection selectToMatchingBracket(int position, boolean quickCopy) {
        int bracket;
        int positionLine = this.buffer.getLineOfOffset(position);
        int lineOffset = position - this.buffer.getLineStartOffset(positionLine);
        if (this.getLineLength(positionLine) != 0 && (bracket = TextUtilities.findMatchingBracket(this.buffer, positionLine, Math.max(0, lineOffset - 1))) != -1) {
            Selection.Range s;
            if (bracket < position) {
                if (!quickCopy) {
                    this.moveCaretPosition(position, false);
                }
                s = new Selection.Range(bracket, position);
            } else {
                if (!quickCopy) {
                    this.moveCaretPosition(bracket + 1, false);
                }
                s = new Selection.Range(position - 1, bracket + 1);
            }
            if (!this.multi && !quickCopy) {
                this.selectNone();
            }
            this.addToSelection(s);
            return s;
        }
        return null;
    }

    public void selectToMatchingBracket() {
        this.selectToMatchingBracket(this.caret, false);
    }

    public void selectBlock() {
        char c;
        int start;
        int end;
        Selection s = this.getSelectionAtOffset(this.caret);
        if (s == null) {
            start = end = this.caret;
        } else {
            start = s.start;
            end = s.end;
        }
        String text = this.getText(0, this.buffer.getLength());
        if (start == 0) {
            this.getToolkit().beep();
            return;
        }
        String openBrackets = "([{";
        String closeBrackets = ")]}";
        int count = 1;
        char openBracket = '\u0000';
        char closeBracket = '\u0000';
        while (--start > 0) {
            c = text.charAt(start);
            int index = openBrackets.indexOf(c);
            if (index != -1) {
                if (--count != 0) continue;
                openBracket = c;
                closeBracket = closeBrackets.charAt(index);
                break;
            }
            if (closeBrackets.indexOf(c) == -1) continue;
            ++count;
        }
        count = 1;
        if (openBracket == '\u0000') {
            this.getToolkit().beep();
            return;
        }
        do {
            if ((c = text.charAt(end)) == closeBracket) {
                if (--count != 0) continue;
                ++end;
                break;
            }
            if (c != openBracket) continue;
            ++count;
        } while (++end < this.buffer.getLength());
        s = new Selection.Range(start, end);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(end);
    }

    public boolean lineInStructureScope(int line) {
        if (this.match == null) {
            return false;
        }
        if (this.match.startLine < this.caretLine) {
            return line >= this.match.startLine && line <= this.caretLine;
        }
        return line <= this.match.endLine && line >= this.caretLine;
    }

    public final void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    public Selection[] getSelection() {
        return this.selectionManager.getSelection();
    }

    public Iterator<Selection> getSelectionIterator() {
        return this.selectionManager.selection.iterator();
    }

    public Selection getSelection(int index) {
        return this.selectionManager.selection.get(index);
    }

    public void selectNone() {
        this.invalidateSelectedLines();
        this.setSelection((Selection)null);
    }

    public void setSelection(Selection[] selection) {
        this.invalidateSelectedLines();
        this.selectionManager.setSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void setSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selectionManager.setSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void addToSelection(Selection[] selection) {
        this.invalidateSelectedLines();
        this.selectionManager.addToSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void addToSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selectionManager.addToSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public Selection getSelectionAtOffset(int offset) {
        return this.selectionManager.getSelectionAtOffset(offset);
    }

    public void removeFromSelection(Selection sel) {
        this.invalidateSelectedLines();
        this.selectionManager.removeFromSelection(sel);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void removeFromSelection(int offset) {
        Selection sel = this.getSelectionAtOffset(offset);
        if (sel == null) {
            return;
        }
        this.invalidateSelectedLines();
        this.selectionManager.removeFromSelection(sel);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void resizeSelection(int offset, int end, int extraEndVirt, boolean rect) {
        Selection s = this.selectionManager.getSelectionAtOffset(offset);
        if (s != null) {
            this.invalidateLineRange(s.startLine, s.endLine);
            this.selectionManager.removeFromSelection(s);
        }
        this.selectionManager.resizeSelection(offset, end, extraEndVirt, rect);
        this.fireCaretEvent();
    }

    public void extendSelection(int offset, int end) {
        this.extendSelection(offset, end, 0, 0);
    }

    public void extendSelection(int offset, int end, int extraStartVirt, int extraEndVirt) {
        Selection s = this.getSelectionAtOffset(offset);
        if (s != null) {
            this.invalidateLineRange(s.startLine, s.endLine);
            this.selectionManager.removeFromSelection(s);
            if (offset == s.start) {
                offset = end;
                end = s.end;
            } else if (offset == s.end) {
                offset = s.start;
            }
        }
        if (end < offset) {
            int tmp = end;
            end = offset;
            offset = tmp;
        }
        if (this.rectangularSelectionMode) {
            s = new Selection.Rect(offset, end);
            ((Selection.Rect)s).extraStartVirt = extraStartVirt;
            ((Selection.Rect)s).extraEndVirt = extraEndVirt;
        } else {
            s = new Selection.Range(offset, end);
        }
        this.selectionManager.addToSelection(s);
        this.fireCaretEvent();
        if (this.rectangularSelectionMode && extraEndVirt != 0) {
            int line = this.getLineOfOffset(end);
            this.scrollTo(line, this.getLineLength(line) + extraEndVirt, false);
        }
    }

    public String getSelectedText(Selection s) {
        StringBuilder buf = new StringBuilder(s.end - s.start);
        s.getText(this.buffer, buf);
        return buf.toString();
    }

    public String getSelectedText(String separator) {
        Selection[] sel = this.selectionManager.getSelection();
        if (sel.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < sel.length; ++i) {
            if (i != 0) {
                buf.append(separator);
            }
            sel[i].getText(this.buffer, buf);
        }
        return buf.toString();
    }

    public String getSelectedText() {
        return this.getSelectedText("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedText(Selection s, String selectedText) {
        if (!this.isEditable()) {
            throw new InternalError("Text component read only");
        }
        try {
            this.buffer.beginCompoundEdit();
            this.moveCaretPosition(s.setText(this.buffer, selectedText));
            Object var4_3 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
    }

    public void setSelectedText(String selectedText) {
        int newCaret = this.replaceSelection(selectedText);
        if (newCaret != -1) {
            this.moveCaretPosition(newCaret);
        }
        this.selectNone();
    }

    public void setSelectedText(String selectedText, boolean moveCaret) {
        int newCaret = this.replaceSelection(selectedText);
        if (moveCaret && newCaret != -1) {
            this.moveCaretPosition(newCaret);
        }
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int replaceSelection(String selectedText) {
        if (!this.isEditable()) {
            throw new RuntimeException("Text component read only");
        }
        int newCaret = -1;
        if (this.getSelectionCount() == 0) {
            this.buffer.insert(this.caret, selectedText);
        } else {
            try {
                this.buffer.beginCompoundEdit();
                Selection[] selection = this.getSelection();
                for (int i = 0; i < selection.length; ++i) {
                    newCaret = selection[i].setText(this.buffer, selectedText);
                }
                Object var6_5 = null;
                this.buffer.endCompoundEdit();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.buffer.endCompoundEdit();
                throw throwable;
            }
        }
        return newCaret;
    }

    public int[] getSelectedLines() {
        if (this.selectionManager.getSelectionCount() == 0) {
            return new int[]{this.caretLine};
        }
        return this.selectionManager.getSelectedLines();
    }

    public boolean caretAutoScroll() {
        return focusedComponent == this;
    }

    public void addStructureMatcher(StructureMatcher matcher) {
        this.structureMatchers.add(matcher);
    }

    public void removeStructureMatcher(StructureMatcher matcher) {
        this.structureMatchers.remove(matcher);
    }

    public StructureMatcher.Match getStructureMatch() {
        return this.match;
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.invalidateLine(this.caretLine);
        } else {
            this.blink = true;
        }
    }

    public void centerCaret() {
        int offset = this.getScreenLineStartOffset(this.visibleLines >> 1);
        if (offset == -1) {
            this.getToolkit().beep();
        } else {
            this.setCaretPosition(offset);
        }
    }

    public void scrollAndCenterCaret() {
        if (!this.getDisplayManager().isLineVisible(this.getCaretLine())) {
            this.getDisplayManager().expandFold(this.getCaretLine(), true);
        }
        int physicalLine = this.getCaretLine();
        int midPhysicalLine = this.getPhysicalLineOfScreenLine(this.visibleLines >> 1);
        int diff = physicalLine - midPhysicalLine;
        this.setFirstLine(this.getFirstLine() + diff);
        this.requestFocus();
    }

    public void setCaretPosition(int newCaret) {
        this.selectNone();
        this.moveCaretPosition(newCaret, true);
    }

    public void setCaretPosition(int newCaret, boolean doElectricScroll) {
        this.selectNone();
        this.moveCaretPosition(newCaret, doElectricScroll);
    }

    public void moveCaretPosition(int newCaret) {
        this.moveCaretPosition(newCaret, true);
    }

    public void moveCaretPosition(int newCaret, boolean doElectricScroll) {
        this.moveCaretPosition(newCaret, doElectricScroll ? 2 : 1);
    }

    public void moveCaretPosition(int newCaret, int scrollMode) {
        if (newCaret < 0 || newCaret > this.buffer.getLength()) {
            throw new IllegalArgumentException("caret out of bounds: " + newCaret);
        }
        int oldCaretLine = this.caretLine;
        if (this.caret == newCaret) {
            this.finishCaretUpdate(oldCaretLine, scrollMode, false);
        } else {
            this.caret = newCaret;
            this.caretLine = this.getLineOfOffset(newCaret);
            this.magicCaret = -1;
            this.finishCaretUpdate(oldCaretLine, scrollMode, true);
        }
    }

    public int getCaretPosition() {
        return this.caret;
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public int getMagicCaretPosition() {
        if (this.magicCaret == -1) {
            this.magicCaret = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        }
        return this.magicCaret;
    }

    public void setMagicCaretPosition(int magicCaret) {
        this.magicCaret = magicCaret;
    }

    public final void addCaretListener(CaretListener listener) {
        this.listenerList.add(CaretListener.class, listener);
    }

    public final void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(CaretListener.class, listener);
    }

    public void goToNextBracket(boolean select) {
        int newCaret = -1;
        if (this.caret != this.buffer.getLength()) {
            String text = this.getText(this.caret, this.buffer.getLength() - this.caret - 1);
            block3: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case ')': 
                    case ']': 
                    case '}': {
                        newCaret = this.caret + i + 1;
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
        }
        if (newCaret == -1) {
            this.getToolkit().beep();
        } else {
            if (select) {
                this.extendSelection(this.caret, newCaret);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(newCaret);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void goToNextCharacter(boolean select) {
        int newCaret;
        int extraEndVirt;
        int extraStartVirt;
        block17: {
            block19: {
                Selection s;
                block18: {
                    s = this.getSelectionAtOffset(this.caret);
                    if (!select && s instanceof Selection.Range) {
                        if (!this.multi) {
                            this.setCaretPosition(s.end);
                            return;
                        }
                        if (this.caret != s.end) {
                            this.moveCaretPosition(s.end);
                            return;
                        }
                    }
                    if (s instanceof Selection.Rect) {
                        extraStartVirt = ((Selection.Rect)s).extraStartVirt;
                        extraEndVirt = ((Selection.Rect)s).extraEndVirt;
                    } else {
                        extraStartVirt = 0;
                        extraEndVirt = 0;
                    }
                    newCaret = this.caret;
                    if (this.caret != this.buffer.getLength()) break block18;
                    if (select && (this.rectangularSelectionMode || s instanceof Selection.Rect)) {
                        if (s != null && this.caret == s.start) {
                            ++extraStartVirt;
                            break block17;
                        } else {
                            ++extraEndVirt;
                        }
                        break block17;
                    } else {
                        this.getToolkit().beep();
                        return;
                    }
                }
                if (this.caret != this.getLineEndOffset(this.caretLine) - 1) break block19;
                if (select && (this.rectangularSelectionMode || s instanceof Selection.Rect)) {
                    if (s != null && this.caret == s.start) {
                        ++extraStartVirt;
                        break block17;
                    } else {
                        ++extraEndVirt;
                    }
                    break block17;
                } else {
                    int line = this.displayManager.getNextVisibleLine(this.caretLine);
                    if (line == -1) {
                        this.getToolkit().beep();
                        return;
                    }
                    newCaret = this.getLineStartOffset(line);
                }
                break block17;
            }
            newCaret = this.caret + 1;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToNextLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        boolean rectSelect = s == null ? this.rectangularSelectionMode : s instanceof Selection.Rect;
        int magic = this.getMagicCaretPosition();
        int newCaret = this.chunkCache.getBelowPosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), magic + 1, rectSelect && select);
        if (newCaret == -1) {
            int end = this.getLineEndOffset(this.caretLine) - 1;
            if (this.caret == end) {
                this.getToolkit().beep();
                return;
            }
            newCaret = end;
        }
        this._changeLine(select, newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextPage(boolean select) {
        int newCaret;
        this.scrollToCaret(false);
        int magic = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() + this.getVisibleLines() >= this.displayManager.getScrollLineCount()) {
            int lastVisibleLine = this.displayManager.getLastVisibleLine();
            newCaret = this.getLineEndOffset(lastVisibleLine) - 1;
        } else {
            int caretScreenLine = this.getScreenLineOfOffset(this.caret);
            this.scrollDownPage();
            newCaret = this.xToScreenLineOffset(caretScreenLine, magic, true);
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret, false);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextParagraph(boolean select) {
        int lineNo = this.getCaretLine();
        int newCaret = this.getBufferLength();
        boolean foundBlank = false;
        block3: for (int i = lineNo + 1; i < this.getLineCount(); ++i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, this.lineSegment);
            block4: for (int j = 0; j < this.lineSegment.count; ++j) {
                switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!foundBlank) continue block3;
                        newCaret = this.getLineStartOffset(i);
                        break block3;
                    }
                }
            }
            foundBlank = true;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToNextWord(boolean select) {
        this.goToNextWord(select, false);
    }

    public void goToNextWord(boolean select, boolean eatWhitespace) {
        String lineText;
        int lineStart = this.getLineStartOffset(this.caretLine);
        int newCaret = this.caret - lineStart;
        if (newCaret == (lineText = this.getLineText(this.caretLine)).length()) {
            int nextLine = this.displayManager.getNextVisibleLine(this.caretLine);
            if (nextLine == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineStartOffset(nextLine);
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            boolean camelCasedWords = this.buffer.getBooleanProperty("camelCasedWords");
            newCaret = TextUtilities.findWordEnd(lineText, newCaret + 1, noWordSep, true, camelCasedWords, eatWhitespace);
            newCaret += lineStart;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevBracket(boolean select) {
        String text = this.getText(0, this.caret);
        int newCaret = -1;
        block3: for (int i = this.getCaretPosition() - 1; i >= 0; --i) {
            switch (text.charAt(i)) {
                case '(': 
                case '[': 
                case '{': {
                    newCaret = i;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (newCaret == -1) {
            this.getToolkit().beep();
        } else {
            if (select) {
                this.extendSelection(this.caret, newCaret);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(newCaret);
        }
    }

    public void goToPrevCharacter(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        if (this.caret == 0) {
            this.getToolkit().beep();
            return;
        }
        if (!select && s instanceof Selection.Range) {
            if (this.multi) {
                if (this.caret != s.start) {
                    this.moveCaretPosition(s.start);
                    return;
                }
            } else {
                this.setCaretPosition(s.start);
                return;
            }
        }
        int extraStartVirt = 0;
        int extraEndVirt = 0;
        int newCaret = this.caret;
        if (select && this.caret == this.getLineEndOffset(this.caretLine) - 1) {
            if (s instanceof Selection.Rect) {
                extraStartVirt = ((Selection.Rect)s).extraStartVirt;
                extraEndVirt = ((Selection.Rect)s).extraEndVirt;
                if (this.caret == s.start) {
                    if (extraStartVirt == 0) {
                        newCaret = this.caret - 1;
                    } else {
                        --extraStartVirt;
                    }
                } else if (extraEndVirt == 0) {
                    newCaret = this.caret - 1;
                } else {
                    --extraEndVirt;
                }
            } else {
                newCaret = this.caret - 1;
            }
        } else if (this.caret == this.getLineStartOffset(this.caretLine)) {
            int line = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (line == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineEndOffset(line) - 1;
        } else {
            newCaret = this.caret - 1;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        boolean rectSelect = s == null ? this.rectangularSelectionMode : s instanceof Selection.Rect;
        int magic = this.getMagicCaretPosition();
        int newCaret = this.chunkCache.getAbovePosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), magic + 1, rectSelect && select);
        if (newCaret == -1) {
            int start = this.getLineStartOffset(this.caretLine);
            if (this.caret == start) {
                this.getToolkit().beep();
                return;
            }
            newCaret = start;
        }
        this._changeLine(select, newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevPage(boolean select) {
        int newCaret;
        this.scrollToCaret(false);
        int magic = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() == 0) {
            int firstVisibleLine = this.displayManager.getFirstVisibleLine();
            newCaret = this.getLineStartOffset(firstVisibleLine);
        } else {
            int caretScreenLine = this.getScreenLineOfOffset(this.caret);
            this.scrollUpPage();
            newCaret = this.xToScreenLineOffset(caretScreenLine, magic, true);
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret, false);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevParagraph(boolean select) {
        int lineNo = this.caretLine;
        int newCaret = 0;
        boolean foundBlank = false;
        block3: for (int i = lineNo - 1; i >= 0; --i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, this.lineSegment);
            block4: for (int j = 0; j < this.lineSegment.count; ++j) {
                switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!foundBlank) continue block3;
                        newCaret = this.getLineEndOffset(i) - 1;
                        break block3;
                    }
                }
            }
            foundBlank = true;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToPrevWord(boolean select) {
        this.goToPrevWord(select, false);
    }

    public void goToPrevWord(boolean select, boolean eatWhitespace) {
        int lineStart = this.getLineStartOffset(this.caretLine);
        int newCaret = this.caret - lineStart;
        String lineText = this.getLineText(this.caretLine);
        if (newCaret == 0) {
            if (lineStart == 0) {
                this.getToolkit().beep();
                return;
            }
            int prevLine = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (prevLine == -1) {
                this.getToolkit().beep();
                return;
            }
            newCaret = this.getLineEndOffset(prevLine) - 1;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            boolean camelCasedWords = this.buffer.getBooleanProperty("camelCasedWords");
            newCaret = TextUtilities.findWordStart(lineText, newCaret - 1, noWordSep, true, camelCasedWords, eatWhitespace);
            newCaret += lineStart;
        }
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void smartHome(boolean select) {
        switch (this.getInputHandler().getLastActionCount()) {
            case 1: {
                this.goToStartOfWhiteSpace(select);
                break;
            }
            case 2: {
                this.goToStartOfLine(select);
                break;
            }
            default: {
                this.goToFirstVisibleLine(select);
            }
        }
    }

    public void smartEnd(boolean select) {
        switch (this.getInputHandler().getLastActionCount()) {
            case 1: {
                this.goToEndOfWhiteSpace(select);
                break;
            }
            case 2: {
                this.goToEndOfLine(select);
                break;
            }
            default: {
                this.goToLastVisibleLine(select);
            }
        }
    }

    public void goToStartOfLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        int line = select || s == null ? this.caretLine : s.startLine;
        int newCaret = this.getLineStartOffset(line);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToEndOfLine(boolean select) {
        Selection s = this.getSelectionAtOffset(this.caret);
        int line = select || s == null ? this.caretLine : s.endLine;
        int newCaret = this.getLineEndOffset(line) - 1;
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    public void goToStartOfWhiteSpace(boolean select) {
        int offset;
        int line;
        Selection s = this.getSelectionAtOffset(this.caret);
        if (select || s == null) {
            line = this.caretLine;
            offset = this.caret - this.buffer.getLineStartOffset(line);
        } else {
            line = s.startLine;
            offset = s.start - this.buffer.getLineStartOffset(line);
        }
        int firstIndent = this.chunkCache.getSubregionStartOffset(line, offset);
        if (firstIndent == this.getLineStartOffset(line)) {
            firstIndent = StandardUtilities.getLeadingWhiteSpace(this.getLineText(line));
            if (firstIndent == this.getLineLength(line)) {
                firstIndent = 0;
            }
            firstIndent += this.getLineStartOffset(line);
        }
        if (select) {
            this.extendSelection(this.caret, firstIndent);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(firstIndent);
    }

    public void goToEndOfWhiteSpace(boolean select) {
        int offset;
        int line;
        Selection s = this.getSelectionAtOffset(this.caret);
        if (select || s == null) {
            line = this.caretLine;
            offset = this.caret - this.getLineStartOffset(line);
        } else {
            line = s.endLine;
            offset = s.end - this.getLineStartOffset(line);
        }
        int lastIndent = this.chunkCache.getSubregionEndOffset(line, offset);
        if (lastIndent == this.getLineEndOffset(line)) {
            lastIndent = this.getLineLength(line) - StandardUtilities.getTrailingWhiteSpace(this.getLineText(line));
            if (lastIndent == 0) {
                lastIndent = this.getLineLength(line);
            }
            lastIndent += this.getLineStartOffset(line);
        } else {
            --lastIndent;
        }
        if (select) {
            this.extendSelection(this.caret, lastIndent);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(lastIndent);
    }

    public void goToFirstVisibleLine(boolean select) {
        int firstVisibleLine = this.getFirstLine() == 0 ? 0 : this.electricScroll;
        int firstVisible = this.getScreenLineStartOffset(firstVisibleLine);
        if (firstVisible == -1) {
            firstVisible = this.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        }
        if (select) {
            this.extendSelection(this.caret, firstVisible);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(firstVisible);
    }

    public void goToLastVisibleLine(boolean select) {
        int lastVisible;
        if (this.getFirstLine() + this.visibleLines >= this.displayManager.getScrollLineCount()) {
            lastVisible = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        } else {
            lastVisible = this.visibleLines - this.electricScroll - 1;
            if (this.lastLinePartial) {
                --lastVisible;
            }
            if (lastVisible < 0) {
                lastVisible = 0;
            }
            if ((lastVisible = this.getScreenLineEndOffset(lastVisible) - 1) == -1) {
                lastVisible = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
            }
        }
        if (select) {
            this.extendSelection(this.caret, lastVisible);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(lastVisible);
    }

    public void goToBufferStart(boolean select) {
        int start = this.buffer.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        if (select) {
            this.extendSelection(this.caret, start);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(start);
    }

    public void goToBufferEnd(boolean select) {
        int end = this.buffer.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        if (select) {
            this.extendSelection(this.caret, end);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(end);
    }

    public void goToMatchingBracket() {
        int dot;
        int bracket;
        if (this.getLineLength(this.caretLine) != 0 && (bracket = TextUtilities.findMatchingBracket(this.buffer, this.caretLine, Math.max(0, (dot = this.caret - this.getLineStartOffset(this.caretLine)) - 1))) != -1) {
            this.selectNone();
            this.moveCaretPosition(bracket + 1, false);
            return;
        }
        this.getToolkit().beep();
    }

    public void userInput(char ch) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.hiddenCursor != null) {
            this.getPainter().setCursor(this.hiddenCursor);
        }
        switch (ch) {
            case '\t': {
                this.userInputTab();
                break;
            }
            case '\b': {
                this.backspace();
                break;
            }
            case '\u007f': {
                this.delete();
                break;
            }
            default: {
                boolean indent = this.buffer.isElectricKey(ch, this.caretLine);
                String str = String.valueOf(ch);
                if (this.getSelectionCount() == 0) {
                    if (this.doWordWrap(ch == ' ')) break;
                    this.insert(str, indent);
                    break;
                }
                this.replaceSelection(str);
            }
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean overwrite) {
        this.blink = true;
        caretTimer.restart();
        this.overwrite = overwrite;
        this.invalidateLine(this.caretLine);
        this.fireStatusChanged(0, overwrite);
    }

    public final void toggleOverwriteEnabled() {
        this.setOverwriteEnabled(!this.overwrite);
    }

    public void backspace() {
        this.delete(false);
    }

    public void backspaceWord() {
        this.backspaceWord(false);
    }

    public void backspaceWord(boolean eatWhitespace) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            this.setSelectedText("");
            return;
        }
        int lineStart = this.getLineStartOffset(this.caretLine);
        int _caret = this.caret - lineStart;
        String lineText = this.getLineText(this.caretLine);
        if (_caret == 0) {
            if (lineStart == 0) {
                this.getToolkit().beep();
                return;
            }
            --_caret;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            boolean camelCasedWords = this.buffer.getBooleanProperty("camelCasedWords");
            _caret = TextUtilities.findWordStart(lineText, _caret - 1, noWordSep, true, camelCasedWords, eatWhitespace);
        }
        this.buffer.remove(_caret + lineStart, this.caret - (_caret + lineStart));
    }

    public void delete() {
        this.delete(true);
    }

    public void deleteToEndOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.caret, this.getLineEndOffset(this.caretLine) - this.caret - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLine() {
        int offset;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        int[] lines = this.getSelectedLines();
        try {
            this.buffer.beginCompoundEdit();
            for (int i = lines.length - 1; i >= 0; --i) {
                int start = this.getLineStartOffset(lines[i]);
                int end = this.getLineEndOffset(lines[i]);
                if (end > this.buffer.getLength()) {
                    if (start != 0) {
                        --start;
                    }
                    --end;
                }
                this.buffer.remove(start, end - start);
            }
            Object var7_6 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
        int lastLine = this.displayManager.getLastVisibleLine();
        if (this.caretLine == lastLine) {
            offset = this.chunkCache.xToSubregionOffset(lastLine, 0, x, true);
            this.setCaretPosition(this.buffer.getLineStartOffset(lastLine) + offset);
        } else {
            offset = this.chunkCache.xToSubregionOffset(this.caretLine, 0, x, true);
            this.setCaretPosition(this.getLineStartOffset(this.caretLine) + offset);
        }
    }

    public void deleteParagraph() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int start = 0;
        for (int i = this.caretLine - 1; i >= 0; --i) {
            if (!this.lineContainsSpaceAndTabs(i)) continue;
            start = this.getLineStartOffset(i);
            break;
        }
        int end = this.buffer.getLength();
        for (int i = this.caretLine + 1; i < this.getLineCount(); ++i) {
            if (!this.lineContainsSpaceAndTabs(i)) continue;
            end = this.getLineEndOffset(i) - 1;
            break;
        }
        this.buffer.remove(start, end - start);
    }

    public void deleteToStartOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.getLineStartOffset(this.caretLine), this.caret - this.getLineStartOffset(this.caretLine));
    }

    public void deleteWord() {
        this.deleteWord(false);
    }

    public void deleteWord(boolean eatWhitespace) {
        String lineText;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            this.setSelectedText("");
            return;
        }
        int lineStart = this.getLineStartOffset(this.caretLine);
        int _caret = this.caret - lineStart;
        if (_caret == (lineText = this.getLineText(this.caretLine)).length()) {
            if (lineStart + _caret == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            ++_caret;
        } else {
            String noWordSep = this.buffer.getStringProperty("noWordSep");
            boolean camelCasedWords = this.buffer.getBooleanProperty("camelCasedWords");
            _caret = TextUtilities.findWordEnd(lineText, _caret + 1, noWordSep, true, camelCasedWords, eatWhitespace);
        }
        this.buffer.remove(this.caret, _caret + lineStart - this.caret);
    }

    public final boolean isMultipleSelectionEnabled() {
        return this.multi;
    }

    public final void toggleMultipleSelectionEnabled() {
        this.setMultipleSelectionEnabled(!this.multi);
    }

    public final void setMultipleSelectionEnabled(boolean multi) {
        this.multi = multi;
        this.fireStatusChanged(1, multi);
        this.painter.repaint();
    }

    public final boolean isRectangularSelectionEnabled() {
        return this.rectangularSelectionMode;
    }

    public final void toggleRectangularSelectionEnabled() {
        this.setRectangularSelectionEnabled(!this.rectangularSelectionMode);
        if (this.getSelectionCount() == 1) {
            Selection s = this.getSelection(0);
            this.removeFromSelection(s);
            if (this.rectangularSelectionMode) {
                this.addToSelection(new Selection.Rect(s.getStart(), s.getEnd()));
            } else {
                this.addToSelection(new Selection.Range(s.getStart(), s.getEnd()));
            }
        }
    }

    public final void setRectangularSelectionEnabled(boolean rectangularSelectionMode) {
        this.rectangularSelectionMode = rectangularSelectionMode;
        this.fireStatusChanged(2, rectangularSelectionMode);
        this.painter.repaint();
    }

    public void goToParentFold() {
        int line = -1;
        int level = this.buffer.getFoldLevel(this.caretLine);
        for (int i = this.caretLine - 1; i >= 0; --i) {
            if (this.buffer.getFoldLevel(i) >= level) continue;
            line = i;
            break;
        }
        if (line == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, magic + 1, true);
        if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToNextFold(boolean select) {
        int nextFold = -1;
        for (int i = this.caretLine + 1; i < this.buffer.getLineCount(); ++i) {
            if (!this.buffer.isFoldStart(i) || !this.displayManager.isLineVisible(i)) continue;
            nextFold = i;
            break;
        }
        if (nextFold == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(nextFold) + this.chunkCache.xToSubregionOffset(nextFold, 0, magic + 1, true);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void goToPrevFold(boolean select) {
        int prevFold = -1;
        for (int i = this.caretLine - 1; i >= 0; --i) {
            if (!this.buffer.isFoldStart(i) || !this.displayManager.isLineVisible(i)) continue;
            prevFold = i;
            break;
        }
        if (prevFold == -1) {
            this.getToolkit().beep();
            return;
        }
        int magic = this.getMagicCaretPosition();
        int newCaret = this.buffer.getLineStartOffset(prevFold) + this.chunkCache.xToSubregionOffset(prevFold, 0, magic + 1, true);
        if (select) {
            this.extendSelection(this.caret, newCaret);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
        this.setMagicCaretPosition(magic);
    }

    public void collapseFold() {
        this.collapseFold(this.caretLine);
    }

    public void collapseFold(int line) {
        int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        this.displayManager.collapseFold(line);
        if (this.displayManager.isLineVisible(this.caretLine)) {
            return;
        }
        line = this.displayManager.getPrevVisibleLine(this.caretLine);
        if (!this.multi) {
            this.invalidateSelectedLines();
            this.selectionManager.setSelection((Selection)null);
        }
        this.moveCaretPosition(this.buffer.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, x, true));
    }

    public void expandFold(boolean fully) {
        int x = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        int line = this.displayManager.expandFold(this.caretLine, fully);
        if (!fully && line != -1) {
            if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(this.getLineStartOffset(line) + this.chunkCache.xToSubregionOffset(line, 0, x, true));
        }
    }

    public void selectFold() {
        this.selectFold(this.caretLine);
    }

    public void selectFold(int line) {
        int[] lines = this.buffer.getFoldAtLine(line);
        int newCaret = this.getLineEndOffset(lines[1]) - 1;
        Selection.Range s = new Selection.Range(this.getLineStartOffset(lines[0]), newCaret);
        if (this.multi) {
            this.addToSelection(s);
        } else {
            this.setSelection(s);
        }
        this.moveCaretPosition(newCaret);
    }

    public void narrowToFold() {
        int[] lines = this.buffer.getFoldAtLine(this.caretLine);
        if (lines[0] == 0 && lines[1] == this.buffer.getLineCount() - 1) {
            this.getToolkit().beep();
        } else {
            this.displayManager.narrow(lines[0], lines[1]);
        }
    }

    public void narrowToSelection() {
        if (this.getSelectionCount() != 1) {
            this.getToolkit().beep();
            return;
        }
        Selection sel = this.getSelection(0);
        this.displayManager.narrow(sel.getStartLine(), sel.getEndLine());
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitFold() throws TextAreaException {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (!this.buffer.getStringProperty("folding").equals("explicit")) {
            throw new TextAreaException("folding-not-explicit");
        }
        try {
            this.buffer.beginCompoundEdit();
            if (this.getSelectionCount() == 0) {
                this.addExplicitFold(this.caret, this.caret, this.caretLine, this.caretLine);
            } else {
                Selection[] selections = this.getSelection();
                Selection selection = null;
                int caretBack = 0;
                for (int i = 0; i < selections.length; ++i) {
                    selection = selections[i];
                    caretBack = this.addExplicitFold(selection.start, selection.end, selection.startLine, selection.endLine);
                }
                assert (selection != null);
                this.setCaretPosition(selection.start - caretBack, false);
            }
            Object var6_5 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineComment() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        String comment = this.buffer.getContextSensitiveProperty(this.caret, "lineComment");
        if (comment == null || comment.length() == 0) {
            this.rangeLineComment();
            return;
        }
        comment = comment + ' ';
        this.buffer.beginCompoundEdit();
        int[] lines = this.getSelectedLines();
        try {
            for (int i = 0; i < lines.length; ++i) {
                String text = this.getLineText(lines[i]);
                this.buffer.insert(this.getLineStartOffset(lines[i]) + StandardUtilities.getLeadingWhiteSpace(text), comment);
            }
            Object var6_5 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rangeComment() {
        String commentStart = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String commentEnd = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (!this.buffer.isEditable() || commentStart == null || commentEnd == null || commentStart.length() == 0 || commentEnd.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        commentStart = commentStart + ' ';
        commentEnd = ' ' + commentEnd;
        try {
            this.buffer.beginCompoundEdit();
            Selection[] selection = this.getSelection();
            if (selection.length == 0) {
                int oldCaret = this.caret;
                this.buffer.insert(this.caret, commentStart);
                this.buffer.insert(this.caret, commentEnd);
                this.setCaretPosition(oldCaret + commentStart.length());
            }
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                if (s instanceof Selection.Range) {
                    this.buffer.insert(s.start, commentStart);
                    this.buffer.insert(s.end, commentEnd);
                    continue;
                }
                if (!(s instanceof Selection.Rect)) continue;
                Selection.Rect rect = (Selection.Rect)s;
                int start = rect.getStartColumn(this.buffer);
                int end = rect.getEndColumn(this.buffer);
                for (int j = s.startLine; j <= s.endLine; ++j) {
                    this.buffer.insertAtColumn(j, end, commentEnd);
                    this.buffer.insertAtColumn(j, start, commentStart);
                }
            }
            this.selectNone();
            Object var11_10 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatParagraph() throws TextAreaException {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.maxLineLen <= 0) {
            throw new TextAreaException("format-maxlinelen");
        }
        Selection[] selection = this.getSelection();
        if (selection.length != 0) {
            this.buffer.beginCompoundEdit();
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.format(this.getSelectedText(s), this.maxLineLen, this.buffer.getTabSize()));
            }
            this.buffer.endCompoundEdit();
        } else {
            int i;
            int lineNo = this.getCaretLine();
            int start = 0;
            int end = this.buffer.getLength();
            for (i = lineNo - 1; i >= 0; --i) {
                if (!this.lineContainsSpaceAndTabs(i)) continue;
                start = this.getLineEndOffset(i);
                break;
            }
            for (i = lineNo + 1; i < this.getLineCount(); ++i) {
                if (!this.lineContainsSpaceAndTabs(i)) continue;
                end = this.getLineStartOffset(i) - 1;
                break;
            }
            try {
                this.buffer.beginCompoundEdit();
                String text = this.buffer.getText(start, end - start);
                int offset = this.getCaretPosition() - start;
                int noSpaceOffset = TextUtilities.indexIgnoringWhitespace(text, offset);
                this.buffer.remove(start, end - start);
                text = TextUtilities.format(text, this.maxLineLen, this.buffer.getTabSize());
                this.buffer.insert(start, text);
                int caretPos = start;
                if (text.length() != 0) {
                    caretPos += Math.min(text.length(), TextUtilities.ignoringWhitespaceIndex(text, noSpaceOffset));
                }
                this.moveCaretPosition(caretPos);
                Object var10_12 = null;
                this.buffer.endCompoundEdit();
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.buffer.endCompoundEdit();
                throw throwable;
            }
        }
    }

    public void spacesToTabs() {
        Selection[] selection = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selection.length == 0) {
            this.setText(TextUtilities.spacesToTabs(this.getText(), this.buffer.getTabSize()));
        } else {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.spacesToTabs(this.getSelectedText(s), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void tabsToSpaces() {
        Selection[] selection = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selection.length == 0) {
            this.setText(TextUtilities.tabsToSpaces(this.getText(), this.buffer.getTabSize()));
        } else {
            for (int i = 0; i < selection.length; ++i) {
                Selection s = selection[i];
                this.setSelectedText(s, TextUtilities.tabsToSpaces(this.getSelectedText(s), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void toUpperCase() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        Selection[] selection = this.getSelection();
        int caret = -1;
        if (selection.length == 0) {
            caret = this.getCaretPosition();
            this.selectWord();
            selection = this.getSelection();
        }
        if (selection.length == 0) {
            if (caret != -1) {
                this.setCaretPosition(caret);
            }
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (int i = 0; i < selection.length; ++i) {
            Selection s = selection[i];
            this.setSelectedText(s, this.getSelectedText(s).toUpperCase());
        }
        this.buffer.endCompoundEdit();
        if (caret != -1) {
            this.setCaretPosition(caret);
        }
    }

    public void toLowerCase() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        Selection[] selection = this.getSelection();
        int caret = -1;
        if (selection.length == 0) {
            caret = this.getCaretPosition();
            this.selectWord();
            selection = this.getSelection();
        }
        if (selection.length == 0) {
            if (caret != -1) {
                this.setCaretPosition(caret);
            }
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (int i = 0; i < selection.length; ++i) {
            Selection s = selection[i];
            this.setSelectedText(s, this.getSelectedText(s).toLowerCase());
        }
        this.buffer.endCompoundEdit();
        if (caret != -1) {
            this.setCaretPosition(caret);
        }
    }

    public void removeTrailingWhiteSpace() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.removeTrailingWhiteSpace(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEnterAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
        } else {
            try {
                this.buffer.beginCompoundEdit();
                this.setSelectedText("\n");
                this.buffer.indentLine(this.caretLine, true);
                Object var2_1 = null;
                this.buffer.endCompoundEdit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.buffer.endCompoundEdit();
                throw throwable;
            }
        }
    }

    public void insertTabAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() == 0) {
            int whiteSpace;
            CharSequence text = this.buffer.getLineSegment(this.caretLine);
            int start = this.buffer.getLineStartOffset(this.caretLine);
            if (this.caret - start <= (whiteSpace = StandardUtilities.getLeadingWhiteSpace(text)) && this.buffer.indentLine(this.caretLine, false)) {
                return;
            }
        }
        this.userInput('\t');
    }

    public void indentSelectedLines() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.indentLines(this.getSelectedLines());
            this.selectNone();
        }
    }

    public void shiftIndentLeft() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentLeft(this.getSelectedLines());
        }
    }

    public void shiftIndentRight() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentRight(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinLines() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            this.buffer.beginCompoundEdit();
            boolean doneForSelection = false;
            for (Selection selection : this.selectionManager.getSelection()) {
                while (selection.startLine < selection.endLine) {
                    this.joinLineAt(selection.endLine - 1);
                    doneForSelection = true;
                }
            }
            if (!doneForSelection) {
                int end = this.getLineEndOffset(this.caretLine);
                if (end > this.buffer.getLength()) {
                    this.getToolkit().beep();
                    Object var7_7 = null;
                    this.buffer.endCompoundEdit();
                    return;
                }
                this.joinLineAt(this.caretLine);
                if (!this.multi) {
                    this.selectNone();
                }
                this.moveCaretPosition(end - 1);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
        Object var7_8 = null;
        this.buffer.endCompoundEdit();
    }

    public void addLeftOfScrollBar(Component comp) {
        this.verticalBox.add(comp, 0);
    }

    public void removeLeftOfScrollBar(Component comp) {
        this.verticalBox.remove(comp);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this.painter);
        ToolTipManager.sharedInstance().registerComponent(this.gutter);
        this.recalculateVisibleLines();
        if (!this.buffer.isLoading()) {
            this.recalculateLastPhysicalLine();
        }
        this.propertiesChanged();
        this.hiddenCursor = this.getToolkit().createCustomCursor(this.getGraphicsConfiguration().createCompatibleImage(16, 16, 2), new Point(0, 0), "Hidden");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this.painter);
        ToolTipManager.sharedInstance().unregisterComponent(this.gutter);
        if (focusedComponent == this) {
            focusedComponent = null;
        }
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean getFocusCycleRoot() {
        return true;
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        this.getInputHandler().processKeyEvent(evt, 1, false);
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void addTopComponent(Component comp) {
        this.add("top", comp);
    }

    public void removeTopComponent(Component comp) {
        this.remove(comp);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodSupport == null) {
            this.inputMethodSupport = new InputMethodSupport(this);
            Log.log(1, this, "InputMethodSupport is activated");
        }
        return this.inputMethodSupport;
    }

    public final void addStatusListener(StatusListener listener) {
        this.listenerList.add(StatusListener.class, listener);
    }

    public final void removeStatusListener(StatusListener listener) {
        this.listenerList.remove(StatusListener.class, listener);
    }

    public void propertiesChanged() {
        boolean wrapSettingsChanged;
        if (this.buffer == null) {
            return;
        }
        int _tabSize = this.buffer.getTabSize();
        char[] foo = new char[_tabSize];
        for (int i = 0; i < foo.length; ++i) {
            foo[i] = 32;
        }
        this.tabSize = this.painter.getStringWidth(new String(foo));
        this.charWidth = (int)Math.round(this.painter.getFont().getStringBounds(foo, 0, 1, this.painter.getFontRenderContext()).getWidth());
        String oldWrap = this.wrap;
        this.wrap = this.buffer.getStringProperty("wrap");
        this.hardWrap = this.wrap.equals("hard");
        this.softWrap = this.wrap.equals("soft");
        boolean oldWrapToWidth = this.wrapToWidth;
        int oldWrapMargin = this.wrapMargin;
        this.setMaxLineLength(this.buffer.getIntegerProperty("maxLineLen", 0));
        boolean bl = wrapSettingsChanged = !this.wrap.equals(oldWrap) || oldWrapToWidth != this.wrapToWidth || oldWrapMargin != this.wrapMargin;
        if (this.displayManager != null && !this.bufferChanging && !this.buffer.isLoading() && wrapSettingsChanged) {
            this.displayManager.invalidateScreenLineCounts();
            this.displayManager.notifyScreenLineChanges();
        }
        this.repaintMgr.setFastScroll(false);
        this.chunkCache.invalidateAll();
        this.gutter.repaint();
        this.painter.repaint();
    }

    public void addActionSet(JEditActionSet<JEditBeanShellAction> actionSet) {
        this.actionContext.addActionSet(actionSet);
    }

    @Deprecated
    public final int getMarkPosition() {
        Selection s = this.getSelectionAtOffset(this.caret);
        if (s == null) {
            return this.caret;
        }
        if (s.start == this.caret) {
            return s.end;
        }
        if (s.end == this.caret) {
            return s.start;
        }
        return this.caret;
    }

    @Deprecated
    public final int getMarkLine() {
        if (this.getSelectionCount() != 1) {
            return this.caretLine;
        }
        Selection s = this.getSelection(0);
        if (s.start == this.caret) {
            return s.endLine;
        }
        if (s.end == this.caret) {
            return s.startLine;
        }
        return this.caretLine;
    }

    final boolean isCaretVisible() {
        return this.blink && this.hasFocus();
    }

    final boolean isStructureHighlightVisible() {
        return this.match != null && this.hasFocus() && this.displayManager.isLineVisible(this.match.startLine) && this.displayManager.isLineVisible(this.match.endLine);
    }

    void updateMaxHorizontalScrollWidth() {
        int max = this.chunkCache.getMaxHorizontalScrollWidth();
        if (max != this.maxHorizontalScrollWidth) {
            this.maxHorizontalScrollWidth = max;
            this.horizontal.setValues(Math.max(0, Math.min(this.maxHorizontalScrollWidth + this.charWidth - this.painter.getWidth(), -this.horizontalOffset)), this.painter.getWidth(), 0, this.maxHorizontalScrollWidth + this.charWidth);
            this.horizontal.setUnitIncrement(10);
            this.horizontal.setBlockIncrement(this.painter.getWidth());
        } else if (this.horizontal.getValue() != -this.horizontalOffset) {
            this.horizontal.setValue(-this.horizontalOffset);
        }
    }

    void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int height = this.painter.getHeight();
        int lineHeight = this.painter.getFontMetrics().getHeight();
        if (lineHeight == 0) {
            this.visibleLines = 0;
        } else if (height <= 0) {
            this.visibleLines = 0;
            this.lastLinePartial = false;
        } else {
            this.visibleLines = height / lineHeight;
            boolean bl = this.lastLinePartial = height % lineHeight != 0;
            if (this.lastLinePartial) {
                ++this.visibleLines;
            }
        }
        this.chunkCache.recalculateVisibleLines();
        if (this.displayManager != null && this.buffer != null && !this.buffer.isLoading()) {
            this.setFirstLine(this.getFirstLine());
        }
        this.updateScrollBar();
    }

    void foldStructureChanged() {
        this.repaintMgr.setFastScroll(false);
        this.chunkCache.invalidateAll();
        this.recalculateLastPhysicalLine();
        this.repaint();
    }

    void updateScrollBar() {
        if (this.buffer == null) {
            return;
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "updateScrollBar(), slc=" + this.displayManager.getScrollLineCount());
        }
        if (this.vertical != null && this.visibleLines != 0) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "Vertical ok");
            }
            int lineCount = this.displayManager.getScrollLineCount();
            int firstLine = this.getFirstLine();
            int visible = this.visibleLines - (this.lastLinePartial ? 1 : 0);
            this.vertical.setValues(firstLine, visible, 0, lineCount);
            this.vertical.setUnitIncrement(2);
            this.vertical.setBlockIncrement(visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _finishCaretUpdate() {
        if (!this.queuedCaretUpdate) {
            return;
        }
        try {
            if (this.match != null) {
                if (this.oldCaretLine < this.match.startLine) {
                    this.invalidateLineRange(this.oldCaretLine, this.match.endLine);
                } else {
                    this.invalidateLineRange(this.match.startLine, this.oldCaretLine);
                }
                this.match = null;
            }
            int newCaretScreenLine = this.chunkCache.getScreenLineOfOffset(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine));
            if (this.caretScreenLine == -1) {
                this.invalidateScreenLineRange(newCaretScreenLine, newCaretScreenLine);
            } else {
                this.invalidateScreenLineRange(this.caretScreenLine, newCaretScreenLine);
            }
            this.caretScreenLine = newCaretScreenLine;
            this.invalidateSelectedLines();
            this.blink = true;
            caretTimer.restart();
            if (!this.displayManager.isLineVisible(this.caretLine)) {
                if (this.caretLine < this.displayManager.getFirstVisibleLine() || this.caretLine > this.displayManager.getLastVisibleLine()) {
                    int collapseFolds = this.buffer.getIntegerProperty("collapseFolds", 0);
                    if (collapseFolds != 0) {
                        this.displayManager.expandFolds(collapseFolds);
                        this.displayManager.expandFold(this.caretLine, false);
                    } else {
                        this.displayManager.expandAllFolds();
                    }
                } else {
                    this.displayManager.expandFold(this.caretLine, false);
                }
            }
            if (this.queuedScrollMode == 2) {
                this.scrollToCaret(true);
            } else if (this.queuedScrollMode == 1) {
                this.scrollToCaret(false);
            }
            TextArea.updateBracketHighlightWithDelay();
            if (this.queuedFireCaretEvent) {
                this.fireCaretEvent();
            }
            Object var4_3 = null;
            this.queuedFireCaretEvent = false;
            this.queuedCaretUpdate = false;
            this.queuedScrollMode = 0;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.queuedFireCaretEvent = false;
            this.queuedCaretUpdate = false;
            this.queuedScrollMode = 0;
            throw throwable;
        }
    }

    void invalidateStructureMatch() {
        if (this.match != null) {
            this.invalidateLineRange(this.match.startLine, this.match.endLine);
        }
    }

    void startDragAndDrop(InputEvent evt, boolean copy) {
        TransferHandler transferHandler = this.getTransferHandler();
        if (transferHandler != null) {
            Log.log(1, this, "Drag and drop callback");
            transferHandler.exportAsDrag(this, evt, copy ? 1 : 2);
        }
    }

    void fireNarrowActive() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != StatusListener.class) continue;
            try {
                ((StatusListener)listeners[i + 1]).narrowActive(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void invalidateSelectedLines() {
        this.invalidateLine(this.caretLine);
        for (Selection s : this.selectionManager.selection) {
            this.invalidateLineRange(s.startLine, s.endLine);
        }
    }

    private void finishCaretUpdate(int oldCaretLine, int scrollMode, boolean fireCaretEvent) {
        this.queuedFireCaretEvent |= fireCaretEvent;
        this.queuedScrollMode = Math.max(scrollMode, this.queuedScrollMode);
        if (this.queuedCaretUpdate) {
            return;
        }
        this.oldCaretLine = oldCaretLine;
        this.queuedCaretUpdate = true;
        if (!this.buffer.isTransactionInProgress()) {
            this._finishCaretUpdate();
        }
        this.repaintMgr.setFastScroll(false);
    }

    private void fireCaretEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != CaretListener.class) continue;
            try {
                ((CaretListener)listeners[i + 1]).caretUpdate(this.caretEvent);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void fireScrollEvent(boolean vertical) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != ScrollListener.class) continue;
            try {
                if (vertical) {
                    ((ScrollListener)listeners[i + 1]).scrolledVertically(this);
                    continue;
                }
                ((ScrollListener)listeners[i + 1]).scrolledHorizontally(this);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void fireStatusChanged(int flag, boolean value) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != StatusListener.class) continue;
            try {
                ((StatusListener)listeners[i + 1]).statusChanged(this, flag, value);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void fireBracketSelected(int line, String text) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != StatusListener.class) continue;
            try {
                ((StatusListener)listeners[i + 1]).bracketSelected(this, line, text);
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, t);
            }
        }
    }

    private void _changeLine(boolean select, int newCaret) {
        if (select) {
            int extraEndVirt;
            int extraStartVirt;
            RectParams params = this.getRectParams(this.caret, newCaret);
            if (params == null) {
                extraStartVirt = 0;
                extraEndVirt = 0;
            } else {
                extraStartVirt = params.extraStartVirt;
                extraEndVirt = params.extraEndVirt;
                newCaret = params.newCaret;
            }
            this.extendSelection(this.caret, newCaret, extraStartVirt, extraEndVirt);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(newCaret);
    }

    private boolean lineContainsSpaceAndTabs(int lineIndex) {
        this.getLineText(lineIndex, this.lineSegment);
        block3: for (int j = 0; j < this.lineSegment.count; ++j) {
            switch (this.lineSegment.array[this.lineSegment.offset + j]) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(String str, boolean indent) {
        try {
            int caretLineEnd;
            if (this.overwrite || indent) {
                this.buffer.beginCompoundEdit();
            }
            if (this.overwrite && (caretLineEnd = this.getLineEndOffset(this.caretLine)) - this.caret > 1) {
                this.buffer.remove(this.caret, 1);
            }
            this.buffer.insert(this.caret, str);
            if (indent) {
                this.buffer.indentLine(this.caretLine, true);
            }
            Object var5_4 = null;
            if (this.overwrite || indent) {
                this.buffer.endCompoundEdit();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.overwrite || indent) {
                this.buffer.endCompoundEdit();
            }
            throw throwable;
        }
    }

    private void insertTab() {
        int tabSize = this.buffer.getTabSize();
        if (this.buffer.getBooleanProperty("noTabs")) {
            int lineStart = this.getLineStartOffset(this.caretLine);
            String line = this.getText(lineStart, this.caret - lineStart);
            int pos = 0;
            block3: for (int i = 0; i < line.length(); ++i) {
                switch (line.charAt(pos)) {
                    case '\t': {
                        pos = 0;
                        continue block3;
                    }
                    default: {
                        if (++pos < tabSize) continue block3;
                        pos = 0;
                    }
                }
            }
            this.replaceSelection(StandardUtilities.createWhiteSpace(tabSize - pos, 0));
        } else {
            this.replaceSelection("\t");
        }
    }

    protected void userInputTab() {
        if (this.getSelectionCount() == 1) {
            Selection sel = this.getSelection(0);
            if (sel instanceof Selection.Rect || sel.startLine == sel.endLine && (sel.start != this.buffer.getLineStartOffset(sel.startLine) || sel.end != this.buffer.getLineEndOffset(sel.startLine) - 1)) {
                this.insertTab();
            } else {
                this.shiftIndentRight();
            }
        } else if (this.getSelectionCount() != 0) {
            this.shiftIndentRight();
        } else {
            this.insertTab();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doWordWrap(boolean spaceInserted) {
        boolean returnValue;
        int insertNewLineAt;
        int caretPos;
        if (!this.hardWrap || this.maxLineLen <= 0) {
            return false;
        }
        this.buffer.getLineText(this.caretLine, this.lineSegment);
        int start = this.getLineStartOffset(this.caretLine);
        int end = this.getLineEndOffset(this.caretLine);
        int len = end - start - 1;
        for (int i = caretPos = this.caret - start; i < len; ++i) {
            char ch = this.lineSegment.array[this.lineSegment.offset + i];
            if (ch == ' ' || ch == '\t') continue;
            return false;
        }
        int tabSize = this.buffer.getTabSize();
        String wordBreakChars = this.buffer.getStringProperty("wordBreakChars");
        int lastInLine = 0;
        int logicalLength = 0;
        int lastWordOffset = -1;
        boolean lastWasSpace = true;
        for (int i = 0; i < caretPos; ++i) {
            char ch = this.lineSegment.array[this.lineSegment.offset + i];
            if (ch == '\t') {
                logicalLength += tabSize - logicalLength % tabSize;
                if (lastWasSpace || logicalLength > this.maxLineLen) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            if (ch == ' ') {
                if (lastWasSpace || ++logicalLength > this.maxLineLen + 1) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            if (wordBreakChars != null && wordBreakChars.indexOf(ch) != -1) {
                if (lastWasSpace || ++logicalLength > this.maxLineLen) continue;
                lastInLine = i;
                lastWordOffset = i;
                lastWasSpace = true;
                continue;
            }
            lastInLine = i;
            ++logicalLength;
            lastWasSpace = false;
        }
        if (spaceInserted && logicalLength == this.maxLineLen && lastInLine == caretPos - 1) {
            insertNewLineAt = caretPos;
            returnValue = true;
        } else if (logicalLength >= this.maxLineLen && lastWordOffset != -1) {
            insertNewLineAt = lastWordOffset;
            returnValue = false;
        } else {
            return false;
        }
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.insert(start + insertNewLineAt, "\n");
            this.buffer.indentLine(this.caretLine, true);
            Object var15_15 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
        return returnValue;
    }

    private static void updateBracketHighlightWithDelay() {
        structureTimer.stop();
        structureTimer.start();
    }

    private void updateStructureHighlight() {
        if (!this.painter.isStructureHighlightEnabled() && !this.gutter.isStructureHighlightEnabled()) {
            return;
        }
        for (StructureMatcher matcher : this.structureMatchers) {
            this.match = matcher.getMatch(this);
            if (this.match == null) continue;
            break;
        }
        if (this.match != null) {
            if (this.caretLine < this.match.startLine) {
                this.invalidateLineRange(this.caretLine, this.match.endLine);
            } else {
                this.invalidateLineRange(this.match.startLine, this.caretLine);
            }
            if (!this.displayManager.isLineVisible(this.match.startLine) || this.chunkCache.getScreenLineOfOffset(this.match.startLine, this.match.start - this.getLineStartOffset(this.match.startLine)) == -1) {
                this.showStructureStatusMessage(this.match.startLine < this.caretLine);
            }
        }
    }

    private void showStructureStatusMessage(boolean backward) {
        String text = this.buffer.getLineText(this.match.startLine).trim();
        if (backward && this.match.startLine != 0 && text.length() == 1) {
            switch (text.charAt(0)) {
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    text = this.buffer.getLineText(this.match.startLine - 1).trim() + ' ' + text;
                }
            }
        }
        this.fireBracketSelected(this.match.startLine + 1, text.replace('\t', ' '));
    }

    void recalculateLastPhysicalLine() {
        int oldScreenLastLine = this.screenLastLine;
        for (int i = this.visibleLines - 1; i >= 0; --i) {
            ChunkCache.LineInfo info = this.chunkCache.getLineInfo(i);
            if (info.physicalLine == -1) continue;
            this.physLastLine = info.physicalLine;
            this.screenLastLine = i;
            break;
        }
        this.invalidateScreenLineRange(oldScreenLastLine, this.screenLastLine);
    }

    private RectParams getRectParams(int caret, int newCaret) {
        int virtualWidth;
        Selection s = this.getSelectionAtOffset(caret);
        if (s instanceof Selection.Rect) {
            virtualWidth = caret == s.end ? this.buffer.getVirtualWidth(s.endLine, s.end - this.getLineStartOffset(s.endLine)) + ((Selection.Rect)s).extraEndVirt : this.buffer.getVirtualWidth(s.startLine, s.start - this.getLineStartOffset(s.startLine)) + ((Selection.Rect)s).extraStartVirt;
        } else if (this.rectangularSelectionMode) {
            virtualWidth = this.buffer.getVirtualWidth(this.caretLine, caret - this.buffer.getLineStartOffset(this.caretLine));
        } else {
            return null;
        }
        int newLine = this.getLineOfOffset(newCaret);
        int[] totalVirtualWidth = new int[1];
        int newOffset = this.buffer.getOffsetOfVirtualColumn(newLine, virtualWidth, totalVirtualWidth);
        if (newOffset == -1) {
            int extraVirt = virtualWidth - totalVirtualWidth[0];
            newCaret = this.getLineEndOffset(newLine) - 1;
            boolean bias = s == null ? newCaret < caret : (s.start == caret ? newCaret <= s.end : (s.end == caret ? newCaret <= s.start : false));
            RectParams returnValue = bias ? new RectParams(extraVirt, 0, newCaret) : new RectParams(0, extraVirt, newCaret);
            return returnValue;
        }
        return new RectParams(0, 0, this.getLineStartOffset(newLine) + newOffset);
    }

    private void delete(boolean forward) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            Selection[] selections = this.getSelection();
            for (int i = 0; i < selections.length; ++i) {
                Selection s = selections[i];
                if (s instanceof Selection.Rect) {
                    Selection.Rect r = (Selection.Rect)s;
                    int startColumn = r.getStartColumn(this.buffer);
                    if (startColumn == r.getEndColumn(this.buffer)) {
                        if (!forward && startColumn == 0) {
                            this.getToolkit().beep();
                            continue;
                        }
                        this.tallCaretDelete(r, forward);
                        continue;
                    }
                    this.setSelectedText(s, null);
                    continue;
                }
                this.setSelectedText(s, null);
            }
        } else if (forward) {
            if (this.caret == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            this.buffer.remove(this.caret, 1);
        } else {
            if (this.caret == 0) {
                this.getToolkit().beep();
                return;
            }
            this.buffer.remove(this.caret - 1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tallCaretDelete(Selection.Rect s, boolean forward) {
        try {
            this.buffer.beginCompoundEdit();
            int[] width = new int[1];
            int startCol = s.getStartColumn(this.buffer);
            int startLine = s.startLine;
            int endLine = s.endLine;
            for (int i = startLine; i <= endLine; ++i) {
                int offset = this.buffer.getOffsetOfVirtualColumn(i, startCol, width);
                if (offset == -1) {
                    if (width[0] == startCol) {
                        offset = this.getLineLength(i);
                    } else {
                        if (i != startLine || forward) continue;
                        this.shiftTallCaretLeft(s);
                        continue;
                    }
                }
                offset += this.buffer.getLineStartOffset(i);
                if (forward) {
                    if (offset == this.buffer.getLineEndOffset(i) - 1) continue;
                    this.buffer.remove(offset, 1);
                    continue;
                }
                this.buffer.remove(offset - 1, 1);
            }
            Object var10_9 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
    }

    private void shiftTallCaretLeft(Selection.Rect s) {
        this.removeFromSelection(s);
        this.addToSelection(new Selection.Rect(this.buffer, s.getStartLine(), s.getStartColumn(this.buffer) - 1, s.getEndLine(), s.getEndColumn(this.buffer) - 1));
    }

    private void setMaxLineLength(int maxLineLen) {
        this.maxLineLen = maxLineLen;
        if (maxLineLen <= 0) {
            if (this.softWrap) {
                this.wrapToWidth = true;
                this.wrapMargin = this.painter.getWidth() - this.charWidth * 3;
            } else {
                this.wrapToWidth = false;
                this.wrapMargin = 0;
            }
        } else {
            char[] foo = new char[maxLineLen];
            for (int i = 0; i < foo.length; ++i) {
                foo[i] = 32;
            }
            this.wrapToWidth = false;
            this.wrapMargin = (int)this.painter.getFont().getStringBounds(foo, 0, foo.length, this.painter.getFontRenderContext()).getWidth();
        }
    }

    protected int addExplicitFold(int caretStart, int caretEnd, int lineStart, int lineEnd) {
        String start;
        int startCaret = caretStart < this.buffer.getLength() ? caretStart + 1 : caretStart;
        int endCaret = caretEnd > 0 ? caretEnd - 1 : caretEnd;
        String startLineComment = this.buffer.getContextSensitiveProperty(startCaret, "lineComment");
        String startCommentStart = this.buffer.getContextSensitiveProperty(startCaret, "commentStart");
        String startCommentEnd = this.buffer.getContextSensitiveProperty(startCaret, "commentEnd");
        String endLineComment = this.buffer.getContextSensitiveProperty(endCaret, "lineComment");
        String endCommentStart = this.buffer.getContextSensitiveProperty(endCaret, "commentStart");
        String endCommentEnd = this.buffer.getContextSensitiveProperty(endCaret, "commentEnd");
        int caretBack = 1;
        if (startLineComment != null) {
            start = startLineComment + "{{{ ";
        } else if (startCommentStart != null && startCommentEnd != null) {
            start = startCommentStart + "{{{  " + startCommentEnd;
            caretBack = 1 + startCommentStart.length();
        } else {
            start = "{{{ ";
        }
        if (startLineComment != null) {
            if (this.buffer.getLineLength(lineStart) != caretStart) {
                start = start + '\n';
            }
        } else {
            start = start + "\n";
        }
        String end = endLineComment != null ? endLineComment + "}}}" : (endCommentStart != null && endCommentEnd != null ? endCommentStart + "}}}" + endCommentEnd : "}}}");
        String line = this.buffer.getLineText(lineStart);
        String whitespace = line.substring(0, StandardUtilities.getLeadingWhiteSpace(line));
        if (endLineComment != null) {
            if (this.buffer.getLineLength(lineEnd) != caretEnd) {
                end = end + '\n';
            }
        } else {
            end = end + "\n";
        }
        if (caretEnd == this.buffer.getLineStartOffset(lineEnd)) {
            this.buffer.insert(caretEnd, end);
        } else {
            CharSequence lineText = this.buffer.getSegment(caretEnd - 1, 1);
            if (Character.isWhitespace(lineText.charAt(0))) {
                this.buffer.insert(caretEnd, end);
            } else {
                this.buffer.insert(caretEnd, ' ' + end);
            }
        }
        this.buffer.insert(caretStart, start + whitespace);
        return caretBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeLineComment() {
        String commentStart = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String commentEnd = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (!this.buffer.isEditable() || commentStart == null || commentEnd == null || commentStart.length() == 0 || commentEnd.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        commentStart = commentStart + ' ';
        commentEnd = ' ' + commentEnd;
        try {
            this.buffer.beginCompoundEdit();
            int[] lines = this.getSelectedLines();
            for (int i = 0; i < lines.length; ++i) {
                String text = this.getLineText(lines[i]);
                if (text.trim().length() == 0) continue;
                this.buffer.insert(this.getLineEndOffset(lines[i]) - 1, commentEnd);
                this.buffer.insert(this.getLineStartOffset(lines[i]) + StandardUtilities.getLeadingWhiteSpace(text), commentStart);
            }
            Object var7_6 = null;
            this.buffer.endCompoundEdit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.buffer.endCompoundEdit();
            throw throwable;
        }
    }

    private void joinLineAt(int line) {
        if (line >= this.buffer.getLineCount() - 1) {
            return;
        }
        int end = this.getLineEndOffset(line);
        CharSequence nextLineText = this.buffer.getLineSegment(line + 1);
        this.buffer.remove(end - 1, StandardUtilities.getLeadingWhiteSpace(nextLineText) + 1);
        if (nextLineText.length() != 0) {
            this.buffer.insert(end - 1, " ");
        }
    }

    public static TextArea _createTextArea(boolean insidejEdit, IPropertyManager iPropertyManager) {
        TextArea textArea = new TextArea(iPropertyManager, insidejEdit);
        textArea.setMouseHandler(new TextAreaMouseHandler(textArea));
        StandaloneActionSet actionSet = new StandaloneActionSet(iPropertyManager, textArea);
        textArea.addActionSet(actionSet);
        actionSet.load();
        actionSet.initKeyBindings();
        return textArea;
    }

    public static TextArea createTextArea(IPropertyManager iPropertyManager) {
        TextArea textArea = TextArea._createTextArea(false, iPropertyManager);
        return textArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TextArea createTextArea() {
        Properties props;
        block4: {
            props = new Properties();
            InputStream in = TextArea.class.getResourceAsStream("/org/gjt/sp/jedit/jedit_keys.props");
            try {
                try {
                    props.load(in);
                }
                catch (IOException e) {
                    Log.log(9, TextArea.class, e);
                    Object var4_3 = null;
                    IOUtilities.closeQuietly(in);
                    break block4;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                IOUtilities.closeQuietly(in);
                throw throwable;
            }
            IOUtilities.closeQuietly(in);
        }
        TextArea textArea = TextArea._createTextArea(false, new IPropertyManager(){

            public String getProperty(String name) {
                return props.getProperty(name);
            }
        });
        textArea.getBuffer().setProperty("folding", "explicit");
        return textArea;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        TextArea text = TextArea.createTextArea();
        Mode mode = new Mode("xml");
        mode.setProperty("file", "modes/xml.xml");
        ModeProvider.instance.addMode(mode);
        text.getBuffer().setMode(mode);
        frame.getContentPane().add(text);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
        structureTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (focusedComponent != null) {
                    focusedComponent.updateStructureHighlight();
                }
            }
        });
        structureTimer.setInitialDelay(100);
        structureTimer.setRepeats(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandaloneActionSet
    extends JEditActionSet<JEditBeanShellAction> {
        private final IPropertyManager iPropertyManager;
        private final TextArea textArea;

        private StandaloneActionSet(IPropertyManager iPropertyManager, TextArea textArea) {
            super(null, TextArea.class.getResource("textarea.actions.xml"));
            this.iPropertyManager = iPropertyManager;
            this.textArea = textArea;
        }

        protected JEditBeanShellAction[] getArray(int size) {
            return new JEditBeanShellAction[size];
        }

        @Override
        protected String getProperty(String name) {
            return this.iPropertyManager.getProperty(name);
        }

        @Override
        public AbstractInputHandler getInputHandler() {
            return this.textArea.getInputHandler();
        }

        @Override
        protected JEditBeanShellAction createBeanShellAction(String actionName, String code, String selected, boolean noRepeat, boolean noRecord, boolean noRememberLast) {
            return new JEditBeanShellAction(actionName, code, selected, noRepeat, noRecord, noRememberLast);
        }
    }

    private class MouseWheelHandler
    implements MouseWheelListener {
        private MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isAltDown()) {
                boolean select;
                boolean bl = select = e.isShiftDown() || e.isControlDown();
                if (e.getWheelRotation() < 0) {
                    TextArea.this.goToPrevLine(select);
                } else {
                    TextArea.this.goToNextLine(select);
                }
            } else if (e.isShiftDown()) {
                if (e.getWheelRotation() > 0) {
                    TextArea.this.scrollDownPage();
                } else {
                    TextArea.this.scrollUpPage();
                }
            } else if (e.isControlDown()) {
                TextArea.this.setFirstLine(TextArea.this.getFirstLine() + e.getWheelRotation());
            } else if (e.getScrollType() == 0) {
                TextArea.this.setFirstLine(TextArea.this.getFirstLine() + e.getUnitsToScroll());
            } else {
                TextArea.this.setFirstLine(TextArea.this.getFirstLine() + 3 * e.getWheelRotation());
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent evt) {
            if (TextArea.this.bufferChanging) {
                return;
            }
            if (TextArea.this.match != null) {
                if (TextArea.this.caretLine < ((TextArea)TextArea.this).match.startLine) {
                    TextArea.this.invalidateLineRange(TextArea.this.caretLine, ((TextArea)TextArea.this).match.endLine);
                } else {
                    TextArea.this.invalidateLineRange(((TextArea)TextArea.this).match.startLine, TextArea.this.caretLine);
                }
            } else {
                TextArea.this.invalidateLine(TextArea.this.caretLine);
            }
            focusedComponent = TextArea.this;
        }

        public void focusLost(FocusEvent evt) {
            if (!TextArea.this.isShowing()) {
                return;
            }
            if (TextArea.this.match != null) {
                if (TextArea.this.caretLine < ((TextArea)TextArea.this).match.startLine) {
                    TextArea.this.invalidateLineRange(TextArea.this.caretLine, ((TextArea)TextArea.this).match.endLine);
                } else {
                    TextArea.this.invalidateLineRange(((TextArea)TextArea.this).match.startLine, TextArea.this.caretLine);
                }
            } else {
                TextArea.this.invalidateLine(TextArea.this.caretLine);
            }
        }
    }

    private class AdjustHandler
    implements AdjustmentListener {
        private AdjustHandler() {
        }

        public void adjustmentValueChanged(AdjustmentEvent evt) {
            if (!TextArea.this.scrollBarsInitialized) {
                return;
            }
            if (evt.getAdjustable() == TextArea.this.vertical) {
                TextArea.this.setFirstLine(TextArea.this.vertical.getValue());
            } else {
                TextArea.this.setHorizontalOffset(-TextArea.this.horizontal.getValue());
            }
        }
    }

    private class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(TextArea.this);
        }

        public int getDot() {
            return TextArea.this.getCaretPosition();
        }

        public int getMark() {
            return TextArea.this.getMarkPosition();
        }
    }

    private static class CaretBlinker
    implements ActionListener {
        private CaretBlinker() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }

    private static class RectParams {
        final int extraStartVirt;
        final int extraEndVirt;
        final int newCaret;

        RectParams(int extraStartVirt, int extraEndVirt, int newCaret) {
            this.extraStartVirt = extraStartVirt;
            this.extraEndVirt = extraEndVirt;
            this.newCaret = newCaret;
        }
    }
}

