/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ScrollLayout
implements LayoutManager {
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String TOP = "top";
    private Component center;
    private Component left;
    private Component right;
    private Component bottom;
    private Component top;

    public void addLayoutComponent(String name, Component comp) {
        if (name.equals(CENTER)) {
            this.center = comp;
        } else if (name.equals(RIGHT)) {
            this.right = comp;
        } else if (name.equals(LEFT)) {
            this.left = comp;
        } else if (name.equals(BOTTOM)) {
            this.bottom = comp;
        } else if (name.equals(TOP)) {
            this.top = comp;
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (this.center == comp) {
            this.center = null;
        } else if (this.right == comp) {
            this.right = null;
        } else if (this.left == comp) {
            this.left = null;
        } else if (this.bottom == comp) {
            this.bottom = null;
        } else if (this.top == comp) {
            this.top = null;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension dim = new Dimension();
        Insets insets = this.getInsets(parent);
        dim.width = insets.left + insets.right;
        dim.height = insets.top + insets.bottom;
        Dimension leftPref = this.left.getPreferredSize();
        dim.width += leftPref.width;
        Dimension centerPref = this.center.getPreferredSize();
        dim.width += centerPref.width;
        dim.height += centerPref.height;
        Dimension rightPref = this.right.getPreferredSize();
        dim.width += rightPref.width;
        Dimension bottomPref = this.bottom.getPreferredSize();
        dim.height += bottomPref.height;
        if (this.top != null) {
            Dimension topPref = this.top.getPreferredSize();
            dim.height += topPref.height;
        }
        return dim;
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim = new Dimension();
        Insets insets = this.getInsets(parent);
        dim.width = insets.left + insets.right;
        dim.height = insets.top + insets.bottom;
        Dimension leftPref = this.left.getMinimumSize();
        dim.width += leftPref.width;
        Dimension centerPref = this.center.getMinimumSize();
        dim.width += centerPref.width;
        dim.height += centerPref.height;
        Dimension rightPref = this.right.getMinimumSize();
        dim.width += rightPref.width;
        Dimension bottomPref = this.bottom.getMinimumSize();
        dim.height += bottomPref.height;
        if (this.top != null) {
            Dimension topPref = this.top.getMinimumSize();
            dim.height += topPref.height;
        }
        return dim;
    }

    public void layoutContainer(Container parent) {
        Dimension size = parent.getSize();
        Insets insets = this.getInsets(parent);
        int itop = insets.top;
        int ileft = insets.left;
        int ibottom = insets.bottom;
        int iright = insets.right;
        int rightWidth = this.right.getPreferredSize().width;
        int leftWidth = this.left.getPreferredSize().width;
        int topHeight = this.top != null ? this.top.getPreferredSize().height : 0;
        int bottomHeight = this.bottom.getPreferredSize().height;
        int centerWidth = Math.max(0, size.width - leftWidth - rightWidth - ileft - iright);
        int centerHeight = Math.max(0, size.height - topHeight - bottomHeight - itop - ibottom);
        this.left.setBounds(ileft, itop + topHeight, leftWidth, centerHeight);
        this.center.setBounds(ileft + leftWidth, itop + topHeight, centerWidth, centerHeight);
        this.right.setBounds(ileft + leftWidth + centerWidth, itop + topHeight, rightWidth, centerHeight);
        this.bottom.setBounds(ileft, itop + topHeight + centerHeight, Math.max(0, size.width - this.bottom.getHeight() - ileft - iright), bottomHeight);
        if (this.top != null) {
            this.top.setBounds(ileft, itop, leftWidth + centerWidth + rightWidth, topHeight);
        }
    }

    private Insets getInsets(Component parent) {
        Border border = ((JComponent)parent).getBorder();
        if (border == null) {
            return new Insets(0, 0, 0, 0);
        }
        return border.getBorderInsets(parent);
    }
}

