/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.textarea.Anchor;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

class FirstLine
extends Anchor {
    int skew;

    FirstLine(DisplayManager displayManager, TextArea textArea) {
        super(displayManager, textArea);
    }

    public void changed() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "changed() before: " + this.physicalLine + ':' + this.scrollLine + ':' + this.skew);
        }
        this.ensurePhysicalLineIsVisible();
        int screenLines = this.displayManager.getScreenLineCount(this.physicalLine);
        if (this.skew >= screenLines) {
            this.skew = screenLines - 1;
        }
        if (Debug.SCROLL_VERIFY) {
            System.err.println("SCROLL_VERIFY");
            int verifyScrollLine = 0;
            for (int i = 0; i < this.displayManager.getBuffer().getLineCount(); ++i) {
                if (!this.displayManager.isLineVisible(i)) continue;
                if (i >= this.physicalLine) break;
                verifyScrollLine += this.displayManager.getScreenLineCount(i);
            }
            if (verifyScrollLine != this.scrollLine) {
                Exception ex = new Exception(this.scrollLine + ":" + verifyScrollLine);
                Log.log(9, this, ex);
            }
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "changed() after: " + this.physicalLine + ':' + this.scrollLine + ':' + this.skew);
        }
    }

    public void reset() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "reset()");
        }
        int oldPhysicalLine = this.physicalLine;
        this.physicalLine = 0;
        this.scrollLine = 0;
        int i = this.displayManager.getFirstVisibleLine();
        while (i < oldPhysicalLine) {
            int before = this.scrollLine;
            this.displayManager.updateScreenLineCount(i);
            if (before != this.scrollLine) {
                throw new RuntimeException(this + " nudged");
            }
            this.scrollLine += this.displayManager.getScreenLineCount(i);
            int nextLine = this.displayManager.getNextVisibleLine(i);
            if (nextLine == -1) break;
            i = nextLine;
        }
        this.physicalLine = i;
        this.displayManager.updateScreenLineCount(i);
        int screenLines = this.displayManager.getScreenLineCount(this.physicalLine);
        if (this.skew >= screenLines) {
            this.skew = screenLines - 1;
        }
        this.textArea.updateScrollBar();
    }

    void physDown(int amount, int screenAmount) {
        int nextPhysicalLine;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physDown() start: " + this.physicalLine + ':' + this.scrollLine);
        }
        this.skew = 0;
        if (!this.displayManager.isLineVisible(this.physicalLine)) {
            int lastVisibleLine = this.displayManager.getLastVisibleLine();
            if (this.physicalLine > lastVisibleLine) {
                this.physicalLine = lastVisibleLine;
            } else {
                int nextPhysicalLine2 = this.displayManager.getNextVisibleLine(this.physicalLine);
                amount -= nextPhysicalLine2 - this.physicalLine;
                this.scrollLine += this.displayManager.getScreenLineCount(this.physicalLine);
                this.physicalLine = nextPhysicalLine2;
            }
        }
        while ((nextPhysicalLine = this.displayManager.getNextVisibleLine(this.physicalLine)) != -1 && nextPhysicalLine <= this.physicalLine + amount) {
            this.scrollLine += this.displayManager.getScreenLineCount(this.physicalLine);
            amount -= nextPhysicalLine - this.physicalLine;
            this.physicalLine = nextPhysicalLine;
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physDown() end: " + this.physicalLine + ':' + this.scrollLine);
        }
        this.callChanged = true;
        if (screenAmount < 0) {
            this.scrollUp(-screenAmount);
        } else if (screenAmount > 0) {
            this.scrollDown(screenAmount);
        }
    }

    void physUp(int amount, int screenAmount) {
        int prevPhysicalLine;
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physUp() start: " + this.physicalLine + ':' + this.scrollLine);
        }
        this.skew = 0;
        if (!this.displayManager.isLineVisible(this.physicalLine)) {
            int firstVisibleLine = this.displayManager.getFirstVisibleLine();
            if (this.physicalLine < firstVisibleLine) {
                this.physicalLine = firstVisibleLine;
            } else {
                int prevPhysicalLine2 = this.displayManager.getPrevVisibleLine(this.physicalLine);
                amount -= this.physicalLine - prevPhysicalLine2;
            }
        }
        while ((prevPhysicalLine = this.displayManager.getPrevVisibleLine(this.physicalLine)) != -1 && prevPhysicalLine >= this.physicalLine - amount) {
            amount -= this.physicalLine - prevPhysicalLine;
            this.physicalLine = prevPhysicalLine;
            this.scrollLine -= this.displayManager.getScreenLineCount(prevPhysicalLine);
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "physUp() end: " + this.physicalLine + ':' + this.scrollLine);
        }
        this.callChanged = true;
        if (screenAmount < 0) {
            this.scrollUp(-screenAmount);
        } else if (screenAmount > 0) {
            this.scrollDown(screenAmount);
        }
    }

    void scrollDown(int amount) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollDown()");
        }
        this.ensurePhysicalLineIsVisible();
        amount += this.skew;
        this.skew = 0;
        while (amount > 0) {
            int screenLines = this.displayManager.getScreenLineCount(this.physicalLine);
            if (amount < screenLines) {
                this.skew = amount;
                break;
            }
            int nextLine = this.displayManager.getNextVisibleLine(this.physicalLine);
            if (nextLine == -1) break;
            boolean visible = this.displayManager.isLineVisible(this.physicalLine);
            this.physicalLine = nextLine;
            if (!visible) continue;
            amount -= screenLines;
            this.scrollLine += screenLines;
        }
        this.callChanged = true;
    }

    void scrollUp(int amount) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollUp() before:" + this);
        }
        this.ensurePhysicalLineIsVisible();
        if (amount <= this.skew) {
            this.skew -= amount;
        } else {
            int prevLine;
            amount -= this.skew;
            this.skew = 0;
            while (amount > 0 && (prevLine = this.displayManager.getPrevVisibleLine(this.physicalLine)) != -1) {
                this.physicalLine = prevLine;
                int screenLines = this.displayManager.getScreenLineCount(this.physicalLine);
                this.scrollLine -= screenLines;
                if (amount < screenLines) {
                    this.skew = screenLines - amount;
                    break;
                }
                amount -= screenLines;
            }
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "scrollUp() after:" + this);
        }
        this.callChanged = true;
    }

    void ensurePhysicalLineIsVisible() {
        if (!this.displayManager.isLineVisible(this.physicalLine)) {
            if (this.physicalLine > this.displayManager.getLastVisibleLine()) {
                this.physicalLine = this.displayManager.getLastVisibleLine();
                this.scrollLine = this.displayManager.getScrollLineCount() - 1;
            } else if (this.physicalLine < this.displayManager.getFirstVisibleLine()) {
                this.physicalLine = this.displayManager.getFirstVisibleLine();
                this.scrollLine = 0;
            } else {
                this.physicalLine = this.displayManager.getNextVisibleLine(this.physicalLine);
                this.scrollLine += this.displayManager.getScreenLineCount(this.physicalLine);
            }
        }
    }

    public String toString() {
        return "FirstLine[" + this.physicalLine + ',' + this.scrollLine + ',' + this.skew + ']';
    }
}

