/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.BufferHandler;
import org.gjt.sp.jedit.textarea.FirstLine;
import org.gjt.sp.jedit.textarea.RangeMap;
import org.gjt.sp.jedit.textarea.ScreenLineManager;
import org.gjt.sp.jedit.textarea.ScrollLineCount;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class DisplayManager {
    private static final Map<JEditBuffer, List<DisplayManager>> bufferMap = new HashMap<JEditBuffer, List<DisplayManager>>();
    final FirstLine firstLine;
    final ScrollLineCount scrollLineCount;
    final ScreenLineManager screenLineMgr;
    RangeMap folds;
    private boolean initialized;
    private boolean inUse;
    private final JEditBuffer buffer;
    private final TextArea textArea;
    private final BufferHandler bufferHandler;

    static DisplayManager getDisplayManager(JEditBuffer buffer, TextArea textArea) {
        DisplayManager dmgr;
        List<DisplayManager> l = bufferMap.get(buffer);
        if (l == null) {
            l = new LinkedList<DisplayManager>();
            bufferMap.put(buffer, l);
        }
        DisplayManager copy = null;
        Iterator<DisplayManager> liter = l.iterator();
        while (liter.hasNext()) {
            copy = dmgr = liter.next();
            if (dmgr.inUse || dmgr.textArea != textArea) continue;
            dmgr.inUse = true;
            return dmgr;
        }
        dmgr = new DisplayManager(buffer, textArea, copy);
        dmgr.inUse = true;
        l.add(dmgr);
        return dmgr;
    }

    void release() {
        this.inUse = false;
    }

    public static void bufferClosed(JEditBuffer buffer) {
        bufferMap.remove(buffer);
    }

    static void textAreaDisposed(TextArea textArea) {
        for (List<DisplayManager> l : bufferMap.values()) {
            Iterator<DisplayManager> liter = l.iterator();
            while (liter.hasNext()) {
                DisplayManager dmgr = liter.next();
                if (dmgr.textArea != textArea) continue;
                dmgr.dispose();
                liter.remove();
            }
        }
    }

    public JEditBuffer getBuffer() {
        return this.buffer;
    }

    public final boolean isLineVisible(int line) {
        return this.folds.search(line) % 2 == 0;
    }

    public int getFirstVisibleLine() {
        return this.folds.first();
    }

    public int getLastVisibleLine() {
        return this.folds.last();
    }

    public int getNextVisibleLine(int line) {
        if (line < 0 || line >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        return this.folds.next(line);
    }

    public int getPrevVisibleLine(int line) {
        if (line < 0 || line >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        return this.folds.prev(line);
    }

    public final int getScreenLineCount(int line) {
        if (!this.screenLineMgr.isScreenLineCountValid(line)) {
            throw new RuntimeException("Invalid screen line count: " + line);
        }
        return this.screenLineMgr.getScreenLineCount(line);
    }

    public final int getScrollLineCount() {
        return this.scrollLineCount.scrollLine;
    }

    public void collapseFold(int line) {
        int lineCount = this.buffer.getLineCount();
        int end = lineCount - 1;
        if (line != 0 && line != this.buffer.getLineCount() - 1 && this.buffer.isFoldStart(line) && !this.isLineVisible(line + 1)) {
            --line;
        }
        int initialFoldLevel = this.buffer.getFoldLevel(line);
        int start = 0;
        if (line != lineCount - 1 && this.buffer.getFoldLevel(line + 1) > initialFoldLevel) {
            start = line + 1;
            for (int i = line + 1; i < lineCount; ++i) {
                if (this.buffer.getFoldLevel(i) > initialFoldLevel) continue;
                end = i - 1;
                break;
            }
        } else {
            int i;
            boolean ok = false;
            for (i = line - 1; i >= 0; --i) {
                if (this.buffer.getFoldLevel(i) >= initialFoldLevel) continue;
                start = i + 1;
                ok = true;
                break;
            }
            if (!ok) {
                return;
            }
            for (i = line + 1; i < lineCount; ++i) {
                if (this.buffer.getFoldLevel(i) >= initialFoldLevel) continue;
                end = i - 1;
                break;
            }
        }
        this.hideLineRange(start, end);
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public int expandFold(int line, boolean fully) {
        int i;
        int start;
        int returnValue = -1;
        int lineCount = this.buffer.getLineCount();
        int end = lineCount - 1;
        int initialFoldLevel = this.buffer.getFoldLevel(line);
        if (line == lineCount - 1) {
            return -1;
        }
        while (!this.isLineVisible(line)) {
            int prevLine = this.folds.lookup(this.folds.search(line)) - 1;
            if (!this.isLineVisible(prevLine)) {
                return -1;
            }
            this.expandFold(prevLine, fully);
            if (this.isLineVisible(prevLine + 1)) continue;
            return -1;
        }
        if (this.isLineVisible(line + 1) && !fully) {
            return -1;
        }
        if (this.buffer.getFoldLevel(line + 1) > initialFoldLevel) {
            start = line;
            if (!this.isLineVisible(line + 1) && this.folds.search(line + 1) != this.folds.count() - 1) {
                int index = this.folds.search(line + 1);
                end = this.folds.lookup(index + 1) - 1;
            } else {
                for (i = line + 1; i < lineCount; ++i) {
                    if (this.buffer.getFoldLevel(i) > initialFoldLevel) continue;
                    end = i - 1;
                    break;
                }
            }
        } else {
            if (!fully) {
                return -1;
            }
            for (start = line; start > 0 && this.buffer.getFoldLevel(start) >= initialFoldLevel; --start) {
            }
            initialFoldLevel = this.buffer.getFoldLevel(start);
            for (i = line + 1; i < lineCount; ++i) {
                if (this.buffer.getFoldLevel(i) > initialFoldLevel) continue;
                end = i - 1;
                break;
            }
        }
        if (fully) {
            this.showLineRange(start, end);
        } else {
            i = start + 1;
            while (i <= end) {
                if (returnValue == -1 && this.buffer.isFoldStart(i)) {
                    returnValue = i;
                }
                this.showLineRange(i, i);
                int fold = this.buffer.getFoldLevel(i);
                ++i;
                while (i <= end && this.buffer.getFoldLevel(i) > fold) {
                    ++i;
                }
            }
        }
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
        return returnValue;
    }

    public void expandAllFolds() {
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public void expandFolds(char digit) {
        if (digit < '1' || digit > '9') {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.expandFolds(digit - 49 + 1);
        }
    }

    public void expandFolds(int foldLevel) {
        if (this.buffer.getFoldHandler() instanceof IndentFoldHandler) {
            foldLevel = (foldLevel - 1) * this.buffer.getIndentSize() + 1;
        }
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        boolean seenVisibleLine = false;
        int firstInvisible = 0;
        for (int i = 0; i < this.buffer.getLineCount(); ++i) {
            if (seenVisibleLine && this.buffer.getFoldLevel(i) >= foldLevel) continue;
            if (firstInvisible != i) {
                this.hideLineRange(firstInvisible, i - 1);
            }
            firstInvisible = i + 1;
            seenVisibleLine = true;
        }
        if (firstInvisible != this.buffer.getLineCount()) {
            this.hideLineRange(firstInvisible, this.buffer.getLineCount() - 1);
        }
        this.notifyScreenLineChanges();
        if (this.textArea.getDisplayManager() == this) {
            this.textArea.foldStructureChanged();
        }
    }

    public void narrow(int start, int end) {
        if (start > end || start < 0 || end >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(start + ", " + end);
        }
        if (start < this.getFirstVisibleLine() || end > this.getLastVisibleLine()) {
            this.expandAllFolds();
        }
        if (start != 0) {
            this.hideLineRange(0, start - 1);
        }
        if (end != this.buffer.getLineCount() - 1) {
            this.hideLineRange(end + 1, this.buffer.getLineCount() - 1);
        }
        if (start != this.buffer.getLineCount() - 1 && !this.isLineVisible(start + 1)) {
            this.expandFold(start, false);
        }
        this.textArea.fireNarrowActive();
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    void init() {
        if (this.initialized) {
            if (!this.buffer.isLoading()) {
                this.resetAnchors();
            }
        } else {
            this.initialized = true;
            this.folds = new RangeMap();
            if (this.buffer.isLoading()) {
                this.folds.reset(this.buffer.getLineCount());
            } else {
                this.bufferHandler.foldHandlerChanged(this.buffer);
            }
            this.notifyScreenLineChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyScreenLineChanges() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "notifyScreenLineChanges()");
        }
        if (this.textArea.getDisplayManager() != this) {
            return;
        }
        try {
            if (this.firstLine.callReset) {
                this.firstLine.reset();
            } else if (this.firstLine.callChanged) {
                this.firstLine.changed();
            }
            if (this.scrollLineCount.callReset) {
                this.scrollLineCount.reset();
                this.firstLine.ensurePhysicalLineIsVisible();
            } else if (this.scrollLineCount.callChanged) {
                this.scrollLineCount.changed();
            }
            if (this.firstLine.callChanged || this.scrollLineCount.callReset || this.scrollLineCount.callChanged) {
                this.textArea.updateScrollBar();
                this.textArea.recalculateLastPhysicalLine();
            }
        }
        finally {
            this.firstLine.callChanged = false;
            this.firstLine.callReset = false;
            this.scrollLineCount.callChanged = false;
            this.scrollLineCount.callReset = false;
        }
    }

    void setFirstLine(int oldFirstLine, int firstLine) {
        int visibleLines = this.textArea.getVisibleLines();
        if (firstLine >= oldFirstLine + visibleLines) {
            this.firstLine.scrollDown(firstLine - oldFirstLine);
            this.textArea.chunkCache.invalidateAll();
        } else if (firstLine <= oldFirstLine - visibleLines) {
            this.firstLine.scrollUp(oldFirstLine - firstLine);
            this.textArea.chunkCache.invalidateAll();
        } else if (firstLine > oldFirstLine) {
            this.firstLine.scrollDown(firstLine - oldFirstLine);
            this.textArea.chunkCache.scrollDown(firstLine - oldFirstLine);
        } else if (firstLine < oldFirstLine) {
            this.firstLine.scrollUp(oldFirstLine - firstLine);
            this.textArea.chunkCache.scrollUp(oldFirstLine - firstLine);
        }
        this.notifyScreenLineChanges();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFirstPhysicalLine(int amount, int skew) {
        int oldFirstLine = this.textArea.getFirstLine();
        if (amount == 0) {
            if ((skew -= this.firstLine.skew) < 0) {
                this.firstLine.scrollUp(-skew);
            } else {
                if (skew <= 0) return;
                this.firstLine.scrollDown(skew);
            }
        } else if (amount > 0) {
            this.firstLine.physDown(amount, skew);
        } else if (amount < 0) {
            this.firstLine.physUp(-amount, skew);
        }
        int firstLine = this.textArea.getFirstLine();
        int visibleLines = this.textArea.getVisibleLines();
        if (firstLine != oldFirstLine) {
            if (firstLine >= oldFirstLine + visibleLines || firstLine <= oldFirstLine - visibleLines) {
                this.textArea.chunkCache.invalidateAll();
            } else if (firstLine > oldFirstLine) {
                this.textArea.chunkCache.scrollDown(firstLine - oldFirstLine);
            } else if (firstLine < oldFirstLine) {
                this.textArea.chunkCache.scrollUp(oldFirstLine - firstLine);
            }
        }
        this.notifyScreenLineChanges();
    }

    void invalidateScreenLineCounts() {
        this.screenLineMgr.invalidateScreenLineCounts();
        this.firstLine.callReset = true;
        this.scrollLineCount.callReset = true;
    }

    void updateScreenLineCount(int line) {
        if (!this.screenLineMgr.isScreenLineCountValid(line)) {
            int newCount = this.textArea.chunkCache.getLineSubregionCount(line);
            this.setScreenLineCount(line, newCount);
        }
    }

    void bufferLoaded() {
        int collapseFolds;
        this.folds.reset(this.buffer.getLineCount());
        this.screenLineMgr.reset();
        if (this.textArea.getDisplayManager() == this) {
            this.textArea.propertiesChanged();
            this.init();
        }
        if ((collapseFolds = this.buffer.getIntegerProperty("collapseFolds", 0)) != 0) {
            this.expandFolds(collapseFolds);
        }
    }

    void foldHandlerChanged() {
        if (this.buffer.isLoading()) {
            return;
        }
        this.folds.reset(this.buffer.getLineCount());
        this.resetAnchors();
        int collapseFolds = this.buffer.getIntegerProperty("collapseFolds", 0);
        if (collapseFolds != 0) {
            this.expandFolds(collapseFolds);
        }
    }

    private DisplayManager(JEditBuffer buffer, TextArea textArea, DisplayManager copy) {
        this.buffer = buffer;
        this.screenLineMgr = new ScreenLineManager(buffer);
        this.textArea = textArea;
        this.scrollLineCount = new ScrollLineCount(this, textArea);
        this.firstLine = new FirstLine(this, textArea);
        this.bufferHandler = new BufferHandler(this, textArea, buffer);
        buffer.addBufferListener(this.bufferHandler, 1);
        if (copy != null) {
            this.folds = new RangeMap(copy.folds);
            this.initialized = true;
        }
    }

    private void resetAnchors() {
        this.firstLine.callReset = true;
        this.scrollLineCount.callReset = true;
        this.notifyScreenLineChanges();
    }

    private void dispose() {
        this.buffer.removeBufferListener(this.bufferHandler);
    }

    private void showLineRange(int start, int end) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "showLineRange(" + start + ',' + end + ')');
        }
        for (int i = start; i <= end; ++i) {
            if (this.isLineVisible(i)) continue;
            this.updateScreenLineCount(i);
            int screenLines = this.getScreenLineCount(i);
            if (this.firstLine.physicalLine >= i) {
                this.firstLine.scrollLine += screenLines;
                this.firstLine.callChanged = true;
            }
            this.scrollLineCount.scrollLine += screenLines;
            this.scrollLineCount.callChanged = true;
        }
        this.folds.show(start, end);
    }

    private void hideLineRange(int start, int end) {
        int i;
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "hideLineRange(" + start + ',' + end + ')');
        }
        if (!this.isLineVisible(i = start)) {
            i = this.getNextVisibleLine(i);
        }
        while (i != -1 && i <= end) {
            int screenLines = this.screenLineMgr.getScreenLineCount(i);
            if (i < this.firstLine.physicalLine) {
                this.firstLine.scrollLine -= screenLines;
                this.firstLine.skew = 0;
                this.firstLine.callChanged = true;
            }
            this.scrollLineCount.scrollLine -= screenLines;
            this.scrollLineCount.callChanged = true;
            i = this.getNextVisibleLine(i);
        }
        this.folds.hide(start, end);
        if (!this.isLineVisible(this.firstLine.physicalLine)) {
            int firstVisible = this.getFirstVisibleLine();
            if (this.firstLine.physicalLine < firstVisible) {
                this.firstLine.physicalLine = firstVisible;
                this.firstLine.scrollLine = 0;
            } else {
                this.firstLine.physicalLine = this.getPrevVisibleLine(this.firstLine.physicalLine);
                this.firstLine.scrollLine -= this.screenLineMgr.getScreenLineCount(this.firstLine.physicalLine);
            }
            this.firstLine.callChanged = true;
        }
    }

    private void setScreenLineCount(int line, int count) {
        int oldCount = this.screenLineMgr.getScreenLineCount(line);
        this.screenLineMgr.setScreenLineCount(line, count);
        if (count == oldCount) {
            return;
        }
        if (!this.isLineVisible(line)) {
            return;
        }
        if (this.firstLine.physicalLine >= line) {
            if (this.firstLine.physicalLine == line) {
                this.firstLine.callChanged = true;
            } else {
                this.firstLine.scrollLine += count - oldCount;
                this.firstLine.callChanged = true;
            }
        }
        this.scrollLineCount.scrollLine += count - oldCount;
        this.scrollLineCount.callChanged = true;
    }
}

