/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ModeProvider {
    public static ModeProvider instance = new ModeProvider();
    private List<Mode> modes = new ArrayList<Mode>(160);

    public void removeAll() {
        this.modes = new ArrayList<Mode>(160);
    }

    public Mode getMode(String name) {
        for (int i = 0; i < this.modes.size(); ++i) {
            Mode mode = this.modes.get(i);
            if (!mode.getName().equals(name)) continue;
            return mode;
        }
        return null;
    }

    public Mode getModeForFile(String filename, String firstLine) {
        String nogzName = filename.substring(0, filename.length() - (filename.endsWith(".gz") ? 3 : 0));
        Mode[] modes = this.getModes();
        for (int i = modes.length - 1; i >= 0; --i) {
            if (!modes[i].accept(nogzName, firstLine)) continue;
            return modes[i];
        }
        return null;
    }

    public Mode[] getModes() {
        Mode[] array = new Mode[this.modes.size()];
        this.modes.toArray(array);
        return array;
    }

    public void addMode(Mode mode) {
        this.modes.add(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadMode(Mode mode, XModeHandler xmh) {
        XMLReader parser;
        String fileName = (String)mode.getProperty("file");
        Log.log(5, this, "Loading edit mode " + fileName);
        try {
            parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException saxe) {
            Log.log(9, this, saxe);
            return;
        }
        mode.setTokenMarker(xmh.getTokenMarker());
        BufferedInputStream grammar = null;
        try {
            try {
                grammar = new BufferedInputStream(new FileInputStream(fileName));
                InputSource isrc = new InputSource(grammar);
                isrc.setSystemId("jedit.jar");
                parser.setContentHandler(xmh);
                parser.setDTDHandler(xmh);
                parser.setEntityResolver(xmh);
                parser.setErrorHandler(xmh);
                parser.parse(isrc);
                mode.setProperties(xmh.getModeProperties());
            }
            catch (Throwable e) {
                this.error(fileName, e);
                Object var8_10 = null;
                IOUtilities.closeQuietly(grammar);
                return;
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            IOUtilities.closeQuietly(grammar);
            throw throwable;
        }
        IOUtilities.closeQuietly(grammar);
    }

    public void loadMode(Mode mode) {
        XModeHandler xmh = new XModeHandler(mode.getName()){

            public void error(String what, Object subst) {
                Log.log(9, this, subst);
            }

            public TokenMarker getTokenMarker(String modeName) {
                Mode mode = ModeProvider.this.getMode(modeName);
                if (mode == null) {
                    return null;
                }
                return mode.getTokenMarker();
            }
        };
        this.loadMode(mode, xmh);
    }

    protected void error(String file, Throwable e) {
        Log.log(9, this, e);
    }
}

