/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.search.SearchMatcher;

public class PatternSearchMatcher
extends SearchMatcher {
    private int flags;
    private Pattern re;
    private final String pattern;

    public PatternSearchMatcher(String search, boolean ignoreCase) {
        this.pattern = search;
        this.flags = PatternSearchMatcher.getFlag(ignoreCase);
    }

    public PatternSearchMatcher(Pattern re, boolean ignoreCase) {
        this(re.pattern(), ignoreCase);
        this.re = re;
    }

    public SearchMatcher.Match nextMatch(CharSequence text, boolean start, boolean end, boolean firstTime, boolean reverse) {
        Matcher match;
        if (this.re == null) {
            this.re = Pattern.compile(this.pattern, this.flags);
        }
        if (!(match = this.re.matcher(text)).find()) {
            return null;
        }
        if (!start && match.start() == 0 && this.re.pattern().charAt(0) == '^' && !match.find()) {
            return null;
        }
        if (!end && match.end() == text.length() - 1 && this.pattern.charAt(this.pattern.length() - 1) == '$') {
            return null;
        }
        this.returnValue.substitutions = new String[match.groupCount() + 1];
        for (int i = 0; i < this.returnValue.substitutions.length; ++i) {
            this.returnValue.substitutions[i] = match.group(i);
        }
        int _start = match.start();
        int _end = match.end();
        this.returnValue.start = _start;
        this.returnValue.end = _end;
        return this.returnValue;
    }

    public boolean isMatchingEOL() {
        return this.pattern.charAt(this.pattern.length() - 1) == '$';
    }

    public String toString() {
        return "PatternSearchMatcher[" + this.pattern + ']';
    }

    static int getFlag(boolean ignoreCase) {
        int flags = 8;
        if (ignoreCase) {
            flags |= 2;
        }
        return flags;
    }
}

