/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.HyperSearchFileNode;
import org.gjt.sp.jedit.search.HyperSearchFolderNode;
import org.gjt.sp.jedit.search.HyperSearchNode;
import org.gjt.sp.jedit.search.HyperSearchOperationNode;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchTreeNodeCallback;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.search.SearchFileSet;

public class HyperSearchResults
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    public static final String NAME = "hypersearch-results";
    private View view;
    private JLabel caption;
    private final JTree resultTree;
    private DefaultMutableTreeNode resultTreeRoot;
    private DefaultTreeModel resultTreeModel;
    private RolloverButton clear;
    private RolloverButton multi;
    private boolean multiStatus;
    public static final int M_OPEN = 0;
    public static final int M_OPEN_NEW_VIEW = 1;
    public static final int M_OPEN_NEW_PLAIN_VIEW = 2;
    public static final int M_OPEN_NEW_SPLIT = 3;

    public HyperSearchResults(View view) {
        super(new BorderLayout());
        this.view = view;
        this.caption = new JLabel();
        Box toolBar = new Box(0);
        toolBar.add(this.caption);
        toolBar.add(Box.createGlue());
        ActionHandler ah = new ActionHandler();
        this.clear = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.clear.icon")));
        this.clear.setToolTipText(jEdit.getProperty("hypersearch-results.clear.label"));
        this.clear.addActionListener(ah);
        toolBar.add(this.clear);
        this.multi = new RolloverButton();
        this.multi.setToolTipText(jEdit.getProperty("hypersearch-results.multi.label"));
        this.multi.addActionListener(ah);
        toolBar.add(this.multi);
        this.add("North", toolBar);
        this.resultTreeRoot = new DefaultMutableTreeNode();
        this.resultTreeModel = new DefaultTreeModel(this.resultTreeRoot);
        this.resultTree = new JTree(this.resultTreeModel);
        this.resultTree.setToolTipText("");
        this.resultTree.setCellRenderer(new ResultCellRenderer());
        this.resultTree.setVisibleRowCount(16);
        this.resultTree.setRootVisible(false);
        this.resultTree.setShowsRootHandles(true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.resultTree.getInputMap().remove(keyStroke);
        if (!OperatingSystem.isMacOSLF()) {
            this.resultTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.resultTree.setEditable(false);
        this.resultTree.addKeyListener(new KeyHandler());
        this.resultTree.addMouseListener(new MouseHandler());
        JScrollPane scrollPane = new JScrollPane(this.resultTree);
        Dimension dim = scrollPane.getPreferredSize();
        dim.width = 400;
        scrollPane.setPreferredSize(dim);
        this.add("Center", scrollPane);
    }

    public void focusOnDefaultComponent() {
        this.resultTree.requestFocus();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
        this.multiStatus = jEdit.getBooleanProperty("hypersearch-results.multi");
        this.updateMultiStatus();
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
        jEdit.setBooleanProperty("hypersearch-results.multi", this.multiStatus);
    }

    private void visitBuffers(final ResultVisitor visitor, final Buffer buffer) {
        HyperSearchResults.traverseNodes(this.resultTreeRoot, new TreeNodeCallbackAdapter(){

            public boolean processNode(DefaultMutableTreeNode node) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof HyperSearchResult)) {
                    return true;
                }
                HyperSearchResult result = (HyperSearchResult)userObject;
                if (result.pathEquals(buffer.getSymlinkPath())) {
                    visitor.visit(buffer, result);
                }
                return true;
            }
        });
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof BufferUpdate) {
            BufferUpdate bmsg = (BufferUpdate)msg;
            Buffer buffer = bmsg.getBuffer();
            Object what = bmsg.getWhat();
            if (what == BufferUpdate.LOADED) {
                this.visitBuffers(new BufferLoadedVisitor(), buffer);
            } else if (what == BufferUpdate.CLOSED) {
                this.visitBuffers(new BufferClosedVisitor(), buffer);
            }
        }
    }

    public static boolean traverseNodes(DefaultMutableTreeNode node, HyperSearchTreeNodeCallback callbackInterface) {
        if (!callbackInterface.processNode(node)) {
            return false;
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
            if (HyperSearchResults.traverseNodes(childNode, callbackInterface)) continue;
            return false;
        }
        return true;
    }

    public DefaultTreeModel getTreeModel() {
        return this.resultTreeModel;
    }

    public JTree getTree() {
        return this.resultTree;
    }

    public void searchStarted() {
        this.caption.setText(jEdit.getProperty("hypersearch-results.searching", new String[]{SearchAndReplace.getSearchString()}));
    }

    public void setSearchStatus(String status) {
        this.caption.setText(status);
    }

    public void searchFailed() {
        this.caption.setText(jEdit.getProperty("hypersearch-results.no-results", new String[]{SearchAndReplace.getSearchString()}));
        for (int i = 0; i < this.resultTreeRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resultTreeRoot.getChildAt(i);
            this.resultTree.collapsePath(new TreePath(new Object[]{this.resultTreeRoot, node}));
        }
    }

    public void searchDone(final DefaultMutableTreeNode searchNode, final DefaultMutableTreeNode selectNode) {
        final int nodeCount = searchNode.getChildCount();
        if (nodeCount < 1) {
            this.searchFailed();
            return;
        }
        this.caption.setText(jEdit.getProperty("hypersearch-results.done", new String[]{SearchAndReplace.getSearchString()}));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i;
                if (!HyperSearchResults.this.multiStatus) {
                    for (i = 0; i < HyperSearchResults.this.resultTreeRoot.getChildCount(); ++i) {
                        HyperSearchResults.this.resultTreeRoot.remove(0);
                    }
                }
                HyperSearchResults.this.resultTreeRoot.add(searchNode);
                HyperSearchResults.this.resultTreeModel.reload(HyperSearchResults.this.resultTreeRoot);
                for (i = 0; i < nodeCount; ++i) {
                    TreePath lastNode = new TreePath(((DefaultMutableTreeNode)searchNode.getChildAt(i)).getPath());
                    HyperSearchResults.this.resultTree.expandPath(lastNode);
                }
                TreePath treePath = selectNode == null ? new TreePath(new Object[]{HyperSearchResults.this.resultTreeRoot, searchNode}) : new TreePath(selectNode.getPath());
                HyperSearchResults.this.resultTree.setSelectionPath(treePath);
                HyperSearchResults.this.resultTree.scrollPathToVisible(treePath);
            }
        });
    }

    public void searchDone(DefaultMutableTreeNode searchNode) {
        this.searchDone(searchNode, null);
    }

    private void updateMultiStatus() {
        if (this.multiStatus) {
            this.multi.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.multi.multiple.icon")));
        } else {
            this.multi.setIcon(GUIUtilities.loadIcon(jEdit.getProperty("hypersearch-results.multi.single.icon")));
        }
    }

    private void goToSelectedNode(int mode) {
        TreePath path = this.resultTree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object value = node.getUserObject();
        if (node.getParent() != this.resultTreeRoot && value instanceof HyperSearchNode) {
            EditPane pane;
            HyperSearchNode n = (HyperSearchNode)value;
            Buffer buffer = n.getBuffer(this.view);
            if (buffer == null) {
                return;
            }
            switch (mode) {
                case 0: {
                    pane = this.view.goToBuffer(buffer);
                    break;
                }
                case 1: {
                    pane = jEdit.newView(this.view, buffer, false).getEditPane();
                    break;
                }
                case 2: {
                    pane = jEdit.newView(this.view, buffer, true).getEditPane();
                    break;
                }
                case 3: {
                    pane = this.view.splitHorizontally();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad mode: " + mode);
                }
            }
            n.goTo(pane);
        }
    }

    private void removeSelectedNode() {
        TreePath path = this.resultTree.getSelectionPath();
        if (path == null) {
            return;
        }
        MutableTreeNode value = (MutableTreeNode)path.getLastPathComponent();
        if (path.getPathCount() > 1) {
            TreePath parentPath = path.getParentPath();
            MutableTreeNode parent = (MutableTreeNode)parentPath.getLastPathComponent();
            int removingIndex = parent.getIndex(value);
            int nextIndex = removingIndex + 1;
            if (nextIndex < parent.getChildCount()) {
                TreeNode next = parent.getChildAt(nextIndex);
                this.resultTree.setSelectionPath(parentPath.pathByAddingChild(next));
            } else {
                this.resultTree.setSelectionPath(parentPath);
            }
            this.resultTreeModel.removeNodeFromParent(value);
        }
        HyperSearchOperationNode.removeNodeFromCache(value);
        if (this.resultTreeRoot.getChildCount() == 0) {
            this.hideDockable();
        }
    }

    private void removeAllNodes() {
        this.resultTreeRoot.removeAllChildren();
        this.resultTreeModel.reload(this.resultTreeRoot);
        this.setSearchStatus(null);
        this.hideDockable();
    }

    private void hideDockable() {
        this.view.getDockableWindowManager().hideDockableWindow(NAME);
    }

    public void expandAllNodes(DefaultMutableTreeNode node) {
        HyperSearchResults.traverseNodes(node, new TreeNodeCallbackAdapter(){

            public boolean processNode(DefaultMutableTreeNode node) {
                HyperSearchResults.this.resultTree.expandPath(new TreePath(node.getPath()));
                return true;
            }
        });
    }

    static class TreeNodeCallbackAdapter
    implements HyperSearchTreeNodeCallback {
        TreeNodeCallbackAdapter() {
        }

        public boolean processNode(DefaultMutableTreeNode node) {
            return false;
        }
    }

    static class BufferClosedVisitor
    implements ResultVisitor {
        BufferClosedVisitor() {
        }

        public void visit(Buffer buffer, HyperSearchResult result) {
            result.bufferClosed();
        }
    }

    static class BufferLoadedVisitor
    implements ResultVisitor {
        BufferLoadedVisitor() {
        }

        public void visit(Buffer buffer, HyperSearchResult result) {
            result.bufferOpened(buffer);
        }
    }

    static interface ResultVisitor {
        public void visit(Buffer var1, HyperSearchResult var2);
    }

    class ResultCellRenderer
    extends DefaultTreeCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont;

        ResultCellRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof HyperSearchOperationNode) {
                this.setFont(this.boldFont);
                CountNodes countNodes = new CountNodes();
                HyperSearchResults.traverseNodes(node, countNodes);
                this.setText(jEdit.getProperty("hypersearch-results.result-caption", new Object[]{node.toString(), countNodes.resultCount, countNodes.bufferCount}));
            } else if (node.getUserObject() instanceof HyperSearchFolderNode) {
                this.setFont(this.plainFont);
                this.setText(node.toString() + " (" + node.getChildCount() + " files/folders)");
            } else if (node.getUserObject() instanceof HyperSearchFileNode) {
                this.setFont(this.boldFont);
                HyperSearchFileNode hyperSearchFileNode = (HyperSearchFileNode)node.getUserObject();
                this.setText(jEdit.getProperty("hypersearch-results.file-caption", new Object[]{hyperSearchFileNode, hyperSearchFileNode.getCount(), node.getChildCount()}));
            } else {
                this.setFont(this.plainFont);
            }
            return this;
        }

        class CountNodes
        implements HyperSearchTreeNodeCallback {
            int bufferCount;
            int resultCount;

            CountNodes() {
            }

            public boolean processNode(DefaultMutableTreeNode node) {
                Object userObject = node.getUserObject();
                if (userObject instanceof HyperSearchFileNode) {
                    this.resultCount += ((HyperSearchFileNode)userObject).getCount();
                    ++this.bufferCount;
                }
                return true;
            }
        }
    }

    class GoToNodeAction
    extends AbstractAction {
        private int mode;

        GoToNodeAction(String labelProp, int mode) {
            super(jEdit.getProperty(labelProp));
            this.mode = mode;
        }

        public void actionPerformed(ActionEvent evt) {
            HyperSearchResults.this.goToSelectedNode(this.mode);
        }
    }

    class TreeDisplayAction
    extends AbstractAction {
        TreeDisplayAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)evt.getSource();
            boolean curState = menuItem.isSelected();
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            HyperSearchOperationNode operNodeObj = (HyperSearchOperationNode)operNode.getUserObject();
            if (curState) {
                operNodeObj.cacheResultNodes(operNode);
            }
            operNode.removeAllChildren();
            Exception excp = null;
            if (curState) {
                try {
                    try {
                        operNodeObj.insertTreeNodes(HyperSearchResults.this.resultTree, operNode);
                    }
                    catch (Exception ex) {
                        operNodeObj.restoreFlatNodes(HyperSearchResults.this.resultTree, operNode);
                        menuItem.setSelected(false);
                        excp = ex;
                        Object var10_9 = null;
                        ((DefaultTreeModel)HyperSearchResults.this.resultTree.getModel()).nodeStructureChanged(operNode);
                        HyperSearchResults.this.expandAllNodes(operNode);
                        HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(operNode.getPath()));
                    }
                    Object var10_8 = null;
                    ((DefaultTreeModel)HyperSearchResults.this.resultTree.getModel()).nodeStructureChanged(operNode);
                    HyperSearchResults.this.expandAllNodes(operNode);
                    HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(operNode.getPath()));
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    ((DefaultTreeModel)HyperSearchResults.this.resultTree.getModel()).nodeStructureChanged(operNode);
                    HyperSearchResults.this.expandAllNodes(operNode);
                    HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(operNode.getPath()));
                    throw throwable;
                }
                if (excp != null) {
                    throw new RuntimeException(excp);
                }
            } else {
                operNodeObj.restoreFlatNodes(HyperSearchResults.this.resultTree, operNode);
            }
            operNodeObj.setTreeViewDisplayed(menuItem.isSelected());
        }
    }

    class RedoSearchAction
    extends AbstractAction {
        private HyperSearchOperationNode hyperSearchOperationNode;

        public RedoSearchAction(HyperSearchOperationNode hyperSearchOperationNode) {
            super(jEdit.getProperty("hypersearch-results.redo"));
            this.hyperSearchOperationNode = hyperSearchOperationNode;
        }

        public void actionPerformed(ActionEvent e) {
            SearchAndReplace.setSearchMatcher(this.hyperSearchOperationNode.getSearchMatcher());
            HyperSearchResults.this.removeSelectedNode();
            SearchAndReplace.hyperSearch(HyperSearchResults.this.view, false);
        }
    }

    class CollapseChildTreeNodesAction
    extends AbstractAction {
        CollapseChildTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.collapse-child-nodes"));
        }

        public void actionPerformed(ActionEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> e = operNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                HyperSearchResults.this.resultTree.collapsePath(new TreePath(node.getPath()));
            }
            HyperSearchResults.this.resultTree.scrollPathToVisible(new TreePath(operNode.getPath()));
        }
    }

    class ExpandChildTreeNodesAction
    extends AbstractAction {
        ExpandChildTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.expand-child-nodes"));
        }

        public void actionPerformed(ActionEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            HyperSearchResults.this.expandAllNodes(operNode);
        }
    }

    class NewSearchAction
    extends AbstractAction {
        NewSearchAction() {
            super(jEdit.getProperty("hypersearch-results.new-search"));
        }

        public void actionPerformed(ActionEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode operNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            HyperSearchFolderNode nodeObj = (HyperSearchFolderNode)operNode.getUserObject();
            String glob = "*";
            SearchFileSet dirList = SearchAndReplace.getSearchFileSet();
            if (dirList instanceof DirectoryListSet) {
                glob = ((DirectoryListSet)dirList).getFileFilter();
            }
            SearchAndReplace.setSearchFileSet(new DirectoryListSet(nodeObj.getNodeFile().getAbsolutePath(), glob, true));
            SearchDialog.showSearchDialog(HyperSearchResults.this.view, null, 2);
        }
    }

    class RemoveAllTreeNodesAction
    extends AbstractAction {
        RemoveAllTreeNodesAction() {
            super(jEdit.getProperty("hypersearch-results.remove-all-nodes"));
        }

        public void actionPerformed(ActionEvent evt) {
            HyperSearchResults.this.removeAllNodes();
        }
    }

    class RemoveTreeNodeAction
    extends AbstractAction {
        RemoveTreeNodeAction() {
            super(jEdit.getProperty("hypersearch-results.remove-node"));
        }

        public void actionPerformed(ActionEvent evt) {
            HyperSearchResults.this.removeSelectedNode();
        }
    }

    class MouseHandler
    extends MouseAdapter {
        private JPopupMenu popupMenu;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            TreePath path1 = HyperSearchResults.this.resultTree.getPathForLocation(evt.getX(), evt.getY());
            if (path1 == null) {
                return;
            }
            HyperSearchResults.this.resultTree.setSelectionPath(path1);
            if (GUIUtilities.isPopupTrigger(evt)) {
                this.showPopupMenu(evt);
            } else {
                HyperSearchResults.this.goToSelectedNode(0);
            }
        }

        private void showPopupMenu(MouseEvent evt) {
            TreePath path = HyperSearchResults.this.resultTree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.popupMenu = new JPopupMenu();
            Object userObj = node.getUserObject();
            if (userObj instanceof HyperSearchFileNode || userObj instanceof HyperSearchResult) {
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open", 0));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-view", 1));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-plain-view", 2));
                this.popupMenu.add(new GoToNodeAction("hypersearch-results.open-split", 3));
            }
            if (!(userObj instanceof HyperSearchFolderNode)) {
                this.popupMenu.add(new RemoveTreeNodeAction());
            }
            this.popupMenu.add(new ExpandChildTreeNodesAction());
            if (userObj instanceof HyperSearchFolderNode || userObj instanceof HyperSearchOperationNode) {
                this.popupMenu.add(new CollapseChildTreeNodesAction());
                if (userObj instanceof HyperSearchFolderNode) {
                    this.popupMenu.add(new NewSearchAction());
                }
            }
            if (userObj instanceof HyperSearchOperationNode) {
                this.popupMenu.add(new JPopupMenu.Separator());
                HyperSearchOperationNode resultNode = (HyperSearchOperationNode)userObj;
                JCheckBoxMenuItem chkItem = new JCheckBoxMenuItem(jEdit.getProperty("hypersearch-results.tree-view"), resultNode.isTreeViewDisplayed());
                chkItem.addActionListener(new TreeDisplayAction());
                this.popupMenu.add(chkItem);
                this.popupMenu.add(new RedoSearchAction((HyperSearchOperationNode)userObj));
            }
            GUIUtilities.showPopupMenu(this.popupMenu, evt.getComponent(), evt.getX(), evt.getY());
            evt.consume();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            switch (evt.getKeyCode()) {
                case 32: {
                    HyperSearchResults.this.goToSelectedNode(0);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            HyperSearchResults.this.resultTree.requestFocus();
                        }
                    });
                    evt.consume();
                    break;
                }
                case 10: {
                    HyperSearchResults.this.goToSelectedNode(0);
                    evt.consume();
                    break;
                }
                case 127: {
                    HyperSearchResults.this.removeSelectedNode();
                    evt.consume();
                    break;
                }
            }
        }
    }

    public class ActionHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == HyperSearchResults.this.clear) {
                HyperSearchResults.this.removeAllNodes();
            } else if (source == HyperSearchResults.this.multi) {
                HyperSearchResults.this.multiStatus = !HyperSearchResults.this.multiStatus;
                HyperSearchResults.this.updateMultiStatus();
                if (!HyperSearchResults.this.multiStatus) {
                    for (int i = HyperSearchResults.this.resultTreeRoot.getChildCount() - 2; i >= 0; --i) {
                        HyperSearchResults.this.resultTreeModel.removeNodeFromParent((MutableTreeNode)HyperSearchResults.this.resultTreeRoot.getChildAt(i));
                    }
                }
            }
        }
    }
}

