/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class DirectoryListSet
extends BufferListSet {
    private String directory;
    private String glob;
    private boolean recurse;
    private boolean skipHidden;
    private boolean skipBinary;

    public DirectoryListSet(String directory, String glob, boolean recurse) {
        this.directory = directory;
        this.glob = glob;
        this.recurse = recurse;
        this.skipBinary = jEdit.getBooleanProperty("search.skipBinary.toggle");
        this.skipHidden = jEdit.getBooleanProperty("search.skipHidden.toggle");
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
        this.invalidateCachedList();
    }

    public String getFileFilter() {
        return this.glob;
    }

    public void setFileFilter(String glob) {
        this.glob = glob;
        this.invalidateCachedList();
    }

    public boolean isRecursive() {
        return this.recurse;
    }

    public void setRecursive(boolean recurse) {
        this.recurse = recurse;
        this.invalidateCachedList();
    }

    public String getCode() {
        return "new DirectoryListSet(\"" + StandardUtilities.charsToEscapes(this.directory) + "\",\"" + StandardUtilities.charsToEscapes(this.glob) + "\"," + this.recurse + ')';
    }

    protected String[] _getFiles(final Component comp) {
        Object session;
        this.skipBinary = jEdit.getBooleanProperty("search.skipBinary.toggle");
        this.skipHidden = jEdit.getBooleanProperty("search.skipHidden.toggle");
        final VFS vfs = VFSManager.getVFSForPath(this.directory);
        if (SwingUtilities.isEventDispatchThread()) {
            session = vfs.createVFSSession(this.directory, comp);
        } else {
            final Object[] returnValue = new Object[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        returnValue[0] = vfs.createVFSSession(DirectoryListSet.this.directory, comp);
                    }
                });
            }
            catch (Exception e) {
                Log.log(9, this, e);
            }
            session = returnValue[0];
        }
        if (session == null) {
            return null;
        }
        try {
            return vfs._listDirectory(session, this.directory, this.glob, this.recurse, comp, this.skipBinary, this.skipHidden);
        }
        catch (IOException io) {
            VFSManager.error(comp, this.directory, "ioerror", new String[]{io.toString()});
            return null;
        }
    }
}

